/* tcpclient-inet_ends_threads.c generated by valac 0.20.1, the Vala compiler
 * generated from tcpclient-inet_ends_threads.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define ZCD_TYPE_ICONNECTED_STREAM_SOCKET (zcd_iconnected_stream_socket_get_type ())
#define ZCD_ICONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET, zcdIConnectedStreamSocket))
#define ZCD_IS_ICONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET))
#define ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET, zcdIConnectedStreamSocketIface))

typedef struct _zcdIConnectedStreamSocket zcdIConnectedStreamSocket;
typedef struct _zcdIConnectedStreamSocketIface zcdIConnectedStreamSocketIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZCD_TYPE_FAKE_RMT (zcd_fake_rmt_get_type ())
#define ZCD_FAKE_RMT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_FAKE_RMT, zcdFakeRmt))
#define ZCD_IS_FAKE_RMT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_FAKE_RMT))
#define ZCD_FAKE_RMT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_FAKE_RMT, zcdFakeRmtIface))

typedef struct _zcdFakeRmt zcdFakeRmt;
typedef struct _zcdFakeRmtIface zcdFakeRmtIface;

#define ZCD_TYPE_REMOTE_CALL (zcd_remote_call_get_type ())
#define ZCD_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCall))
#define ZCD_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))
#define ZCD_IS_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_REMOTE_CALL))
#define ZCD_IS_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_REMOTE_CALL))
#define ZCD_REMOTE_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))

typedef struct _zcdRemoteCall zcdRemoteCall;
typedef struct _zcdRemoteCallClass zcdRemoteCallClass;

#define ZCD_TYPE_ISERIALIZABLE (zcd_iserializable_get_type ())
#define ZCD_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializable))
#define ZCD_IS_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_ISERIALIZABLE))
#define ZCD_ISERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializableIface))

typedef struct _zcdISerializable zcdISerializable;
typedef struct _zcdISerializableIface zcdISerializableIface;

#define ZCD_TYPE_TCP_CLIENT (zcd_tcp_client_get_type ())
#define ZCD_TCP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_TCP_CLIENT, zcdTCPClient))
#define ZCD_TCP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_TCP_CLIENT, zcdTCPClientClass))
#define ZCD_IS_TCP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_TCP_CLIENT))
#define ZCD_IS_TCP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_TCP_CLIENT))
#define ZCD_TCP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_TCP_CLIENT, zcdTCPClientClass))

typedef struct _zcdTCPClient zcdTCPClient;
typedef struct _zcdTCPClientClass zcdTCPClientClass;
typedef struct _zcdTCPClientPrivate zcdTCPClientPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZCD_TYPE_TCP_REQUEST (zcd_tcp_request_get_type ())
#define ZCD_TCP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_TCP_REQUEST, zcdTCPRequest))
#define ZCD_TCP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_TCP_REQUEST, zcdTCPRequestClass))
#define ZCD_IS_TCP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_TCP_REQUEST))
#define ZCD_IS_TCP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_TCP_REQUEST))
#define ZCD_TCP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_TCP_REQUEST, zcdTCPRequestClass))

typedef struct _zcdTCPRequest zcdTCPRequest;
typedef struct _zcdTCPRequestClass zcdTCPRequestClass;

#define ZCD_TYPE_SERIALIZABLE_NONE (zcd_serializable_none_get_type ())
#define ZCD_SERIALIZABLE_NONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNone))
#define ZCD_SERIALIZABLE_NONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNoneClass))
#define ZCD_IS_SERIALIZABLE_NONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_NONE))
#define ZCD_IS_SERIALIZABLE_NONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_NONE))
#define ZCD_SERIALIZABLE_NONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNoneClass))

typedef struct _zcdSerializableNone zcdSerializableNone;
typedef struct _zcdSerializableNoneClass zcdSerializableNoneClass;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define ZCD_TYPE_CLIENT_STREAM_SOCKET (zcd_client_stream_socket_get_type ())
#define ZCD_CLIENT_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocket))
#define ZCD_CLIENT_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocketClass))
#define ZCD_IS_CLIENT_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET))
#define ZCD_IS_CLIENT_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_CLIENT_STREAM_SOCKET))
#define ZCD_CLIENT_STREAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocketClass))

typedef struct _zcdClientStreamSocket zcdClientStreamSocket;
typedef struct _zcdClientStreamSocketClass zcdClientStreamSocketClass;

struct _zcdIConnectedStreamSocketIface {
	GTypeInterface parent_iface;
	guint16 (*_peer_port_getter) (zcdIConnectedStreamSocket* self);
	const gchar* (*_peer_address_getter) (zcdIConnectedStreamSocket* self);
	guint16 (*_my_port_getter) (zcdIConnectedStreamSocket* self);
	const gchar* (*_my_address_getter) (zcdIConnectedStreamSocket* self);
	gint (*send_part) (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, gint maxlen, GError** error);
	guchar* (*recv) (zcdIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error);
	void (*close) (zcdIConnectedStreamSocket* self, GError** error);
};

typedef enum  {
	ZCD_SERIALIZER_ERROR_GENERIC
} zcdSerializerError;
#define ZCD_SERIALIZER_ERROR zcd_serializer_error_quark ()
struct _zcdISerializableIface {
	GTypeInterface parent_iface;
	GVariant* (*serialize_to_variant) (zcdISerializable* self);
	void (*deserialize_from_variant) (zcdISerializable* self, GVariant* v, GError** error);
};

typedef enum  {
	ZCD_RPC_ERROR_FUNCTION_NOT_REMOTABLE,
	ZCD_RPC_ERROR_MALFORMED_PACKET,
	ZCD_RPC_ERROR_NETWORK_ERROR,
	ZCD_RPC_ERROR_NOT_VALID_MAP_YET,
	ZCD_RPC_ERROR_DROP,
	ZCD_RPC_ERROR_SERIALIZER_ERROR,
	ZCD_RPC_ERROR_GENERIC
} zcdRPCError;
#define ZCD_RPC_ERROR zcd_rpc_error_quark ()
struct _zcdFakeRmtIface {
	GTypeInterface parent_iface;
	zcdISerializable* (*rmt) (zcdFakeRmt* self, zcdRemoteCall* data, GError** error);
};

struct _zcdTCPClient {
	GObject parent_instance;
	zcdTCPClientPrivate * priv;
	guint16 dest_port;
};

struct _zcdTCPClientClass {
	GObjectClass parent_class;
};

struct _zcdTCPClientPrivate {
	gchar* _dest_addr;
	gchar* my_addr;
	gboolean wait_response;
	gboolean connected;
	gboolean _calling;
	gboolean _retry_connect;
	zcdIConnectedStreamSocket* socket;
};


extern gboolean zcd_endianness_network;
static gpointer zcd_tcp_client_parent_class = NULL;
static zcdFakeRmtIface* zcd_tcp_client_zcd_fake_rmt_parent_iface = NULL;

guchar* zcd_data_pack (guchar* data, int data_length1, int* result_length1);
GType zcd_iconnected_stream_socket_get_type (void) G_GNUC_CONST;
guchar* zcd_data_unpack_from_stream (zcdIConnectedStreamSocket* socket, int* result_length1);
guchar* zcd_iconnected_stream_socket_recv (zcdIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error);
static guchar* _vala_array_dup2 (guchar* self, int length);
static guint _variant_get14 (GVariant* value);
void zcd_log_debug (const gchar* msg);
static guchar* _vala_array_dup3 (guchar* self, int length);
GType zcd_remote_call_get_type (void) G_GNUC_CONST;
GQuark zcd_serializer_error_quark (void);
GType zcd_iserializable_get_type (void) G_GNUC_CONST;
GQuark zcd_rpc_error_quark (void);
GType zcd_fake_rmt_get_type (void) G_GNUC_CONST;
GType zcd_tcp_client_get_type (void) G_GNUC_CONST;
#define ZCD_TCP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_TCP_CLIENT, zcdTCPClientPrivate))
enum  {
	ZCD_TCP_CLIENT_DUMMY_PROPERTY,
	ZCD_TCP_CLIENT_DEST_ADDR,
	ZCD_TCP_CLIENT_CALLING,
	ZCD_TCP_CLIENT_RETRY_CONNECT
};
const gchar* zcd_tcp_client_get_dest_addr (zcdTCPClient* self);
void zcd_tcp_client_close (zcdTCPClient* self, GError** error);
zcdTCPClient* zcd_tcp_client_new (const gchar* dest_addr, guint16* dest_port, const gchar* my_addr, gboolean wait_response);
zcdTCPClient* zcd_tcp_client_construct (GType object_type, const gchar* dest_addr, guint16* dest_port, const gchar* my_addr, gboolean wait_response);
static void zcd_tcp_client_set_dest_addr (zcdTCPClient* self, const gchar* value);
static void zcd_tcp_client_set_calling (zcdTCPClient* self, gboolean value);
static zcdISerializable* zcd_tcp_client_real_rmt (zcdFakeRmt* base, zcdRemoteCall* data, GError** error);
gchar* zcd_remote_call_to_string (zcdRemoteCall* self);
gboolean zcd_tcp_client_get_calling (zcdTCPClient* self);
void zcd_log_warn (const gchar* msg);
zcdTCPRequest* zcd_tcp_request_new (gboolean wait_response, zcdRemoteCall* data);
zcdTCPRequest* zcd_tcp_request_construct (GType object_type, gboolean wait_response, zcdRemoteCall* data);
GType zcd_tcp_request_get_type (void) G_GNUC_CONST;
void zcd_tcp_client_rpc_send (zcdTCPClient* self, guchar* serdata, int serdata_length1, GError** error);
guchar* zcd_iserializable_serialize (zcdISerializable* self, int* result_length1);
zcdISerializable* zcd_tcp_client_rpc_receive (zcdTCPClient* self, GError** error);
zcdSerializableNone* zcd_serializable_none_new (void);
zcdSerializableNone* zcd_serializable_none_construct (GType object_type);
GType zcd_serializable_none_get_type (void) G_GNUC_CONST;
void zcd_tcp_client_connect (zcdTCPClient* self);
gboolean zcd_tcp_client_get_retry_connect (zcdTCPClient* self);
void zcd_iconnected_stream_socket_send (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, GError** error);
zcdISerializable* zcd_iserializable_deserialize (guchar* ser, int ser_length1, GError** error);
zcdClientStreamSocket* zcd_client_stream_socket_new (const gchar* my_addr, GError** error);
zcdClientStreamSocket* zcd_client_stream_socket_construct (GType object_type, const gchar* my_addr, GError** error);
GType zcd_client_stream_socket_get_type (void) G_GNUC_CONST;
zcdIConnectedStreamSocket* zcd_client_stream_socket_socket_connect (zcdClientStreamSocket* self, const gchar* addr, guint16 port, GError** error);
void zcd_iconnected_stream_socket_close (zcdIConnectedStreamSocket* self, GError** error);
void zcd_tcp_client_set_retry_connect (zcdTCPClient* self, gboolean value);
static void zcd_tcp_client_finalize (GObject* obj);
static void _vala_zcd_tcp_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zcd_tcp_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/** Packs a message of variable size together with the indication of its size
      */
guchar* zcd_data_pack (guchar* data, int data_length1, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guint data_sz;
	guint _tmp1_;
	GVariant* _tmp2_;
	GVariant* data_hdr;
	GVariant* _tmp3_;
	gsize _tmp4_ = 0UL;
	guint data_hdr_sz;
	guchar* ser;
	gint ser_length1;
	gint _ser_size_;
	guint _tmp5_;
	guint _tmp6_;
	guchar* _tmp7_ = NULL;
	gboolean _tmp20_;
	GVariant* _tmp23_;
	guchar* _tmp24_;
	gint _tmp24__length1;
	guchar* _tmp25_;
	gint _tmp25__length1;
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	data_sz = (guint) _tmp0__length1;
	_tmp1_ = data_sz;
	_tmp2_ = g_variant_new_uint32 ((guint32) _tmp1_);
	g_variant_ref_sink (_tmp2_);
	data_hdr = _tmp2_;
	_tmp3_ = data_hdr;
	_tmp4_ = g_variant_get_size (_tmp3_);
	data_hdr_sz = (guint) _tmp4_;
	ser = NULL;
	ser_length1 = 0;
	_ser_size_ = ser_length1;
	_tmp5_ = data_hdr_sz;
	_tmp6_ = data_sz;
	_tmp7_ = g_new0 (guchar, _tmp5_ + _tmp6_);
	ser = (g_free (ser), NULL);
	ser = _tmp7_;
	ser_length1 = _tmp5_ + _tmp6_;
	_ser_size_ = ser_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				guint _tmp12_;
				guchar* _tmp13_;
				gint _tmp13__length1;
				guint _tmp14_;
				gint _tmp15_;
				guchar* _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				guchar _tmp18_;
				guchar _tmp19_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = data_sz;
				if (!(((guint) _tmp11_) < _tmp12_)) {
					break;
				}
				_tmp13_ = ser;
				_tmp13__length1 = ser_length1;
				_tmp14_ = data_hdr_sz;
				_tmp15_ = i;
				_tmp16_ = data;
				_tmp16__length1 = data_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				_tmp13_[_tmp14_ + _tmp15_] = _tmp18_;
				_tmp19_ = _tmp13_[_tmp14_ + _tmp15_];
			}
		}
	}
	_tmp20_ = zcd_endianness_network;
	if (!_tmp20_) {
		GVariant* _tmp21_;
		GVariant* _tmp22_ = NULL;
		_tmp21_ = data_hdr;
		_tmp22_ = g_variant_byteswap (_tmp21_);
		_g_variant_unref0 (data_hdr);
		data_hdr = _tmp22_;
	}
	_tmp23_ = data_hdr;
	_tmp24_ = ser;
	_tmp24__length1 = ser_length1;
	g_variant_store (_tmp23_, _tmp24_);
	_tmp25_ = ser;
	_tmp25__length1 = ser_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	_g_variant_unref0 (data_hdr);
	return result;
}


/** Reads from a stream a message of variable size (use with tcp streams)
      */
static guchar* _vala_array_dup2 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


static guint _variant_get14 (GVariant* value) {
	return g_variant_get_uint32 (value);
}


static guchar* _vala_array_dup3 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


guchar* zcd_data_unpack_from_stream (zcdIConnectedStreamSocket* socket, int* result_length1) {
	guchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (socket != NULL, NULL);
	{
		gint i = 0;
		guchar* _tmp0_ = NULL;
		guchar* readBuffer;
		gint readBuffer_length1;
		gint _readBuffer_size_;
		GVariant* _tmp1_;
		GVariant* data_hdr_tmp;
		GVariant* _tmp2_;
		gsize _tmp3_ = 0UL;
		guint data_hdr_sz;
		_tmp0_ = g_new0 (guchar, 0);
		readBuffer = _tmp0_;
		readBuffer_length1 = 0;
		_readBuffer_size_ = readBuffer_length1;
		_tmp1_ = g_variant_new_uint32 ((guint32) 0);
		g_variant_ref_sink (_tmp1_);
		data_hdr_tmp = _tmp1_;
		_tmp2_ = data_hdr_tmp;
		_tmp3_ = g_variant_get_size (_tmp2_);
		data_hdr_sz = (guint) _tmp3_;
		while (TRUE) {
			zcdIConnectedStreamSocket* _tmp4_;
			guint _tmp5_;
			guchar* _tmp6_;
			gint _tmp6__length1;
			gint _tmp7_ = 0;
			guchar* _tmp8_ = NULL;
			guchar* rawPacket;
			gint rawPacket_length1;
			gint _rawPacket_size_;
			guchar* _tmp9_;
			gint _tmp9__length1;
			guchar* _tmp10_;
			gint _tmp10__length1;
			guchar* _tmp11_ = NULL;
			guchar* tempBuffer;
			gint tempBuffer_length1;
			gint _tempBuffer_size_;
			guchar* _tmp35_;
			gint _tmp35__length1;
			guchar* _tmp36_;
			gint _tmp36__length1;
			guchar* _tmp37_;
			gint _tmp37__length1;
			guint _tmp38_;
			_tmp4_ = socket;
			_tmp5_ = data_hdr_sz;
			_tmp6_ = readBuffer;
			_tmp6__length1 = readBuffer_length1;
			_tmp8_ = zcd_iconnected_stream_socket_recv (_tmp4_, (gint) (_tmp5_ - _tmp6__length1), &_tmp7_, &_inner_error_);
			rawPacket = _tmp8_;
			rawPacket_length1 = _tmp7_;
			_rawPacket_size_ = rawPacket_length1;
			if (_inner_error_ != NULL) {
				_g_variant_unref0 (data_hdr_tmp);
				readBuffer = (g_free (readBuffer), NULL);
				goto __catch1_g_error;
			}
			_tmp9_ = readBuffer;
			_tmp9__length1 = readBuffer_length1;
			_tmp10_ = rawPacket;
			_tmp10__length1 = rawPacket_length1;
			_tmp11_ = g_new0 (guchar, _tmp9__length1 + _tmp10__length1);
			tempBuffer = _tmp11_;
			tempBuffer_length1 = _tmp9__length1 + _tmp10__length1;
			_tempBuffer_size_ = tempBuffer_length1;
			{
				gboolean _tmp12_;
				i = 0;
				_tmp12_ = TRUE;
				while (TRUE) {
					gboolean _tmp13_;
					gint _tmp15_;
					guchar* _tmp16_;
					gint _tmp16__length1;
					guchar* _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					guchar* _tmp19_;
					gint _tmp19__length1;
					gint _tmp20_;
					guchar _tmp21_;
					guchar _tmp22_;
					_tmp13_ = _tmp12_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp15_ = i;
					_tmp16_ = readBuffer;
					_tmp16__length1 = readBuffer_length1;
					if (!(_tmp15_ < _tmp16__length1)) {
						break;
					}
					_tmp17_ = tempBuffer;
					_tmp17__length1 = tempBuffer_length1;
					_tmp18_ = i;
					_tmp19_ = readBuffer;
					_tmp19__length1 = readBuffer_length1;
					_tmp20_ = i;
					_tmp21_ = _tmp19_[_tmp20_];
					_tmp17_[_tmp18_] = _tmp21_;
					_tmp22_ = _tmp17_[_tmp18_];
				}
			}
			{
				gboolean _tmp23_;
				i = 0;
				_tmp23_ = TRUE;
				while (TRUE) {
					gboolean _tmp24_;
					gint _tmp26_;
					guchar* _tmp27_;
					gint _tmp27__length1;
					guchar* _tmp28_;
					gint _tmp28__length1;
					guchar* _tmp29_;
					gint _tmp29__length1;
					gint _tmp30_;
					guchar* _tmp31_;
					gint _tmp31__length1;
					gint _tmp32_;
					guchar _tmp33_;
					guchar _tmp34_;
					_tmp24_ = _tmp23_;
					if (!_tmp24_) {
						gint _tmp25_;
						_tmp25_ = i;
						i = _tmp25_ + 1;
					}
					_tmp23_ = FALSE;
					_tmp26_ = i;
					_tmp27_ = rawPacket;
					_tmp27__length1 = rawPacket_length1;
					if (!(_tmp26_ < _tmp27__length1)) {
						break;
					}
					_tmp28_ = tempBuffer;
					_tmp28__length1 = tempBuffer_length1;
					_tmp29_ = readBuffer;
					_tmp29__length1 = readBuffer_length1;
					_tmp30_ = i;
					_tmp31_ = rawPacket;
					_tmp31__length1 = rawPacket_length1;
					_tmp32_ = i;
					_tmp33_ = _tmp31_[_tmp32_];
					_tmp28_[_tmp29__length1 + _tmp30_] = _tmp33_;
					_tmp34_ = _tmp28_[_tmp29__length1 + _tmp30_];
				}
			}
			_tmp35_ = tempBuffer;
			_tmp35__length1 = tempBuffer_length1;
			_tmp36_ = (_tmp35_ != NULL) ? _vala_array_dup2 (_tmp35_, _tmp35__length1) : ((gpointer) _tmp35_);
			_tmp36__length1 = _tmp35__length1;
			readBuffer = (g_free (readBuffer), NULL);
			readBuffer = _tmp36_;
			readBuffer_length1 = _tmp36__length1;
			_readBuffer_size_ = readBuffer_length1;
			_tmp37_ = readBuffer;
			_tmp37__length1 = readBuffer_length1;
			_tmp38_ = data_hdr_sz;
			if (((guint) _tmp37__length1) == _tmp38_) {
				const GVariantType* _tmp39_;
				guchar* _tmp40_;
				gint _tmp40__length1;
				GVariant* _tmp41_ = NULL;
				GVariant* data_hdr;
				gboolean _tmp42_;
				GVariant* _tmp45_;
				guint _tmp46_;
				guint data_sz;
				guint _tmp47_;
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_;
				guchar* _tmp52_ = NULL;
				guchar* _tmp89_;
				gint _tmp89__length1;
				_tmp39_ = G_VARIANT_TYPE_UINT32;
				_tmp40_ = readBuffer;
				_tmp40__length1 = readBuffer_length1;
				_tmp41_ = g_variant_new_from_data (_tmp39_, _tmp40_, _tmp40__length1, FALSE, g_free, NULL);
				g_variant_ref_sink (_tmp41_);
				data_hdr = _tmp41_;
				_tmp42_ = zcd_endianness_network;
				if (!_tmp42_) {
					GVariant* _tmp43_;
					GVariant* _tmp44_ = NULL;
					_tmp43_ = data_hdr;
					_tmp44_ = g_variant_byteswap (_tmp43_);
					_g_variant_unref0 (data_hdr);
					data_hdr = _tmp44_;
				}
				_tmp45_ = data_hdr;
				_tmp46_ = _variant_get14 (_tmp45_);
				data_sz = _tmp46_;
				_tmp47_ = data_sz;
				_tmp48_ = g_strdup_printf ("%u", _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strconcat ("zcd: data_unpack_from_stream: start reading ", _tmp49_, " bytes from stream.", NULL);
				_tmp51_ = _tmp50_;
				zcd_log_debug (_tmp51_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_tmp52_ = g_new0 (guchar, 0);
				readBuffer = (g_free (readBuffer), NULL);
				readBuffer = _tmp52_;
				readBuffer_length1 = 0;
				_readBuffer_size_ = readBuffer_length1;
				while (TRUE) {
					guchar* _tmp53_;
					gint _tmp53__length1;
					guint _tmp54_;
					zcdIConnectedStreamSocket* _tmp55_;
					guint _tmp56_;
					guchar* _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_ = 0;
					guchar* _tmp59_ = NULL;
					guchar* _tmp60_;
					gint _tmp60__length1;
					gint __tmp60__size_;
					guchar* _tmp61_;
					gint _tmp61__length1;
					guchar* _tmp62_;
					gint _tmp62__length1;
					guchar* _tmp63_ = NULL;
					guchar* _tmp87_;
					gint _tmp87__length1;
					guchar* _tmp88_;
					gint _tmp88__length1;
					_tmp53_ = readBuffer;
					_tmp53__length1 = readBuffer_length1;
					_tmp54_ = data_sz;
					if (!(((guint) _tmp53__length1) != _tmp54_)) {
						break;
					}
					_tmp55_ = socket;
					_tmp56_ = data_sz;
					_tmp57_ = readBuffer;
					_tmp57__length1 = readBuffer_length1;
					_tmp59_ = zcd_iconnected_stream_socket_recv (_tmp55_, (gint) (_tmp56_ - _tmp57__length1), &_tmp58_, &_inner_error_);
					_tmp60_ = _tmp59_;
					_tmp60__length1 = _tmp58_;
					__tmp60__size_ = _tmp60__length1;
					if (_inner_error_ != NULL) {
						_g_variant_unref0 (data_hdr);
						tempBuffer = (g_free (tempBuffer), NULL);
						rawPacket = (g_free (rawPacket), NULL);
						_g_variant_unref0 (data_hdr_tmp);
						readBuffer = (g_free (readBuffer), NULL);
						goto __catch1_g_error;
					}
					rawPacket = (g_free (rawPacket), NULL);
					rawPacket = _tmp60_;
					rawPacket_length1 = _tmp60__length1;
					_rawPacket_size_ = rawPacket_length1;
					_tmp61_ = readBuffer;
					_tmp61__length1 = readBuffer_length1;
					_tmp62_ = rawPacket;
					_tmp62__length1 = rawPacket_length1;
					_tmp63_ = g_new0 (guchar, _tmp61__length1 + _tmp62__length1);
					tempBuffer = (g_free (tempBuffer), NULL);
					tempBuffer = _tmp63_;
					tempBuffer_length1 = _tmp61__length1 + _tmp62__length1;
					_tempBuffer_size_ = tempBuffer_length1;
					{
						gboolean _tmp64_;
						i = 0;
						_tmp64_ = TRUE;
						while (TRUE) {
							gboolean _tmp65_;
							gint _tmp67_;
							guchar* _tmp68_;
							gint _tmp68__length1;
							guchar* _tmp69_;
							gint _tmp69__length1;
							gint _tmp70_;
							guchar* _tmp71_;
							gint _tmp71__length1;
							gint _tmp72_;
							guchar _tmp73_;
							guchar _tmp74_;
							_tmp65_ = _tmp64_;
							if (!_tmp65_) {
								gint _tmp66_;
								_tmp66_ = i;
								i = _tmp66_ + 1;
							}
							_tmp64_ = FALSE;
							_tmp67_ = i;
							_tmp68_ = readBuffer;
							_tmp68__length1 = readBuffer_length1;
							if (!(_tmp67_ < _tmp68__length1)) {
								break;
							}
							_tmp69_ = tempBuffer;
							_tmp69__length1 = tempBuffer_length1;
							_tmp70_ = i;
							_tmp71_ = readBuffer;
							_tmp71__length1 = readBuffer_length1;
							_tmp72_ = i;
							_tmp73_ = _tmp71_[_tmp72_];
							_tmp69_[_tmp70_] = _tmp73_;
							_tmp74_ = _tmp69_[_tmp70_];
						}
					}
					{
						gboolean _tmp75_;
						i = 0;
						_tmp75_ = TRUE;
						while (TRUE) {
							gboolean _tmp76_;
							gint _tmp78_;
							guchar* _tmp79_;
							gint _tmp79__length1;
							guchar* _tmp80_;
							gint _tmp80__length1;
							guchar* _tmp81_;
							gint _tmp81__length1;
							gint _tmp82_;
							guchar* _tmp83_;
							gint _tmp83__length1;
							gint _tmp84_;
							guchar _tmp85_;
							guchar _tmp86_;
							_tmp76_ = _tmp75_;
							if (!_tmp76_) {
								gint _tmp77_;
								_tmp77_ = i;
								i = _tmp77_ + 1;
							}
							_tmp75_ = FALSE;
							_tmp78_ = i;
							_tmp79_ = rawPacket;
							_tmp79__length1 = rawPacket_length1;
							if (!(_tmp78_ < _tmp79__length1)) {
								break;
							}
							_tmp80_ = tempBuffer;
							_tmp80__length1 = tempBuffer_length1;
							_tmp81_ = readBuffer;
							_tmp81__length1 = readBuffer_length1;
							_tmp82_ = i;
							_tmp83_ = rawPacket;
							_tmp83__length1 = rawPacket_length1;
							_tmp84_ = i;
							_tmp85_ = _tmp83_[_tmp84_];
							_tmp80_[_tmp81__length1 + _tmp82_] = _tmp85_;
							_tmp86_ = _tmp80_[_tmp81__length1 + _tmp82_];
						}
					}
					_tmp87_ = tempBuffer;
					_tmp87__length1 = tempBuffer_length1;
					_tmp88_ = (_tmp87_ != NULL) ? _vala_array_dup3 (_tmp87_, _tmp87__length1) : ((gpointer) _tmp87_);
					_tmp88__length1 = _tmp87__length1;
					readBuffer = (g_free (readBuffer), NULL);
					readBuffer = _tmp88_;
					readBuffer_length1 = _tmp88__length1;
					_readBuffer_size_ = readBuffer_length1;
				}
				_tmp89_ = readBuffer;
				_tmp89__length1 = readBuffer_length1;
				if (result_length1) {
					*result_length1 = _tmp89__length1;
				}
				result = _tmp89_;
				_g_variant_unref0 (data_hdr);
				tempBuffer = (g_free (tempBuffer), NULL);
				rawPacket = (g_free (rawPacket), NULL);
				_g_variant_unref0 (data_hdr_tmp);
				return result;
			}
			tempBuffer = (g_free (tempBuffer), NULL);
			rawPacket = (g_free (rawPacket), NULL);
		}
		_g_variant_unref0 (data_hdr_tmp);
		readBuffer = (g_free (readBuffer), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		guchar* _tmp90_ = NULL;
		guchar* _tmp91_;
		gint _tmp91__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp90_ = g_new0 (guchar, 0);
		_tmp91_ = _tmp90_;
		_tmp91__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp91__length1;
		}
		result = _tmp91_;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


zcdTCPClient* zcd_tcp_client_construct (GType object_type, const gchar* dest_addr, guint16* dest_port, const gchar* my_addr, gboolean wait_response) {
	zcdTCPClient * self = NULL;
	guint16* _tmp0_;
	const gchar* _tmp2_;
	guint16* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (dest_addr != NULL, NULL);
	self = (zcdTCPClient*) g_object_new (object_type, NULL);
	_tmp0_ = dest_port;
	if (_tmp0_ == NULL) {
		guint16 _tmp1_;
		_tmp1_ = (guint16) 269;
		dest_port = &_tmp1_;
	}
	_tmp2_ = dest_addr;
	zcd_tcp_client_set_dest_addr (self, _tmp2_);
	_tmp3_ = dest_port;
	self->dest_port = *_tmp3_;
	_tmp4_ = my_addr;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->my_addr);
	self->priv->my_addr = _tmp5_;
	_tmp6_ = wait_response;
	self->priv->wait_response = _tmp6_;
	_g_object_unref0 (self->priv->socket);
	self->priv->socket = NULL;
	self->priv->connected = FALSE;
	zcd_tcp_client_set_calling (self, FALSE);
	return self;
}


zcdTCPClient* zcd_tcp_client_new (const gchar* dest_addr, guint16* dest_port, const gchar* my_addr, gboolean wait_response) {
	return zcd_tcp_client_construct (ZCD_TYPE_TCP_CLIENT, dest_addr, dest_port, my_addr, wait_response);
}


static zcdISerializable* zcd_tcp_client_real_rmt (zcdFakeRmt* base, zcdRemoteCall* data, GError** error) {
	zcdTCPClient * self;
	zcdISerializable* result = NULL;
	GType _tmp0_ = 0UL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	zcdRemoteCall* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	self = (zcdTCPClient*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp1_ = g_type_name (_tmp0_);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = data;
	_tmp4_ = zcd_remote_call_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, ": sending ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	zcd_log_debug (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = self->priv->_calling;
	if (_tmp8_) {
		zcd_log_warn ("TCPClient: a remote call through TCP is delayed...");
		while (TRUE) {
			gboolean _tmp9_;
			_tmp9_ = self->priv->_calling;
			if (!_tmp9_) {
				break;
			}
			g_usleep ((gulong) 1000);
		}
		zcd_log_warn ("TCPClient: a remote call through TCP was delayed. Now takes place.");
	}
	{
		gboolean _tmp10_;
		zcdRemoteCall* _tmp11_;
		zcdTCPRequest* _tmp12_;
		zcdTCPRequest* message;
		zcdTCPRequest* _tmp13_;
		gint _tmp14_ = 0;
		guchar* _tmp15_ = NULL;
		guchar* _tmp16_;
		gint _tmp16__length1;
		gboolean _tmp17_;
		zcdSerializableNone* _tmp20_;
		zcd_tcp_client_set_calling (self, TRUE);
		_tmp10_ = self->priv->wait_response;
		_tmp11_ = data;
		_tmp12_ = zcd_tcp_request_new (_tmp10_, _tmp11_);
		message = _tmp12_;
		_tmp13_ = message;
		_tmp15_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp13_, &_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _tmp14_;
		zcd_tcp_client_rpc_send (self, _tmp16_, _tmp14_, &_inner_error_);
		_tmp16_ = (g_free (_tmp16_), NULL);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (message);
			goto __finally2;
		}
		_tmp17_ = self->priv->wait_response;
		if (_tmp17_) {
			zcdISerializable* _tmp18_ = NULL;
			zcdISerializable* _tmp19_;
			_tmp18_ = zcd_tcp_client_rpc_receive (self, &_inner_error_);
			_tmp19_ = _tmp18_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (message);
				goto __finally2;
			}
			result = _tmp19_;
			_g_object_unref0 (message);
			{
				zcd_tcp_client_set_calling (self, FALSE);
			}
			return result;
		}
		_tmp20_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp20_;
		_g_object_unref0 (message);
		{
			zcd_tcp_client_set_calling (self, FALSE);
		}
		return result;
	}
	__finally2:
	{
		zcd_tcp_client_set_calling (self, FALSE);
	}
	if (_inner_error_->domain == ZCD_RPC_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void zcd_tcp_client_rpc_send (zcdTCPClient* self, guchar* serdata, int serdata_length1, GError** error) {
	GTimer* _tmp0_;
	GTimer* timeout;
	gint interval;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timer_new ();
	timeout = _tmp0_;
	interval = 5;
	while (TRUE) {
		gboolean _tmp1_;
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp1_ = self->priv->connected;
		if (!(!_tmp1_)) {
			break;
		}
		zcd_log_debug ("TCPClient: trying to connect...");
		zcd_tcp_client_connect (self);
		_tmp3_ = self->priv->connected;
		if (_tmp3_) {
			_tmp2_ = "True";
		} else {
			_tmp2_ = "False";
		}
		_tmp4_ = _tmp2_;
		_tmp5_ = g_strconcat ("TCPClient: connect returns ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		zcd_log_debug (_tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->connected;
		if (!_tmp7_) {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_;
			gboolean _tmp12_;
			gint _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			_tmp9_ = self->priv->_retry_connect;
			if (!_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				GTimer* _tmp10_;
				gdouble _tmp11_ = 0.0;
				_tmp10_ = timeout;
				_tmp11_ = g_timer_elapsed (_tmp10_, NULL);
				_tmp8_ = _tmp11_ > ((gdouble) 30);
			}
			_tmp12_ = _tmp8_;
			if (_tmp12_) {
				const gchar* _tmp13_;
				const gchar* _tmp14_ = NULL;
				guint16 _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				GError* _tmp20_;
				GError* _tmp21_;
				_tmp13_ = self->priv->_dest_addr;
				_tmp14_ = string_to_string (_tmp13_);
				_tmp15_ = self->dest_port;
				_tmp16_ = g_strdup_printf ("%hu", _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat ("Failed connecting to (\"", _tmp14_, "\", ", _tmp17_, ")", NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, _tmp19_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_inner_error_ = _tmp21_;
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_timer_destroy0 (timeout);
					return;
				} else {
					_g_timer_destroy0 (timeout);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp22_ = interval;
			_tmp23_ = g_strdup_printf ("%i", _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat ("wait ", _tmp24_, " before trying again to connect a TCPClient...", NULL);
			_tmp26_ = _tmp25_;
			zcd_log_debug (_tmp26_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_tmp27_ = interval;
			g_usleep ((gulong) (_tmp27_ * 1000));
			_tmp28_ = interval;
			interval = _tmp28_ * 2;
			_tmp29_ = interval;
			if (_tmp29_ > 10000) {
				interval = 10000;
			}
		}
	}
	zcd_log_debug ("TCPClient: sending message...");
	{
		zcdIConnectedStreamSocket* _tmp30_;
		guchar* _tmp31_;
		gint _tmp31__length1;
		gint _tmp32_ = 0;
		guchar* _tmp33_ = NULL;
		guchar* _tmp34_;
		gint _tmp34__length1;
		_tmp30_ = self->priv->socket;
		_tmp31_ = serdata;
		_tmp31__length1 = serdata_length1;
		_tmp33_ = zcd_data_pack (_tmp31_, _tmp31__length1, &_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp34__length1 = _tmp32_;
		zcd_iconnected_stream_socket_send (_tmp30_, _tmp34_, _tmp32_, &_inner_error_);
		_tmp34_ = (g_free (_tmp34_), NULL);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		self->priv->connected = FALSE;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		_tmp37_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, _tmp36_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_timer_destroy0 (timeout);
			return;
		} else {
			_g_timer_destroy0 (timeout);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	zcd_log_debug ("TCPClient: message sent.");
	_g_timer_destroy0 (timeout);
}


zcdISerializable* zcd_tcp_client_rpc_receive (zcdTCPClient* self, GError** error) {
	zcdISerializable* result = NULL;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->connected;
	if (_tmp0_) {
		zcdIConnectedStreamSocket* _tmp1_;
		gint _tmp2_ = 0;
		guchar* _tmp3_ = NULL;
		guchar* recv_encoded_data;
		gint recv_encoded_data_length1;
		gint _recv_encoded_data_size_;
		guchar* _tmp4_;
		gint _tmp4__length1;
		zcdISerializable* ret = NULL;
		zcd_log_debug ("TCPClient: receiving response...");
		_tmp1_ = self->priv->socket;
		_tmp3_ = zcd_data_unpack_from_stream (_tmp1_, &_tmp2_);
		recv_encoded_data = _tmp3_;
		recv_encoded_data_length1 = _tmp2_;
		_recv_encoded_data_size_ = recv_encoded_data_length1;
		zcd_log_debug ("TCPClient: got response.");
		_tmp4_ = recv_encoded_data;
		_tmp4__length1 = recv_encoded_data_length1;
		if (_tmp4__length1 == 0) {
			GError* _tmp5_;
			zcd_log_debug ("TCPClient: throwing 'Connection closed before reply'.");
			self->priv->connected = FALSE;
			_tmp5_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, "Connection closed before reply");
			_inner_error_ = _tmp5_;
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				g_propagate_error (error, _inner_error_);
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				return NULL;
			} else {
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		zcd_log_debug ("TCPClient: deserializing.");
		{
			guchar* _tmp6_;
			gint _tmp6__length1;
			zcdISerializable* _tmp7_ = NULL;
			zcdISerializable* _tmp8_;
			_tmp6_ = recv_encoded_data;
			_tmp6__length1 = recv_encoded_data_length1;
			_tmp7_ = zcd_iserializable_deserialize (_tmp6_, _tmp6__length1, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
					goto __catch4_zcd_serializer_error;
				}
				_g_object_unref0 (ret);
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (ret);
			ret = _tmp8_;
		}
		goto __finally4;
		__catch4_zcd_serializer_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_SERIALIZER_ERROR, "Error deserializing response");
			_inner_error_ = _tmp9_;
			_g_error_free0 (e);
			goto __finally4;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (ret);
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				return NULL;
			} else {
				_g_object_unref0 (ret);
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = ret;
		recv_encoded_data = (g_free (recv_encoded_data), NULL);
		return result;
	} else {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, "Connection closed before reply");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


void zcd_tcp_client_connect (zcdTCPClient* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		zcdClientStreamSocket* _tmp1_;
		zcdClientStreamSocket* x;
		zcdClientStreamSocket* _tmp2_;
		const gchar* _tmp3_;
		guint16 _tmp4_;
		zcdIConnectedStreamSocket* _tmp5_ = NULL;
		zcdIConnectedStreamSocket* _tmp6_;
		_tmp0_ = self->priv->my_addr;
		_tmp1_ = zcd_client_stream_socket_new (_tmp0_, &_inner_error_);
		x = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp2_ = x;
		_tmp3_ = self->priv->_dest_addr;
		_tmp4_ = self->dest_port;
		_tmp5_ = zcd_client_stream_socket_socket_connect (_tmp2_, _tmp3_, _tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (x);
			goto __catch5_g_error;
		}
		_g_object_unref0 (self->priv->socket);
		self->priv->socket = _tmp6_;
		self->priv->connected = TRUE;
		_g_object_unref0 (x);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strdup_printf ("TCPClient: socket connect error: %s", _tmp8_);
		_tmp10_ = _tmp9_;
		zcd_log_debug (_tmp10_);
		_g_free0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void zcd_tcp_client_close (zcdTCPClient* self, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connected;
	if (_tmp0_) {
		zcdIConnectedStreamSocket* _tmp1_;
		_tmp1_ = self->priv->socket;
		if (_tmp1_ != NULL) {
			{
				zcdIConnectedStreamSocket* _tmp2_;
				_tmp2_ = self->priv->socket;
				zcd_iconnected_stream_socket_close (_tmp2_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch6_g_error;
				}
			}
			goto __finally6;
			__catch6_g_error:
			{
				GError* e = NULL;
				GError* _tmp3_;
				const gchar* _tmp4_;
				GError* _tmp5_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp3_ = e;
				_tmp4_ = _tmp3_->message;
				_tmp5_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, _tmp4_);
				_inner_error_ = _tmp5_;
				_g_error_free0 (e);
				goto __finally6;
			}
			__finally6:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_object_unref0 (self->priv->socket);
			self->priv->socket = NULL;
		}
		self->priv->connected = FALSE;
	}
}


const gchar* zcd_tcp_client_get_dest_addr (zcdTCPClient* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dest_addr;
	result = _tmp0_;
	return result;
}


static void zcd_tcp_client_set_dest_addr (zcdTCPClient* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dest_addr);
	self->priv->_dest_addr = _tmp1_;
	g_object_notify ((GObject *) self, "dest-addr");
}


gboolean zcd_tcp_client_get_calling (zcdTCPClient* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_calling;
	result = _tmp0_;
	return result;
}


static void zcd_tcp_client_set_calling (zcdTCPClient* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_calling = _tmp0_;
	g_object_notify ((GObject *) self, "calling");
}


gboolean zcd_tcp_client_get_retry_connect (zcdTCPClient* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_retry_connect;
	result = _tmp0_;
	return result;
}


void zcd_tcp_client_set_retry_connect (zcdTCPClient* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_retry_connect = _tmp0_;
	g_object_notify ((GObject *) self, "retry-connect");
}


static void zcd_tcp_client_class_init (zcdTCPClientClass * klass) {
	zcd_tcp_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdTCPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_tcp_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zcd_tcp_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_tcp_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_TCP_CLIENT_DEST_ADDR, g_param_spec_string ("dest-addr", "dest-addr", "dest-addr", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_TCP_CLIENT_CALLING, g_param_spec_boolean ("calling", "calling", "calling", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_TCP_CLIENT_RETRY_CONNECT, g_param_spec_boolean ("retry-connect", "retry-connect", "retry-connect", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void zcd_tcp_client_zcd_fake_rmt_interface_init (zcdFakeRmtIface * iface) {
	zcd_tcp_client_zcd_fake_rmt_parent_iface = g_type_interface_peek_parent (iface);
	iface->rmt = (zcdISerializable* (*)(zcdFakeRmt*, zcdRemoteCall*, GError**)) zcd_tcp_client_real_rmt;
}


static void zcd_tcp_client_instance_init (zcdTCPClient * self) {
	self->priv = ZCD_TCP_CLIENT_GET_PRIVATE (self);
	self->priv->_retry_connect = TRUE;
}


static void zcd_tcp_client_finalize (GObject* obj) {
	zcdTCPClient * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_TCP_CLIENT, zcdTCPClient);
	_tmp0_ = self->priv->_dest_addr;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("TCPClient: destructor: \"", _tmp1_, "\"", NULL);
	_tmp3_ = _tmp2_;
	zcd_log_debug (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->connected;
	if (_tmp4_) {
		zcd_tcp_client_close (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_free0 (self->priv->_dest_addr);
	_g_free0 (self->priv->my_addr);
	_g_object_unref0 (self->priv->socket);
	G_OBJECT_CLASS (zcd_tcp_client_parent_class)->finalize (obj);
}


/** An instance of this class is used when we want to send a message via TCP.
      */
GType zcd_tcp_client_get_type (void) {
	static volatile gsize zcd_tcp_client_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_tcp_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdTCPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_tcp_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdTCPClient), 0, (GInstanceInitFunc) zcd_tcp_client_instance_init, NULL };
		static const GInterfaceInfo zcd_fake_rmt_info = { (GInterfaceInitFunc) zcd_tcp_client_zcd_fake_rmt_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_tcp_client_type_id;
		zcd_tcp_client_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdTCPClient", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_tcp_client_type_id, ZCD_TYPE_FAKE_RMT, &zcd_fake_rmt_info);
		g_once_init_leave (&zcd_tcp_client_type_id__volatile, zcd_tcp_client_type_id);
	}
	return zcd_tcp_client_type_id__volatile;
}


static void _vala_zcd_tcp_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdTCPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_TCP_CLIENT, zcdTCPClient);
	switch (property_id) {
		case ZCD_TCP_CLIENT_DEST_ADDR:
		g_value_set_string (value, zcd_tcp_client_get_dest_addr (self));
		break;
		case ZCD_TCP_CLIENT_CALLING:
		g_value_set_boolean (value, zcd_tcp_client_get_calling (self));
		break;
		case ZCD_TCP_CLIENT_RETRY_CONNECT:
		g_value_set_boolean (value, zcd_tcp_client_get_retry_connect (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zcd_tcp_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	zcdTCPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_TCP_CLIENT, zcdTCPClient);
	switch (property_id) {
		case ZCD_TCP_CLIENT_DEST_ADDR:
		zcd_tcp_client_set_dest_addr (self, g_value_get_string (value));
		break;
		case ZCD_TCP_CLIENT_CALLING:
		zcd_tcp_client_set_calling (self, g_value_get_boolean (value));
		break;
		case ZCD_TCP_CLIENT_RETRY_CONNECT:
		zcd_tcp_client_set_retry_connect (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



