/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using Tasklets;
using zcd;
using Ntk.Test;

namespace Netsukuku
{
#if log_tasklet
    private string tasklet_id()
    {
        return @"[$(Tasklet.self().id)] ";
    }
#else
    private string tasklet_id()
    {
        return "";
    }
#endif
    internal void log_debug(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_info(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_notice(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_warn(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_error(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_critical(string msg) {print_out(tasklet_id()+msg+"\n");}

}

namespace Ntk.Test
{
    string logger;
    const bool output = false;
    public void print_out(string s)
    {
        if (output) print(s);
    }

    public class TaskletTester : Object
    {
        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        public void test_taskletstats ()
        {
            TaskletStats t0;
            {
                uchar[] orig;
                {
                    TaskletStats t = new TaskletStats();
                    t.id = 2;
                    t.parent = 1;
                    t.status = Status.SPAWNED;
                    t.funcname = "pippo";
                    
                    t.status = Status.STARTED;
                    t.tasklet_started = new TimeCapsule(0);
                    
                    t.status = Status.ENDED;
                    t.tasklet_ended = new TimeCapsule(0);

                    orig = t.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                t0 = (TaskletStats)ISerializable.deserialize(dest);
            }
            print_out(@"t0 $(t0.id)\n");
            assert(true);
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            Tasklet.init();
            GLib.Test.add_func ("/Tasklet/Stats", () => {
                var x = new TaskletTester();
                x.set_up();
                x.test_taskletstats();
                x.tear_down();
            });
            GLib.Test.run();
            Tasklet.kill();
            return 0;
        }
    }
}
