/* qspn_tester_2.c generated by valac 0.20.1, the Vala compiler
 * generated from qspn_tester_2.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <syslog.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <zcd.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_ROUTE (netsukuku_route_get_type ())
#define NETSUKUKU_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRoute))
#define NETSUKUKU_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))
#define NETSUKUKU_IS_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_IS_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))

typedef struct _NetsukukuRoute NetsukukuRoute;
typedef struct _NetsukukuRouteClass NetsukukuRouteClass;
typedef struct _NetsukukuRoutePrivate NetsukukuRoutePrivate;

#define NETSUKUKU_TYPE_ROUTE_NODE (netsukuku_route_node_get_type ())
#define NETSUKUKU_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode))
#define NETSUKUKU_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))
#define NETSUKUKU_IS_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_IS_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_ROUTE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))

typedef struct _NetsukukuRouteNode NetsukukuRouteNode;
typedef struct _NetsukukuRouteNodeClass NetsukukuRouteNodeClass;
typedef struct _NetsukukuRouteNodePrivate NetsukukuRouteNodePrivate;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

#define NETSUKUKU_TYPE_ADDRESS_MANAGER (netsukuku_address_manager_get_type ())
#define NETSUKUKU_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager))
#define NETSUKUKU_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))
#define NETSUKUKU_IS_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_IS_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))

typedef struct _NetsukukuAddressManager NetsukukuAddressManager;
typedef struct _NetsukukuAddressManagerClass NetsukukuAddressManagerClass;
typedef struct _NetsukukuAddressManagerPrivate NetsukukuAddressManagerPrivate;

#define NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER (netsukuku_network_interface_manager_get_type ())
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))

typedef struct _NetsukukuNetworkInterfaceManager NetsukukuNetworkInterfaceManager;
typedef struct _NetsukukuNetworkInterfaceManagerClass NetsukukuNetworkInterfaceManagerClass;

#define NETSUKUKU_TYPE_INCOMING_NODES (netsukuku_incoming_nodes_get_type ())
#define NETSUKUKU_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodes))
#define NETSUKUKU_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))
#define NETSUKUKU_IS_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_IS_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_INCOMING_NODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))

typedef struct _NetsukukuIncomingNodes NetsukukuIncomingNodes;
typedef struct _NetsukukuIncomingNodesClass NetsukukuIncomingNodesClass;
#define _netsukuku_incoming_nodes_unref0(var) ((var == NULL) ? NULL : (var = (netsukuku_incoming_nodes_unref (var), NULL)))

#define NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT (netsukuku_fake_address_manager_fake_rmt_get_type ())
#define NETSUKUKU_FAKE_ADDRESS_MANAGER_FAKE_RMT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuFakeAddressManagerFakeRmt))
#define NETSUKUKU_FAKE_ADDRESS_MANAGER_FAKE_RMT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuFakeAddressManagerFakeRmtClass))
#define NETSUKUKU_IS_FAKE_ADDRESS_MANAGER_FAKE_RMT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT))
#define NETSUKUKU_IS_FAKE_ADDRESS_MANAGER_FAKE_RMT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT))
#define NETSUKUKU_FAKE_ADDRESS_MANAGER_FAKE_RMT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuFakeAddressManagerFakeRmtClass))

typedef struct _NetsukukuFakeAddressManagerFakeRmt NetsukukuFakeAddressManagerFakeRmt;
typedef struct _NetsukukuFakeAddressManagerFakeRmtClass NetsukukuFakeAddressManagerFakeRmtClass;

#define NETSUKUKU_TYPE_NIC (netsukuku_nic_get_type ())
#define NETSUKUKU_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNIC))
#define NETSUKUKU_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))
#define NETSUKUKU_IS_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_IS_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))

typedef struct _NetsukukuNIC NetsukukuNIC;
typedef struct _NetsukukuNICClass NetsukukuNICClass;
typedef struct _NetsukukuNICPrivate NetsukukuNICPrivate;
typedef struct _NetsukukuNetworkInterfaceManagerPrivate NetsukukuNetworkInterfaceManagerPrivate;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
typedef struct _NetsukukuAggregatedNeighbourManagerPrivate NetsukukuAggregatedNeighbourManagerPrivate;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;
typedef struct _NetsukukuFakeAddressManagerFakeRmtPrivate NetsukukuFakeAddressManagerFakeRmtPrivate;
typedef struct _NetsukukuIncomingNodesPrivate NetsukukuIncomingNodesPrivate;
typedef struct _NetsukukuParamSpecIncomingNodes NetsukukuParamSpecIncomingNodes;

#define NTK_TEST_TYPE_QSPN_TESTER (ntk_test_qspn_tester_get_type ())
#define NTK_TEST_QSPN_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_QSPN_TESTER, NtkTestQspnTester))
#define NTK_TEST_QSPN_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_QSPN_TESTER, NtkTestQspnTesterClass))
#define NTK_TEST_IS_QSPN_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_QSPN_TESTER))
#define NTK_TEST_IS_QSPN_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_QSPN_TESTER))
#define NTK_TEST_QSPN_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_QSPN_TESTER, NtkTestQspnTesterClass))

typedef struct _NtkTestQspnTester NtkTestQspnTester;
typedef struct _NtkTestQspnTesterClass NtkTestQspnTesterClass;
typedef struct _NtkTestQspnTesterPrivate NtkTestQspnTesterPrivate;

#define NETSUKUKU_TYPE_ETP (netsukuku_etp_get_type ())
#define NETSUKUKU_ETP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtp))
#define NETSUKUKU_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))
#define NETSUKUKU_IS_ETP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_IS_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_ETP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))

typedef struct _NetsukukuEtp NetsukukuEtp;
typedef struct _NetsukukuEtpClass NetsukukuEtpClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_GENERIC
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
typedef enum  {
	NETSUKUKU_INCOMING_NODES_ERROR_GENERIC
} NetsukukuIncomingNodesError;
#define NETSUKUKU_INCOMING_NODES_ERROR netsukuku_incoming_nodes_error_quark ()
typedef enum  {
	NETSUKUKU_RPC_ERROR_FUNCTION_NOT_REMOTABLE,
	NETSUKUKU_RPC_ERROR_MALFORMED_PACKET,
	NETSUKUKU_RPC_ERROR_NETWORK_ERROR,
	NETSUKUKU_RPC_ERROR_NOT_VALID_MAP_YET,
	NETSUKUKU_RPC_ERROR_DROP,
	NETSUKUKU_RPC_ERROR_GENERIC
} NetsukukuRPCError;
#define NETSUKUKU_RPC_ERROR netsukuku_rpc_error_quark ()
struct _NetsukukuRoute {
	GObject parent_instance;
	NetsukukuRoutePrivate * priv;
	NetsukukuREM* rem;
	NetsukukuREM* rem_at_gw;
	GeeList* hops;
	NetsukukuGNodeID* gid;
	GeeList* hops_with_gw;
};

struct _NetsukukuRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuRouteNode {
	GObject parent_instance;
	NetsukukuRouteNodePrivate * priv;
};

struct _NetsukukuRouteNodeClass {
	GObjectClass parent_class;
};

struct _NetsukukuMapRoute {
	GObject parent_instance;
	NetsukukuMapRoutePrivate * priv;
	NetsukukuAddressManager* address_manager;
	gint gsize;
	gint levels;
	NetsukukuNIP* me;
};

struct _NetsukukuMapRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuMapRoutePrivate {
	NetsukukuGNodeID** _id_myself;
	gint _id_myself_length1;
	gint __id_myself_size_;
};

struct _NetsukukuAddressManager {
	GObject parent_instance;
	NetsukukuAddressManagerPrivate * priv;
	GeeArrayList* nics;
	NetsukukuIncomingNodes* incoming_nodes;
	gboolean is_mature;
};

struct _NetsukukuAddressManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuNIC {
	GObject parent_instance;
	NetsukukuNICPrivate * priv;
	gchar* mac;
};

struct _NetsukukuNICClass {
	GObjectClass parent_class;
};

struct _NetsukukuNetworkInterfaceManager {
	GObject parent_instance;
	NetsukukuNetworkInterfaceManagerPrivate * priv;
	gboolean to_be_managed;
	gboolean to_be_copied;
	gboolean initialized;
};

struct _NetsukukuNetworkInterfaceManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuNetworkInterfaceManagerPrivate {
	NetsukukuNIC* _nic_class;
	gchar* _nic_name;
};

struct _NetsukukuAggregatedNeighbourManager {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourManagerPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
	NetsukukuNIP* nip;
	NetsukukuREM* rem;
	gint mod_seq_num;
	NetsukukuNetworkID* netid;
	NetsukukuFakeAddressManagerFakeRmt* neighbour_client;
	gint nodeid;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _NetsukukuFakeAddressManagerFakeRmt {
	NetsukukuAddressManagerFakeRmt parent_instance;
	NetsukukuFakeAddressManagerFakeRmtPrivate * priv;
	NetsukukuFakeAddressManagerFakeRmt* etp;
};

struct _NetsukukuFakeAddressManagerFakeRmtClass {
	NetsukukuAddressManagerFakeRmtClass parent_class;
};

struct _NetsukukuIncomingNodes {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NetsukukuIncomingNodesPrivate * priv;
};

struct _NetsukukuIncomingNodesClass {
	GTypeClass parent_class;
	void (*finalize) (NetsukukuIncomingNodes *self);
};

struct _NetsukukuParamSpecIncomingNodes {
	GParamSpec parent_instance;
};

struct _NtkTestQspnTester {
	GObject parent_instance;
	NtkTestQspnTesterPrivate * priv;
};

struct _NtkTestQspnTesterClass {
	GObjectClass parent_class;
};


extern NetsukukuNetworkID* netsukuku_the_common_netid;
NetsukukuNetworkID* netsukuku_the_common_netid = NULL;
static gpointer netsukuku_route_parent_class = NULL;
static gpointer netsukuku_route_node_parent_class = NULL;
static gpointer netsukuku_map_route_parent_class = NULL;
static gpointer netsukuku_address_manager_parent_class = NULL;
static gpointer netsukuku_nic_parent_class = NULL;
static gpointer netsukuku_network_interface_manager_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_manager_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_parent_class = NULL;
static gpointer netsukuku_fake_address_manager_fake_rmt_parent_class = NULL;
static gpointer netsukuku_incoming_nodes_parent_class = NULL;
extern gchar* ntk_test_logger;
gchar* ntk_test_logger = NULL;
static gpointer ntk_test_qspn_tester_parent_class = NULL;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
guint32 netsukuku_crypto_fnv_32 (guchar* data, int data_length1);
GQuark netsukuku_incoming_nodes_error_quark (void);
GQuark netsukuku_rpc_error_quark (void);
GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
NetsukukuNetworkID* netsukuku_get_common_netid (void);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
GType netsukuku_route_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ROUTE_DUMMY_PROPERTY
};
NetsukukuRoute* netsukuku_route_new (void);
NetsukukuRoute* netsukuku_route_construct (GType object_type);
static void netsukuku_route_finalize (GObject* obj);
GType netsukuku_route_node_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ROUTE_NODE_DUMMY_PROPERTY
};
gboolean netsukuku_route_node_is_empty (NetsukukuRouteNode* self);
gboolean netsukuku_route_node_is_free (NetsukukuRouteNode* self);
NetsukukuGNodeID* netsukuku_route_node_get_eldest_gid (NetsukukuRouteNode* self);
gint netsukuku_route_node_nroutes (NetsukukuRouteNode* self);
NetsukukuRoute* netsukuku_route_node_best_route (NetsukukuRouteNode* self);
NetsukukuRoute* netsukuku_route_node_best_route_without (NetsukukuRouteNode* self, NetsukukuHCoord* hop);
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRoute* netsukuku_route_node_route_get_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRouteNode* netsukuku_route_node_new (void);
NetsukukuRouteNode* netsukuku_route_node_construct (GType object_type);
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_address_manager_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_MAP_ROUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoutePrivate))
enum  {
	NETSUKUKU_MAP_ROUTE_DUMMY_PROPERTY
};
NetsukukuMapRoute* netsukuku_map_route_new (void);
NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type);
NetsukukuHCoord* netsukuku_map_route_nip_to_lvlid (NetsukukuMapRoute* self, NetsukukuNIP* nip_caller);
NetsukukuRouteNode* netsukuku_map_route_node_get (NetsukukuMapRoute* self, gint lvl, gint pos);
GeeList* netsukuku_map_route_list_lvl_id_from_nip (NetsukukuMapRoute* self, GeeList* lvl_ids, NetsukukuNIP* sender_nip);
GeeList* netsukuku_map_route_list_lvl_id_to_nip (NetsukukuMapRoute* self, GeeList* lvl_ids, NetsukukuNIP* to_nip);
gint netsukuku_map_route_nip_cmp (NetsukukuMapRoute* self, gint* nipA, int nipA_length1);
void netsukuku_map_route_update_route_by_gw (NetsukukuMapRoute* self, NetsukukuHCoord* dest, NetsukukuAggregatedNeighbour* nr, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid);
gint netsukuku_map_route_busy_nodes_nb (NetsukukuMapRoute* self, gint lvl);
void netsukuku_map_route_route_signal_rem_changed (NetsukukuMapRoute* self, gint lvl, gint dst);
void netsukuku_map_route_delete_routes_via_neighbour (NetsukukuMapRoute* self, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuGNodeID** netsukuku_map_route_get_id_myself (NetsukukuMapRoute* self, int* result_length1);
static void netsukuku_map_route_set_id_myself (NetsukukuMapRoute* self, NetsukukuGNodeID** value, int value_length1);
static NetsukukuGNodeID** _vala_array_dup1 (NetsukukuGNodeID** self, int length);
static void netsukuku_map_route_finalize (GObject* obj);
static void _vala_netsukuku_map_route_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_map_route_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_network_interface_manager_get_type (void) G_GNUC_CONST;
gpointer netsukuku_incoming_nodes_ref (gpointer instance);
void netsukuku_incoming_nodes_unref (gpointer instance);
GParamSpec* netsukuku_param_spec_incoming_nodes (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void netsukuku_value_set_incoming_nodes (GValue* value, gpointer v_object);
void netsukuku_value_take_incoming_nodes (GValue* value, gpointer v_object);
gpointer netsukuku_value_get_incoming_nodes (const GValue* value);
GType netsukuku_incoming_nodes_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ADDRESS_MANAGER_DUMMY_PROPERTY
};
NetsukukuNetworkID* netsukuku_address_manager_get_main_netid (NetsukukuAddressManager* self);
gboolean netsukuku_address_manager_is_in_my_network (NetsukukuAddressManager* self, NetsukukuNetworkID* netid);
gboolean netsukuku_address_manager_do_i_act_as_gateway_for (NetsukukuAddressManager* self, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid);
gint netsukuku_address_manager_get_my_id (NetsukukuAddressManager* self);
GType netsukuku_fake_address_manager_fake_rmt_get_type (void) G_GNUC_CONST;
NetsukukuFakeAddressManagerFakeRmt* netsukuku_address_manager_get_broadcast_client (NetsukukuAddressManager* self);
NetsukukuFakeAddressManagerFakeRmt* netsukuku_fake_address_manager_fake_rmt_new (void);
NetsukukuFakeAddressManagerFakeRmt* netsukuku_fake_address_manager_fake_rmt_construct (GType object_type);
gboolean netsukuku_address_manager_is_preferred_network (NetsukukuAddressManager* self, NetsukukuNetworkID* netid);
NetsukukuAddressManager* netsukuku_address_manager_new (void);
NetsukukuAddressManager* netsukuku_address_manager_construct (GType object_type);
static void netsukuku_address_manager_finalize (GObject* obj);
GType netsukuku_nic_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_NIC_DUMMY_PROPERTY
};
NetsukukuNIC* netsukuku_nic_new (void);
NetsukukuNIC* netsukuku_nic_construct (GType object_type);
static void netsukuku_nic_finalize (GObject* obj);
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerPrivate))
enum  {
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_DUMMY_PROPERTY,
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS,
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME
};
NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_new (void);
NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_construct (GType object_type);
NetsukukuNIC* netsukuku_network_interface_manager_get_nic_class (NetsukukuNetworkInterfaceManager* self);
static void netsukuku_network_interface_manager_set_nic_class (NetsukukuNetworkInterfaceManager* self, NetsukukuNIC* value);
const gchar* netsukuku_network_interface_manager_get_nic_name (NetsukukuNetworkInterfaceManager* self);
static void netsukuku_network_interface_manager_set_nic_name (NetsukukuNetworkInterfaceManager* self, const gchar* value);
static void netsukuku_network_interface_manager_finalize (GObject* obj);
static void _vala_netsukuku_network_interface_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_network_interface_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_DUMMY_PROPERTY
};
GeeList* netsukuku_aggregated_neighbour_manager_neighbour_list (NetsukukuAggregatedNeighbourManager* self, gboolean* b, NetsukukuNetworkID* with_this_netid);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_manager_key_to_neighbour (NetsukukuAggregatedNeighbourManager* self, NetsukukuNIP* nip, gint nodeid);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_DUMMY_PROPERTY
};
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type);
gchar* netsukuku_aggregated_neighbour_to_string (NetsukukuAggregatedNeighbour* self);
NetsukukuFakeAddressManagerFakeRmt* netsukuku_aggregated_neighbour_create_neighbour_client (NetsukukuAggregatedNeighbour* self, gboolean response);
gboolean netsukuku_aggregated_neighbour_equal_func (NetsukukuAggregatedNeighbour* a, NetsukukuAggregatedNeighbour* b);
guint netsukuku_aggregated_neighbour_hash_func (NetsukukuAggregatedNeighbour* a);
static void netsukuku_aggregated_neighbour_finalize (GObject* obj);
enum  {
	NETSUKUKU_FAKE_ADDRESS_MANAGER_FAKE_RMT_DUMMY_PROPERTY
};
void netsukuku_fake_address_manager_fake_rmt_new_sequence_number (NetsukukuFakeAddressManagerFakeRmt* self, NetsukukuNIP* nip, gint nodeid, gint seqnum);
void netsukuku_fake_address_manager_fake_rmt_act_as_gateway (NetsukukuFakeAddressManagerFakeRmt* self, NetsukukuNIP* nip_caller, gint nodeid_caller, NetsukukuNetworkID* netid_caller, GeeList* macs);
gint netsukuku_fake_address_manager_fake_rmt_request_size (NetsukukuFakeAddressManagerFakeRmt* self);
NetsukukuExtendedTracerPacket* netsukuku_fake_address_manager_fake_rmt_request_etp (NetsukukuFakeAddressManagerFakeRmt* self, gint prev_mod_seq_num, NetsukukuNIP* nip_caller, gint nodeid_caller, NetsukukuNetworkID* netid_caller, GeeList* macs_caller, GError** error);
static zcdISerializable* netsukuku_fake_address_manager_fake_rmt_real_rmt (NetsukukuAddressManagerFakeRmt* base, zcdRemoteCall* data, GError** error);
static void netsukuku_fake_address_manager_fake_rmt_finalize (GObject* obj);
enum  {
	NETSUKUKU_INCOMING_NODES_DUMMY_PROPERTY
};
gboolean netsukuku_incoming_nodes_contains (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid);
NetsukukuRoutesSet* netsukuku_incoming_nodes_get_knowledge (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, gint prev_seq_num);
void netsukuku_incoming_nodes_update (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, GeeList* macs, gint* ttl);
void netsukuku_incoming_nodes_log_knowledge (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, gint my_seq_num, NetsukukuRoutesSet* destinations);
void netsukuku_incoming_nodes_purge (NetsukukuIncomingNodes* self);
NetsukukuIncomingNodes* netsukuku_incoming_nodes_new (void);
NetsukukuIncomingNodes* netsukuku_incoming_nodes_construct (GType object_type);
static void netsukuku_incoming_nodes_finalize (NetsukukuIncomingNodes* obj);
#define NTK_TEST_output FALSE
GType ntk_test_qspn_tester_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_QSPN_TESTER_DUMMY_PROPERTY
};
void ntk_test_qspn_tester_set_up (NtkTestQspnTester* self);
void ntk_test_qspn_tester_tear_down (NtkTestQspnTester* self);
void ntk_test_qspn_tester_test_etp_exec (NtkTestQspnTester* self);
NetsukukuEtp* netsukuku_etp_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuAddressManager* address_manager);
NetsukukuEtp* netsukuku_etp_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuAddressManager* address_manager);
GType netsukuku_etp_get_type (void) G_GNUC_CONST;
static gboolean _netsukuku_hcoord_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
void netsukuku_etp_etp_exec (NetsukukuEtp* self, NetsukukuAggregatedNeighbour* aggregated_neighbour, NetsukukuExtendedTracerPacket* etp);
gint ntk_test_qspn_tester_main (gchar** args, int args_length1);
static void __lambda2_ (void);
NtkTestQspnTester* ntk_test_qspn_tester_new (void);
NtkTestQspnTester* ntk_test_qspn_tester_construct (GType object_type);
static void ___lambda2__gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("[", _tmp5_, "] ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_DEBUG, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_INFO, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_NOTICE, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_WARNING, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_ERR, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_CRIT, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


GQuark netsukuku_crypto_gcrypt_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_crypto_gcrypt_error-quark");
}


guint32 netsukuku_crypto_fnv_32 (guchar* data, int data_length1) {
	guint32 result = 0U;
	result = (guint32) 0;
	return result;
}


GQuark netsukuku_incoming_nodes_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_incoming_nodes_error-quark");
}


GQuark netsukuku_rpc_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_rpc_error-quark");
}


GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	g_return_val_if_fail (partial_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = gsize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) _tmp7_));
			}
		}
	}
	result = ret;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NetsukukuNetworkID* netsukuku_get_common_netid (void) {
	NetsukukuNetworkID* result = NULL;
	NetsukukuNetworkID* _tmp0_;
	NetsukukuNetworkID* _tmp7_;
	NetsukukuNetworkID* _tmp8_;
	_tmp0_ = netsukuku_the_common_netid;
	if (_tmp0_ == NULL) {
		NetsukukuGNodeID* _tmp1_;
		NetsukukuGNodeID* gid0;
		GeeArrayList* _tmp2_;
		GeeArrayList* gidlist;
		GeeArrayList* _tmp3_;
		NetsukukuGNodeID* _tmp4_;
		GeeArrayList* _tmp5_;
		NetsukukuNetworkID* _tmp6_;
		_tmp1_ = netsukuku_gnode_id_new (1, 1, 12323);
		gid0 = _tmp1_;
		_tmp2_ = gee_array_list_new (NETSUKUKU_TYPE_GNODE_ID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		gidlist = _tmp2_;
		_tmp3_ = gidlist;
		_tmp4_ = gid0;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
		_tmp5_ = gidlist;
		_tmp6_ = netsukuku_network_id_new ((GeeList*) _tmp5_);
		_g_object_unref0 (netsukuku_the_common_netid);
		netsukuku_the_common_netid = _tmp6_;
		_g_object_unref0 (gidlist);
		_g_object_unref0 (gid0);
	}
	_tmp7_ = netsukuku_the_common_netid;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}


gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


NetsukukuRoute* netsukuku_route_construct (GType object_type) {
	NetsukukuRoute * self = NULL;
	self = (NetsukukuRoute*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuRoute* netsukuku_route_new (void) {
	return netsukuku_route_construct (NETSUKUKU_TYPE_ROUTE);
}


static void netsukuku_route_class_init (NetsukukuRouteClass * klass) {
	netsukuku_route_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_route_finalize;
}


static void netsukuku_route_instance_init (NetsukukuRoute * self) {
}


static void netsukuku_route_finalize (GObject* obj) {
	NetsukukuRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ROUTE, NetsukukuRoute);
	_g_object_unref0 (self->rem);
	_g_object_unref0 (self->rem_at_gw);
	_g_object_unref0 (self->hops);
	_g_object_unref0 (self->gid);
	_g_object_unref0 (self->hops_with_gw);
	G_OBJECT_CLASS (netsukuku_route_parent_class)->finalize (obj);
}


GType netsukuku_route_get_type (void) {
	static volatile gsize netsukuku_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRoute), 0, (GInstanceInitFunc) netsukuku_route_instance_init, NULL };
		GType netsukuku_route_type_id;
		netsukuku_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_route_type_id__volatile, netsukuku_route_type_id);
	}
	return netsukuku_route_type_id__volatile;
}


gboolean netsukuku_route_node_is_empty (NetsukukuRouteNode* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean netsukuku_route_node_is_free (NetsukukuRouteNode* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


NetsukukuGNodeID* netsukuku_route_node_get_eldest_gid (NetsukukuRouteNode* self) {
	NetsukukuGNodeID* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


gint netsukuku_route_node_nroutes (NetsukukuRouteNode* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}


NetsukukuRoute* netsukuku_route_node_best_route (NetsukukuRouteNode* self) {
	NetsukukuRoute* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuRoute* netsukuku_route_node_best_route_without (NetsukukuRouteNode* self, NetsukukuHCoord* hop) {
	NetsukukuRoute* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hop != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuRoute* netsukuku_route_node_route_get_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRoute* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (aggregated_neighbour != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuRouteNode* netsukuku_route_node_construct (GType object_type) {
	NetsukukuRouteNode * self = NULL;
	self = (NetsukukuRouteNode*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuRouteNode* netsukuku_route_node_new (void) {
	return netsukuku_route_node_construct (NETSUKUKU_TYPE_ROUTE_NODE);
}


static void netsukuku_route_node_class_init (NetsukukuRouteNodeClass * klass) {
	netsukuku_route_node_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_route_node_instance_init (NetsukukuRouteNode * self) {
}


GType netsukuku_route_node_get_type (void) {
	static volatile gsize netsukuku_route_node_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_route_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRouteNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_route_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRouteNode), 0, (GInstanceInitFunc) netsukuku_route_node_instance_init, NULL };
		GType netsukuku_route_node_type_id;
		netsukuku_route_node_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRouteNode", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_route_node_type_id__volatile, netsukuku_route_node_type_id);
	}
	return netsukuku_route_node_type_id__volatile;
}


NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type) {
	NetsukukuMapRoute * self = NULL;
	gint* _tmp0_ = NULL;
	gint* _tmp1_;
	gint _tmp1__length1;
	NetsukukuNIP* _tmp2_;
	self = (NetsukukuMapRoute*) g_object_new (object_type, NULL);
	self->levels = 3;
	self->gsize = 4;
	_tmp0_ = g_new0 (gint, 3);
	_tmp0_[0] = 1;
	_tmp0_[1] = 2;
	_tmp0_[2] = 3;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	_tmp2_ = netsukuku_nip_new (_tmp1_, 3);
	_g_object_unref0 (self->me);
	self->me = _tmp2_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	return self;
}


NetsukukuMapRoute* netsukuku_map_route_new (void) {
	return netsukuku_map_route_construct (NETSUKUKU_TYPE_MAP_ROUTE);
}


NetsukukuHCoord* netsukuku_map_route_nip_to_lvlid (NetsukukuMapRoute* self, NetsukukuNIP* nip_caller) {
	NetsukukuHCoord* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip_caller != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuRouteNode* netsukuku_map_route_node_get (NetsukukuMapRoute* self, gint lvl, gint pos) {
	NetsukukuRouteNode* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = lvl;
	if (_tmp1_ == 0) {
		gint _tmp2_;
		_tmp2_ = pos;
		_tmp0_ = _tmp2_ == 2;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		NetsukukuRouteNode* _tmp4_;
		NetsukukuRouteNode* ret;
		_tmp4_ = netsukuku_route_node_new ();
		ret = _tmp4_;
		result = ret;
		return result;
	}
	result = NULL;
	return result;
}


GeeList* netsukuku_map_route_list_lvl_id_from_nip (NetsukukuMapRoute* self, GeeList* lvl_ids, NetsukukuNIP* sender_nip) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lvl_ids != NULL, NULL);
	g_return_val_if_fail (sender_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


GeeList* netsukuku_map_route_list_lvl_id_to_nip (NetsukukuMapRoute* self, GeeList* lvl_ids, NetsukukuNIP* to_nip) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lvl_ids != NULL, NULL);
	g_return_val_if_fail (to_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


gint netsukuku_map_route_nip_cmp (NetsukukuMapRoute* self, gint* nipA, int nipA_length1) {
	gint result = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = nipA;
	_tmp0__length1 = nipA_length1;
	_tmp1_ = self->me;
	_tmp3_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = netsukuku_nip_nip_cmp (_tmp0_, _tmp0__length1, _tmp4_, _tmp2_);
	_tmp6_ = _tmp5_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	result = _tmp6_;
	return result;
}


void netsukuku_map_route_update_route_by_gw (NetsukukuMapRoute* self, NetsukukuHCoord* dest, NetsukukuAggregatedNeighbour* nr, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest != NULL);
	g_return_if_fail (nr != NULL);
	g_return_if_fail (rem_at_gw != NULL);
	g_return_if_fail (hops != NULL);
	g_return_if_fail (gid != NULL);
}


gint netsukuku_map_route_busy_nodes_nb (NetsukukuMapRoute* self, gint lvl) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 1;
	return result;
}


void netsukuku_map_route_route_signal_rem_changed (NetsukukuMapRoute* self, gint lvl, gint dst) {
	g_return_if_fail (self != NULL);
}


void netsukuku_map_route_delete_routes_via_neighbour (NetsukukuMapRoute* self, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (aggregated_neighbour != NULL);
}


NetsukukuGNodeID** netsukuku_map_route_get_id_myself (NetsukukuMapRoute* self, int* result_length1) {
	NetsukukuGNodeID** result;
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id_myself;
	_tmp0__length1 = self->priv->_id_myself_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static NetsukukuGNodeID** _vala_array_dup1 (NetsukukuGNodeID** self, int length) {
	NetsukukuGNodeID** result;
	int i;
	result = g_new0 (NetsukukuGNodeID*, length + 1);
	for (i = 0; i < length; i++) {
		NetsukukuGNodeID* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void netsukuku_map_route_set_id_myself (NetsukukuMapRoute* self, NetsukukuGNodeID** value, int value_length1) {
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_id_myself = (_vala_array_free (self->priv->_id_myself, self->priv->_id_myself_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_id_myself = _tmp1_;
	self->priv->_id_myself_length1 = _tmp1__length1;
	self->priv->__id_myself_size_ = self->priv->_id_myself_length1;
}


static void netsukuku_map_route_class_init (NetsukukuMapRouteClass * klass) {
	netsukuku_map_route_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuMapRoutePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_map_route_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_map_route_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_route_finalize;
}


static void netsukuku_map_route_instance_init (NetsukukuMapRoute * self) {
	self->priv = NETSUKUKU_MAP_ROUTE_GET_PRIVATE (self);
}


static void netsukuku_map_route_finalize (GObject* obj) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	_g_object_unref0 (self->address_manager);
	self->priv->_id_myself = (_vala_array_free (self->priv->_id_myself, self->priv->_id_myself_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->me);
	G_OBJECT_CLASS (netsukuku_map_route_parent_class)->finalize (obj);
}


GType netsukuku_map_route_get_type (void) {
	static volatile gsize netsukuku_map_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMapRoute), 0, (GInstanceInitFunc) netsukuku_map_route_instance_init, NULL };
		GType netsukuku_map_route_type_id;
		netsukuku_map_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuMapRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_map_route_type_id__volatile, netsukuku_map_route_type_id);
	}
	return netsukuku_map_route_type_id__volatile;
}


static void _vala_netsukuku_map_route_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_map_route_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


NetsukukuNetworkID* netsukuku_address_manager_get_main_netid (NetsukukuAddressManager* self) {
	NetsukukuNetworkID* result = NULL;
	NetsukukuNetworkID* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_get_common_netid ();
	result = _tmp0_;
	return result;
}


gboolean netsukuku_address_manager_is_in_my_network (NetsukukuAddressManager* self, NetsukukuNetworkID* netid) {
	gboolean result = FALSE;
	NetsukukuNetworkID* _tmp0_;
	NetsukukuNetworkID* _tmp1_ = NULL;
	NetsukukuNetworkID* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (netid != NULL, FALSE);
	_tmp0_ = netid;
	_tmp1_ = netsukuku_address_manager_get_main_netid (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp0_ == _tmp2_;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


gboolean netsukuku_address_manager_do_i_act_as_gateway_for (NetsukukuAddressManager* self, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	g_return_val_if_fail (netid != NULL, FALSE);
	result = TRUE;
	return result;
}


gint netsukuku_address_manager_get_my_id (NetsukukuAddressManager* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}


NetsukukuFakeAddressManagerFakeRmt* netsukuku_address_manager_get_broadcast_client (NetsukukuAddressManager* self) {
	NetsukukuFakeAddressManagerFakeRmt* result = NULL;
	NetsukukuFakeAddressManagerFakeRmt* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_fake_address_manager_fake_rmt_new ();
	result = _tmp0_;
	return result;
}


gboolean netsukuku_address_manager_is_preferred_network (NetsukukuAddressManager* self, NetsukukuNetworkID* netid) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (netid != NULL, FALSE);
	result = FALSE;
	return result;
}


NetsukukuAddressManager* netsukuku_address_manager_construct (GType object_type) {
	NetsukukuAddressManager * self = NULL;
	self = (NetsukukuAddressManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAddressManager* netsukuku_address_manager_new (void) {
	return netsukuku_address_manager_construct (NETSUKUKU_TYPE_ADDRESS_MANAGER);
}


static void netsukuku_address_manager_class_init (NetsukukuAddressManagerClass * klass) {
	netsukuku_address_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_address_manager_finalize;
}


static void netsukuku_address_manager_instance_init (NetsukukuAddressManager * self) {
}


static void netsukuku_address_manager_finalize (GObject* obj) {
	NetsukukuAddressManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager);
	_g_object_unref0 (self->nics);
	_netsukuku_incoming_nodes_unref0 (self->incoming_nodes);
	G_OBJECT_CLASS (netsukuku_address_manager_parent_class)->finalize (obj);
}


GType netsukuku_address_manager_get_type (void) {
	static volatile gsize netsukuku_address_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_address_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAddressManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_address_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAddressManager), 0, (GInstanceInitFunc) netsukuku_address_manager_instance_init, NULL };
		GType netsukuku_address_manager_type_id;
		netsukuku_address_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAddressManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_address_manager_type_id__volatile, netsukuku_address_manager_type_id);
	}
	return netsukuku_address_manager_type_id__volatile;
}


NetsukukuNIC* netsukuku_nic_construct (GType object_type) {
	NetsukukuNIC * self = NULL;
	self = (NetsukukuNIC*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuNIC* netsukuku_nic_new (void) {
	return netsukuku_nic_construct (NETSUKUKU_TYPE_NIC);
}


static void netsukuku_nic_class_init (NetsukukuNICClass * klass) {
	netsukuku_nic_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_nic_finalize;
}


static void netsukuku_nic_instance_init (NetsukukuNIC * self) {
}


static void netsukuku_nic_finalize (GObject* obj) {
	NetsukukuNIC * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NIC, NetsukukuNIC);
	_g_free0 (self->mac);
	G_OBJECT_CLASS (netsukuku_nic_parent_class)->finalize (obj);
}


GType netsukuku_nic_get_type (void) {
	static volatile gsize netsukuku_nic_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_nic_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNICClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_nic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNIC), 0, (GInstanceInitFunc) netsukuku_nic_instance_init, NULL };
		GType netsukuku_nic_type_id;
		netsukuku_nic_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuNIC", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_nic_type_id__volatile, netsukuku_nic_type_id);
	}
	return netsukuku_nic_type_id__volatile;
}


NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_construct (GType object_type) {
	NetsukukuNetworkInterfaceManager * self = NULL;
	self = (NetsukukuNetworkInterfaceManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_new (void) {
	return netsukuku_network_interface_manager_construct (NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER);
}


NetsukukuNIC* netsukuku_network_interface_manager_get_nic_class (NetsukukuNetworkInterfaceManager* self) {
	NetsukukuNIC* result;
	NetsukukuNIC* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nic_class;
	result = _tmp0_;
	return result;
}


static void netsukuku_network_interface_manager_set_nic_class (NetsukukuNetworkInterfaceManager* self, NetsukukuNIC* value) {
	NetsukukuNIC* _tmp0_;
	NetsukukuNIC* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_nic_class);
	self->priv->_nic_class = _tmp1_;
	g_object_notify ((GObject *) self, "nic-class");
}


const gchar* netsukuku_network_interface_manager_get_nic_name (NetsukukuNetworkInterfaceManager* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nic_name;
	result = _tmp0_;
	return result;
}


static void netsukuku_network_interface_manager_set_nic_name (NetsukukuNetworkInterfaceManager* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_nic_name);
	self->priv->_nic_name = _tmp1_;
	g_object_notify ((GObject *) self, "nic-name");
}


static void netsukuku_network_interface_manager_class_init (NetsukukuNetworkInterfaceManagerClass * klass) {
	netsukuku_network_interface_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuNetworkInterfaceManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_network_interface_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_network_interface_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_network_interface_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS, g_param_spec_object ("nic-class", "nic-class", "nic-class", NETSUKUKU_TYPE_NIC, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME, g_param_spec_string ("nic-name", "nic-name", "nic-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_network_interface_manager_instance_init (NetsukukuNetworkInterfaceManager * self) {
	self->priv = NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_PRIVATE (self);
}


static void netsukuku_network_interface_manager_finalize (GObject* obj) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	_g_object_unref0 (self->priv->_nic_class);
	_g_free0 (self->priv->_nic_name);
	G_OBJECT_CLASS (netsukuku_network_interface_manager_parent_class)->finalize (obj);
}


GType netsukuku_network_interface_manager_get_type (void) {
	static volatile gsize netsukuku_network_interface_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_network_interface_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNetworkInterfaceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_network_interface_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNetworkInterfaceManager), 0, (GInstanceInitFunc) netsukuku_network_interface_manager_instance_init, NULL };
		GType netsukuku_network_interface_manager_type_id;
		netsukuku_network_interface_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuNetworkInterfaceManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_network_interface_manager_type_id__volatile, netsukuku_network_interface_manager_type_id);
	}
	return netsukuku_network_interface_manager_type_id__volatile;
}


static void _vala_netsukuku_network_interface_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	switch (property_id) {
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS:
		g_value_set_object (value, netsukuku_network_interface_manager_get_nic_class (self));
		break;
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME:
		g_value_set_string (value, netsukuku_network_interface_manager_get_nic_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_network_interface_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	switch (property_id) {
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS:
		netsukuku_network_interface_manager_set_nic_class (self, g_value_get_object (value));
		break;
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME:
		netsukuku_network_interface_manager_set_nic_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GeeList* netsukuku_aggregated_neighbour_manager_neighbour_list (NetsukukuAggregatedNeighbourManager* self, gboolean* b, NetsukukuNetworkID* with_this_netid) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (FALSE, "false");
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_manager_key_to_neighbour (NetsukukuAggregatedNeighbourManager* self, NetsukukuNIP* nip, gint nodeid) {
	NetsukukuAggregatedNeighbour* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_vala_assert (FALSE, "false");
	result = NULL;
	return result;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type) {
	NetsukukuAggregatedNeighbourManager * self = NULL;
	self = (NetsukukuAggregatedNeighbourManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void) {
	return netsukuku_aggregated_neighbour_manager_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER);
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void netsukuku_aggregated_neighbour_manager_class_init (NetsukukuAggregatedNeighbourManagerClass * klass) {
	netsukuku_aggregated_neighbour_manager_parent_class = g_type_class_peek_parent (klass);
	g_signal_new ("aggregated_neighbour_new", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_new_before", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_deleted", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_deleted_after", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_rem_chged", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NETSUKUKU_TYPE_REM);
	g_signal_new ("aggregated_neighbour_rem_chged_before", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NETSUKUKU_TYPE_REM);
	g_signal_new ("aggregated_neighbour_going_new", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_going_deleted", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_going_rem_chged", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_new", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_deleted", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_rem_chged", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NETSUKUKU_TYPE_REM);
	g_signal_new ("aggregated_neighbour_colliding_going_new", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_going_deleted", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_going_rem_chged", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
}


static void netsukuku_aggregated_neighbour_manager_instance_init (NetsukukuAggregatedNeighbourManager * self) {
}


GType netsukuku_aggregated_neighbour_manager_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbourManager), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_manager_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_manager_type_id;
		netsukuku_aggregated_neighbour_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbourManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_manager_type_id__volatile, netsukuku_aggregated_neighbour_manager_type_id);
	}
	return netsukuku_aggregated_neighbour_manager_type_id__volatile;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type) {
	NetsukukuAggregatedNeighbour * self = NULL;
	gint* _tmp0_ = NULL;
	gint* _tmp1_;
	gint _tmp1__length1;
	NetsukukuNIP* _tmp2_;
	NetsukukuNetworkID* _tmp3_ = NULL;
	self = (NetsukukuAggregatedNeighbour*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (gint, 3);
	_tmp0_[0] = 2;
	_tmp0_[1] = 2;
	_tmp0_[2] = 3;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	_tmp2_ = netsukuku_nip_new (_tmp1_, 3);
	_g_object_unref0 (self->nip);
	self->nip = _tmp2_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	self->mod_seq_num = 0;
	_tmp3_ = netsukuku_get_common_netid ();
	_g_object_unref0 (self->netid);
	self->netid = _tmp3_;
	return self;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void) {
	return netsukuku_aggregated_neighbour_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
}


gchar* netsukuku_aggregated_neighbour_to_string (NetsukukuAggregatedNeighbour* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


NetsukukuFakeAddressManagerFakeRmt* netsukuku_aggregated_neighbour_create_neighbour_client (NetsukukuAggregatedNeighbour* self, gboolean response) {
	NetsukukuFakeAddressManagerFakeRmt* result = NULL;
	NetsukukuFakeAddressManagerFakeRmt* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_fake_address_manager_fake_rmt_new ();
	result = _tmp0_;
	return result;
}


gboolean netsukuku_aggregated_neighbour_equal_func (NetsukukuAggregatedNeighbour* a, NetsukukuAggregatedNeighbour* b) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


guint netsukuku_aggregated_neighbour_hash_func (NetsukukuAggregatedNeighbour* a) {
	guint result = 0U;
	g_return_val_if_fail (a != NULL, 0U);
	result = (guint) 0;
	return result;
}


static void netsukuku_aggregated_neighbour_class_init (NetsukukuAggregatedNeighbourClass * klass) {
	netsukuku_aggregated_neighbour_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_aggregated_neighbour_finalize;
}


static void netsukuku_aggregated_neighbour_instance_init (NetsukukuAggregatedNeighbour * self) {
}


static void netsukuku_aggregated_neighbour_finalize (GObject* obj) {
	NetsukukuAggregatedNeighbour * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour);
	_g_object_unref0 (self->nip);
	_g_object_unref0 (self->rem);
	_g_object_unref0 (self->netid);
	_g_object_unref0 (self->neighbour_client);
	G_OBJECT_CLASS (netsukuku_aggregated_neighbour_parent_class)->finalize (obj);
}


GType netsukuku_aggregated_neighbour_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbour), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_type_id;
		netsukuku_aggregated_neighbour_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbour", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_type_id__volatile, netsukuku_aggregated_neighbour_type_id);
	}
	return netsukuku_aggregated_neighbour_type_id__volatile;
}


NetsukukuFakeAddressManagerFakeRmt* netsukuku_fake_address_manager_fake_rmt_construct (GType object_type) {
	NetsukukuFakeAddressManagerFakeRmt * self = NULL;
	NetsukukuFakeAddressManagerFakeRmt* _tmp0_;
	self = (NetsukukuFakeAddressManagerFakeRmt*) netsukuku_address_manager_fake_rmt_construct (object_type);
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (self->etp);
	self->etp = _tmp0_;
	return self;
}


NetsukukuFakeAddressManagerFakeRmt* netsukuku_fake_address_manager_fake_rmt_new (void) {
	return netsukuku_fake_address_manager_fake_rmt_construct (NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT);
}


void netsukuku_fake_address_manager_fake_rmt_new_sequence_number (NetsukukuFakeAddressManagerFakeRmt* self, NetsukukuNIP* nip, gint nodeid, gint seqnum) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
}


void netsukuku_fake_address_manager_fake_rmt_act_as_gateway (NetsukukuFakeAddressManagerFakeRmt* self, NetsukukuNIP* nip_caller, gint nodeid_caller, NetsukukuNetworkID* netid_caller, GeeList* macs) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip_caller != NULL);
	g_return_if_fail (netid_caller != NULL);
	g_return_if_fail (macs != NULL);
	_vala_assert (FALSE, "false");
}


gint netsukuku_fake_address_manager_fake_rmt_request_size (NetsukukuFakeAddressManagerFakeRmt* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_vala_assert (FALSE, "false");
	result = 0;
	return result;
}


NetsukukuExtendedTracerPacket* netsukuku_fake_address_manager_fake_rmt_request_etp (NetsukukuFakeAddressManagerFakeRmt* self, gint prev_mod_seq_num, NetsukukuNIP* nip_caller, gint nodeid_caller, NetsukukuNetworkID* netid_caller, GeeList* macs_caller, GError** error) {
	NetsukukuExtendedTracerPacket* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip_caller != NULL, NULL);
	g_return_val_if_fail (netid_caller != NULL, NULL);
	g_return_val_if_fail (macs_caller != NULL, NULL);
	_vala_assert (FALSE, "false");
	result = NULL;
	return result;
}


static zcdISerializable* netsukuku_fake_address_manager_fake_rmt_real_rmt (NetsukukuAddressManagerFakeRmt* base, zcdRemoteCall* data, GError** error) {
	NetsukukuFakeAddressManagerFakeRmt * self;
	zcdISerializable* result = NULL;
	self = (NetsukukuFakeAddressManagerFakeRmt*) base;
	g_return_val_if_fail (data != NULL, NULL);
	result = NULL;
	return result;
}


static void netsukuku_fake_address_manager_fake_rmt_class_init (NetsukukuFakeAddressManagerFakeRmtClass * klass) {
	netsukuku_fake_address_manager_fake_rmt_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_ADDRESS_MANAGER_FAKE_RMT_CLASS (klass)->rmt = netsukuku_fake_address_manager_fake_rmt_real_rmt;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_fake_address_manager_fake_rmt_finalize;
}


static void netsukuku_fake_address_manager_fake_rmt_instance_init (NetsukukuFakeAddressManagerFakeRmt * self) {
}


static void netsukuku_fake_address_manager_fake_rmt_finalize (GObject* obj) {
	NetsukukuFakeAddressManagerFakeRmt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuFakeAddressManagerFakeRmt);
	_g_object_unref0 (self->etp);
	G_OBJECT_CLASS (netsukuku_fake_address_manager_fake_rmt_parent_class)->finalize (obj);
}


GType netsukuku_fake_address_manager_fake_rmt_get_type (void) {
	static volatile gsize netsukuku_fake_address_manager_fake_rmt_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_fake_address_manager_fake_rmt_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuFakeAddressManagerFakeRmtClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_fake_address_manager_fake_rmt_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuFakeAddressManagerFakeRmt), 0, (GInstanceInitFunc) netsukuku_fake_address_manager_fake_rmt_instance_init, NULL };
		GType netsukuku_fake_address_manager_fake_rmt_type_id;
		netsukuku_fake_address_manager_fake_rmt_type_id = g_type_register_static (NETSUKUKU_TYPE_ADDRESS_MANAGER_FAKE_RMT, "NetsukukuFakeAddressManagerFakeRmt", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_fake_address_manager_fake_rmt_type_id__volatile, netsukuku_fake_address_manager_fake_rmt_type_id);
	}
	return netsukuku_fake_address_manager_fake_rmt_type_id__volatile;
}


gboolean netsukuku_incoming_nodes_contains (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	result = FALSE;
	return result;
}


NetsukukuRoutesSet* netsukuku_incoming_nodes_get_knowledge (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, gint prev_seq_num) {
	NetsukukuRoutesSet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	result = NULL;
	return result;
}


void netsukuku_incoming_nodes_update (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, GeeList* macs, gint* ttl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	g_return_if_fail (macs != NULL);
}


void netsukuku_incoming_nodes_log_knowledge (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, gint my_seq_num, NetsukukuRoutesSet* destinations) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	g_return_if_fail (destinations != NULL);
}


void netsukuku_incoming_nodes_purge (NetsukukuIncomingNodes* self) {
	g_return_if_fail (self != NULL);
}


NetsukukuIncomingNodes* netsukuku_incoming_nodes_construct (GType object_type) {
	NetsukukuIncomingNodes* self = NULL;
	self = (NetsukukuIncomingNodes*) g_type_create_instance (object_type);
	return self;
}


NetsukukuIncomingNodes* netsukuku_incoming_nodes_new (void) {
	return netsukuku_incoming_nodes_construct (NETSUKUKU_TYPE_INCOMING_NODES);
}


static void netsukuku_value_incoming_nodes_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void netsukuku_value_incoming_nodes_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		netsukuku_incoming_nodes_unref (value->data[0].v_pointer);
	}
}


static void netsukuku_value_incoming_nodes_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = netsukuku_incoming_nodes_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer netsukuku_value_incoming_nodes_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* netsukuku_value_incoming_nodes_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		NetsukukuIncomingNodes* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = netsukuku_incoming_nodes_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* netsukuku_value_incoming_nodes_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	NetsukukuIncomingNodes** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = netsukuku_incoming_nodes_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* netsukuku_param_spec_incoming_nodes (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	NetsukukuParamSpecIncomingNodes* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NETSUKUKU_TYPE_INCOMING_NODES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer netsukuku_value_get_incoming_nodes (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_INCOMING_NODES), NULL);
	return value->data[0].v_pointer;
}


void netsukuku_value_set_incoming_nodes (GValue* value, gpointer v_object) {
	NetsukukuIncomingNodes* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_INCOMING_NODES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NETSUKUKU_TYPE_INCOMING_NODES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		netsukuku_incoming_nodes_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		netsukuku_incoming_nodes_unref (old);
	}
}


void netsukuku_value_take_incoming_nodes (GValue* value, gpointer v_object) {
	NetsukukuIncomingNodes* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_INCOMING_NODES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NETSUKUKU_TYPE_INCOMING_NODES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		netsukuku_incoming_nodes_unref (old);
	}
}


static void netsukuku_incoming_nodes_class_init (NetsukukuIncomingNodesClass * klass) {
	netsukuku_incoming_nodes_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_INCOMING_NODES_CLASS (klass)->finalize = netsukuku_incoming_nodes_finalize;
}


static void netsukuku_incoming_nodes_instance_init (NetsukukuIncomingNodes * self) {
	self->ref_count = 1;
}


static void netsukuku_incoming_nodes_finalize (NetsukukuIncomingNodes* obj) {
	NetsukukuIncomingNodes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodes);
}


GType netsukuku_incoming_nodes_get_type (void) {
	static volatile gsize netsukuku_incoming_nodes_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_incoming_nodes_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { netsukuku_value_incoming_nodes_init, netsukuku_value_incoming_nodes_free_value, netsukuku_value_incoming_nodes_copy_value, netsukuku_value_incoming_nodes_peek_pointer, "p", netsukuku_value_incoming_nodes_collect_value, "p", netsukuku_value_incoming_nodes_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuIncomingNodesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_incoming_nodes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuIncomingNodes), 0, (GInstanceInitFunc) netsukuku_incoming_nodes_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType netsukuku_incoming_nodes_type_id;
		netsukuku_incoming_nodes_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NetsukukuIncomingNodes", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&netsukuku_incoming_nodes_type_id__volatile, netsukuku_incoming_nodes_type_id);
	}
	return netsukuku_incoming_nodes_type_id__volatile;
}


gpointer netsukuku_incoming_nodes_ref (gpointer instance) {
	NetsukukuIncomingNodes* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void netsukuku_incoming_nodes_unref (gpointer instance) {
	NetsukukuIncomingNodes* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NETSUKUKU_INCOMING_NODES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void ntk_test_qspn_tester_set_up (NtkTestQspnTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


void ntk_test_qspn_tester_tear_down (NtkTestQspnTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


static gboolean _netsukuku_hcoord_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_hcoord_equal_func (a, b);
	return result;
}


void ntk_test_qspn_tester_test_etp_exec (NtkTestQspnTester* self) {
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuMapRoute* maproute;
	NetsukukuAddressManager* _tmp2_;
	NetsukukuAddressManager* address_manager;
	NetsukukuEtp* _tmp3_;
	NetsukukuEtp* etp;
	gint _tmp4_;
	NetsukukuRoutesSet* _tmp5_;
	NetsukukuRoutesSet* r_to_send;
	NetsukukuNullREM* _tmp6_;
	NetsukukuNullREM* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	NetsukukuGNodeID* _tmp10_;
	NetsukukuGNodeID* _tmp11_;
	NetsukukuTracerPacketList* _tmp12_;
	NetsukukuTracerPacketList* tpl;
	NetsukukuNullREM* _tmp13_;
	NetsukukuNullREM* _tmp14_;
	NetsukukuExtendedTracerPacket* _tmp15_;
	NetsukukuExtendedTracerPacket* et_packet;
	NetsukukuRoutesSet* _tmp16_;
	NetsukukuTracerPacketList* _tmp17_;
	NetsukukuAggregatedNeighbour* _tmp18_;
	NetsukukuAggregatedNeighbour* aggregated_neighbour;
	g_return_if_fail (self != NULL);
	_tmp0_ = netsukuku_aggregated_neighbour_manager_new ();
	aggregated_neighbour_manager = _tmp0_;
	_tmp1_ = netsukuku_map_route_new ();
	maproute = _tmp1_;
	_tmp2_ = netsukuku_address_manager_new ();
	address_manager = _tmp2_;
	_tmp3_ = netsukuku_etp_new (aggregated_neighbour_manager, maproute, address_manager);
	etp = _tmp3_;
	_tmp4_ = maproute->levels;
	_tmp5_ = netsukuku_routes_set_new (_tmp4_);
	r_to_send = _tmp5_;
	_tmp6_ = netsukuku_null_rem_new ();
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = netsukuku_gnode_id_new (1, 1, 12345);
	_tmp11_ = _tmp10_;
	netsukuku_routes_set_add_replace (r_to_send, 0, 2, (NetsukukuREM*) _tmp7_, (GeeList*) _tmp9_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_tmp12_ = netsukuku_tracer_packet_list_new ();
	tpl = _tmp12_;
	_tmp13_ = netsukuku_null_rem_new ();
	_tmp14_ = _tmp13_;
	netsukuku_tracer_packet_list_append (tpl, 2, (NetsukukuREM*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = netsukuku_extended_tracer_packet_new ();
	et_packet = _tmp15_;
	_tmp16_ = _g_object_ref0 (r_to_send);
	_g_object_unref0 (et_packet->r);
	et_packet->r = _tmp16_;
	_tmp17_ = _g_object_ref0 (tpl);
	_g_object_unref0 (et_packet->tpl);
	et_packet->tpl = _tmp17_;
	et_packet->seq_num = 1;
	_tmp18_ = netsukuku_aggregated_neighbour_new ();
	aggregated_neighbour = _tmp18_;
	netsukuku_etp_etp_exec (etp, aggregated_neighbour, et_packet);
	_g_object_unref0 (aggregated_neighbour);
	_g_object_unref0 (et_packet);
	_g_object_unref0 (tpl);
	_g_object_unref0 (r_to_send);
	_g_object_unref0 (etp);
	_g_object_unref0 (address_manager);
	_g_object_unref0 (maproute);
	_g_object_unref0 (aggregated_neighbour_manager);
}


static void __lambda2_ (void) {
	NtkTestQspnTester* _tmp0_;
	NtkTestQspnTester* x;
	_tmp0_ = ntk_test_qspn_tester_new ();
	x = _tmp0_;
	ntk_test_qspn_tester_set_up (x);
	ntk_test_qspn_tester_test_etp_exec (x);
	ntk_test_qspn_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda2__gcallback (void) {
	__lambda2_ ();
}


gint ntk_test_qspn_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	tasklets_tasklet_init (64);
	g_test_add_func ("/Qspn/EtpExec", ___lambda2__gcallback);
	g_test_run ();
	tasklets_tasklet_kill ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ntk_test_qspn_tester_main (argv, argc);
}


NtkTestQspnTester* ntk_test_qspn_tester_construct (GType object_type) {
	NtkTestQspnTester * self = NULL;
	self = (NtkTestQspnTester*) g_object_new (object_type, NULL);
	return self;
}


NtkTestQspnTester* ntk_test_qspn_tester_new (void) {
	return ntk_test_qspn_tester_construct (NTK_TEST_TYPE_QSPN_TESTER);
}


static void ntk_test_qspn_tester_class_init (NtkTestQspnTesterClass * klass) {
	ntk_test_qspn_tester_parent_class = g_type_class_peek_parent (klass);
}


static void ntk_test_qspn_tester_instance_init (NtkTestQspnTester * self) {
}


GType ntk_test_qspn_tester_get_type (void) {
	static volatile gsize ntk_test_qspn_tester_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_qspn_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestQspnTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_qspn_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestQspnTester), 0, (GInstanceInitFunc) ntk_test_qspn_tester_instance_init, NULL };
		GType ntk_test_qspn_tester_type_id;
		ntk_test_qspn_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestQspnTester", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_qspn_tester_type_id__volatile, ntk_test_qspn_tester_type_id);
	}
	return ntk_test_qspn_tester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



