/* peertopeer_tester.c generated by valac 0.20.1, the Vala compiler
 * generated from peertopeer_tester.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <syslog.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <zcd.h>
#include <stdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_FAKE_ADDR_MGR (netsukuku_fake_addr_mgr_get_type ())
#define NETSUKUKU_FAKE_ADDR_MGR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_FAKE_ADDR_MGR, NetsukukuFakeAddrMgr))
#define NETSUKUKU_FAKE_ADDR_MGR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_FAKE_ADDR_MGR, NetsukukuFakeAddrMgrClass))
#define NETSUKUKU_IS_FAKE_ADDR_MGR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_FAKE_ADDR_MGR))
#define NETSUKUKU_IS_FAKE_ADDR_MGR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_FAKE_ADDR_MGR))
#define NETSUKUKU_FAKE_ADDR_MGR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_FAKE_ADDR_MGR, NetsukukuFakeAddrMgrClass))

typedef struct _NetsukukuFakeAddrMgr NetsukukuFakeAddrMgr;
typedef struct _NetsukukuFakeAddrMgrClass NetsukukuFakeAddrMgrClass;
typedef struct _NetsukukuFakeAddrMgrPrivate NetsukukuFakeAddrMgrPrivate;

#define NETSUKUKU_TYPE_FAKE_ADDR_MGR_RMT (netsukuku_fake_addr_mgr_rmt_get_type ())
#define NETSUKUKU_FAKE_ADDR_MGR_RMT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_FAKE_ADDR_MGR_RMT, NetsukukuFakeAddrMgrRmt))
#define NETSUKUKU_FAKE_ADDR_MGR_RMT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_FAKE_ADDR_MGR_RMT, NetsukukuFakeAddrMgrRmtClass))
#define NETSUKUKU_IS_FAKE_ADDR_MGR_RMT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_FAKE_ADDR_MGR_RMT))
#define NETSUKUKU_IS_FAKE_ADDR_MGR_RMT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_FAKE_ADDR_MGR_RMT))
#define NETSUKUKU_FAKE_ADDR_MGR_RMT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_FAKE_ADDR_MGR_RMT, NetsukukuFakeAddrMgrRmtClass))

typedef struct _NetsukukuFakeAddrMgrRmt NetsukukuFakeAddrMgrRmt;
typedef struct _NetsukukuFakeAddrMgrRmtClass NetsukukuFakeAddrMgrRmtClass;
typedef struct _NetsukukuFakeAddrMgrRmtPrivate NetsukukuFakeAddrMgrRmtPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
typedef struct _NetsukukuAggregatedNeighbourManagerPrivate NetsukukuAggregatedNeighbourManagerPrivate;

#define NETSUKUKU_TYPE_ROUTE (netsukuku_route_get_type ())
#define NETSUKUKU_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRoute))
#define NETSUKUKU_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))
#define NETSUKUKU_IS_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_IS_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))

typedef struct _NetsukukuRoute NetsukukuRoute;
typedef struct _NetsukukuRouteClass NetsukukuRouteClass;
typedef struct _NetsukukuRoutePrivate NetsukukuRoutePrivate;

#define NETSUKUKU_TYPE_ROUTE_NODE (netsukuku_route_node_get_type ())
#define NETSUKUKU_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode))
#define NETSUKUKU_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))
#define NETSUKUKU_IS_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_IS_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_ROUTE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))

typedef struct _NetsukukuRouteNode NetsukukuRouteNode;
typedef struct _NetsukukuRouteNodeClass NetsukukuRouteNodeClass;
typedef struct _NetsukukuRouteNodePrivate NetsukukuRouteNodePrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;
typedef struct _NetsukukuMapPrivate NetsukukuMapPrivate;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

#define NTK_TEST_TYPE_PEER_TO_PEER_TESTER (ntk_test_peer_to_peer_tester_get_type ())
#define NTK_TEST_PEER_TO_PEER_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_PEER_TO_PEER_TESTER, NtkTestPeerToPeerTester))
#define NTK_TEST_PEER_TO_PEER_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_PEER_TO_PEER_TESTER, NtkTestPeerToPeerTesterClass))
#define NTK_TEST_IS_PEER_TO_PEER_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_PEER_TO_PEER_TESTER))
#define NTK_TEST_IS_PEER_TO_PEER_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_PEER_TO_PEER_TESTER))
#define NTK_TEST_PEER_TO_PEER_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_PEER_TO_PEER_TESTER, NtkTestPeerToPeerTesterClass))

typedef struct _NtkTestPeerToPeerTester NtkTestPeerToPeerTester;
typedef struct _NtkTestPeerToPeerTesterClass NtkTestPeerToPeerTesterClass;
typedef struct _NtkTestPeerToPeerTesterPrivate NtkTestPeerToPeerTesterPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_MAP_PEER_TO_PEER (netsukuku_map_peer_to_peer_get_type ())
#define NETSUKUKU_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeer))
#define NETSUKUKU_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_MAP_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))

typedef struct _NetsukukuMapPeerToPeer NetsukukuMapPeerToPeer;
typedef struct _NetsukukuMapPeerToPeerClass NetsukukuMapPeerToPeerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuFakeAddrMgr {
	GObject parent_instance;
	NetsukukuFakeAddrMgrPrivate * priv;
};

struct _NetsukukuFakeAddrMgrClass {
	GObjectClass parent_class;
};

struct _NetsukukuFakeAddrMgrRmt {
	GObject parent_instance;
	NetsukukuFakeAddrMgrRmtPrivate * priv;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
};

struct _NetsukukuFakeAddrMgrRmtClass {
	GObjectClass parent_class;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
	NetsukukuNIP* nip;
	NetsukukuFakeAddrMgrRmt* tcp_client;
	NetsukukuFakeAddrMgrRmt* neighbour_client;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _NetsukukuAggregatedNeighbourManager {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourManagerPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuRoute {
	GObject parent_instance;
	NetsukukuRoutePrivate * priv;
	NetsukukuAggregatedNeighbour* gw;
};

struct _NetsukukuRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuRouteNode {
	NetsukukuDataClass parent_instance;
	NetsukukuRouteNodePrivate * priv;
};

struct _NetsukukuRouteNodeClass {
	NetsukukuDataClassClass parent_class;
};

struct _NetsukukuRouteNodePrivate {
	gboolean _free;
};

struct _NetsukukuMap {
	GObject parent_instance;
	NetsukukuMapPrivate * priv;
	NetsukukuDataClass** node;
	gint node_length1;
	gint node_length2;
};

struct _NetsukukuMapClass {
	GObjectClass parent_class;
	void (*stop_operations) (NetsukukuMap* self);
	gpointer (*node_get) (NetsukukuMap* self, gint lvl, gint pos);
};

struct _NetsukukuMapRoute {
	NetsukukuMap parent_instance;
	NetsukukuMapRoutePrivate * priv;
	NetsukukuFakeAddrMgr* address_manager;
};

struct _NetsukukuMapRouteClass {
	NetsukukuMapClass parent_class;
};

struct _NtkTestPeerToPeerTester {
	GObject parent_instance;
	NtkTestPeerToPeerTesterPrivate * priv;
};

struct _NtkTestPeerToPeerTesterClass {
	GObjectClass parent_class;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()

static gpointer netsukuku_fake_addr_mgr_parent_class = NULL;
static gpointer netsukuku_fake_addr_mgr_rmt_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_manager_parent_class = NULL;
static gpointer netsukuku_route_parent_class = NULL;
static gpointer netsukuku_route_node_parent_class = NULL;
static gpointer netsukuku_map_route_parent_class = NULL;
extern gchar* ntk_test_logger;
gchar* ntk_test_logger = NULL;
static gpointer ntk_test_peer_to_peer_tester_parent_class = NULL;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
GType netsukuku_fake_addr_mgr_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_FAKE_ADDR_MGR_DUMMY_PROPERTY
};
NetsukukuAddressManagerFakeRmt* netsukuku_fake_addr_mgr_get_broadcast_client (NetsukukuFakeAddrMgr* self);
NetsukukuFakeAddrMgr* netsukuku_fake_addr_mgr_new (void);
NetsukukuFakeAddrMgr* netsukuku_fake_addr_mgr_construct (GType object_type);
GType netsukuku_fake_addr_mgr_rmt_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_FAKE_ADDR_MGR_RMT_DUMMY_PROPERTY
};
NetsukukuIPeerToPeer* netsukuku_fake_addr_mgr_rmt_get_peer_to_peer_service (NetsukukuFakeAddrMgrRmt* self, gint pid);
NetsukukuIOptionalPeerToPeer* netsukuku_fake_addr_mgr_rmt_get_optional_peer_to_peer_service (NetsukukuFakeAddrMgrRmt* self, gint pid);
NetsukukuFakeAddrMgrRmt* netsukuku_fake_addr_mgr_rmt_new (void);
NetsukukuFakeAddrMgrRmt* netsukuku_fake_addr_mgr_rmt_construct (GType object_type);
static void netsukuku_fake_addr_mgr_rmt_finalize (GObject* obj);
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_DUMMY_PROPERTY
};
gboolean netsukuku_aggregated_neighbour_equal_func (NetsukukuAggregatedNeighbour* a, NetsukukuAggregatedNeighbour* b);
gchar* netsukuku_aggregated_neighbour_to_string (NetsukukuAggregatedNeighbour* self);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type);
static void netsukuku_aggregated_neighbour_finalize (GObject* obj);
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_DUMMY_PROPERTY
};
GeeList* netsukuku_aggregated_neighbour_manager_neighbour_list (NetsukukuAggregatedNeighbourManager* self, gboolean* b);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type);
GType netsukuku_route_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ROUTE_DUMMY_PROPERTY
};
NetsukukuRoute* netsukuku_route_new (void);
NetsukukuRoute* netsukuku_route_construct (GType object_type);
static void netsukuku_route_finalize (GObject* obj);
GType netsukuku_route_node_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_ROUTE_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodePrivate))
enum  {
	NETSUKUKU_ROUTE_NODE_DUMMY_PROPERTY
};
static void netsukuku_route_node_real_initialize (NetsukukuDataClass* base, GObject* m, gint lvl, gint pos, gboolean its_me);
static gboolean netsukuku_route_node_real_is_free (NetsukukuDataClass* base);
GeeList* netsukuku_route_node_all_valid_routes (NetsukukuRouteNode* self);
NetsukukuRouteNode* netsukuku_route_node_new (void);
NetsukukuRouteNode* netsukuku_route_node_construct (GType object_type);
static void netsukuku_route_node_finalize (GObject* obj);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_MAP_ROUTE_DUMMY_PROPERTY
};
NetsukukuMapRoute* netsukuku_map_route_new (NetsukukuNIP* me);
NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, NetsukukuNIP* me);
NetsukukuMap* netsukuku_map_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
NetsukukuMap* netsukuku_map_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
static void netsukuku_map_route_finalize (GObject* obj);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
#define NTK_TEST_output FALSE
GType ntk_test_peer_to_peer_tester_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_PEER_TO_PEER_TESTER_DUMMY_PROPERTY
};
void ntk_test_peer_to_peer_tester_set_up (NtkTestPeerToPeerTester* self);
void ntk_test_peer_to_peer_tester_tear_down (NtkTestPeerToPeerTester* self);
void ntk_test_peer_to_peer_tester_test_search_participant (NtkTestPeerToPeerTester* self);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GQuark netsukuku_peer_to_peer_error_quark (void);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
void ntk_test_peer_to_peer_tester_test_tpl (NtkTestPeerToPeerTester* self);
void netsukuku_peer_to_peer_execute (NetsukukuMapRoute* maproute, NetsukukuPeerToPeerTracerPacketList* ptptpl, GError** error);
void ntk_test_peer_to_peer_tester_test_map_peers (NtkTestPeerToPeerTester* self);
NetsukukuMapPeerToPeer* netsukuku_map_peer_to_peer_new (gint levels, gint gsize, NetsukukuNIP* me, gint pid);
NetsukukuMapPeerToPeer* netsukuku_map_peer_to_peer_construct (GType object_type, gint levels, gint gsize, NetsukukuNIP* me, gint pid);
GType netsukuku_map_peer_to_peer_get_type (void) G_GNUC_CONST;
void netsukuku_map_peer_to_peer_participate (NetsukukuMapPeerToPeer* self);
gpointer netsukuku_map_node_get (NetsukukuMap* self, gint lvl, gint pos);
void netsukuku_map_peer_to_peer_sit_out (NetsukukuMapPeerToPeer* self);
void ntk_test_peer_to_peer_tester_test_list_ids (NtkTestPeerToPeerTester* self);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
gint ntk_test_peer_to_peer_tester_main (gchar** args, int args_length1);
static void __lambda2_ (void);
NtkTestPeerToPeerTester* ntk_test_peer_to_peer_tester_new (void);
NtkTestPeerToPeerTester* ntk_test_peer_to_peer_tester_construct (GType object_type);
static void ___lambda2__gcallback (void);
static void __lambda3_ (void);
static void ___lambda3__gcallback (void);
static void __lambda4_ (void);
static void ___lambda4__gcallback (void);
static void __lambda5_ (void);
static void ___lambda5__gcallback (void);


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("[", _tmp5_, "] ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_DEBUG, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_INFO, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_NOTICE, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_WARNING, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_ERR, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_CRIT, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	g_return_val_if_fail (partial_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = gsize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) _tmp7_));
			}
		}
	}
	result = ret;
	return result;
}


NetsukukuAddressManagerFakeRmt* netsukuku_fake_addr_mgr_get_broadcast_client (NetsukukuFakeAddrMgr* self) {
	NetsukukuAddressManagerFakeRmt* result = NULL;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "FakeAddrMgrget_broadcast_client");
	_inner_error_ = _tmp0_;
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
	return result;
}


NetsukukuFakeAddrMgr* netsukuku_fake_addr_mgr_construct (GType object_type) {
	NetsukukuFakeAddrMgr * self = NULL;
	self = (NetsukukuFakeAddrMgr*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuFakeAddrMgr* netsukuku_fake_addr_mgr_new (void) {
	return netsukuku_fake_addr_mgr_construct (NETSUKUKU_TYPE_FAKE_ADDR_MGR);
}


static void netsukuku_fake_addr_mgr_class_init (NetsukukuFakeAddrMgrClass * klass) {
	netsukuku_fake_addr_mgr_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_fake_addr_mgr_instance_init (NetsukukuFakeAddrMgr * self) {
}


GType netsukuku_fake_addr_mgr_get_type (void) {
	static volatile gsize netsukuku_fake_addr_mgr_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_fake_addr_mgr_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuFakeAddrMgrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_fake_addr_mgr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuFakeAddrMgr), 0, (GInstanceInitFunc) netsukuku_fake_addr_mgr_instance_init, NULL };
		GType netsukuku_fake_addr_mgr_type_id;
		netsukuku_fake_addr_mgr_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuFakeAddrMgr", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_fake_addr_mgr_type_id__volatile, netsukuku_fake_addr_mgr_type_id);
	}
	return netsukuku_fake_addr_mgr_type_id__volatile;
}


NetsukukuIPeerToPeer* netsukuku_fake_addr_mgr_rmt_get_peer_to_peer_service (NetsukukuFakeAddrMgrRmt* self, gint pid) {
	NetsukukuIPeerToPeer* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuIOptionalPeerToPeer* netsukuku_fake_addr_mgr_rmt_get_optional_peer_to_peer_service (NetsukukuFakeAddrMgrRmt* self, gint pid) {
	NetsukukuIOptionalPeerToPeer* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuFakeAddrMgrRmt* netsukuku_fake_addr_mgr_rmt_construct (GType object_type) {
	NetsukukuFakeAddrMgrRmt * self = NULL;
	self = (NetsukukuFakeAddrMgrRmt*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuFakeAddrMgrRmt* netsukuku_fake_addr_mgr_rmt_new (void) {
	return netsukuku_fake_addr_mgr_rmt_construct (NETSUKUKU_TYPE_FAKE_ADDR_MGR_RMT);
}


static void netsukuku_fake_addr_mgr_rmt_class_init (NetsukukuFakeAddrMgrRmtClass * klass) {
	netsukuku_fake_addr_mgr_rmt_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_fake_addr_mgr_rmt_finalize;
}


static void netsukuku_fake_addr_mgr_rmt_instance_init (NetsukukuFakeAddrMgrRmt * self) {
}


static void netsukuku_fake_addr_mgr_rmt_finalize (GObject* obj) {
	NetsukukuFakeAddrMgrRmt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_FAKE_ADDR_MGR_RMT, NetsukukuFakeAddrMgrRmt);
	_g_object_unref0 (self->peer_to_peer_all);
	G_OBJECT_CLASS (netsukuku_fake_addr_mgr_rmt_parent_class)->finalize (obj);
}


GType netsukuku_fake_addr_mgr_rmt_get_type (void) {
	static volatile gsize netsukuku_fake_addr_mgr_rmt_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_fake_addr_mgr_rmt_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuFakeAddrMgrRmtClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_fake_addr_mgr_rmt_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuFakeAddrMgrRmt), 0, (GInstanceInitFunc) netsukuku_fake_addr_mgr_rmt_instance_init, NULL };
		GType netsukuku_fake_addr_mgr_rmt_type_id;
		netsukuku_fake_addr_mgr_rmt_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuFakeAddrMgrRmt", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_fake_addr_mgr_rmt_type_id__volatile, netsukuku_fake_addr_mgr_rmt_type_id);
	}
	return netsukuku_fake_addr_mgr_rmt_type_id__volatile;
}


gboolean netsukuku_aggregated_neighbour_equal_func (NetsukukuAggregatedNeighbour* a, NetsukukuAggregatedNeighbour* b) {
	gboolean result = FALSE;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "AggregatedNeighbourequal_func");
	_inner_error_ = _tmp0_;
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
	return result;
}


gchar* netsukuku_aggregated_neighbour_to_string (NetsukukuAggregatedNeighbour* self) {
	gchar* result = NULL;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "AggregatedNeighbourto_string");
	_inner_error_ = _tmp0_;
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
	return result;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type) {
	NetsukukuAggregatedNeighbour * self = NULL;
	self = (NetsukukuAggregatedNeighbour*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void) {
	return netsukuku_aggregated_neighbour_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
}


static void netsukuku_aggregated_neighbour_class_init (NetsukukuAggregatedNeighbourClass * klass) {
	netsukuku_aggregated_neighbour_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_aggregated_neighbour_finalize;
}


static void netsukuku_aggregated_neighbour_instance_init (NetsukukuAggregatedNeighbour * self) {
}


static void netsukuku_aggregated_neighbour_finalize (GObject* obj) {
	NetsukukuAggregatedNeighbour * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour);
	_g_object_unref0 (self->nip);
	_g_object_unref0 (self->tcp_client);
	_g_object_unref0 (self->neighbour_client);
	G_OBJECT_CLASS (netsukuku_aggregated_neighbour_parent_class)->finalize (obj);
}


GType netsukuku_aggregated_neighbour_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbour), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_type_id;
		netsukuku_aggregated_neighbour_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbour", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_type_id__volatile, netsukuku_aggregated_neighbour_type_id);
	}
	return netsukuku_aggregated_neighbour_type_id__volatile;
}


GeeList* netsukuku_aggregated_neighbour_manager_neighbour_list (NetsukukuAggregatedNeighbourManager* self, gboolean* b) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type) {
	NetsukukuAggregatedNeighbourManager * self = NULL;
	self = (NetsukukuAggregatedNeighbourManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void) {
	return netsukuku_aggregated_neighbour_manager_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER);
}


static void netsukuku_aggregated_neighbour_manager_class_init (NetsukukuAggregatedNeighbourManagerClass * klass) {
	netsukuku_aggregated_neighbour_manager_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_aggregated_neighbour_manager_instance_init (NetsukukuAggregatedNeighbourManager * self) {
}


GType netsukuku_aggregated_neighbour_manager_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbourManager), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_manager_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_manager_type_id;
		netsukuku_aggregated_neighbour_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbourManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_manager_type_id__volatile, netsukuku_aggregated_neighbour_manager_type_id);
	}
	return netsukuku_aggregated_neighbour_manager_type_id__volatile;
}


NetsukukuRoute* netsukuku_route_construct (GType object_type) {
	NetsukukuRoute * self = NULL;
	self = (NetsukukuRoute*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuRoute* netsukuku_route_new (void) {
	return netsukuku_route_construct (NETSUKUKU_TYPE_ROUTE);
}


static void netsukuku_route_class_init (NetsukukuRouteClass * klass) {
	netsukuku_route_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_route_finalize;
}


static void netsukuku_route_instance_init (NetsukukuRoute * self) {
}


static void netsukuku_route_finalize (GObject* obj) {
	NetsukukuRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ROUTE, NetsukukuRoute);
	_g_object_unref0 (self->gw);
	G_OBJECT_CLASS (netsukuku_route_parent_class)->finalize (obj);
}


GType netsukuku_route_get_type (void) {
	static volatile gsize netsukuku_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRoute), 0, (GInstanceInitFunc) netsukuku_route_instance_init, NULL };
		GType netsukuku_route_type_id;
		netsukuku_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_route_type_id__volatile, netsukuku_route_type_id);
	}
	return netsukuku_route_type_id__volatile;
}


static void netsukuku_route_node_real_initialize (NetsukukuDataClass* base, GObject* m, gint lvl, gint pos, gboolean its_me) {
	NetsukukuRouteNode * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	gboolean _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_;
	gboolean _tmp19_;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_;
	gboolean _tmp23_;
	self = (NetsukukuRouteNode*) base;
	g_return_if_fail (m != NULL);
	self->priv->_free = TRUE;
	_tmp1_ = lvl;
	if (_tmp1_ == 0) {
		gint _tmp2_;
		_tmp2_ = pos;
		_tmp0_ = _tmp2_ == 1;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		self->priv->_free = FALSE;
	}
	_tmp5_ = lvl;
	if (_tmp5_ == 1) {
		gint _tmp6_;
		_tmp6_ = pos;
		_tmp4_ = _tmp6_ == 2;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		self->priv->_free = FALSE;
	}
	_tmp9_ = lvl;
	if (_tmp9_ == 2) {
		gint _tmp10_;
		_tmp10_ = pos;
		_tmp8_ = _tmp10_ == 3;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp11_ = _tmp8_;
	if (_tmp11_) {
		self->priv->_free = FALSE;
	}
	_tmp13_ = lvl;
	if (_tmp13_ == 0) {
		gint _tmp14_;
		_tmp14_ = pos;
		_tmp12_ = _tmp14_ == 2;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		self->priv->_free = FALSE;
	}
	_tmp17_ = lvl;
	if (_tmp17_ == 1) {
		gint _tmp18_;
		_tmp18_ = pos;
		_tmp16_ = _tmp18_ == 1;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp19_ = _tmp16_;
	if (_tmp19_) {
		self->priv->_free = FALSE;
	}
	_tmp21_ = lvl;
	if (_tmp21_ == 2) {
		gint _tmp22_;
		_tmp22_ = pos;
		_tmp20_ = _tmp22_ == 1;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp23_ = _tmp20_;
	if (_tmp23_) {
		self->priv->_free = FALSE;
	}
}


static gboolean netsukuku_route_node_real_is_free (NetsukukuDataClass* base) {
	NetsukukuRouteNode * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (NetsukukuRouteNode*) base;
	_tmp0_ = self->priv->_free;
	result = _tmp0_;
	return result;
}


GeeList* netsukuku_route_node_all_valid_routes (NetsukukuRouteNode* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_ROUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


NetsukukuRouteNode* netsukuku_route_node_construct (GType object_type) {
	NetsukukuRouteNode * self = NULL;
	self = (NetsukukuRouteNode*) netsukuku_dataclass_construct (object_type);
	return self;
}


NetsukukuRouteNode* netsukuku_route_node_new (void) {
	return netsukuku_route_node_construct (NETSUKUKU_TYPE_ROUTE_NODE);
}


static void netsukuku_route_node_class_init (NetsukukuRouteNodeClass * klass) {
	netsukuku_route_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuRouteNodePrivate));
	NETSUKUKU_DATACLASS_CLASS (klass)->initialize = netsukuku_route_node_real_initialize;
	NETSUKUKU_DATACLASS_CLASS (klass)->is_free = netsukuku_route_node_real_is_free;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_route_node_finalize;
}


static void netsukuku_route_node_instance_init (NetsukukuRouteNode * self) {
	self->priv = NETSUKUKU_ROUTE_NODE_GET_PRIVATE (self);
}


static void netsukuku_route_node_finalize (GObject* obj) {
	NetsukukuRouteNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode);
	G_OBJECT_CLASS (netsukuku_route_node_parent_class)->finalize (obj);
}


GType netsukuku_route_node_get_type (void) {
	static volatile gsize netsukuku_route_node_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_route_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRouteNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_route_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRouteNode), 0, (GInstanceInitFunc) netsukuku_route_node_instance_init, NULL };
		GType netsukuku_route_node_type_id;
		netsukuku_route_node_type_id = g_type_register_static (NETSUKUKU_TYPE_DATACLASS, "NetsukukuRouteNode", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_route_node_type_id__volatile, netsukuku_route_node_type_id);
	}
	return netsukuku_route_node_type_id__volatile;
}


NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, NetsukukuNIP* me) {
	NetsukukuMapRoute * self = NULL;
	NetsukukuNIP* _tmp0_;
	g_return_val_if_fail (me != NULL, NULL);
	_tmp0_ = me;
	self = (NetsukukuMapRoute*) netsukuku_map_construct (object_type, NETSUKUKU_TYPE_ROUTE_NODE, (GBoxedCopyFunc) g_object_ref, g_object_unref, 3, 4, _tmp0_);
	return self;
}


NetsukukuMapRoute* netsukuku_map_route_new (NetsukukuNIP* me) {
	return netsukuku_map_route_construct (NETSUKUKU_TYPE_MAP_ROUTE, me);
}


static void netsukuku_map_route_class_init (NetsukukuMapRouteClass * klass) {
	netsukuku_map_route_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_route_finalize;
}


static void netsukuku_map_route_instance_init (NetsukukuMapRoute * self) {
}


static void netsukuku_map_route_finalize (GObject* obj) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	_g_object_unref0 (self->address_manager);
	G_OBJECT_CLASS (netsukuku_map_route_parent_class)->finalize (obj);
}


GType netsukuku_map_route_get_type (void) {
	static volatile gsize netsukuku_map_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMapRoute), 0, (GInstanceInitFunc) netsukuku_map_route_instance_init, NULL };
		GType netsukuku_map_route_type_id;
		netsukuku_map_route_type_id = g_type_register_static (NETSUKUKU_TYPE_MAP, "NetsukukuMapRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_map_route_type_id__volatile, netsukuku_map_route_type_id);
	}
	return netsukuku_map_route_type_id__volatile;
}


gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


void ntk_test_peer_to_peer_tester_set_up (NtkTestPeerToPeerTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


void ntk_test_peer_to_peer_tester_tear_down (NtkTestPeerToPeerTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


void ntk_test_peer_to_peer_tester_test_search_participant (NtkTestPeerToPeerTester* self) {
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuAggregatedNeighbourManager* anm;
	gint* _tmp1_ = NULL;
	gint* _tmp2_;
	gint _tmp2__length1;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* _tmp7_;
	NetsukukuMapRoute* _tmp8_;
	NetsukukuPeerToPeer* _tmp9_;
	NetsukukuPeerToPeer* ptp;
	NetsukukuPeerToPeer* _tmp10_;
	gint* _tmp11_ = NULL;
	gint* _tmp12_;
	gint _tmp12__length1;
	NetsukukuNIP* _tmp13_;
	NetsukukuNIP* _tmp14_;
	NetsukukuHCoord* _tmp15_ = NULL;
	NetsukukuHCoord* _tmp16_;
	NetsukukuHCoord* hc;
	NetsukukuHCoord* _tmp23_;
	NetsukukuHCoord* _tmp24_;
	NetsukukuHCoord* _tmp25_;
	gboolean _tmp26_ = FALSE;
	NetsukukuPeerToPeer* _tmp27_;
	gint* _tmp28_ = NULL;
	gint* _tmp29_;
	gint _tmp29__length1;
	NetsukukuNIP* _tmp30_;
	NetsukukuNIP* _tmp31_;
	NetsukukuHCoord* _tmp32_ = NULL;
	NetsukukuHCoord* _tmp33_;
	NetsukukuHCoord* _tmp34_;
	NetsukukuHCoord* _tmp41_;
	NetsukukuHCoord* _tmp42_;
	NetsukukuHCoord* _tmp43_;
	gboolean _tmp44_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = netsukuku_aggregated_neighbour_manager_new ();
	anm = _tmp0_;
	_tmp1_ = g_new0 (gint, 3);
	_tmp1_[0] = 1;
	_tmp1_[1] = 2;
	_tmp1_[2] = 3;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 3;
	_tmp3_ = netsukuku_nip_new (_tmp2_, 3);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_map_route_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp2_ = (g_free (_tmp2_), NULL);
	maproute = _tmp6_;
	_tmp7_ = anm;
	_tmp8_ = maproute;
	_tmp9_ = netsukuku_peer_to_peer_new (_tmp7_, _tmp8_, 1);
	ptp = _tmp9_;
	_tmp10_ = ptp;
	_tmp11_ = g_new0 (gint, 3);
	_tmp11_[0] = 2;
	_tmp11_[1] = 2;
	_tmp11_[2] = 1;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 3;
	_tmp13_ = netsukuku_nip_new (_tmp12_, 3);
	_tmp14_ = _tmp13_;
	_tmp15_ = netsukuku_peer_to_peer_search_participant (_tmp10_, _tmp14_, 1, &_inner_error_);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp14_);
	_tmp12_ = (g_free (_tmp12_), NULL);
	hc = _tmp16_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ptp);
		_g_object_unref0 (maproute);
		_g_object_unref0 (anm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (NTK_TEST_output) {
		FILE* _tmp17_;
		NetsukukuHCoord* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp17_ = stdout;
		_tmp18_ = hc;
		_tmp19_ = netsukuku_hcoord_to_string (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat ("from 2,2,1 to ", _tmp20_, "\n", NULL);
		_tmp22_ = _tmp21_;
		fprintf (_tmp17_, "%s", _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
	}
	_tmp23_ = hc;
	_tmp24_ = netsukuku_hcoord_new (2, 1);
	_tmp25_ = _tmp24_;
	_tmp26_ = netsukuku_hcoord_is_equal (_tmp23_, _tmp25_);
	_vala_assert (_tmp26_, "hc.is_equal(new HCoord(2, 1))");
	_g_object_unref0 (_tmp25_);
	_tmp27_ = ptp;
	_tmp28_ = g_new0 (gint, 3);
	_tmp28_[0] = 1;
	_tmp28_[1] = 1;
	_tmp28_[2] = 2;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 3;
	_tmp30_ = netsukuku_nip_new (_tmp29_, 3);
	_tmp31_ = _tmp30_;
	_tmp32_ = netsukuku_peer_to_peer_search_participant (_tmp27_, _tmp31_, 1, &_inner_error_);
	_tmp33_ = _tmp32_;
	_g_object_unref0 (_tmp31_);
	_tmp29_ = (g_free (_tmp29_), NULL);
	_tmp34_ = _tmp33_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (hc);
		_g_object_unref0 (ptp);
		_g_object_unref0 (maproute);
		_g_object_unref0 (anm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (hc);
	hc = _tmp34_;
	if (NTK_TEST_output) {
		FILE* _tmp35_;
		NetsukukuHCoord* _tmp36_;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		_tmp35_ = stdout;
		_tmp36_ = hc;
		_tmp37_ = netsukuku_hcoord_to_string (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat ("from 1,1,2 to ", _tmp38_, "\n", NULL);
		_tmp40_ = _tmp39_;
		fprintf (_tmp35_, "%s", _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
	}
	_tmp41_ = hc;
	_tmp42_ = netsukuku_hcoord_new (1, 1);
	_tmp43_ = _tmp42_;
	_tmp44_ = netsukuku_hcoord_is_equal (_tmp41_, _tmp43_);
	_vala_assert (_tmp44_, "hc.is_equal(new HCoord(1, 1))");
	_g_object_unref0 (_tmp43_);
	_g_object_unref0 (hc);
	_g_object_unref0 (ptp);
	_g_object_unref0 (maproute);
	_g_object_unref0 (anm);
}


void ntk_test_peer_to_peer_tester_test_tpl (NtkTestPeerToPeerTester* self) {
	NetsukukuPeerToPeerTracerPacketList* _tmp0_;
	NetsukukuPeerToPeerTracerPacketList* x;
	gint* _tmp1_ = NULL;
	gint* _tmp2_;
	gint _tmp2__length1;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuMapRoute* mr1;
	NetsukukuMapRoute* _tmp8_;
	NetsukukuPeerToPeerTracerPacketList* _tmp9_;
	gint* _tmp11_ = NULL;
	gint* _tmp12_;
	gint _tmp12__length1;
	NetsukukuNIP* _tmp13_;
	NetsukukuNIP* _tmp14_;
	NetsukukuMapRoute* _tmp15_;
	NetsukukuMapRoute* _tmp16_;
	NetsukukuMapRoute* mr2;
	NetsukukuMapRoute* _tmp18_;
	NetsukukuPeerToPeerTracerPacketList* _tmp19_;
	gint* _tmp21_ = NULL;
	gint* _tmp22_;
	gint _tmp22__length1;
	NetsukukuNIP* _tmp23_;
	NetsukukuNIP* _tmp24_;
	NetsukukuMapRoute* _tmp25_;
	NetsukukuMapRoute* _tmp26_;
	NetsukukuMapRoute* mr3;
	NetsukukuMapRoute* _tmp28_;
	NetsukukuPeerToPeerTracerPacketList* _tmp29_;
	gint* _tmp31_ = NULL;
	gint* _tmp32_;
	gint _tmp32__length1;
	NetsukukuNIP* _tmp33_;
	NetsukukuNIP* _tmp34_;
	NetsukukuMapRoute* _tmp35_;
	NetsukukuMapRoute* _tmp36_;
	NetsukukuMapRoute* mr4;
	NetsukukuMapRoute* _tmp38_;
	NetsukukuPeerToPeerTracerPacketList* _tmp39_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = netsukuku_peer_to_peer_tracer_packet_list_new (120000);
	x = _tmp0_;
	_tmp1_ = g_new0 (gint, 3);
	_tmp1_[0] = 1;
	_tmp1_[1] = 2;
	_tmp1_[2] = 3;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 3;
	_tmp3_ = netsukuku_nip_new (_tmp2_, 3);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_map_route_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp2_ = (g_free (_tmp2_), NULL);
	mr1 = _tmp6_;
	if (NTK_TEST_output) {
		FILE* _tmp7_;
		_tmp7_ = stdout;
		fprintf (_tmp7_, "executing mr1\n");
	}
	_tmp8_ = mr1;
	_tmp9_ = x;
	netsukuku_peer_to_peer_execute (_tmp8_, _tmp9_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (mr1);
		_g_object_unref0 (x);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (NTK_TEST_output) {
		FILE* _tmp10_;
		_tmp10_ = stdout;
		fprintf (_tmp10_, "done \n");
	}
	_tmp11_ = g_new0 (gint, 3);
	_tmp11_[0] = 2;
	_tmp11_[1] = 3;
	_tmp11_[2] = 1;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 3;
	_tmp13_ = netsukuku_nip_new (_tmp12_, 3);
	_tmp14_ = _tmp13_;
	_tmp15_ = netsukuku_map_route_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp14_);
	_tmp12_ = (g_free (_tmp12_), NULL);
	mr2 = _tmp16_;
	if (NTK_TEST_output) {
		FILE* _tmp17_;
		_tmp17_ = stdout;
		fprintf (_tmp17_, "executing mr2\n");
	}
	_tmp18_ = mr2;
	_tmp19_ = x;
	netsukuku_peer_to_peer_execute (_tmp18_, _tmp19_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (mr2);
		_g_object_unref0 (mr1);
		_g_object_unref0 (x);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (NTK_TEST_output) {
		FILE* _tmp20_;
		_tmp20_ = stdout;
		fprintf (_tmp20_, "done \n");
	}
	_tmp21_ = g_new0 (gint, 3);
	_tmp21_[0] = 0;
	_tmp21_[1] = 0;
	_tmp21_[2] = 0;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 3;
	_tmp23_ = netsukuku_nip_new (_tmp22_, 3);
	_tmp24_ = _tmp23_;
	_tmp25_ = netsukuku_map_route_new (_tmp24_);
	_tmp26_ = _tmp25_;
	_g_object_unref0 (_tmp24_);
	_tmp22_ = (g_free (_tmp22_), NULL);
	mr3 = _tmp26_;
	if (NTK_TEST_output) {
		FILE* _tmp27_;
		_tmp27_ = stdout;
		fprintf (_tmp27_, "executing mr3\n");
	}
	_tmp28_ = mr3;
	_tmp29_ = x;
	netsukuku_peer_to_peer_execute (_tmp28_, _tmp29_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (mr3);
		_g_object_unref0 (mr2);
		_g_object_unref0 (mr1);
		_g_object_unref0 (x);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (NTK_TEST_output) {
		FILE* _tmp30_;
		_tmp30_ = stdout;
		fprintf (_tmp30_, "done \n");
	}
	_tmp31_ = g_new0 (gint, 3);
	_tmp31_[0] = 0;
	_tmp31_[1] = 0;
	_tmp31_[2] = 1;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 3;
	_tmp33_ = netsukuku_nip_new (_tmp32_, 3);
	_tmp34_ = _tmp33_;
	_tmp35_ = netsukuku_map_route_new (_tmp34_);
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp34_);
	_tmp32_ = (g_free (_tmp32_), NULL);
	mr4 = _tmp36_;
	if (NTK_TEST_output) {
		FILE* _tmp37_;
		_tmp37_ = stdout;
		fprintf (_tmp37_, "executing mr4 (should detect loop and wait a bit)\n");
	}
	_tmp38_ = mr4;
	_tmp39_ = x;
	netsukuku_peer_to_peer_execute (_tmp38_, _tmp39_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (mr4);
		_g_object_unref0 (mr3);
		_g_object_unref0 (mr2);
		_g_object_unref0 (mr1);
		_g_object_unref0 (x);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (NTK_TEST_output) {
		FILE* _tmp40_;
		_tmp40_ = stdout;
		fprintf (_tmp40_, "done \n");
	}
	_g_object_unref0 (mr4);
	_g_object_unref0 (mr3);
	_g_object_unref0 (mr2);
	_g_object_unref0 (mr1);
	_g_object_unref0 (x);
}


void ntk_test_peer_to_peer_tester_test_map_peers (NtkTestPeerToPeerTester* self) {
	gint* _tmp0_ = NULL;
	gint* _tmp1_;
	gint _tmp1__length1;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuMapPeerToPeer* _tmp4_;
	NetsukukuMapPeerToPeer* _tmp5_;
	NetsukukuMapPeerToPeer* map;
	gpointer _tmp6_ = NULL;
	NetsukukuParticipantNode* _tmp7_;
	gboolean _tmp8_;
	gpointer _tmp9_ = NULL;
	NetsukukuParticipantNode* _tmp10_;
	gboolean _tmp11_;
	gpointer _tmp12_ = NULL;
	NetsukukuParticipantNode* _tmp13_;
	gboolean _tmp14_;
	gpointer _tmp15_ = NULL;
	NetsukukuParticipantNode* _tmp16_;
	gboolean _tmp17_;
	gpointer _tmp18_ = NULL;
	NetsukukuParticipantNode* _tmp19_;
	gboolean _tmp20_;
	gpointer _tmp21_ = NULL;
	NetsukukuParticipantNode* _tmp22_;
	gboolean _tmp23_;
	gpointer _tmp24_ = NULL;
	NetsukukuParticipantNode* _tmp25_;
	gboolean _tmp26_;
	gpointer _tmp27_ = NULL;
	NetsukukuParticipantNode* _tmp28_;
	gpointer _tmp29_ = NULL;
	NetsukukuParticipantNode* _tmp30_;
	gboolean _tmp31_;
	gpointer _tmp32_ = NULL;
	NetsukukuParticipantNode* _tmp33_;
	gpointer _tmp34_ = NULL;
	NetsukukuParticipantNode* _tmp35_;
	gboolean _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gint, 3);
	_tmp0_[0] = 1;
	_tmp0_[1] = 2;
	_tmp0_[2] = 3;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	_tmp2_ = netsukuku_nip_new (_tmp1_, 3);
	_tmp3_ = _tmp2_;
	_tmp4_ = netsukuku_map_peer_to_peer_new (3, 4, _tmp3_, 2);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp1_ = (g_free (_tmp1_), NULL);
	map = _tmp5_;
	netsukuku_map_peer_to_peer_participate (map);
	_tmp6_ = netsukuku_map_node_get ((NetsukukuMap*) map, 0, 1);
	_tmp7_ = (NetsukukuParticipantNode*) _tmp6_;
	_tmp8_ = _tmp7_->participant;
	_vala_assert (_tmp8_, "map.node_get(0, 1).participant");
	_g_object_unref0 (_tmp7_);
	_tmp9_ = netsukuku_map_node_get ((NetsukukuMap*) map, 1, 2);
	_tmp10_ = (NetsukukuParticipantNode*) _tmp9_;
	_tmp11_ = _tmp10_->participant;
	_vala_assert (_tmp11_, "map.node_get(1, 2).participant");
	_g_object_unref0 (_tmp10_);
	_tmp12_ = netsukuku_map_node_get ((NetsukukuMap*) map, 2, 3);
	_tmp13_ = (NetsukukuParticipantNode*) _tmp12_;
	_tmp14_ = _tmp13_->participant;
	_vala_assert (_tmp14_, "map.node_get(2, 3).participant");
	_g_object_unref0 (_tmp13_);
	netsukuku_map_peer_to_peer_sit_out (map);
	_tmp15_ = netsukuku_map_node_get ((NetsukukuMap*) map, 0, 1);
	_tmp16_ = (NetsukukuParticipantNode*) _tmp15_;
	_tmp17_ = _tmp16_->participant;
	_vala_assert (!_tmp17_, "! map.node_get(0, 1).participant");
	_g_object_unref0 (_tmp16_);
	_tmp18_ = netsukuku_map_node_get ((NetsukukuMap*) map, 1, 2);
	_tmp19_ = (NetsukukuParticipantNode*) _tmp18_;
	_tmp20_ = _tmp19_->participant;
	_vala_assert (!_tmp20_, "! map.node_get(1, 2).participant");
	_g_object_unref0 (_tmp19_);
	_tmp21_ = netsukuku_map_node_get ((NetsukukuMap*) map, 2, 3);
	_tmp22_ = (NetsukukuParticipantNode*) _tmp21_;
	_tmp23_ = _tmp22_->participant;
	_vala_assert (!_tmp23_, "! map.node_get(2, 3).participant");
	_g_object_unref0 (_tmp22_);
	_tmp24_ = netsukuku_map_node_get ((NetsukukuMap*) map, 1, 1);
	_tmp25_ = (NetsukukuParticipantNode*) _tmp24_;
	_tmp26_ = _tmp25_->participant;
	_vala_assert (!_tmp26_, "! map.node_get(1, 1).participant");
	_g_object_unref0 (_tmp25_);
	_tmp27_ = netsukuku_map_node_get ((NetsukukuMap*) map, 1, 1);
	_tmp28_ = (NetsukukuParticipantNode*) _tmp27_;
	_tmp28_->participant = TRUE;
	_g_object_unref0 (_tmp28_);
	_tmp29_ = netsukuku_map_node_get ((NetsukukuMap*) map, 1, 1);
	_tmp30_ = (NetsukukuParticipantNode*) _tmp29_;
	_tmp31_ = _tmp30_->participant;
	_vala_assert (_tmp31_, "map.node_get(1, 1).participant");
	_g_object_unref0 (_tmp30_);
	_tmp32_ = netsukuku_map_node_get ((NetsukukuMap*) map, 1, 1);
	_tmp33_ = (NetsukukuParticipantNode*) _tmp32_;
	_tmp33_->participant = FALSE;
	_g_object_unref0 (_tmp33_);
	_tmp34_ = netsukuku_map_node_get ((NetsukukuMap*) map, 1, 1);
	_tmp35_ = (NetsukukuParticipantNode*) _tmp34_;
	_tmp36_ = _tmp35_->participant;
	_vala_assert (!_tmp36_, "! map.node_get(1, 1).participant");
	_g_object_unref0 (_tmp35_);
	_g_object_unref0 (map);
}


void ntk_test_peer_to_peer_tester_test_list_ids (NtkTestPeerToPeerTester* self) {
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuAggregatedNeighbourManager* anm;
	gint* _tmp1_ = NULL;
	gint* _tmp2_;
	gint _tmp2__length1;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuMapRoute* maproute;
	NetsukukuPeerToPeer* _tmp7_;
	NetsukukuPeerToPeer* ptp;
	GeeList* ret = NULL;
	GeeList* _tmp8_ = NULL;
	GeeList* _tmp9_;
	gpointer _tmp10_ = NULL;
	GeeList* _tmp11_;
	gpointer _tmp12_ = NULL;
	GeeList* _tmp13_;
	gpointer _tmp14_ = NULL;
	GeeList* _tmp15_;
	gpointer _tmp16_ = NULL;
	GeeList* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GeeList* _tmp20_ = NULL;
	GeeList* _tmp21_;
	gpointer _tmp22_ = NULL;
	GeeList* _tmp23_;
	gpointer _tmp24_ = NULL;
	GeeList* _tmp25_;
	gpointer _tmp26_ = NULL;
	GeeList* _tmp27_;
	gpointer _tmp28_ = NULL;
	GeeList* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GeeList* _tmp32_ = NULL;
	GeeList* _tmp33_;
	gpointer _tmp34_ = NULL;
	GeeList* _tmp35_;
	gpointer _tmp36_ = NULL;
	GeeList* _tmp37_;
	gpointer _tmp38_ = NULL;
	GeeList* _tmp39_;
	gpointer _tmp40_ = NULL;
	GeeList* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = netsukuku_aggregated_neighbour_manager_new ();
	anm = _tmp0_;
	_tmp1_ = g_new0 (gint, 3);
	_tmp1_[0] = 1;
	_tmp1_[1] = 2;
	_tmp1_[2] = 3;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 3;
	_tmp3_ = netsukuku_nip_new (_tmp2_, 3);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_map_route_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp2_ = (g_free (_tmp2_), NULL);
	maproute = _tmp6_;
	_tmp7_ = netsukuku_peer_to_peer_new (anm, maproute, 1);
	ptp = _tmp7_;
	_tmp8_ = netsukuku_peer_to_peer_list_ids (ptp, 1, 1);
	_g_object_unref0 (ret);
	ret = _tmp8_;
	_tmp9_ = ret;
	_tmp10_ = gee_list_remove_at (_tmp9_, 0);
	_vala_assert (((gint) ((gintptr) _tmp10_)) == 1, "ret.remove_at(0) == 1");
	_tmp11_ = ret;
	_tmp12_ = gee_list_remove_at (_tmp11_, 0);
	_vala_assert (((gint) ((gintptr) _tmp12_)) == 2, "ret.remove_at(0) == 2");
	_tmp13_ = ret;
	_tmp14_ = gee_list_remove_at (_tmp13_, 0);
	_vala_assert (((gint) ((gintptr) _tmp14_)) == 3, "ret.remove_at(0) == 3");
	_tmp15_ = ret;
	_tmp16_ = gee_list_remove_at (_tmp15_, 0);
	_vala_assert (((gint) ((gintptr) _tmp16_)) == 0, "ret.remove_at(0) == 0");
	_tmp17_ = ret;
	_tmp18_ = gee_collection_get_is_empty ((GeeCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	_vala_assert (_tmp19_, "ret.is_empty");
	_tmp20_ = netsukuku_peer_to_peer_list_ids (ptp, 2, -1);
	_g_object_unref0 (ret);
	ret = _tmp20_;
	_tmp21_ = ret;
	_tmp22_ = gee_list_remove_at (_tmp21_, 0);
	_vala_assert (((gint) ((gintptr) _tmp22_)) == 2, "ret.remove_at(0) == 2");
	_tmp23_ = ret;
	_tmp24_ = gee_list_remove_at (_tmp23_, 0);
	_vala_assert (((gint) ((gintptr) _tmp24_)) == 1, "ret.remove_at(0) == 1");
	_tmp25_ = ret;
	_tmp26_ = gee_list_remove_at (_tmp25_, 0);
	_vala_assert (((gint) ((gintptr) _tmp26_)) == 0, "ret.remove_at(0) == 0");
	_tmp27_ = ret;
	_tmp28_ = gee_list_remove_at (_tmp27_, 0);
	_vala_assert (((gint) ((gintptr) _tmp28_)) == 3, "ret.remove_at(0) == 3");
	_tmp29_ = ret;
	_tmp30_ = gee_collection_get_is_empty ((GeeCollection*) _tmp29_);
	_tmp31_ = _tmp30_;
	_vala_assert (_tmp31_, "ret.is_empty");
	_tmp32_ = netsukuku_peer_to_peer_list_ids (ptp, 0, -1);
	_g_object_unref0 (ret);
	ret = _tmp32_;
	_tmp33_ = ret;
	_tmp34_ = gee_list_remove_at (_tmp33_, 0);
	_vala_assert (((gint) ((gintptr) _tmp34_)) == 0, "ret.remove_at(0) == 0");
	_tmp35_ = ret;
	_tmp36_ = gee_list_remove_at (_tmp35_, 0);
	_vala_assert (((gint) ((gintptr) _tmp36_)) == 3, "ret.remove_at(0) == 3");
	_tmp37_ = ret;
	_tmp38_ = gee_list_remove_at (_tmp37_, 0);
	_vala_assert (((gint) ((gintptr) _tmp38_)) == 2, "ret.remove_at(0) == 2");
	_tmp39_ = ret;
	_tmp40_ = gee_list_remove_at (_tmp39_, 0);
	_vala_assert (((gint) ((gintptr) _tmp40_)) == 1, "ret.remove_at(0) == 1");
	_tmp41_ = ret;
	_tmp42_ = gee_collection_get_is_empty ((GeeCollection*) _tmp41_);
	_tmp43_ = _tmp42_;
	_vala_assert (_tmp43_, "ret.is_empty");
	_g_object_unref0 (ret);
	_g_object_unref0 (ptp);
	_g_object_unref0 (maproute);
	_g_object_unref0 (anm);
}


static void __lambda2_ (void) {
	NtkTestPeerToPeerTester* _tmp0_;
	NtkTestPeerToPeerTester* x;
	_tmp0_ = ntk_test_peer_to_peer_tester_new ();
	x = _tmp0_;
	ntk_test_peer_to_peer_tester_set_up (x);
	ntk_test_peer_to_peer_tester_test_search_participant (x);
	ntk_test_peer_to_peer_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda2__gcallback (void) {
	__lambda2_ ();
}


static void __lambda3_ (void) {
	NtkTestPeerToPeerTester* _tmp0_;
	NtkTestPeerToPeerTester* x;
	_tmp0_ = ntk_test_peer_to_peer_tester_new ();
	x = _tmp0_;
	ntk_test_peer_to_peer_tester_set_up (x);
	ntk_test_peer_to_peer_tester_test_tpl (x);
	ntk_test_peer_to_peer_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda3__gcallback (void) {
	__lambda3_ ();
}


static void __lambda4_ (void) {
	NtkTestPeerToPeerTester* _tmp0_;
	NtkTestPeerToPeerTester* x;
	_tmp0_ = ntk_test_peer_to_peer_tester_new ();
	x = _tmp0_;
	ntk_test_peer_to_peer_tester_set_up (x);
	ntk_test_peer_to_peer_tester_test_map_peers (x);
	ntk_test_peer_to_peer_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda4__gcallback (void) {
	__lambda4_ ();
}


static void __lambda5_ (void) {
	NtkTestPeerToPeerTester* _tmp0_;
	NtkTestPeerToPeerTester* x;
	_tmp0_ = ntk_test_peer_to_peer_tester_new ();
	x = _tmp0_;
	ntk_test_peer_to_peer_tester_set_up (x);
	ntk_test_peer_to_peer_tester_test_list_ids (x);
	ntk_test_peer_to_peer_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda5__gcallback (void) {
	__lambda5_ ();
}


gint ntk_test_peer_to_peer_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	tasklets_tasklet_init (64);
	g_test_add_func ("/PeerToPeer/SearchParticipant", ___lambda2__gcallback);
	g_test_add_func ("/PeerToPeer/TracerPacketList", ___lambda3__gcallback);
	g_test_add_func ("/PeerToPeer/MapPeers", ___lambda4__gcallback);
	g_test_add_func ("/PeerToPeer/ListIDs", ___lambda5__gcallback);
	g_test_run ();
	tasklets_tasklet_kill ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ntk_test_peer_to_peer_tester_main (argv, argc);
}


NtkTestPeerToPeerTester* ntk_test_peer_to_peer_tester_construct (GType object_type) {
	NtkTestPeerToPeerTester * self = NULL;
	self = (NtkTestPeerToPeerTester*) g_object_new (object_type, NULL);
	return self;
}


NtkTestPeerToPeerTester* ntk_test_peer_to_peer_tester_new (void) {
	return ntk_test_peer_to_peer_tester_construct (NTK_TEST_TYPE_PEER_TO_PEER_TESTER);
}


static void ntk_test_peer_to_peer_tester_class_init (NtkTestPeerToPeerTesterClass * klass) {
	ntk_test_peer_to_peer_tester_parent_class = g_type_class_peek_parent (klass);
}


static void ntk_test_peer_to_peer_tester_instance_init (NtkTestPeerToPeerTester * self) {
}


GType ntk_test_peer_to_peer_tester_get_type (void) {
	static volatile gsize ntk_test_peer_to_peer_tester_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_peer_to_peer_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestPeerToPeerTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_peer_to_peer_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestPeerToPeerTester), 0, (GInstanceInitFunc) ntk_test_peer_to_peer_tester_instance_init, NULL };
		GType ntk_test_peer_to_peer_tester_type_id;
		ntk_test_peer_to_peer_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestPeerToPeerTester", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_peer_to_peer_tester_type_id__volatile, ntk_test_peer_to_peer_tester_type_id);
	}
	return ntk_test_peer_to_peer_tester_type_id__volatile;
}



