/* map_tester_1.c generated by valac 0.20.1, the Vala compiler
 * generated from map_tester_1.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <syslog.h>
#include <netsukuku-rpc.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NTK_TEST_TYPE_DERIVED_DATACLASS (ntk_test_derived_dataclass_get_type ())
#define NTK_TEST_DERIVED_DATACLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_DERIVED_DATACLASS, NtkTestDerivedDataClass))
#define NTK_TEST_DERIVED_DATACLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_DERIVED_DATACLASS, NtkTestDerivedDataClassClass))
#define NTK_TEST_IS_DERIVED_DATACLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_DERIVED_DATACLASS))
#define NTK_TEST_IS_DERIVED_DATACLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_DERIVED_DATACLASS))
#define NTK_TEST_DERIVED_DATACLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_DERIVED_DATACLASS, NtkTestDerivedDataClassClass))

typedef struct _NtkTestDerivedDataClass NtkTestDerivedDataClass;
typedef struct _NtkTestDerivedDataClassClass NtkTestDerivedDataClassClass;
typedef struct _NtkTestDerivedDataClassPrivate NtkTestDerivedDataClassPrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;
typedef struct _NetsukukuMapPrivate NetsukukuMapPrivate;

#define NTK_TEST_TYPE_DERIVED_MAP (ntk_test_derived_map_get_type ())
#define NTK_TEST_DERIVED_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_DERIVED_MAP, NtkTestDerivedMap))
#define NTK_TEST_DERIVED_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_DERIVED_MAP, NtkTestDerivedMapClass))
#define NTK_TEST_IS_DERIVED_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_DERIVED_MAP))
#define NTK_TEST_IS_DERIVED_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_DERIVED_MAP))
#define NTK_TEST_DERIVED_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_DERIVED_MAP, NtkTestDerivedMapClass))

typedef struct _NtkTestDerivedMap NtkTestDerivedMap;
typedef struct _NtkTestDerivedMapClass NtkTestDerivedMapClass;
typedef struct _NtkTestDerivedMapPrivate NtkTestDerivedMapPrivate;

#define NTK_TEST_TYPE_MAP_TESTER (ntk_test_map_tester_get_type ())
#define NTK_TEST_MAP_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_MAP_TESTER, NtkTestMapTester))
#define NTK_TEST_MAP_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_MAP_TESTER, NtkTestMapTesterClass))
#define NTK_TEST_IS_MAP_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_MAP_TESTER))
#define NTK_TEST_IS_MAP_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_MAP_TESTER))
#define NTK_TEST_MAP_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_MAP_TESTER, NtkTestMapTesterClass))

typedef struct _NtkTestMapTester NtkTestMapTester;
typedef struct _NtkTestMapTesterClass NtkTestMapTesterClass;
typedef struct _NtkTestMapTesterPrivate NtkTestMapTesterPrivate;
typedef struct _Block1Data Block1Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NtkTestDerivedDataClass {
	NetsukukuDataClass parent_instance;
	NtkTestDerivedDataClassPrivate * priv;
	gboolean busy;
};

struct _NtkTestDerivedDataClassClass {
	NetsukukuDataClassClass parent_class;
};

struct _NtkTestDerivedDataClassPrivate {
	NetsukukuMap* m;
	gint lvl;
	gint pos;
	gboolean its_me;
};

struct _NetsukukuMap {
	GObject parent_instance;
	NetsukukuMapPrivate * priv;
	NetsukukuDataClass** node;
	gint node_length1;
	gint node_length2;
};

struct _NetsukukuMapClass {
	GObjectClass parent_class;
	void (*stop_operations) (NetsukukuMap* self);
	gpointer (*node_get) (NetsukukuMap* self, gint lvl, gint pos);
};

struct _NtkTestDerivedMap {
	NetsukukuMap parent_instance;
	NtkTestDerivedMapPrivate * priv;
};

struct _NtkTestDerivedMapClass {
	NetsukukuMapClass parent_class;
};

struct _NtkTestMapTester {
	GObject parent_instance;
	NtkTestMapTesterPrivate * priv;
};

struct _NtkTestMapTesterClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	NtkTestMapTester * self;
	gchar* test;
};


static gpointer ntk_test_derived_dataclass_parent_class = NULL;
static gpointer ntk_test_derived_map_parent_class = NULL;
static gpointer ntk_test_map_tester_parent_class = NULL;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
GType ntk_test_derived_dataclass_get_type (void) G_GNUC_CONST;
GType netsukuku_map_get_type (void) G_GNUC_CONST;
#define NTK_TEST_DERIVED_DATACLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NTK_TEST_TYPE_DERIVED_DATACLASS, NtkTestDerivedDataClassPrivate))
enum  {
	NTK_TEST_DERIVED_DATACLASS_DUMMY_PROPERTY
};
NtkTestDerivedDataClass* ntk_test_derived_dataclass_new (void);
NtkTestDerivedDataClass* ntk_test_derived_dataclass_construct (GType object_type);
static void ntk_test_derived_dataclass_real_initialize (NetsukukuDataClass* base, GObject* m, gint lvl, gint pos, gboolean its_me);
static gboolean ntk_test_derived_dataclass_real_is_free (NetsukukuDataClass* base);
static void ntk_test_derived_dataclass_finalize (GObject* obj);
GType ntk_test_derived_map_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_DERIVED_MAP_DUMMY_PROPERTY
};
NtkTestDerivedMap* ntk_test_derived_map_new (gint levels, gint gsize, NetsukukuNIP* me);
NtkTestDerivedMap* ntk_test_derived_map_construct (GType object_type, gint levels, gint gsize, NetsukukuNIP* me);
NetsukukuMap* netsukuku_map_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
NetsukukuMap* netsukuku_map_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
void ntk_test_derived_map_deriv_node_add (NtkTestDerivedMap* self, gint lvl, gint pos);
gpointer netsukuku_map_node_get (NetsukukuMap* self, gint lvl, gint pos);
void netsukuku_map_node_add (NetsukukuMap* self, gint lvl, gint pos);
void ntk_test_derived_map_deriv_node_del (NtkTestDerivedMap* self, gint lvl, gint pos);
void netsukuku_map_node_del (NetsukukuMap* self, gint lvl, gint pos);
GType ntk_test_map_tester_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_MAP_TESTER_DUMMY_PROPERTY
};
void ntk_test_map_tester_set_up (NtkTestMapTester* self);
void ntk_test_map_tester_tear_down (NtkTestMapTester* self);
void ntk_test_map_tester_test_fundamentals (NtkTestMapTester* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda2_ (Block1Data* _data1_, NetsukukuMap* _m, gint lvl, gint pos);
static void ___lambda2__netsukuku_map_node_new (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self);
static void __lambda3_ (Block1Data* _data1_, NetsukukuMap* _m, gint lvl, gint pos);
static void ___lambda3__netsukuku_map_node_deleted (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
gint netsukuku_map_get_levels (NetsukukuMap* self);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
gint netsukuku_map_free_nodes_nb (NetsukukuMap* self, gint lvl);
gint* netsukuku_map_free_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1);
static gboolean _vala_int_array_contains (gint* stack, int stack_length, gint needle);
gint netsukuku_map_busy_nodes_nb (NetsukukuMap* self, gint lvl);
gint* netsukuku_map_busy_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1);
NetsukukuHCoord* netsukuku_map_nip_to_lvlid (NetsukukuMap* self, NetsukukuPartialNIP* nip);
NetsukukuPartialNIP* netsukuku_map_lvlid_to_nip (NetsukukuMap* self, NetsukukuHCoord* lvlid);
void netsukuku_map_stop_operations (NetsukukuMap* self);
gint ntk_test_map_tester_main (gchar** args, int args_length1);
static void __lambda4_ (void);
NtkTestMapTester* ntk_test_map_tester_new (void);
NtkTestMapTester* ntk_test_map_tester_construct (GType object_type);
static void ___lambda4__gcallback (void);


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("[", _tmp5_, "] ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_DEBUG, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_INFO, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_NOTICE, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_WARNING, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_ERR, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_CRIT, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	g_return_val_if_fail (partial_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = gsize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) _tmp7_));
			}
		}
	}
	result = ret;
	return result;
}


gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


NtkTestDerivedDataClass* ntk_test_derived_dataclass_construct (GType object_type) {
	NtkTestDerivedDataClass * self = NULL;
	self = (NtkTestDerivedDataClass*) netsukuku_dataclass_construct (object_type);
	return self;
}


NtkTestDerivedDataClass* ntk_test_derived_dataclass_new (void) {
	return ntk_test_derived_dataclass_construct (NTK_TEST_TYPE_DERIVED_DATACLASS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ntk_test_derived_dataclass_real_initialize (NetsukukuDataClass* base, GObject* m, gint lvl, gint pos, gboolean its_me) {
	NtkTestDerivedDataClass * self;
	GObject* _tmp0_;
	NetsukukuMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	self = (NtkTestDerivedDataClass*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_MAP, NetsukukuMap));
	_g_object_unref0 (self->priv->m);
	self->priv->m = _tmp1_;
	_tmp2_ = lvl;
	self->priv->lvl = _tmp2_;
	_tmp3_ = pos;
	self->priv->pos = _tmp3_;
	_tmp4_ = its_me;
	self->priv->its_me = _tmp4_;
}


static gboolean ntk_test_derived_dataclass_real_is_free (NetsukukuDataClass* base) {
	NtkTestDerivedDataClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (NtkTestDerivedDataClass*) base;
	_tmp0_ = self->priv->its_me;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->busy;
	result = !_tmp1_;
	return result;
}


static void ntk_test_derived_dataclass_class_init (NtkTestDerivedDataClassClass * klass) {
	ntk_test_derived_dataclass_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NtkTestDerivedDataClassPrivate));
	NETSUKUKU_DATACLASS_CLASS (klass)->initialize = ntk_test_derived_dataclass_real_initialize;
	NETSUKUKU_DATACLASS_CLASS (klass)->is_free = ntk_test_derived_dataclass_real_is_free;
	G_OBJECT_CLASS (klass)->finalize = ntk_test_derived_dataclass_finalize;
}


static void ntk_test_derived_dataclass_instance_init (NtkTestDerivedDataClass * self) {
	self->priv = NTK_TEST_DERIVED_DATACLASS_GET_PRIVATE (self);
}


static void ntk_test_derived_dataclass_finalize (GObject* obj) {
	NtkTestDerivedDataClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTK_TEST_TYPE_DERIVED_DATACLASS, NtkTestDerivedDataClass);
	_g_object_unref0 (self->priv->m);
	G_OBJECT_CLASS (ntk_test_derived_dataclass_parent_class)->finalize (obj);
}


GType ntk_test_derived_dataclass_get_type (void) {
	static volatile gsize ntk_test_derived_dataclass_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_derived_dataclass_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestDerivedDataClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_derived_dataclass_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestDerivedDataClass), 0, (GInstanceInitFunc) ntk_test_derived_dataclass_instance_init, NULL };
		GType ntk_test_derived_dataclass_type_id;
		ntk_test_derived_dataclass_type_id = g_type_register_static (NETSUKUKU_TYPE_DATACLASS, "NtkTestDerivedDataClass", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_derived_dataclass_type_id__volatile, ntk_test_derived_dataclass_type_id);
	}
	return ntk_test_derived_dataclass_type_id__volatile;
}


NtkTestDerivedMap* ntk_test_derived_map_construct (GType object_type, gint levels, gint gsize, NetsukukuNIP* me) {
	NtkTestDerivedMap * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	g_return_val_if_fail (me != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = me;
	self = (NtkTestDerivedMap*) netsukuku_map_construct (object_type, NTK_TEST_TYPE_DERIVED_DATACLASS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


NtkTestDerivedMap* ntk_test_derived_map_new (gint levels, gint gsize, NetsukukuNIP* me) {
	return ntk_test_derived_map_construct (NTK_TEST_TYPE_DERIVED_MAP, levels, gsize, me);
}


void ntk_test_derived_map_deriv_node_add (NtkTestDerivedMap* self, gint lvl, gint pos) {
	gint _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
	NtkTestDerivedDataClass* node;
	NtkTestDerivedDataClass* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = lvl;
	_tmp1_ = pos;
	_tmp2_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp0_, _tmp1_);
	node = (NtkTestDerivedDataClass*) _tmp2_;
	_tmp3_ = node;
	_tmp4_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp3_);
	if (_tmp4_) {
		NtkTestDerivedDataClass* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = node;
		_tmp5_->busy = TRUE;
		_tmp6_ = lvl;
		_tmp7_ = pos;
		netsukuku_map_node_add ((NetsukukuMap*) self, _tmp6_, _tmp7_);
	}
	_g_object_unref0 (node);
}


void ntk_test_derived_map_deriv_node_del (NtkTestDerivedMap* self, gint lvl, gint pos) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lvl;
	_tmp1_ = pos;
	netsukuku_map_node_del ((NetsukukuMap*) self, _tmp0_, _tmp1_);
}


static void ntk_test_derived_map_class_init (NtkTestDerivedMapClass * klass) {
	ntk_test_derived_map_parent_class = g_type_class_peek_parent (klass);
}


static void ntk_test_derived_map_instance_init (NtkTestDerivedMap * self) {
}


GType ntk_test_derived_map_get_type (void) {
	static volatile gsize ntk_test_derived_map_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_derived_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestDerivedMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_derived_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestDerivedMap), 0, (GInstanceInitFunc) ntk_test_derived_map_instance_init, NULL };
		GType ntk_test_derived_map_type_id;
		ntk_test_derived_map_type_id = g_type_register_static (NETSUKUKU_TYPE_MAP, "NtkTestDerivedMap", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_derived_map_type_id__volatile, ntk_test_derived_map_type_id);
	}
	return ntk_test_derived_map_type_id__volatile;
}


void ntk_test_map_tester_set_up (NtkTestMapTester* self) {
	g_return_if_fail (self != NULL);
}


void ntk_test_map_tester_tear_down (NtkTestMapTester* self) {
	g_return_if_fail (self != NULL);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		NtkTestMapTester * self;
		self = _data1_->self;
		_g_free0 (_data1_->test);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda2_ (Block1Data* _data1_, NetsukukuMap* _m, gint lvl, gint pos) {
	NtkTestMapTester * self;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = _data1_->self;
	g_return_if_fail (_m != NULL);
	_tmp0_ = _data1_->test;
	_tmp1_ = lvl;
	_tmp2_ = pos;
	_tmp3_ = g_strdup_printf ("C%d,%d", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp0_, _tmp4_, NULL);
	_g_free0 (_data1_->test);
	_data1_->test = _tmp5_;
	_g_free0 (_tmp4_);
}


static void ___lambda2__netsukuku_map_node_new (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self) {
	__lambda2_ (self, _sender, lvl, pos);
}


static void __lambda3_ (Block1Data* _data1_, NetsukukuMap* _m, gint lvl, gint pos) {
	NtkTestMapTester * self;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = _data1_->self;
	g_return_if_fail (_m != NULL);
	_tmp0_ = _data1_->test;
	_tmp1_ = lvl;
	_tmp2_ = pos;
	_tmp3_ = g_strdup_printf ("D%d,%d", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp0_, _tmp4_, NULL);
	_g_free0 (_data1_->test);
	_data1_->test = _tmp5_;
	_g_free0 (_tmp4_);
}


static void ___lambda3__netsukuku_map_node_deleted (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self) {
	__lambda3_ (self, _sender, lvl, pos);
}


static gboolean _vala_int_array_contains (gint* stack, int stack_length, gint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


void ntk_test_map_tester_test_fundamentals (NtkTestMapTester* self) {
	Block1Data* _data1_;
	gint* _tmp0_ = NULL;
	gint* _tmp1_;
	gint _tmp1__length1;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NtkTestDerivedMap* _tmp4_;
	NtkTestDerivedMap* _tmp5_;
	NtkTestDerivedMap* m;
	gchar* _tmp6_;
	NtkTestDerivedMap* _tmp7_;
	NtkTestDerivedMap* _tmp8_;
	NtkTestDerivedMap* _tmp9_;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* _tmp11_;
	gint _tmp12_ = 0;
	NtkTestDerivedMap* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	NtkTestDerivedMap* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	NtkTestDerivedMap* _tmp27_;
	gint _tmp28_ = 0;
	gint* _tmp29_ = NULL;
	gint* free;
	gint free_length1;
	gint _free_size_;
	gint* _tmp30_;
	gint _tmp30__length1;
	gint* _tmp31_;
	gint _tmp31__length1;
	gint* _tmp32_;
	gint _tmp32__length1;
	gint* _tmp33_;
	gint _tmp33__length1;
	gint* _tmp34_;
	gint _tmp34__length1;
	gint* _tmp35_;
	gint _tmp35__length1;
	gint* _tmp36_;
	gint _tmp36__length1;
	gint* _tmp37_;
	gint _tmp37__length1;
	const gchar* _tmp38_;
	NtkTestDerivedMap* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	NtkTestDerivedMap* _tmp50_;
	gint _tmp51_ = 0;
	gint* _tmp52_ = NULL;
	gint* busy;
	gint busy_length1;
	gint _busy_size_;
	const gchar* _tmp53_;
	NtkTestDerivedMap* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gint* _tmp57_ = NULL;
	gint* _tmp58_;
	gint _tmp58__length1;
	NetsukukuNIP* _tmp59_;
	NetsukukuNIP* _tmp60_;
	NetsukukuNIP* n;
	gint* _tmp61_ = NULL;
	gint* _tmp62_;
	gint _tmp62__length1;
	NetsukukuNIP* _tmp63_;
	NetsukukuNIP* _tmp64_;
	NetsukukuNIP* n2;
	gint* _tmp65_ = NULL;
	gint* _tmp66_;
	gint _tmp66__length1;
	NetsukukuNIP* _tmp67_;
	NetsukukuNIP* _tmp68_;
	NetsukukuNIP* n3;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	NtkTestDerivedMap* _tmp71_;
	NetsukukuHCoord* _tmp72_ = NULL;
	NetsukukuHCoord* hc_n;
	NetsukukuHCoord* _tmp73_;
	NetsukukuHCoord* hc;
	gint _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	gboolean _tmp78_ = FALSE;
	NtkTestDerivedMap* _tmp79_;
	NetsukukuPartialNIP* _tmp80_ = NULL;
	NetsukukuPartialNIP* _tmp81_;
	NetsukukuNIP* _tmp82_ = NULL;
	NetsukukuNIP* _tmp83_;
	NetsukukuNIP* n4;
	gint* _tmp84_ = NULL;
	gint* _tmp85_;
	gint _tmp85__length1;
	NetsukukuNIP* _tmp86_;
	NetsukukuNIP* _tmp87_;
	gboolean _tmp88_ = FALSE;
	NtkTestDerivedMap* _tmp89_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	if (FALSE) {
		exit (77);
	}
	_tmp0_ = g_new0 (gint, 8);
	_tmp0_[0] = 2;
	_tmp0_[1] = 3;
	_tmp0_[2] = 4;
	_tmp0_[3] = 5;
	_tmp0_[4] = 2;
	_tmp0_[5] = 3;
	_tmp0_[6] = 4;
	_tmp0_[7] = 5;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 8;
	_tmp2_ = netsukuku_nip_new (_tmp1_, 8);
	_tmp3_ = _tmp2_;
	_tmp4_ = ntk_test_derived_map_new (8, 8, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp1_ = (g_free (_tmp1_), NULL);
	m = _tmp5_;
	_tmp6_ = g_strdup ("");
	_data1_->test = _tmp6_;
	_tmp7_ = m;
	g_signal_connect_data ((NetsukukuMap*) _tmp7_, "node-new", (GCallback) ___lambda2__netsukuku_map_node_new, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp8_ = m;
	g_signal_connect_data ((NetsukukuMap*) _tmp8_, "node-deleted", (GCallback) ___lambda3__netsukuku_map_node_deleted, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp9_ = m;
	_tmp10_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp11_, 2);
	_vala_assert (_tmp12_ == 4, "m.me.position_at(2) == 4");
	_tmp13_ = m;
	_tmp14_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_ == 8, "m.levels == 8");
	_tmp16_ = m;
	_tmp17_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp16_);
	_tmp18_ = _tmp17_;
	_vala_assert (_tmp18_ == 8, "m.gsize == 8");
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp19_;
			_tmp19_ = TRUE;
			while (TRUE) {
				gboolean _tmp20_;
				gint _tmp22_;
				NtkTestDerivedMap* _tmp23_;
				gint _tmp24_;
				gint _tmp25_ = 0;
				gint n;
				gint _tmp26_;
				_tmp20_ = _tmp19_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = lvl;
					lvl = _tmp21_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp22_ = lvl;
				if (!(_tmp22_ < 8)) {
					break;
				}
				_tmp23_ = m;
				_tmp24_ = lvl;
				_tmp25_ = netsukuku_map_free_nodes_nb ((NetsukukuMap*) _tmp23_, _tmp24_);
				n = _tmp25_;
				_tmp26_ = n;
				_vala_assert (_tmp26_ == 7, "n == 7");
			}
		}
	}
	_tmp27_ = m;
	_tmp29_ = netsukuku_map_free_nodes_list ((NetsukukuMap*) _tmp27_, 1, &_tmp28_);
	free = _tmp29_;
	free_length1 = _tmp28_;
	_free_size_ = free_length1;
	_tmp30_ = free;
	_tmp30__length1 = free_length1;
	_vala_assert (_vala_int_array_contains (_tmp30_, _tmp30__length1, 0), "0 in free");
	_tmp31_ = free;
	_tmp31__length1 = free_length1;
	_vala_assert (_vala_int_array_contains (_tmp31_, _tmp31__length1, 1), "1 in free");
	_tmp32_ = free;
	_tmp32__length1 = free_length1;
	_vala_assert (_vala_int_array_contains (_tmp32_, _tmp32__length1, 2), "2 in free");
	_tmp33_ = free;
	_tmp33__length1 = free_length1;
	_vala_assert (!_vala_int_array_contains (_tmp33_, _tmp33__length1, 3), "!(3 in free)");
	_tmp34_ = free;
	_tmp34__length1 = free_length1;
	_vala_assert (_vala_int_array_contains (_tmp34_, _tmp34__length1, 4), "4 in free");
	_tmp35_ = free;
	_tmp35__length1 = free_length1;
	_vala_assert (_vala_int_array_contains (_tmp35_, _tmp35__length1, 5), "5 in free");
	_tmp36_ = free;
	_tmp36__length1 = free_length1;
	_vala_assert (_vala_int_array_contains (_tmp36_, _tmp36__length1, 6), "6 in free");
	_tmp37_ = free;
	_tmp37__length1 = free_length1;
	_vala_assert (_vala_int_array_contains (_tmp37_, _tmp37__length1, 7), "7 in free");
	_tmp38_ = _data1_->test;
	_vala_assert (g_strcmp0 (_tmp38_, "") == 0, "test == \"\"");
	_tmp39_ = m;
	ntk_test_derived_map_deriv_node_add (_tmp39_, 0, 7);
	_tmp40_ = _data1_->test;
	_vala_assert (g_strcmp0 (_tmp40_, "C0,7") == 0, "test == \"C0,7\"");
	_tmp41_ = g_strdup ("");
	_g_free0 (_data1_->test);
	_data1_->test = _tmp41_;
	{
		gint lvl2;
		lvl2 = 1;
		{
			gboolean _tmp42_;
			_tmp42_ = TRUE;
			while (TRUE) {
				gboolean _tmp43_;
				gint _tmp45_;
				NtkTestDerivedMap* _tmp46_;
				gint _tmp47_;
				gint _tmp48_ = 0;
				gint n2;
				gint _tmp49_;
				_tmp43_ = _tmp42_;
				if (!_tmp43_) {
					gint _tmp44_;
					_tmp44_ = lvl2;
					lvl2 = _tmp44_ + 1;
				}
				_tmp42_ = FALSE;
				_tmp45_ = lvl2;
				if (!(_tmp45_ < 8)) {
					break;
				}
				_tmp46_ = m;
				_tmp47_ = lvl2;
				_tmp48_ = netsukuku_map_busy_nodes_nb ((NetsukukuMap*) _tmp46_, _tmp47_);
				n2 = _tmp48_;
				_tmp49_ = n2;
				_vala_assert (_tmp49_ == 1, "n2 == 1");
			}
		}
	}
	_tmp50_ = m;
	_tmp52_ = netsukuku_map_busy_nodes_list ((NetsukukuMap*) _tmp50_, 0, &_tmp51_);
	busy = _tmp52_;
	busy_length1 = _tmp51_;
	_busy_size_ = busy_length1;
	_vala_assert (!_vala_int_array_contains (busy, busy_length1, 0), "!(0 in busy)");
	_vala_assert (!_vala_int_array_contains (busy, busy_length1, 1), "!(1 in busy)");
	_vala_assert (_vala_int_array_contains (busy, busy_length1, 2), "2 in busy");
	_vala_assert (!_vala_int_array_contains (busy, busy_length1, 3), "!(3 in busy)");
	_vala_assert (!_vala_int_array_contains (busy, busy_length1, 4), "!(4 in busy)");
	_vala_assert (!_vala_int_array_contains (busy, busy_length1, 5), "!(5 in busy)");
	_vala_assert (!_vala_int_array_contains (busy, busy_length1, 6), "!(6 in busy)");
	_vala_assert (_vala_int_array_contains (busy, busy_length1, 7), "7 in busy");
	_tmp53_ = _data1_->test;
	_vala_assert (g_strcmp0 (_tmp53_, "") == 0, "test == \"\"");
	_tmp54_ = m;
	ntk_test_derived_map_deriv_node_del (_tmp54_, 0, 7);
	_tmp55_ = _data1_->test;
	_vala_assert (g_strcmp0 (_tmp55_, "D0,7") == 0, "test == \"D0,7\"");
	_tmp56_ = g_strdup ("");
	_g_free0 (_data1_->test);
	_data1_->test = _tmp56_;
	_tmp57_ = g_new0 (gint, 8);
	_tmp57_[0] = 2;
	_tmp57_[1] = 2;
	_tmp57_[2] = 2;
	_tmp57_[3] = 1;
	_tmp57_[4] = 1;
	_tmp57_[5] = 1;
	_tmp57_[6] = 1;
	_tmp57_[7] = 5;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 8;
	_tmp59_ = netsukuku_nip_new (_tmp58_, 8);
	_tmp60_ = _tmp59_;
	_tmp58_ = (g_free (_tmp58_), NULL);
	n = _tmp60_;
	_tmp61_ = g_new0 (gint, 8);
	_tmp61_[0] = 2;
	_tmp61_[1] = 2;
	_tmp61_[2] = 2;
	_tmp61_[3] = 1;
	_tmp61_[4] = 1;
	_tmp61_[5] = 1;
	_tmp61_[6] = 1;
	_tmp61_[7] = 5;
	_tmp62_ = _tmp61_;
	_tmp62__length1 = 8;
	_tmp63_ = netsukuku_nip_new (_tmp62_, 8);
	_tmp64_ = _tmp63_;
	_tmp62_ = (g_free (_tmp62_), NULL);
	n2 = _tmp64_;
	_tmp65_ = g_new0 (gint, 8);
	_tmp65_[0] = 3;
	_tmp65_[1] = 2;
	_tmp65_[2] = 2;
	_tmp65_[3] = 1;
	_tmp65_[4] = 1;
	_tmp65_[5] = 1;
	_tmp65_[6] = 1;
	_tmp65_[7] = 5;
	_tmp66_ = _tmp65_;
	_tmp66__length1 = 8;
	_tmp67_ = netsukuku_nip_new (_tmp66_, 8);
	_tmp68_ = _tmp67_;
	_tmp66_ = (g_free (_tmp66_), NULL);
	n3 = _tmp68_;
	_vala_assert (n != n2, "n != n2");
	_tmp69_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n, (NetsukukuPartialNIP*) n2);
	_vala_assert (_tmp69_, "n.is_equal(n2)");
	_tmp70_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n, (NetsukukuPartialNIP*) n3);
	_vala_assert (!_tmp70_, "!n.is_equal(n3)");
	_tmp71_ = m;
	_tmp72_ = netsukuku_map_nip_to_lvlid ((NetsukukuMap*) _tmp71_, (NetsukukuPartialNIP*) n);
	hc_n = _tmp72_;
	_tmp73_ = netsukuku_hcoord_new (6, 1);
	hc = _tmp73_;
	_tmp74_ = netsukuku_hcoord_get_lvl (hc);
	_tmp75_ = _tmp74_;
	_vala_assert (_tmp75_ == 6, "hc.lvl == 6");
	_tmp76_ = netsukuku_hcoord_get_pos (hc);
	_tmp77_ = _tmp76_;
	_vala_assert (_tmp77_ == 1, "hc.pos == 1");
	_vala_assert (hc != hc_n, "hc != hc_n");
	_tmp78_ = netsukuku_hcoord_is_equal (hc, hc_n);
	_vala_assert (_tmp78_, "hc.is_equal(hc_n)");
	_tmp79_ = m;
	_tmp80_ = netsukuku_map_lvlid_to_nip ((NetsukukuMap*) _tmp79_, hc_n);
	_tmp81_ = _tmp80_;
	_tmp82_ = netsukuku_partial_nip_lowest_nip (_tmp81_);
	_tmp83_ = _tmp82_;
	_g_object_unref0 (_tmp81_);
	n4 = _tmp83_;
	_tmp84_ = g_new0 (gint, 8);
	_tmp84_[0] = 0;
	_tmp84_[1] = 0;
	_tmp84_[2] = 0;
	_tmp84_[3] = 0;
	_tmp84_[4] = 0;
	_tmp84_[5] = 0;
	_tmp84_[6] = 1;
	_tmp84_[7] = 5;
	_tmp85_ = _tmp84_;
	_tmp85__length1 = 8;
	_tmp86_ = netsukuku_nip_new (_tmp85_, 8);
	_tmp87_ = _tmp86_;
	_tmp88_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n4, (NetsukukuPartialNIP*) _tmp87_);
	_vala_assert (_tmp88_, "n4.is_equal(new NIP({0,0,0,0,0,0,1,5}))");
	_g_object_unref0 (_tmp87_);
	_tmp85_ = (g_free (_tmp85_), NULL);
	_tmp89_ = m;
	netsukuku_map_stop_operations ((NetsukukuMap*) _tmp89_);
	tasklets_tasklet_dispatcher_abort_all ();
	_g_object_unref0 (n4);
	_g_object_unref0 (hc);
	_g_object_unref0 (hc_n);
	_g_object_unref0 (n3);
	_g_object_unref0 (n2);
	_g_object_unref0 (n);
	busy = (g_free (busy), NULL);
	free = (g_free (free), NULL);
	_g_object_unref0 (m);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void __lambda4_ (void) {
	NtkTestMapTester* _tmp0_;
	NtkTestMapTester* x;
	_tmp0_ = ntk_test_map_tester_new ();
	x = _tmp0_;
	ntk_test_map_tester_set_up (x);
	ntk_test_map_tester_test_fundamentals (x);
	ntk_test_map_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda4__gcallback (void) {
	__lambda4_ ();
}


gint ntk_test_map_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	tasklets_tasklet_init (64);
	g_test_add_func ("/Map/Fundamentals", ___lambda4__gcallback);
	g_test_run ();
	tasklets_tasklet_kill ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ntk_test_map_tester_main (argv, argc);
}


NtkTestMapTester* ntk_test_map_tester_construct (GType object_type) {
	NtkTestMapTester * self = NULL;
	self = (NtkTestMapTester*) g_object_new (object_type, NULL);
	return self;
}


NtkTestMapTester* ntk_test_map_tester_new (void) {
	return ntk_test_map_tester_construct (NTK_TEST_TYPE_MAP_TESTER);
}


static void ntk_test_map_tester_class_init (NtkTestMapTesterClass * klass) {
	ntk_test_map_tester_parent_class = g_type_class_peek_parent (klass);
}


static void ntk_test_map_tester_instance_init (NtkTestMapTester * self) {
}


GType ntk_test_map_tester_get_type (void) {
	static volatile gsize ntk_test_map_tester_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_map_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestMapTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_map_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestMapTester), 0, (GInstanceInitFunc) ntk_test_map_tester_instance_init, NULL };
		GType ntk_test_map_tester_type_id;
		ntk_test_map_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestMapTester", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_map_tester_type_id__volatile, ntk_test_map_tester_type_id);
	}
	return ntk_test_map_tester_type_id__volatile;
}



