/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using Tasklets;
using zcd;

namespace Netsukuku
{
#if log_tasklet
    private string tasklet_id()
    {
        return @"[$(Tasklet.self().id)] ";
    }
#else
    private string tasklet_id()
    {
        return "";
    }
#endif
    internal void log_debug(string msg) {Posix.syslog(Posix.LOG_DEBUG, tasklet_id()+msg);}
    internal void log_info(string msg) {Posix.syslog(Posix.LOG_INFO, tasklet_id()+msg);}
    internal void log_notice(string msg) {Posix.syslog(Posix.LOG_NOTICE, tasklet_id()+msg);}
    internal void log_warn(string msg) {Posix.syslog(Posix.LOG_WARNING, tasklet_id()+msg);}
    internal void log_error(string msg) {Posix.syslog(Posix.LOG_ERR, tasklet_id()+msg);}
    internal void log_critical(string msg) {Posix.syslog(Posix.LOG_CRIT, tasklet_id()+msg);}

    namespace Crypto
    {
        public errordomain GCryptError {GENERIC}
        public uint32 fnv_32(uchar[] data) {return 0;}
    }

    public errordomain RPCError {
        FUNCTION_NOT_REMOTABLE,
        MALFORMED_PACKET,
        NETWORK_ERROR,
        NOT_VALID_MAP_YET,
        DROP,
        GENERIC
    }

    public ArrayList<int> valid_ids(int levels, int gsize, int lvl, PartialNIP partial_nip)
    {
        ArrayList<int> ret = new ArrayList<int>();
        for (int i = 0; i < gsize; i++) ret.add(i);
        return ret;
    }

    public class AggregatedNeighbour : Object
    {
        public AggregatedNeighbour(int i)
        {
            if (i == 0)
            {
                descr = "<10.1.2.3 ident 123>";
                neighbour_client = new fake_AggregatedNeighbour();
                neighbour_client.hook = neighbour_client;
                Gee.List<PairLvlNumberOfFreeNodes> ret =
                        new ArrayList<PairLvlNumberOfFreeNodes>();
                // full network.
                neighbour_client.hook._list_non_saturated_levels = ret;
            }
        }
        public NIP nip;
        private string descr;
        public string to_string() {return descr;}
        public fake_AggregatedNeighbour neighbour_client;
    }
    public class fake_AggregatedNeighbour : Object
    {
        public fake_AggregatedNeighbour hook;
        public Gee.List<PairLvlNumberOfFreeNodes> _list_non_saturated_levels;
        public Gee.List<PairLvlNumberOfFreeNodes> list_non_saturated_levels()
        {return _list_non_saturated_levels;}
        public fake_AggregatedNeighbour coordinator;
        public CoordinatorReservation reserve_into(PartialNIP gnode)
        {return null;}
    }

    public class MapRoute : Object
    {
        public int levels;
        public int free_nodes_nb(int lvl) {return 0;}
    }

    public class AddressManager : Object
    {
        public bool is_mature;
    }
}

namespace Ntk.Test
{
    string logger;
    const bool output = false;

    public class HookTester : Object
    {
        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        public void test_hook_fullnetwork()
        {
            MapRoute maproute = new MapRoute();
            AddressManager addr_man = new AddressManager();
            ArrayList<AggregatedNeighbour> neighbour_list = new ArrayList<AggregatedNeighbour>();
            AggregatedNeighbour n1 = new AggregatedNeighbour(0);
            neighbour_list.add(n1);
            Hook h = new Hook(maproute, addr_man);
            bool thrown = false;
            try
            {
                h.hook(neighbour_list);
            }
            catch (HookingError e)
            {
                if (e is HookingError.GENERIC
                        && e.message.contains("full"))
                {
                    if (output) stdout.printf(@"full: $(e.message)\n");
                    thrown = true;
                }
            }
            assert(thrown);
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            GLib.Test.add_func ("/Hook/HookFullNetwork", () => {
                var x = new HookTester();
                x.set_up();
                x.test_hook_fullnetwork();
                x.tear_down();
            });
            GLib.Test.run();
            return 0;
        }
    }
}
