/* ntkd.c generated by valac 0.20.1, the Vala compiler
 * generated from ntkd.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <syslog.h>
#include <config.h>
#include <netsukuku-rpc.h>
#include <zcd.h>
#include <andns-rpc.h>
#include <gee.h>
#include <signal.h>
#include <gobject/gvaluecollector.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define NETSUKUKU_TYPE_NTKD (netsukuku_ntkd_get_type ())
#define NETSUKUKU_NTKD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NTKD, NetsukukuNtkd))
#define NETSUKUKU_NTKD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NTKD, NetsukukuNtkdClass))
#define NETSUKUKU_IS_NTKD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NTKD))
#define NETSUKUKU_IS_NTKD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NTKD))
#define NETSUKUKU_NTKD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NTKD, NetsukukuNtkdClass))

typedef struct _NetsukukuNtkd NetsukukuNtkd;
typedef struct _NetsukukuNtkdClass NetsukukuNtkdClass;
typedef struct _NetsukukuNtkdPrivate NetsukukuNtkdPrivate;

#define NETSUKUKU_TYPE_NTK_NODE (netsukuku_ntk_node_get_type ())
#define NETSUKUKU_NTK_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NTK_NODE, NetsukukuNtkNode))
#define NETSUKUKU_NTK_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NTK_NODE, NetsukukuNtkNodeClass))
#define NETSUKUKU_IS_NTK_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NTK_NODE))
#define NETSUKUKU_IS_NTK_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NTK_NODE))
#define NETSUKUKU_NTK_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NTK_NODE, NetsukukuNtkNodeClass))

typedef struct _NetsukukuNtkNode NetsukukuNtkNode;
typedef struct _NetsukukuNtkNodeClass NetsukukuNtkNodeClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetsukukuParamSpecNtkd NetsukukuParamSpecNtkd;

struct _NetsukukuNtkd {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NetsukukuNtkdPrivate * priv;
};

struct _NetsukukuNtkdClass {
	GTypeClass parent_class;
	void (*finalize) (NetsukukuNtkd *self);
};

struct _NetsukukuParamSpecNtkd {
	GParamSpec parent_instance;
};


static gpointer netsukuku_ntkd_parent_class = NULL;
static gint netsukuku_ntkd_verbosity;
static gint netsukuku_ntkd_verbosity = 0;
static gboolean netsukuku_ntkd_nicreset;
static gboolean netsukuku_ntkd_nicreset = FALSE;
static gchar* netsukuku_ntkd_config_file;
static gchar* netsukuku_ntkd_config_file = NULL;
static gchar** netsukuku_ntkd_interfaces;
static gchar** netsukuku_ntkd_interfaces = NULL;
static gchar** netsukuku_ntkd_excluded;
static gchar** netsukuku_ntkd_excluded = NULL;
static gboolean netsukuku_ntkd_log_trace;
static gboolean netsukuku_ntkd_log_trace = FALSE;
static gboolean netsukuku_ntkd_log_verbose;
static gboolean netsukuku_ntkd_log_verbose = FALSE;
static gboolean netsukuku_ntkd_show_version;
static gboolean netsukuku_ntkd_show_version = FALSE;
static NetsukukuNtkNode* netsukuku_ntkd_me;
static NetsukukuNtkNode* netsukuku_ntkd_me = NULL;
static gboolean netsukuku_ntkd_do_me_exit;
static gboolean netsukuku_ntkd_do_me_exit = FALSE;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void netsukuku_log_trace (const gchar* msg);
gboolean netsukuku_settings_get_LOG_TRACE (void);
void netsukuku_log_verbose (const gchar* msg);
gboolean netsukuku_settings_get_LOG_VERBOSE (void);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
gpointer netsukuku_ntkd_ref (gpointer instance);
void netsukuku_ntkd_unref (gpointer instance);
GParamSpec* netsukuku_param_spec_ntkd (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void netsukuku_value_set_ntkd (GValue* value, gpointer v_object);
void netsukuku_value_take_ntkd (GValue* value, gpointer v_object);
gpointer netsukuku_value_get_ntkd (const GValue* value);
GType netsukuku_ntkd_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_NTKD_DUMMY_PROPERTY
};
GType netsukuku_ntk_node_get_type (void) G_GNUC_CONST;
gint netsukuku_ntkd_main (gchar** args, int args_length1);
void netsukuku_settings_init (const gchar* config_file);
gint netsukuku_settings_get_THREAD_STACK_SIZE (void);
static TaskletsStat* __lambda40_ (void);
static TaskletsStat* ___lambda40__tasklets_create_tasklet_stat (gpointer self);
static void __lambda41_ (TaskletsStat* tasklet, TaskletsEventType event_type);
static void ___lambda41__tasklets_tasklet_event (TaskletsStat* tasklet, TaskletsEventType event_type, gpointer self);
void netsukuku_impl_linux_linux_nic_register (void);
void netsukuku_impl_linux_linux_route_register (void);
void netsukuku_impl_linux_linux_tunnel_register (void);
gint netsukuku_settings_get_VERBOSE_LEVEL (void);
void netsukuku_settings_set_VERBOSE_LEVEL (gint value);
GeeArrayList* netsukuku_settings_get_NICS (void);
void netsukuku_settings_set_NICS (GeeArrayList* value);
GeeArrayList* netsukuku_settings_get_EXCLUDE_NICS (void);
void netsukuku_settings_set_EXCLUDE_NICS (GeeArrayList* value);
gboolean netsukuku_settings_get_FORCE_NIC_RESET (void);
void netsukuku_settings_set_FORCE_NIC_RESET (gboolean value);
void netsukuku_settings_set_LOG_TRACE (gboolean value);
void netsukuku_settings_set_LOG_VERBOSE (gboolean value);
NetsukukuNtkNode* netsukuku_ntk_node_new (void);
NetsukukuNtkNode* netsukuku_ntk_node_construct (GType object_type);
void netsukuku_ntk_node_run (NetsukukuNtkNode* self);
void andns_andns_server_start_operations (void);
void netsukuku_ntkd_reload_andna (gint signal);
static void _netsukuku_ntkd_reload_andna_sighandler_t (gint signal);
void netsukuku_ntkd_safe_exit (gint signal);
static void _netsukuku_ntkd_safe_exit_sighandler_t (gint signal);
void netsukuku_ntk_node_exit (NetsukukuNtkNode* self);
NetsukukuNtkd* netsukuku_ntkd_new (void);
NetsukukuNtkd* netsukuku_ntkd_construct (GType object_type);
static void netsukuku_ntkd_finalize (NetsukukuNtkd* obj);
static gint _vala_array_length (gpointer array);


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* ret;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint len;
	const gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	ret = _tmp5_;
	_tmp6_ = ret;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	len = _tmp8_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				gint _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = len;
				if (!(_tmp12_ < (5 - _tmp13_))) {
					break;
				}
				_tmp14_ = ret;
				_tmp15_ = g_strconcat (" ", _tmp14_, NULL);
				_g_free0 (ret);
				ret = _tmp15_;
			}
		}
	}
	_tmp16_ = ret;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = g_strconcat ("[", _tmp17_, "] ", NULL);
	result = _tmp18_;
	_g_free0 (ret);
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "DEBUG ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_DEBUG, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_trace (const gchar* msg) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_settings_get_LOG_TRACE ();
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = netsukuku_tasklet_id ();
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "INFO ", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = msg;
		_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		syslog (LOG_INFO, _tmp8_, NULL);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
}


void netsukuku_log_verbose (const gchar* msg) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_settings_get_LOG_VERBOSE ();
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = netsukuku_tasklet_id ();
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "INFO ", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = msg;
		_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		syslog (LOG_INFO, _tmp8_, NULL);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "INFO ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_INFO, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "INFO+ ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_NOTICE, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "INFO++ ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_WARNING, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "ERROR ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_ERR, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "ERROR+ ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_CRIT, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


static TaskletsStat* __lambda40_ (void) {
	TaskletsStat* result = NULL;
	NetsukukuTaskletStats* _tmp0_;
	_tmp0_ = netsukuku_tasklet_stats_new ();
	result = (TaskletsStat*) _tmp0_;
	return result;
}


static TaskletsStat* ___lambda40__tasklets_create_tasklet_stat (gpointer self) {
	TaskletsStat* result;
	result = __lambda40_ ();
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda41_ (TaskletsStat* tasklet, TaskletsEventType event_type) {
	TaskletsStat* _tmp0_;
	NetsukukuTaskletStats* _tmp1_;
	NetsukukuTaskletStats* st;
	TaskletsEventType _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	TaskletsEventType _tmp7_;
	gboolean _tmp9_;
	gboolean _tmp11_;
	g_return_if_fail (tasklet != NULL);
	_tmp0_ = tasklet;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_TASKLET_STATS, NetsukukuTaskletStats));
	st = _tmp1_;
	_tmp2_ = event_type;
	if (_tmp2_ == TASKLETS_EVENT_TYPE_STARTED) {
		NetsukukuTaskletStats* _tmp3_;
		NetsukukuTimeCapsule* _tmp4_;
		_tmp3_ = st;
		_tmp4_ = netsukuku_time_capsule_new ((gint64) 0);
		_g_object_unref0 (_tmp3_->tasklet_started);
		_tmp3_->tasklet_started = _tmp4_;
	}
	_tmp7_ = event_type;
	if (_tmp7_ == TASKLETS_EVENT_TYPE_CRASHED) {
		_tmp6_ = TRUE;
	} else {
		TaskletsEventType _tmp8_;
		_tmp8_ = event_type;
		_tmp6_ = _tmp8_ == TASKLETS_EVENT_TYPE_ENDED;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		_tmp5_ = TRUE;
	} else {
		TaskletsEventType _tmp10_;
		_tmp10_ = event_type;
		_tmp5_ = _tmp10_ == TASKLETS_EVENT_TYPE_ABORTED;
	}
	_tmp11_ = _tmp5_;
	if (_tmp11_) {
		NetsukukuTaskletStats* _tmp12_;
		NetsukukuTimeCapsule* _tmp13_;
		_tmp12_ = st;
		_tmp13_ = netsukuku_time_capsule_new ((gint64) 0);
		_g_object_unref0 (_tmp12_->tasklet_ended);
		_tmp12_->tasklet_ended = _tmp13_;
	}
	_g_object_unref0 (st);
}


static void ___lambda41__tasklets_tasklet_event (TaskletsStat* tasklet, TaskletsEventType event_type, gpointer self) {
	__lambda41_ (tasklet, event_type);
}


static void _netsukuku_ntkd_reload_andna_sighandler_t (gint signal) {
	netsukuku_ntkd_reload_andna (signal);
}


static void _netsukuku_ntkd_safe_exit_sighandler_t (gint signal) {
	netsukuku_ntkd_safe_exit (signal);
}


gint netsukuku_ntkd_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* oc;
	GOptionEntry* _tmp2_ = NULL;
	GOptionEntry* entries;
	gint entries_length1;
	gint _entries_size_;
	gint index;
	GOptionEntry* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_;
	GOptionEntry* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	GOptionEntry _tmp9_ = {0};
	GOptionEntry _tmp10_;
	GOptionEntry* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	GOptionEntry _tmp13_ = {0};
	GOptionEntry _tmp14_;
	GOptionEntry* _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_;
	GOptionEntry _tmp17_ = {0};
	GOptionEntry _tmp18_;
	GOptionEntry* _tmp19_;
	gint _tmp19__length1;
	gint _tmp20_;
	GOptionEntry _tmp21_ = {0};
	GOptionEntry _tmp22_;
	GOptionEntry* _tmp23_;
	gint _tmp23__length1;
	gint _tmp24_;
	GOptionEntry _tmp25_ = {0};
	GOptionEntry _tmp26_;
	GOptionEntry* _tmp27_;
	gint _tmp27__length1;
	gint _tmp28_;
	GOptionEntry _tmp29_ = {0};
	GOptionEntry _tmp30_;
	GOptionEntry* _tmp31_;
	gint _tmp31__length1;
	gint _tmp32_;
	GOptionEntry _tmp33_ = {0};
	GOptionEntry _tmp34_;
	GOptionEntry* _tmp35_;
	gint _tmp35__length1;
	gint _tmp36_;
	GOptionEntry _tmp37_ = {0};
	GOptionEntry _tmp38_;
	GOptionContext* _tmp39_;
	GOptionEntry* _tmp40_;
	gint _tmp40__length1;
	gboolean _tmp47_;
	const gchar* _tmp52_;
	gint _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gint loglevel;
	gint _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp64_ = 0;
	GeeArrayList* _tmp65_;
	GeeArrayList* _tmp66_;
	GeeArrayList* _tmp67_;
	GeeArrayList* _tmp68_;
	GeeArrayList* _tmp69_;
	GeeArrayList* _tmp70_;
	GeeArrayList* _tmp71_;
	GeeArrayList* _tmp72_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	gchar** _tmp78_;
	gint _tmp78__length1;
	gboolean _tmp83_;
	gboolean _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	gboolean _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp89_;
	gboolean _tmp90_;
	gboolean _tmp91_;
	NetsukukuNtkNode* _tmp92_;
	NetsukukuNtkNode* _tmp93_;
	GError * _inner_error_ = NULL;
	netsukuku_ntkd_verbosity = -1;
	netsukuku_ntkd_nicreset = FALSE;
	_tmp0_ = g_strdup ("");
	_g_free0 (netsukuku_ntkd_config_file);
	netsukuku_ntkd_config_file = _tmp0_;
	_tmp1_ = g_option_context_new ("- Netsukuku routing daemon");
	oc = _tmp1_;
	_tmp2_ = g_new0 (GOptionEntry, 9);
	entries = _tmp2_;
	entries_length1 = 9;
	_entries_size_ = entries_length1;
	index = 0;
	_tmp3_ = entries;
	_tmp3__length1 = entries_length1;
	_tmp4_ = index;
	index = _tmp4_ + 1;
	_tmp5_.long_name = "config";
	_tmp5_.short_name = 'c';
	_tmp5_.flags = 0;
	_tmp5_.arg = G_OPTION_ARG_FILENAME;
	_tmp5_.arg_data = &netsukuku_ntkd_config_file;
	_tmp5_.description = "Configuration file";
	_tmp5_.arg_description = NULL;
	_tmp3_[_tmp4_] = _tmp5_;
	_tmp6_ = _tmp3_[_tmp4_];
	_tmp7_ = entries;
	_tmp7__length1 = entries_length1;
	_tmp8_ = index;
	index = _tmp8_ + 1;
	_tmp9_.long_name = "interface";
	_tmp9_.short_name = 'i';
	_tmp9_.flags = 0;
	_tmp9_.arg = G_OPTION_ARG_STRING_ARRAY;
	_tmp9_.arg_data = &netsukuku_ntkd_interfaces;
	_tmp9_.description = "Interface to be managed";
	_tmp9_.arg_description = NULL;
	_tmp7_[_tmp8_] = _tmp9_;
	_tmp10_ = _tmp7_[_tmp8_];
	_tmp11_ = entries;
	_tmp11__length1 = entries_length1;
	_tmp12_ = index;
	index = _tmp12_ + 1;
	_tmp13_.long_name = "exclude";
	_tmp13_.short_name = 'e';
	_tmp13_.flags = 0;
	_tmp13_.arg = G_OPTION_ARG_STRING_ARRAY;
	_tmp13_.arg_data = &netsukuku_ntkd_excluded;
	_tmp13_.description = "Interface to be excluded";
	_tmp13_.arg_description = NULL;
	_tmp11_[_tmp12_] = _tmp13_;
	_tmp14_ = _tmp11_[_tmp12_];
	_tmp15_ = entries;
	_tmp15__length1 = entries_length1;
	_tmp16_ = index;
	index = _tmp16_ + 1;
	_tmp17_.long_name = "verbosity";
	_tmp17_.short_name = 'v';
	_tmp17_.flags = 0;
	_tmp17_.arg = G_OPTION_ARG_INT;
	_tmp17_.arg_data = &netsukuku_ntkd_verbosity;
	_tmp17_.description = "Verbosity level 0..4 (overrides configuration file, default: 0)";
	_tmp17_.arg_description = NULL;
	_tmp15_[_tmp16_] = _tmp17_;
	_tmp18_ = _tmp15_[_tmp16_];
	_tmp19_ = entries;
	_tmp19__length1 = entries_length1;
	_tmp20_ = index;
	index = _tmp20_ + 1;
	_tmp21_.long_name = "nic-reset";
	_tmp21_.short_name = (gchar) 0;
	_tmp21_.flags = 0;
	_tmp21_.arg = G_OPTION_ARG_NONE;
	_tmp21_.arg_data = &netsukuku_ntkd_nicreset;
	_tmp21_.description = "Force NIC reset";
	_tmp21_.arg_description = NULL;
	_tmp19_[_tmp20_] = _tmp21_;
	_tmp22_ = _tmp19_[_tmp20_];
	_tmp23_ = entries;
	_tmp23__length1 = entries_length1;
	_tmp24_ = index;
	index = _tmp24_ + 1;
	_tmp25_.long_name = "verbose";
	_tmp25_.short_name = (gchar) 0;
	_tmp25_.flags = 0;
	_tmp25_.arg = G_OPTION_ARG_NONE;
	_tmp25_.arg_data = &netsukuku_ntkd_log_verbose;
	_tmp25_.description = "Produce more logs";
	_tmp25_.arg_description = NULL;
	_tmp23_[_tmp24_] = _tmp25_;
	_tmp26_ = _tmp23_[_tmp24_];
	_tmp27_ = entries;
	_tmp27__length1 = entries_length1;
	_tmp28_ = index;
	index = _tmp28_ + 1;
	_tmp29_.long_name = "trace";
	_tmp29_.short_name = (gchar) 0;
	_tmp29_.flags = 0;
	_tmp29_.arg = G_OPTION_ARG_NONE;
	_tmp29_.arg_data = &netsukuku_ntkd_log_trace;
	_tmp29_.description = "Produce logs for bug report";
	_tmp29_.arg_description = NULL;
	_tmp27_[_tmp28_] = _tmp29_;
	_tmp30_ = _tmp27_[_tmp28_];
	_tmp31_ = entries;
	_tmp31__length1 = entries_length1;
	_tmp32_ = index;
	index = _tmp32_ + 1;
	_tmp33_.long_name = "version";
	_tmp33_.short_name = (gchar) 0;
	_tmp33_.flags = 0;
	_tmp33_.arg = G_OPTION_ARG_NONE;
	_tmp33_.arg_data = &netsukuku_ntkd_show_version;
	_tmp33_.description = "Show version and exit";
	_tmp33_.arg_description = NULL;
	_tmp31_[_tmp32_] = _tmp33_;
	_tmp34_ = _tmp31_[_tmp32_];
	_tmp35_ = entries;
	_tmp35__length1 = entries_length1;
	_tmp36_ = index;
	index = _tmp36_ + 1;
	_tmp37_.long_name = NULL;
	_tmp35_[_tmp36_] = _tmp37_;
	_tmp38_ = _tmp35_[_tmp36_];
	_tmp39_ = oc;
	_tmp40_ = entries;
	_tmp40__length1 = entries_length1;
	g_option_context_add_main_entries (_tmp39_, _tmp40_, NULL);
	{
		GOptionContext* _tmp41_;
		_tmp41_ = oc;
		g_option_context_parse (_tmp41_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch83_g_option_error;
			}
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally83;
	__catch83_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		_tmp44_ = string_to_string (_tmp43_);
		_tmp45_ = g_strconcat ("Error parsing options: ", _tmp44_, "\n", NULL);
		_tmp46_ = _tmp45_;
		g_print ("%s", _tmp46_);
		_g_free0 (_tmp46_);
		result = 1;
		_g_error_free0 (e);
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		return result;
	}
	__finally83:
	if (_inner_error_ != NULL) {
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp47_ = netsukuku_ntkd_show_version;
	if (_tmp47_) {
		const gchar* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_;
		_tmp48_ = string_to_string (PACKAGE_NAME);
		_tmp49_ = string_to_string (PACKAGE_VERSION);
		_tmp50_ = g_strconcat (_tmp48_, " ", _tmp49_, "\n", NULL);
		_tmp51_ = _tmp50_;
		g_print ("%s", _tmp51_);
		_g_free0 (_tmp51_);
		result = 0;
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp52_ = netsukuku_ntkd_config_file;
	if (g_strcmp0 (_tmp52_, "") != 0) {
		const gchar* _tmp53_;
		_tmp53_ = netsukuku_ntkd_config_file;
		netsukuku_settings_init (_tmp53_);
	}
	_tmp54_ = netsukuku_settings_get_THREAD_STACK_SIZE ();
	_tmp55_ = _tmp54_;
	tasklets_tasklet_init (_tmp55_);
	tasklets_init_stats (___lambda40__tasklets_create_tasklet_stat, NULL, ___lambda41__tasklets_tasklet_event, NULL);
	zcd_serializer_init ();
	andns_rpc_andns_init ();
	netsukuku_rpc_ntk_init ();
	netsukuku_impl_linux_linux_nic_register ();
	netsukuku_impl_linux_linux_route_register ();
	netsukuku_impl_linux_linux_tunnel_register ();
	_tmp56_ = netsukuku_ntkd_verbosity;
	if (_tmp56_ >= 0) {
		gint _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		_tmp57_ = netsukuku_ntkd_verbosity;
		if (_tmp57_ > 4) {
			netsukuku_ntkd_verbosity = 4;
		}
		_tmp58_ = netsukuku_settings_get_VERBOSE_LEVEL ();
		_tmp59_ = _tmp58_;
		_tmp60_ = netsukuku_ntkd_verbosity;
		netsukuku_settings_set_VERBOSE_LEVEL (_tmp60_);
	}
	openlog ("netsukuku", LOG_PID, LOG_USER);
	loglevel = LOG_ERR;
	_tmp61_ = netsukuku_settings_get_VERBOSE_LEVEL ();
	_tmp62_ = _tmp61_;
	switch (_tmp62_) {
		case 1:
		{
			loglevel = LOG_WARNING;
			break;
		}
		case 2:
		{
			loglevel = LOG_NOTICE;
			break;
		}
		case 3:
		{
			loglevel = LOG_INFO;
			break;
		}
		case 4:
		{
			loglevel = LOG_DEBUG;
			break;
		}
		default:
		break;
	}
	_tmp63_ = loglevel;
	_tmp64_ = LOG_UPTO (_tmp63_);
	setlogmask (_tmp64_);
	_tmp65_ = netsukuku_settings_get_NICS ();
	_tmp66_ = _tmp65_;
	_tmp67_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_tmp68_ = _tmp67_;
	netsukuku_settings_set_NICS (_tmp68_);
	_g_object_unref0 (_tmp68_);
	_tmp69_ = netsukuku_settings_get_EXCLUDE_NICS ();
	_tmp70_ = _tmp69_;
	_tmp71_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_tmp72_ = _tmp71_;
	netsukuku_settings_set_EXCLUDE_NICS (_tmp72_);
	_g_object_unref0 (_tmp72_);
	_tmp73_ = netsukuku_ntkd_interfaces;
	_tmp73__length1 = _vala_array_length (netsukuku_ntkd_interfaces);
	{
		gchar** intf_collection = NULL;
		gint intf_collection_length1 = 0;
		gint _intf_collection_size_ = 0;
		gint intf_it = 0;
		intf_collection = _tmp73_;
		intf_collection_length1 = _tmp73__length1;
		for (intf_it = 0; intf_it < _tmp73__length1; intf_it = intf_it + 1) {
			gchar* _tmp74_;
			gchar* intf = NULL;
			_tmp74_ = g_strdup (intf_collection[intf_it]);
			intf = _tmp74_;
			{
				GeeArrayList* _tmp75_;
				GeeArrayList* _tmp76_;
				const gchar* _tmp77_;
				_tmp75_ = netsukuku_settings_get_NICS ();
				_tmp76_ = _tmp75_;
				_tmp77_ = intf;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, _tmp77_);
				_g_free0 (intf);
			}
		}
	}
	_tmp78_ = netsukuku_ntkd_excluded;
	_tmp78__length1 = _vala_array_length (netsukuku_ntkd_excluded);
	{
		gchar** excl_collection = NULL;
		gint excl_collection_length1 = 0;
		gint _excl_collection_size_ = 0;
		gint excl_it = 0;
		excl_collection = _tmp78_;
		excl_collection_length1 = _tmp78__length1;
		for (excl_it = 0; excl_it < _tmp78__length1; excl_it = excl_it + 1) {
			gchar* _tmp79_;
			gchar* excl = NULL;
			_tmp79_ = g_strdup (excl_collection[excl_it]);
			excl = _tmp79_;
			{
				GeeArrayList* _tmp80_;
				GeeArrayList* _tmp81_;
				const gchar* _tmp82_;
				_tmp80_ = netsukuku_settings_get_EXCLUDE_NICS ();
				_tmp81_ = _tmp80_;
				_tmp82_ = excl;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp81_, _tmp82_);
				_g_free0 (excl);
			}
		}
	}
	_tmp83_ = netsukuku_settings_get_FORCE_NIC_RESET ();
	_tmp84_ = _tmp83_;
	_tmp85_ = netsukuku_ntkd_nicreset;
	netsukuku_settings_set_FORCE_NIC_RESET (_tmp85_);
	_tmp86_ = netsukuku_settings_get_LOG_TRACE ();
	_tmp87_ = _tmp86_;
	_tmp88_ = netsukuku_ntkd_log_trace;
	netsukuku_settings_set_LOG_TRACE (_tmp88_);
	_tmp89_ = netsukuku_settings_get_LOG_VERBOSE ();
	_tmp90_ = _tmp89_;
	_tmp91_ = netsukuku_ntkd_log_verbose;
	netsukuku_settings_set_LOG_VERBOSE (_tmp91_);
	_tmp92_ = netsukuku_ntk_node_new ();
	_g_object_unref0 (netsukuku_ntkd_me);
	netsukuku_ntkd_me = _tmp92_;
	_tmp93_ = netsukuku_ntkd_me;
	netsukuku_ntk_node_run (_tmp93_);
	andns_andns_server_start_operations ();
	signal (SIGHUP, _netsukuku_ntkd_reload_andna_sighandler_t);
	signal (SIGINT, _netsukuku_ntkd_safe_exit_sighandler_t);
	signal (SIGTERM, _netsukuku_ntkd_safe_exit_sighandler_t);
	while (TRUE) {
		gboolean _tmp94_;
		tasklets_tasklet_nap ((glong) 1, (glong) 0);
		_tmp94_ = netsukuku_ntkd_do_me_exit;
		if (_tmp94_) {
			NetsukukuNtkNode* _tmp95_;
			netsukuku_ntkd_do_me_exit = FALSE;
			_tmp95_ = netsukuku_ntkd_me;
			netsukuku_ntk_node_exit (_tmp95_);
		}
	}
	entries = (g_free (entries), NULL);
	_g_option_context_free0 (oc);
}


int main (int argc, char ** argv) {
	g_type_init ();
	return netsukuku_ntkd_main (argv, argc);
}


void netsukuku_ntkd_safe_exit (gint signal) {
	netsukuku_ntkd_do_me_exit = TRUE;
}


void netsukuku_ntkd_reload_andna (gint signal) {
}


NetsukukuNtkd* netsukuku_ntkd_construct (GType object_type) {
	NetsukukuNtkd* self = NULL;
	self = (NetsukukuNtkd*) g_type_create_instance (object_type);
	return self;
}


NetsukukuNtkd* netsukuku_ntkd_new (void) {
	return netsukuku_ntkd_construct (NETSUKUKU_TYPE_NTKD);
}


static void netsukuku_value_ntkd_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void netsukuku_value_ntkd_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		netsukuku_ntkd_unref (value->data[0].v_pointer);
	}
}


static void netsukuku_value_ntkd_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = netsukuku_ntkd_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer netsukuku_value_ntkd_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* netsukuku_value_ntkd_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		NetsukukuNtkd* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = netsukuku_ntkd_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* netsukuku_value_ntkd_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	NetsukukuNtkd** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = netsukuku_ntkd_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* netsukuku_param_spec_ntkd (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	NetsukukuParamSpecNtkd* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NETSUKUKU_TYPE_NTKD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer netsukuku_value_get_ntkd (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_NTKD), NULL);
	return value->data[0].v_pointer;
}


void netsukuku_value_set_ntkd (GValue* value, gpointer v_object) {
	NetsukukuNtkd* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_NTKD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NETSUKUKU_TYPE_NTKD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		netsukuku_ntkd_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		netsukuku_ntkd_unref (old);
	}
}


void netsukuku_value_take_ntkd (GValue* value, gpointer v_object) {
	NetsukukuNtkd* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_NTKD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NETSUKUKU_TYPE_NTKD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		netsukuku_ntkd_unref (old);
	}
}


static void netsukuku_ntkd_class_init (NetsukukuNtkdClass * klass) {
	netsukuku_ntkd_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_NTKD_CLASS (klass)->finalize = netsukuku_ntkd_finalize;
}


static void netsukuku_ntkd_instance_init (NetsukukuNtkd * self) {
	self->ref_count = 1;
}


static void netsukuku_ntkd_finalize (NetsukukuNtkd* obj) {
	NetsukukuNtkd * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NTKD, NetsukukuNtkd);
}


GType netsukuku_ntkd_get_type (void) {
	static volatile gsize netsukuku_ntkd_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_ntkd_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { netsukuku_value_ntkd_init, netsukuku_value_ntkd_free_value, netsukuku_value_ntkd_copy_value, netsukuku_value_ntkd_peek_pointer, "p", netsukuku_value_ntkd_collect_value, "p", netsukuku_value_ntkd_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNtkdClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_ntkd_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNtkd), 0, (GInstanceInitFunc) netsukuku_ntkd_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType netsukuku_ntkd_type_id;
		netsukuku_ntkd_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NetsukukuNtkd", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&netsukuku_ntkd_type_id__volatile, netsukuku_ntkd_type_id);
	}
	return netsukuku_ntkd_type_id__volatile;
}


gpointer netsukuku_ntkd_ref (gpointer instance) {
	NetsukukuNtkd* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void netsukuku_ntkd_unref (gpointer instance) {
	NetsukukuNtkd* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NETSUKUKU_NTKD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



