/* maproute.c generated by valac 0.20.1, the Vala compiler
 * generated from maproute.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/** Evaluation methods **/
/** Neighbour stuff **/

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <zcd.h>
#include <math.h>
#include <float.h>
#include <tasklet.h>


#define NETSUKUKU_TYPE_ROUTE (netsukuku_route_get_type ())
#define NETSUKUKU_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRoute))
#define NETSUKUKU_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))
#define NETSUKUKU_IS_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_IS_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))

typedef struct _NetsukukuRoute NetsukukuRoute;
typedef struct _NetsukukuRouteClass NetsukukuRouteClass;
typedef struct _NetsukukuRoutePrivate NetsukukuRoutePrivate;

#define NETSUKUKU_TYPE_ROUTE_NODE (netsukuku_route_node_get_type ())
#define NETSUKUKU_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode))
#define NETSUKUKU_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))
#define NETSUKUKU_IS_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_IS_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_ROUTE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))

typedef struct _NetsukukuRouteNode NetsukukuRouteNode;
typedef struct _NetsukukuRouteNodeClass NetsukukuRouteNodeClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_CLONE_ROUTE (netsukuku_clone_route_get_type ())
#define NETSUKUKU_CLONE_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_CLONE_ROUTE, NetsukukuCloneRoute))
#define NETSUKUKU_CLONE_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_CLONE_ROUTE, NetsukukuCloneRouteClass))
#define NETSUKUKU_IS_CLONE_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_CLONE_ROUTE))
#define NETSUKUKU_IS_CLONE_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_CLONE_ROUTE))
#define NETSUKUKU_CLONE_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_CLONE_ROUTE, NetsukukuCloneRouteClass))

typedef struct _NetsukukuCloneRoute NetsukukuCloneRoute;
typedef struct _NetsukukuCloneRouteClass NetsukukuCloneRouteClass;
typedef struct _NetsukukuRouteNodePrivate NetsukukuRouteNodePrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;
typedef struct _NetsukukuCloneRoutePrivate NetsukukuCloneRoutePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_GID_CHECKER (netsukuku_gid_checker_get_type ())
#define NETSUKUKU_GID_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_GID_CHECKER, NetsukukuGIDChecker))
#define NETSUKUKU_GID_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_GID_CHECKER, NetsukukuGIDCheckerClass))
#define NETSUKUKU_IS_GID_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_GID_CHECKER))
#define NETSUKUKU_IS_GID_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_GID_CHECKER))
#define NETSUKUKU_GID_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_GID_CHECKER, NetsukukuGIDCheckerClass))

typedef struct _NetsukukuGIDChecker NetsukukuGIDChecker;
typedef struct _NetsukukuGIDCheckerClass NetsukukuGIDCheckerClass;
typedef struct _NetsukukuGIDCheckerPrivate NetsukukuGIDCheckerPrivate;

#define NETSUKUKU_TYPE_STRUCT_HELPER_MAPROUTE_PERIODICALLY_CHECK_GID (netsukuku_struct_helper_maproute_periodically_check_gid_get_type ())

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;
typedef struct _Netsukukustruct_helper_MapRoute_periodically_check_gid Netsukukustruct_helper_MapRoute_periodically_check_gid;
typedef struct _NetsukukuMapPrivate NetsukukuMapPrivate;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

#define NETSUKUKU_TYPE_ADDRESS_MANAGER (netsukuku_address_manager_get_type ())
#define NETSUKUKU_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager))
#define NETSUKUKU_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))
#define NETSUKUKU_IS_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_IS_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))

typedef struct _NetsukukuAddressManager NetsukukuAddressManager;
typedef struct _NetsukukuAddressManagerClass NetsukukuAddressManagerClass;
typedef struct _NetsukukuAddressManagerPrivate NetsukukuAddressManagerPrivate;

#define NETSUKUKU_TYPE_HOOK_INFORMATION (netsukuku_hook_information_get_type ())
#define NETSUKUKU_HOOK_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformation))
#define NETSUKUKU_HOOK_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformationClass))
#define NETSUKUKU_IS_HOOK_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION))
#define NETSUKUKU_IS_HOOK_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HOOK_INFORMATION))
#define NETSUKUKU_HOOK_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformationClass))

typedef struct _NetsukukuHookInformation NetsukukuHookInformation;
typedef struct _NetsukukuHookInformationClass NetsukukuHookInformationClass;

#define NETSUKUKU_TYPE_INCOMING_NODES (netsukuku_incoming_nodes_get_type ())
#define NETSUKUKU_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodes))
#define NETSUKUKU_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))
#define NETSUKUKU_IS_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_IS_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_INCOMING_NODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))

typedef struct _NetsukukuIncomingNodes NetsukukuIncomingNodes;
typedef struct _NetsukukuIncomingNodesClass NetsukukuIncomingNodesClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

#define NETSUKUKU_TYPE_ETP (netsukuku_etp_get_type ())
#define NETSUKUKU_ETP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtp))
#define NETSUKUKU_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))
#define NETSUKUKU_IS_ETP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_IS_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_ETP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))

typedef struct _NetsukukuEtp NetsukukuEtp;
typedef struct _NetsukukuEtpClass NetsukukuEtpClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_COORDINATOR (netsukuku_coordinator_get_type ())
#define NETSUKUKU_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator))
#define NETSUKUKU_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))
#define NETSUKUKU_IS_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_IS_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_COORDINATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))

typedef struct _NetsukukuCoordinator NetsukukuCoordinator;
typedef struct _NetsukukuCoordinatorClass NetsukukuCoordinatorClass;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;

#define NETSUKUKU_TYPE_TUNNEL_MANAGER (netsukuku_tunnel_manager_get_type ())
#define NETSUKUKU_TUNNEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManager))
#define NETSUKUKU_TUNNEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerClass))
#define NETSUKUKU_IS_TUNNEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER))
#define NETSUKUKU_IS_TUNNEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_TUNNEL_MANAGER))
#define NETSUKUKU_TUNNEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerClass))

typedef struct _NetsukukuTunnelManager NetsukukuTunnelManager;
typedef struct _NetsukukuTunnelManagerClass NetsukukuTunnelManagerClass;

#define NETSUKUKU_TYPE_HOOK (netsukuku_hook_get_type ())
#define NETSUKUKU_HOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HOOK, NetsukukuHook))
#define NETSUKUKU_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HOOK, NetsukukuHookClass))
#define NETSUKUKU_IS_HOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HOOK))
#define NETSUKUKU_IS_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HOOK))
#define NETSUKUKU_HOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HOOK, NetsukukuHookClass))

typedef struct _NetsukukuHook NetsukukuHook;
typedef struct _NetsukukuHookClass NetsukukuHookClass;

#define NETSUKUKU_TYPE_BORDER_NODES_MANAGER (netsukuku_border_nodes_manager_get_type ())
#define NETSUKUKU_BORDER_NODES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManager))
#define NETSUKUKU_BORDER_NODES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManagerClass))
#define NETSUKUKU_IS_BORDER_NODES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER))
#define NETSUKUKU_IS_BORDER_NODES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_BORDER_NODES_MANAGER))
#define NETSUKUKU_BORDER_NODES_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManagerClass))

typedef struct _NetsukukuBorderNodesManager NetsukukuBorderNodesManager;
typedef struct _NetsukukuBorderNodesManagerClass NetsukukuBorderNodesManagerClass;

#define NETSUKUKU_TYPE_MIGRATION_MANAGER (netsukuku_migration_manager_get_type ())
#define NETSUKUKU_MIGRATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManager))
#define NETSUKUKU_MIGRATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManagerClass))
#define NETSUKUKU_IS_MIGRATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER))
#define NETSUKUKU_IS_MIGRATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MIGRATION_MANAGER))
#define NETSUKUKU_MIGRATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManagerClass))

typedef struct _NetsukukuMigrationManager NetsukukuMigrationManager;
typedef struct _NetsukukuMigrationManagerClass NetsukukuMigrationManagerClass;

#define NETSUKUKU_TYPE_NIC (netsukuku_nic_get_type ())
#define NETSUKUKU_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNIC))
#define NETSUKUKU_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))
#define NETSUKUKU_IS_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_IS_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))

typedef struct _NetsukukuNIC NetsukukuNIC;
typedef struct _NetsukukuNICClass NetsukukuNICClass;

#define NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER (netsukuku_igs_manager_dispatcher_get_type ())
#define NETSUKUKU_IGS_MANAGER_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcher))
#define NETSUKUKU_IGS_MANAGER_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcherClass))
#define NETSUKUKU_IS_IGS_MANAGER_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER))
#define NETSUKUKU_IS_IGS_MANAGER_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER))
#define NETSUKUKU_IGS_MANAGER_DISPATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcherClass))

typedef struct _NetsukukuIGSManagerDispatcher NetsukukuIGSManagerDispatcher;
typedef struct _NetsukukuIGSManagerDispatcherClass NetsukukuIGSManagerDispatcherClass;

#define NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER (netsukuku_network_interface_manager_get_type ())
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))

typedef struct _NetsukukuNetworkInterfaceManager NetsukukuNetworkInterfaceManager;
typedef struct _NetsukukuNetworkInterfaceManagerClass NetsukukuNetworkInterfaceManagerClass;

#define NETSUKUKU_TYPE_NEIGHBOUR_MANAGER (netsukuku_neighbour_manager_get_type ())
#define NETSUKUKU_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManager))
#define NETSUKUKU_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerClass))
#define NETSUKUKU_IS_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerClass))

typedef struct _NetsukukuNeighbourManager NetsukukuNeighbourManager;
typedef struct _NetsukukuNeighbourManagerClass NetsukukuNeighbourManagerClass;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuRoute {
	GObject parent_instance;
	NetsukukuRoutePrivate * priv;
	NetsukukuRouteNode* routenode;
	NetsukukuAggregatedNeighbour* gw;
	NetsukukuREM* rem_at_gw;
	GeeList* hops;
	NetsukukuGNodeID* gid;
};

struct _NetsukukuRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuRoutePrivate {
	NetsukukuREM* _rem;
	NetsukukuHCoord* _first_hop;
	NetsukukuHCoord* _dest;
	GeeList* _hops_with_gw;
};

struct _NetsukukuRouteNode {
	NetsukukuDataClass parent_instance;
	NetsukukuRouteNodePrivate * priv;
	NetsukukuMap* maproute;
	gint lvl;
	gint pos;
	gboolean its_me;
	gboolean busy;
	GeeArrayList* routes;
};

struct _NetsukukuRouteNodeClass {
	NetsukukuDataClassClass parent_class;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
	gint levels;
	gint gsize;
	NetsukukuNIP* nip;
	gint nodeid;
	NetsukukuNetworkID* netid;
	gboolean is_primary;
	gboolean is_auxiliary;
	GeeHashMap* interfaces;
	GeeList* macs;
	gint mod_seq_num;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _NetsukukuCloneRoute {
	GObject parent_instance;
	NetsukukuCloneRoutePrivate * priv;
	gchar* gwdev;
	NetsukukuREM* gwrem;
	NetsukukuNIP* gwnip;
	gchar* gwipstr;
	NetsukukuREM* rem;
	NetsukukuREM* rem_at_gw;
	NetsukukuHCoord* dest;
	NetsukukuHCoord* first_hop;
	GeeList* hops;
	GeeList* hops_with_gw;
	NetsukukuNIP* mymap_me;
};

struct _NetsukukuCloneRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuGIDChecker {
	GObject parent_instance;
	NetsukukuGIDCheckerPrivate * priv;
	gint my_req_id;
	NetsukukuTimeCapsule* ttl;
	GeeArrayList* received_req_ids;
};

struct _NetsukukuGIDCheckerClass {
	GObjectClass parent_class;
};

struct _Netsukukustruct_helper_MapRoute_periodically_check_gid {
	NetsukukuMapRoute* self;
	gint level;
};

struct _NetsukukuMap {
	GObject parent_instance;
	NetsukukuMapPrivate * priv;
	NetsukukuDataClass** node;
	gint node_length1;
	gint node_length2;
};

struct _NetsukukuMapClass {
	GObjectClass parent_class;
	void (*stop_operations) (NetsukukuMap* self);
	gpointer (*node_get) (NetsukukuMap* self, gint lvl, gint pos);
};

struct _NetsukukuMapRoute {
	NetsukukuMap parent_instance;
	NetsukukuMapRoutePrivate * priv;
};

struct _NetsukukuMapRouteClass {
	NetsukukuMapClass parent_class;
};

struct _NetsukukuMapRoutePrivate {
	NetsukukuAddressManager* _address_manager;
	NetsukukuGNodeID** _id_myself;
	gint _id_myself_length1;
	gint __id_myself_size_;
	GeeHashMap* checking_gid;
	GeeArrayList* check_gid_handle;
};

typedef NetsukukuNIC* (*NetsukukuCreateNicDelegate) (const gchar* nic_name, void* user_data);
struct _NetsukukuAddressManager {
	GObject parent_instance;
	NetsukukuAddressManagerPrivate * priv;
	GeeArrayList* auxiliary_addresses;
	gint levels;
	gint gsize;
	NetsukukuKeyPair* keypair;
	NetsukukuCreateNicDelegate create_new_nic;
	gpointer create_new_nic_target;
	GDestroyNotify create_new_nic_target_destroy_notify;
	gboolean operative;
	gboolean is_mature;
	NetsukukuIncomingNodes* incoming_nodes;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	NetsukukuEtp* etp;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	NetsukukuCoordinator* coordinator;
	NetsukukuCounter* counter;
	NetsukukuAndna* andna;
	NetsukukuTunnelManager* tunnel_manager;
	NetsukukuHook* hook;
	NetsukukuBorderNodesManager* border_nodes_manager;
	NetsukukuMigrationManager* migration_manager;
	NetsukukuIGSManagerDispatcher* igs_manager;
	GeeArrayList* nics;
	GeeHashMap* neighbour_managers;
};

struct _NetsukukuAddressManagerClass {
	GObjectClass parent_class;
	void (*_get_data_from_hook_information) (NetsukukuAddressManager* self, gint levels, gint gsize, NetsukukuHookInformation* hook_information, NetsukukuNIP** nip, NetsukukuGNodeID*** id_myself, int* id_myself_length1);
	NetsukukuIncomingNodes* (*create_IncomingNodes) (NetsukukuAddressManager* self);
	NetsukukuMapRoute* (*create_MapRoute) (NetsukukuAddressManager* self, gint levels, gint gsize, NetsukukuNIP* nip, NetsukukuGNodeID** id_myself, int id_myself_length1);
	NetsukukuAggregatedNeighbourManager* (*create_AggregatedNeighbourManager) (NetsukukuAddressManager* self);
	NetsukukuEtp* (*create_Etp) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute);
	NetsukukuPeerToPeerAll* (*create_PeerToPeerAll) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute);
	NetsukukuCoordinator* (*create_Coordinator) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuCounter* (*create_Counter) (NetsukukuAddressManager* self, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuAndna* (*create_Andna) (NetsukukuAddressManager* self, NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuTunnelManager* (*create_TunnelManager) (NetsukukuAddressManager* self, const gchar* ipstr);
	NetsukukuHook* (*create_Hook) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute);
	NetsukukuBorderNodesManager* (*create_BorderNodesManager) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager);
	NetsukukuMigrationManager* (*create_MigrationManager) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager);
	gboolean (*do_i_act_as_gateway_for) (NetsukukuAddressManager* self, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid);
	gboolean (*do_i_act_as_gateway_for_local) (NetsukukuAddressManager* self);
	gboolean (*do_i_participate_in_routing_tables) (NetsukukuAddressManager* self);
	gboolean (*get_is_auxiliary) (NetsukukuAddressManager* self);
	gboolean (*get_is_autonomous) (NetsukukuAddressManager* self);
};


static gpointer netsukuku_route_parent_class = NULL;
static gpointer netsukuku_clone_route_parent_class = NULL;
static gpointer netsukuku_route_node_parent_class = NULL;
static gpointer netsukuku_gid_checker_parent_class = NULL;
static gpointer netsukuku_map_route_parent_class = NULL;
static NetsukukuIMapRouteIface* netsukuku_map_route_netsukuku_imap_route_parent_iface = NULL;

GType netsukuku_route_get_type (void) G_GNUC_CONST;
GType netsukuku_route_node_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_ROUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_ROUTE, NetsukukuRoutePrivate))
enum  {
	NETSUKUKU_ROUTE_DUMMY_PROPERTY,
	NETSUKUKU_ROUTE_REM,
	NETSUKUKU_ROUTE_FIRST_HOP,
	NETSUKUKU_ROUTE_DEST,
	NETSUKUKU_ROUTE_HOPS_WITH_GW
};
NetsukukuRoute* netsukuku_route_new (NetsukukuAggregatedNeighbour* gw, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid, NetsukukuRouteNode* routenode);
NetsukukuRoute* netsukuku_route_construct (GType object_type, NetsukukuAggregatedNeighbour* gw, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid, NetsukukuRouteNode* routenode);
gint netsukuku_route_compare_func (NetsukukuRoute* a, NetsukukuRoute* b);
static gint netsukuku_route_compare_to (NetsukukuRoute* self, NetsukukuRoute* other);
NetsukukuREM* netsukuku_route_get_rem (NetsukukuRoute* self);
gboolean netsukuku_route_equal_func_in_routenode (NetsukukuRoute* a, NetsukukuRoute* b);
gboolean netsukuku_route_contains (NetsukukuRoute* self, NetsukukuHCoord* hop);
NetsukukuHCoord* netsukuku_route_get_dest (NetsukukuRoute* self);
NetsukukuHCoord* netsukuku_route_get_first_hop (NetsukukuRoute* self);
NetsukukuREM* netsukuku_route_rem_modify (NetsukukuRoute* self, NetsukukuREM* newrem_at_gw, GeeList* new_hops, NetsukukuGNodeID* new_gid);
GType netsukuku_clone_route_get_type (void) G_GNUC_CONST;
NetsukukuCloneRoute* netsukuku_route_clone (NetsukukuRoute* self);
NetsukukuCloneRoute* netsukuku_clone_route_new (NetsukukuRoute* route);
NetsukukuCloneRoute* netsukuku_clone_route_construct (GType object_type, NetsukukuRoute* route);
NetsukukuREM* netsukuku_aggregated_neighbour_get_rem (NetsukukuAggregatedNeighbour* self);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
NetsukukuHCoord* netsukuku_map_nip_to_lvlid (NetsukukuMap* self, NetsukukuPartialNIP* nip);
GeeList* netsukuku_route_get_hops_with_gw (NetsukukuRoute* self);
static gboolean _netsukuku_hcoord_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void netsukuku_route_finalize (GObject* obj);
static void _vala_netsukuku_route_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	NETSUKUKU_CLONE_ROUTE_DUMMY_PROPERTY
};
const gchar* netsukuku_aggregated_neighbour_get_dev (NetsukukuAggregatedNeighbour* self);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
gboolean netsukuku_clone_route_equal_func (NetsukukuCloneRoute* a, NetsukukuCloneRoute* b);
guint netsukuku_clone_route_hash_func (NetsukukuCloneRoute* a);
gchar* netsukuku_clone_route_to_string (NetsukukuCloneRoute* self);
gint netsukuku_clone_route_compare_func (NetsukukuCloneRoute* a, NetsukukuCloneRoute* b);
gint netsukuku_clone_route_compare_to (NetsukukuCloneRoute* self, NetsukukuCloneRoute* other);
gboolean netsukuku_clone_route_contains (NetsukukuCloneRoute* self, NetsukukuHCoord* hop);
gboolean netsukuku_clone_route_contains_nip (NetsukukuCloneRoute* self, NetsukukuNIP* nip);
NetsukukuHCoord* netsukuku_clone_route_nip_to_lvlid (NetsukukuCloneRoute* self, NetsukukuNIP* nip);
NetsukukuPartialNIP* netsukuku_clone_route_lvlid_to_nip (NetsukukuCloneRoute* self, NetsukukuHCoord* lvlid);
static void netsukuku_clone_route_finalize (GObject* obj);
enum  {
	NETSUKUKU_ROUTE_NODE_DUMMY_PROPERTY
};
static void netsukuku_route_node_real_initialize (NetsukukuDataClass* base, GObject* map, gint lvl, gint pos, gboolean its_me);
static gboolean _netsukuku_route_equal_func_in_routenode_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuRoute* netsukuku_route_node_route_get_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* gw);
void netsukuku_route_node_update_route_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* nr, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid);
void netsukuku_route_node_sort (NetsukukuRouteNode* self);
gint netsukuku_route_node_route_del_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* gw);
static gint netsukuku_route_node_reverse_compare_func (NetsukukuRoute* a, NetsukukuRoute* b);
static gint _netsukuku_route_node_reverse_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
gboolean netsukuku_route_node_is_empty (NetsukukuRouteNode* self);
static gboolean netsukuku_route_node_real_is_free (NetsukukuDataClass* base);
NetsukukuGNodeID* netsukuku_route_node_get_eldest_gid (NetsukukuRouteNode* self);
GeeList* netsukuku_route_node_all_valid_routes (NetsukukuRouteNode* self);
gint netsukuku_route_node_nroutes (NetsukukuRouteNode* self);
NetsukukuRoute* netsukuku_route_node_best_route (NetsukukuRouteNode* self);
NetsukukuRoute* netsukuku_route_node_best_route_without (NetsukukuRouteNode* self, NetsukukuHCoord* hop);
NetsukukuRouteNode* netsukuku_route_node_new (void);
NetsukukuRouteNode* netsukuku_route_node_construct (GType object_type);
static void netsukuku_route_node_finalize (GObject* obj);
GType netsukuku_gid_checker_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_GID_CHECKER_DUMMY_PROPERTY
};
NetsukukuGIDChecker* netsukuku_gid_checker_new (void);
NetsukukuGIDChecker* netsukuku_gid_checker_construct (GType object_type);
static void netsukuku_gid_checker_finalize (GObject* obj);
GType netsukuku_struct_helper_maproute_periodically_check_gid_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_MapRoute_periodically_check_gid* netsukuku_struct_helper_maproute_periodically_check_gid_dup (const Netsukukustruct_helper_MapRoute_periodically_check_gid* self);
void netsukuku_struct_helper_maproute_periodically_check_gid_free (Netsukukustruct_helper_MapRoute_periodically_check_gid* self);
void netsukuku_struct_helper_maproute_periodically_check_gid_copy (const Netsukukustruct_helper_MapRoute_periodically_check_gid* self, Netsukukustruct_helper_MapRoute_periodically_check_gid* dest);
void netsukuku_struct_helper_maproute_periodically_check_gid_destroy (Netsukukustruct_helper_MapRoute_periodically_check_gid* self);
GType netsukuku_address_manager_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_MAP_ROUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoutePrivate))
enum  {
	NETSUKUKU_MAP_ROUTE_DUMMY_PROPERTY,
	NETSUKUKU_MAP_ROUTE_ADDRESS_MANAGER
};
NetsukukuMapRoute* netsukuku_map_route_new (gint levels, gint gsize, NetsukukuNIP* me, NetsukukuGNodeID** id_myself, int id_myself_length1, NetsukukuAddressManager* address_manager);
NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, gint levels, gint gsize, NetsukukuNIP* me, NetsukukuGNodeID** id_myself, int id_myself_length1, NetsukukuAddressManager* address_manager);
NetsukukuMap* netsukuku_map_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
NetsukukuMap* netsukuku_map_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
static void netsukuku_map_route_set_id_myself (NetsukukuMapRoute* self, NetsukukuGNodeID** value, int value_length1);
static void netsukuku_map_route_set_address_manager (NetsukukuMapRoute* self, NetsukukuAddressManager* value);
static void netsukuku_map_route_real_stop_operations (NetsukukuMap* base);
void netsukuku_map_stop_operations (NetsukukuMap* self);
gint netsukuku_map_get_levels (NetsukukuMap* self);
static GeeList* netsukuku_map_route_real_report_routes (NetsukukuIMapRoute* base, GError** error);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
gpointer netsukuku_map_node_get (NetsukukuMap* self, gint lvl, gint pos);
static GeeList* netsukuku_map_route_real_report_gid_list (NetsukukuIMapRoute* base, GError** error);
NetsukukuGNodeID** netsukuku_map_route_get_gid_list (NetsukukuMapRoute* self, int* result_length1);
static NetsukukuInfoNode* netsukuku_map_route_real_report_yourself (NetsukukuIMapRoute* base, GError** error);
NetsukukuNetworkID* netsukuku_map_route_get_main_netid (NetsukukuMapRoute* self);
NetsukukuAddressManager* netsukuku_map_route_get_address_manager (NetsukukuMapRoute* self);
GType netsukuku_hook_information_get_type (void) G_GNUC_CONST;
GType netsukuku_incoming_nodes_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_etp_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_coordinator_get_type (void) G_GNUC_CONST;
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_tunnel_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_hook_get_type (void) G_GNUC_CONST;
GType netsukuku_border_nodes_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_migration_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_nic_get_type (void) G_GNUC_CONST;
GType netsukuku_igs_manager_dispatcher_get_type (void) G_GNUC_CONST;
GType netsukuku_network_interface_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
NetsukukuGNodeID** netsukuku_map_route_get_id_myself (NetsukukuMapRoute* self, int* result_length1);
NetsukukuGNodeID** netsukuku_map_route_get_gid_uppermost_list (NetsukukuMapRoute* self, gint level_of_gnode, int* result_length1);
NetsukukuGNodeID* netsukuku_map_route_get_gid_at_level (NetsukukuMapRoute* self, gint lvl);
gint netsukuku_map_route_get_my_id (NetsukukuMapRoute* self);
static gboolean _netsukuku_gnode_id_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void _vala_array_add11 (NetsukukuRouteNode*** array, int* length, int* size, NetsukukuRouteNode* value);
gboolean netsukuku_map_route_is_in_my_network (NetsukukuMapRoute* self, NetsukukuNetworkID* netid);
gboolean netsukuku_map_route_is_preferred_network (NetsukukuMapRoute* self, NetsukukuNetworkID* netid);
void netsukuku_map_route_evaluate_changed_netid (NetsukukuMapRoute* self);
void netsukuku_map_route_handle_check_gid (NetsukukuMapRoute* self, gint level);
void netsukuku_map_route_periodically_check_gid (NetsukukuMapRoute* self, gint level);
static void netsukuku_map_route_impl_periodically_check_gid (NetsukukuMapRoute* self, gint level, GError** error);
void netsukuku_map_route_send_request_gid (NetsukukuMapRoute* self, gint level, GError** error);
void netsukuku_log_warn (const gchar* msg);
static void* netsukuku_map_route_helper_periodically_check_gid (void* v, GError** error);
NetsukukuAddressManagerFakeRmt* netsukuku_address_manager_get_broadcast_client (NetsukukuAddressManager* self);
static void netsukuku_map_route_real_request_gid (NetsukukuIMapRoute* base, gint request_id, NetsukukuNetworkID* gnetid, NetsukukuPartialNIP* gprefix, GError** error);
void netsukuku_map_route_send_answer_gid (NetsukukuMapRoute* self, GeeList* queue, NetsukukuGNodeID* actual_gid, GError** error);
static void netsukuku_map_route_real_answer_gid (NetsukukuIMapRoute* base, NetsukukuNIP* answering_nip, gint request_id, NetsukukuGNodeID* actual_gid, GError** error);
GeeList* netsukuku_aggregated_neighbour_manager_neighbour_list (NetsukukuAggregatedNeighbourManager* self, gboolean* in_my_network, NetsukukuNetworkID* with_this_netid);
gboolean netsukuku_aggregated_neighbour_equal_func (NetsukukuAggregatedNeighbour* a, NetsukukuAggregatedNeighbour* b);
static gboolean _netsukuku_aggregated_neighbour_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static NetsukukuREM* netsukuku_map_route_real_worst_internal_bestrem (NetsukukuIMapRoute* base, gint level_of_gnode, GError** error);
gint* netsukuku_map_route_get_distance (NetsukukuMapRoute* self, gint lvl, gint pos);
static gint* _int_dup (gint* self);
void netsukuku_map_route_update_route_by_gw (NetsukukuMapRoute* self, NetsukukuHCoord* dest, NetsukukuAggregatedNeighbour* nr, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid);
void netsukuku_map_node_remove (NetsukukuMap* self, gint lvl, gint pos);
void netsukuku_map_check_node (NetsukukuMap* self, gint lvl, gint pos);
void _netsukuku_map_route_emit_routes_updated (NetsukukuMapRoute* self, gint lvl, gint dst);
void netsukuku_map_route_route_del_by_gw (NetsukukuMapRoute* self, gint lvl, gint dst, NetsukukuAggregatedNeighbour* gw);
void netsukuku_map_route_route_signal_rem_changed (NetsukukuMapRoute* self, gint lvl, gint dst);
void netsukuku_map_route_delete_routes_via_neighbour (NetsukukuMapRoute* self, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuPartialNIP* netsukuku_map_route_choose_between (NetsukukuMapRoute* self, GeeList* choose_from);
NetsukukuPartialNIP* netsukuku_map_route_choose_fast (NetsukukuMapRoute* self, GeeList* choose_from);
static NetsukukuGNodeID** _vala_array_dup7 (NetsukukuGNodeID** self, int length);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
gint netsukuku_map_free_nodes_nb (NetsukukuMap* self, gint lvl);
static void netsukuku_map_route_finalize (GObject* obj);
static void _vala_netsukuku_map_route_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_map_route_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NetsukukuRoute* netsukuku_route_construct (GType object_type, NetsukukuAggregatedNeighbour* gw, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid, NetsukukuRouteNode* routenode) {
	NetsukukuRoute * self = NULL;
	NetsukukuAggregatedNeighbour* _tmp0_;
	NetsukukuAggregatedNeighbour* _tmp1_;
	NetsukukuREM* _tmp2_;
	NetsukukuREM* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	NetsukukuGNodeID* _tmp6_;
	NetsukukuGNodeID* _tmp7_;
	NetsukukuRouteNode* _tmp8_;
	g_return_val_if_fail (gw != NULL, NULL);
	g_return_val_if_fail (rem_at_gw != NULL, NULL);
	g_return_val_if_fail (hops != NULL, NULL);
	g_return_val_if_fail (gid != NULL, NULL);
	g_return_val_if_fail (routenode != NULL, NULL);
	self = (NetsukukuRoute*) g_object_new (object_type, NULL);
	_tmp0_ = gw;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->gw);
	self->gw = _tmp1_;
	_tmp2_ = rem_at_gw;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->rem_at_gw);
	self->rem_at_gw = _tmp3_;
	_tmp4_ = hops;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->hops);
	self->hops = _tmp5_;
	_tmp6_ = gid;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->gid);
	self->gid = _tmp7_;
	_tmp8_ = routenode;
	self->routenode = _tmp8_;
	return self;
}


NetsukukuRoute* netsukuku_route_new (NetsukukuAggregatedNeighbour* gw, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid, NetsukukuRouteNode* routenode) {
	return netsukuku_route_construct (NETSUKUKU_TYPE_ROUTE, gw, rem_at_gw, hops, gid, routenode);
}


/** The route 'this' is better (greater) than 'other' if its rem is better
          */
gint netsukuku_route_compare_func (NetsukukuRoute* a, NetsukukuRoute* b) {
	gint result = 0;
	NetsukukuRoute* _tmp0_;
	NetsukukuRoute* _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	_tmp2_ = netsukuku_route_compare_to (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gint netsukuku_route_compare_to (NetsukukuRoute* self, NetsukukuRoute* other) {
	gint result = 0;
	NetsukukuREM* _tmp0_;
	NetsukukuREM* _tmp1_;
	NetsukukuRoute* _tmp2_;
	NetsukukuREM* _tmp3_;
	NetsukukuREM* _tmp4_;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = netsukuku_route_get_rem (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = other;
	_tmp3_ = netsukuku_route_get_rem (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_rem_compare_to (_tmp1_, _tmp4_);
	result = _tmp5_;
	return result;
}


/** Used to test between 2 routes in the same RouteNode
          * (e.g. to remove a route from the collection of routes)
          * In such a comparison the only member we can check is the gateway.
          */
gboolean netsukuku_route_equal_func_in_routenode (NetsukukuRoute* a, NetsukukuRoute* b) {
	gboolean result = FALSE;
	NetsukukuRoute* _tmp0_;
	NetsukukuRoute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	NetsukukuRoute* _tmp3_;
	gboolean _tmp5_;
	NetsukukuRoute* _tmp6_;
	NetsukukuAggregatedNeighbour* _tmp7_;
	NetsukukuRoute* _tmp8_;
	NetsukukuAggregatedNeighbour* _tmp9_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = b;
	if (_tmp0_ == _tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = a;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		NetsukukuRoute* _tmp4_;
		_tmp4_ = b;
		_tmp2_ = _tmp4_ == NULL;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = a;
	_tmp7_ = _tmp6_->gw;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->gw;
	result = _tmp7_ == _tmp9_;
	return result;
}


/** The path contains a specified hop?
          */
gboolean netsukuku_route_contains (NetsukukuRoute* self, NetsukukuHCoord* hop) {
	gboolean result = FALSE;
	NetsukukuHCoord* _tmp0_;
	NetsukukuHCoord* _tmp1_;
	NetsukukuHCoord* _tmp2_;
	gboolean _tmp3_ = FALSE;
	NetsukukuHCoord* _tmp4_;
	NetsukukuHCoord* _tmp5_;
	NetsukukuHCoord* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeList* _tmp8_;
	NetsukukuHCoord* _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hop != NULL, FALSE);
	_tmp0_ = hop;
	_tmp1_ = netsukuku_route_get_dest (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_hcoord_is_equal (_tmp0_, _tmp2_);
	if (_tmp3_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = hop;
	_tmp5_ = netsukuku_route_get_first_hop (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = netsukuku_hcoord_is_equal (_tmp4_, _tmp6_);
	if (_tmp7_) {
		result = TRUE;
		return result;
	}
	_tmp8_ = self->hops;
	_tmp9_ = hop;
	_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


NetsukukuREM* netsukuku_route_rem_modify (NetsukukuRoute* self, NetsukukuREM* newrem_at_gw, GeeList* new_hops, NetsukukuGNodeID* new_gid) {
	NetsukukuREM* result = NULL;
	NetsukukuREM* _tmp0_;
	NetsukukuREM* _tmp1_;
	NetsukukuREM* oldrem_at_gw;
	NetsukukuREM* _tmp2_;
	NetsukukuREM* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	NetsukukuGNodeID* _tmp6_;
	NetsukukuGNodeID* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (newrem_at_gw != NULL, NULL);
	g_return_val_if_fail (new_hops != NULL, NULL);
	g_return_val_if_fail (new_gid != NULL, NULL);
	_tmp0_ = self->rem_at_gw;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	oldrem_at_gw = _tmp1_;
	_tmp2_ = newrem_at_gw;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->rem_at_gw);
	self->rem_at_gw = _tmp3_;
	_tmp4_ = new_hops;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->hops);
	self->hops = _tmp5_;
	_tmp6_ = new_gid;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->gid);
	self->gid = _tmp7_;
	result = oldrem_at_gw;
	return result;
}


/** Returns an instance of CloneRoute that is a copy of the current
          * status of this Route. If this Route changes in some way, the cloned
          * instance will not.
          * The class CloneRoute has some of the methods that Route has,
          * those needed to perform the task of choosing the settings to
          * impose in the kernel routing tables.
          */
NetsukukuCloneRoute* netsukuku_route_clone (NetsukukuRoute* self) {
	NetsukukuCloneRoute* result = NULL;
	NetsukukuCloneRoute* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_clone_route_new (self);
	result = _tmp0_;
	return result;
}


NetsukukuREM* netsukuku_route_get_rem (NetsukukuRoute* self) {
	NetsukukuREM* result;
	NetsukukuREM* _tmp0_;
	NetsukukuAggregatedNeighbour* _tmp1_;
	NetsukukuREM* _tmp2_;
	NetsukukuREM* _tmp3_;
	NetsukukuREM* _tmp4_ = NULL;
	NetsukukuREM* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->rem_at_gw;
	_tmp1_ = self->gw;
	_tmp2_ = netsukuku_aggregated_neighbour_get_rem (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = netsukuku_rem_add_segment (_tmp0_, _tmp3_);
	_g_object_unref0 (self->priv->_rem);
	self->priv->_rem = _tmp4_;
	_tmp5_ = self->priv->_rem;
	result = _tmp5_;
	return result;
}


NetsukukuHCoord* netsukuku_route_get_first_hop (NetsukukuRoute* self) {
	NetsukukuHCoord* result;
	NetsukukuRouteNode* _tmp0_;
	NetsukukuMap* _tmp1_;
	NetsukukuAggregatedNeighbour* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuHCoord* _tmp4_ = NULL;
	NetsukukuHCoord* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->routenode;
	_tmp1_ = _tmp0_->maproute;
	_tmp2_ = self->gw;
	_tmp3_ = _tmp2_->nip;
	_tmp4_ = netsukuku_map_nip_to_lvlid (_tmp1_, (NetsukukuPartialNIP*) _tmp3_);
	_g_object_unref0 (self->priv->_first_hop);
	self->priv->_first_hop = _tmp4_;
	_tmp5_ = self->priv->_first_hop;
	result = _tmp5_;
	return result;
}


NetsukukuHCoord* netsukuku_route_get_dest (NetsukukuRoute* self) {
	NetsukukuHCoord* result;
	NetsukukuRouteNode* _tmp0_;
	gint _tmp1_;
	NetsukukuRouteNode* _tmp2_;
	gint _tmp3_;
	NetsukukuHCoord* _tmp4_;
	NetsukukuHCoord* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->routenode;
	_tmp1_ = _tmp0_->lvl;
	_tmp2_ = self->routenode;
	_tmp3_ = _tmp2_->pos;
	_tmp4_ = netsukuku_hcoord_new (_tmp1_, _tmp3_);
	_g_object_unref0 (self->priv->_dest);
	self->priv->_dest = _tmp4_;
	_tmp5_ = self->priv->_dest;
	result = _tmp5_;
	return result;
}


static gboolean _netsukuku_hcoord_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_hcoord_equal_func (a, b);
	return result;
}


GeeList* netsukuku_route_get_hops_with_gw (NetsukukuRoute* self) {
	GeeList* result;
	GeeArrayList* _tmp0_;
	NetsukukuHCoord* _tmp1_;
	NetsukukuHCoord* _tmp2_;
	NetsukukuHCoord* _tmp3_;
	NetsukukuHCoord* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeList* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_hops_with_gw);
	self->priv->_hops_with_gw = (GeeList*) _tmp0_;
	_tmp1_ = netsukuku_route_get_first_hop (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_route_get_dest (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_hcoord_is_equal (_tmp2_, _tmp4_);
	if (!_tmp5_) {
		GeeList* _tmp6_;
		NetsukukuHCoord* _tmp7_;
		NetsukukuHCoord* _tmp8_;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		_tmp6_ = self->priv->_hops_with_gw;
		_tmp7_ = netsukuku_route_get_first_hop (self);
		_tmp8_ = _tmp7_;
		gee_collection_add ((GeeCollection*) _tmp6_, _tmp8_);
		_tmp9_ = self->priv->_hops_with_gw;
		_tmp10_ = self->hops;
		gee_collection_add_all ((GeeCollection*) _tmp9_, (GeeCollection*) _tmp10_);
	}
	_tmp11_ = self->priv->_hops_with_gw;
	result = _tmp11_;
	return result;
}


static void netsukuku_route_class_init (NetsukukuRouteClass * klass) {
	netsukuku_route_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuRoutePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_route_get_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_route_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_ROUTE_REM, g_param_spec_object ("rem", "rem", "rem", NETSUKUKU_TYPE_REM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_ROUTE_FIRST_HOP, g_param_spec_object ("first-hop", "first-hop", "first-hop", NETSUKUKU_TYPE_HCOORD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_ROUTE_DEST, g_param_spec_object ("dest", "dest", "dest", NETSUKUKU_TYPE_HCOORD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_ROUTE_HOPS_WITH_GW, g_param_spec_object ("hops-with-gw", "hops-with-gw", "hops-with-gw", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_route_instance_init (NetsukukuRoute * self) {
	self->priv = NETSUKUKU_ROUTE_GET_PRIVATE (self);
}


static void netsukuku_route_finalize (GObject* obj) {
	NetsukukuRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ROUTE, NetsukukuRoute);
	_g_object_unref0 (self->gw);
	_g_object_unref0 (self->rem_at_gw);
	_g_object_unref0 (self->hops);
	_g_object_unref0 (self->gid);
	_g_object_unref0 (self->priv->_rem);
	_g_object_unref0 (self->priv->_first_hop);
	_g_object_unref0 (self->priv->_dest);
	_g_object_unref0 (self->priv->_hops_with_gw);
	G_OBJECT_CLASS (netsukuku_route_parent_class)->finalize (obj);
}


/** A path to a known destination.
      *
      * An instance of this class represents a path to a known
      * destination d.
      * The instance members are:
      * `gw': the gateway of the route. Our next hop. It is an instance of the
      *       class AggregatedNeighbour.
      * `rem_at_gw': a REM (Route Efficience Measure) of the path from the 
      *       gateway to the destination d. It is an instance of the class 
      *       REM or a derivative.
      * `hops': a List of HCoord of the hops represented by this
      *       path from the gateway gw to the destination d.
      *       gw and d are not included.
      * `gid': a instance of GNodeid, it is the ID of the gnode that this class
      *       represents, as it is reported by this path.
      */
GType netsukuku_route_get_type (void) {
	static volatile gsize netsukuku_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRoute), 0, (GInstanceInitFunc) netsukuku_route_instance_init, NULL };
		GType netsukuku_route_type_id;
		netsukuku_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_route_type_id__volatile, netsukuku_route_type_id);
	}
	return netsukuku_route_type_id__volatile;
}


static void _vala_netsukuku_route_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_ROUTE, NetsukukuRoute);
	switch (property_id) {
		case NETSUKUKU_ROUTE_REM:
		g_value_set_object (value, netsukuku_route_get_rem (self));
		break;
		case NETSUKUKU_ROUTE_FIRST_HOP:
		g_value_set_object (value, netsukuku_route_get_first_hop (self));
		break;
		case NETSUKUKU_ROUTE_DEST:
		g_value_set_object (value, netsukuku_route_get_dest (self));
		break;
		case NETSUKUKU_ROUTE_HOPS_WITH_GW:
		g_value_set_object (value, netsukuku_route_get_hops_with_gw (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


NetsukukuCloneRoute* netsukuku_clone_route_construct (GType object_type, NetsukukuRoute* route) {
	NetsukukuCloneRoute * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (route != NULL, NULL);
	self = (NetsukukuCloneRoute*) g_object_new (object_type, NULL);
	{
		NetsukukuRoute* _tmp0_;
		NetsukukuAggregatedNeighbour* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		NetsukukuRoute* _tmp5_;
		NetsukukuAggregatedNeighbour* _tmp6_;
		NetsukukuREM* _tmp7_;
		NetsukukuREM* _tmp8_;
		NetsukukuREM* _tmp9_;
		NetsukukuRoute* _tmp10_;
		NetsukukuAggregatedNeighbour* _tmp11_;
		gint _tmp12_;
		NetsukukuRoute* _tmp13_;
		NetsukukuAggregatedNeighbour* _tmp14_;
		gint _tmp15_;
		NetsukukuRoute* _tmp16_;
		NetsukukuAggregatedNeighbour* _tmp17_;
		NetsukukuNIP* _tmp18_;
		gchar* _tmp19_ = NULL;
		NetsukukuRoute* _tmp20_;
		NetsukukuAggregatedNeighbour* _tmp21_;
		NetsukukuNIP* _tmp22_;
		gint _tmp23_ = 0;
		guchar* _tmp24_ = NULL;
		guchar* _tmp25_;
		gint _tmp25__length1;
		zcdISerializable* _tmp26_ = NULL;
		zcdISerializable* _tmp27_;
		zcdISerializable* _tmp28_;
		NetsukukuRoute* _tmp29_;
		NetsukukuREM* _tmp30_;
		NetsukukuREM* _tmp31_;
		gint _tmp32_ = 0;
		guchar* _tmp33_ = NULL;
		guchar* _tmp34_;
		gint _tmp34__length1;
		zcdISerializable* _tmp35_ = NULL;
		zcdISerializable* _tmp36_;
		zcdISerializable* _tmp37_;
		NetsukukuRoute* _tmp38_;
		NetsukukuREM* _tmp39_;
		gint _tmp40_ = 0;
		guchar* _tmp41_ = NULL;
		guchar* _tmp42_;
		gint _tmp42__length1;
		zcdISerializable* _tmp43_ = NULL;
		zcdISerializable* _tmp44_;
		zcdISerializable* _tmp45_;
		NetsukukuRoute* _tmp46_;
		NetsukukuHCoord* _tmp47_;
		NetsukukuHCoord* _tmp48_;
		gint _tmp49_ = 0;
		guchar* _tmp50_ = NULL;
		guchar* _tmp51_;
		gint _tmp51__length1;
		zcdISerializable* _tmp52_ = NULL;
		zcdISerializable* _tmp53_;
		zcdISerializable* _tmp54_;
		NetsukukuRoute* _tmp55_;
		NetsukukuHCoord* _tmp56_;
		NetsukukuHCoord* _tmp57_;
		gint _tmp58_ = 0;
		guchar* _tmp59_ = NULL;
		guchar* _tmp60_;
		gint _tmp60__length1;
		zcdISerializable* _tmp61_ = NULL;
		zcdISerializable* _tmp62_;
		zcdISerializable* _tmp63_;
		GeeArrayList* _tmp64_;
		GeeArrayList* _tmp86_;
		NetsukukuRoute* _tmp109_;
		NetsukukuRouteNode* _tmp110_;
		NetsukukuMap* _tmp111_;
		NetsukukuNIP* _tmp112_;
		NetsukukuNIP* _tmp113_;
		NetsukukuNIP* _tmp114_;
		_tmp0_ = route;
		_tmp1_ = _tmp0_->gw;
		_tmp2_ = netsukuku_aggregated_neighbour_get_dev (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->gwdev);
		self->gwdev = _tmp4_;
		_tmp5_ = route;
		_tmp6_ = _tmp5_->gw;
		_tmp7_ = netsukuku_aggregated_neighbour_get_rem (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (self->gwrem);
		self->gwrem = _tmp9_;
		_tmp10_ = route;
		_tmp11_ = _tmp10_->gw;
		_tmp12_ = _tmp11_->levels;
		_tmp13_ = route;
		_tmp14_ = _tmp13_->gw;
		_tmp15_ = _tmp14_->gsize;
		_tmp16_ = route;
		_tmp17_ = _tmp16_->gw;
		_tmp18_ = _tmp17_->nip;
		_tmp19_ = netsukuku_nip_to_str (_tmp12_, _tmp15_, _tmp18_);
		_g_free0 (self->gwipstr);
		self->gwipstr = _tmp19_;
		_tmp20_ = route;
		_tmp21_ = _tmp20_->gw;
		_tmp22_ = _tmp21_->nip;
		_tmp24_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp22_, &_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp25__length1 = _tmp23_;
		_tmp26_ = zcd_iserializable_deserialize (_tmp25_, _tmp23_, &_inner_error_);
		_tmp27_ = _tmp26_;
		_tmp25_ = (g_free (_tmp25_), NULL);
		_tmp28_ = _tmp27_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				goto __catch51_zcd_serializer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->gwnip);
		self->gwnip = G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, NETSUKUKU_TYPE_NIP, NetsukukuNIP);
		_tmp29_ = route;
		_tmp30_ = netsukuku_route_get_rem (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp33_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp31_, &_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp34__length1 = _tmp32_;
		_tmp35_ = zcd_iserializable_deserialize (_tmp34_, _tmp32_, &_inner_error_);
		_tmp36_ = _tmp35_;
		_tmp34_ = (g_free (_tmp34_), NULL);
		_tmp37_ = _tmp36_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				goto __catch51_zcd_serializer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->rem);
		self->rem = G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, NETSUKUKU_TYPE_REM, NetsukukuREM);
		_tmp38_ = route;
		_tmp39_ = _tmp38_->rem_at_gw;
		_tmp41_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp39_, &_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp42__length1 = _tmp40_;
		_tmp43_ = zcd_iserializable_deserialize (_tmp42_, _tmp40_, &_inner_error_);
		_tmp44_ = _tmp43_;
		_tmp42_ = (g_free (_tmp42_), NULL);
		_tmp45_ = _tmp44_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				goto __catch51_zcd_serializer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->rem_at_gw);
		self->rem_at_gw = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, NETSUKUKU_TYPE_REM, NetsukukuREM);
		_tmp46_ = route;
		_tmp47_ = netsukuku_route_get_dest (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp50_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp48_, &_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp51__length1 = _tmp49_;
		_tmp52_ = zcd_iserializable_deserialize (_tmp51_, _tmp49_, &_inner_error_);
		_tmp53_ = _tmp52_;
		_tmp51_ = (g_free (_tmp51_), NULL);
		_tmp54_ = _tmp53_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				goto __catch51_zcd_serializer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->dest);
		self->dest = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, NETSUKUKU_TYPE_HCOORD, NetsukukuHCoord);
		_tmp55_ = route;
		_tmp56_ = netsukuku_route_get_first_hop (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp59_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp57_, &_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp60__length1 = _tmp58_;
		_tmp61_ = zcd_iserializable_deserialize (_tmp60_, _tmp58_, &_inner_error_);
		_tmp62_ = _tmp61_;
		_tmp60_ = (g_free (_tmp60_), NULL);
		_tmp63_ = _tmp62_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				goto __catch51_zcd_serializer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->first_hop);
		self->first_hop = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, NETSUKUKU_TYPE_HCOORD, NetsukukuHCoord);
		_tmp64_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
		_g_object_unref0 (self->hops);
		self->hops = (GeeList*) _tmp64_;
		{
			NetsukukuRoute* _tmp65_;
			GeeList* _tmp66_;
			GeeList* _tmp67_;
			GeeList* _hop_list;
			GeeList* _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _hop_size;
			gint _hop_index;
			_tmp65_ = route;
			_tmp66_ = _tmp65_->hops;
			_tmp67_ = _g_object_ref0 (_tmp66_);
			_hop_list = _tmp67_;
			_tmp68_ = _hop_list;
			_tmp69_ = gee_collection_get_size ((GeeCollection*) _tmp68_);
			_tmp70_ = _tmp69_;
			_hop_size = _tmp70_;
			_hop_index = -1;
			while (TRUE) {
				gint _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				GeeList* _tmp74_;
				gint _tmp75_;
				gpointer _tmp76_ = NULL;
				NetsukukuHCoord* hop;
				NetsukukuHCoord* _tmp77_;
				gint _tmp78_ = 0;
				guchar* _tmp79_ = NULL;
				guchar* _tmp80_;
				gint _tmp80__length1;
				zcdISerializable* _tmp81_ = NULL;
				zcdISerializable* _tmp82_;
				zcdISerializable* _tmp83_;
				NetsukukuHCoord* hop2;
				GeeList* _tmp84_;
				NetsukukuHCoord* _tmp85_;
				_tmp71_ = _hop_index;
				_hop_index = _tmp71_ + 1;
				_tmp72_ = _hop_index;
				_tmp73_ = _hop_size;
				if (!(_tmp72_ < _tmp73_)) {
					break;
				}
				_tmp74_ = _hop_list;
				_tmp75_ = _hop_index;
				_tmp76_ = gee_list_get (_tmp74_, _tmp75_);
				hop = (NetsukukuHCoord*) _tmp76_;
				_tmp77_ = hop;
				_tmp79_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp77_, &_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp80__length1 = _tmp78_;
				_tmp81_ = zcd_iserializable_deserialize (_tmp80_, _tmp78_, &_inner_error_);
				_tmp82_ = _tmp81_;
				_tmp80_ = (g_free (_tmp80_), NULL);
				_tmp83_ = _tmp82_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (hop);
					_g_object_unref0 (_hop_list);
					if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
						goto __catch51_zcd_serializer_error;
					}
					_g_object_unref0 (hop);
					_g_object_unref0 (_hop_list);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				hop2 = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, NETSUKUKU_TYPE_HCOORD, NetsukukuHCoord);
				_tmp84_ = self->hops;
				_tmp85_ = hop2;
				gee_collection_add ((GeeCollection*) _tmp84_, _tmp85_);
				_g_object_unref0 (hop2);
				_g_object_unref0 (hop);
			}
			_g_object_unref0 (_hop_list);
		}
		_tmp86_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
		_g_object_unref0 (self->hops_with_gw);
		self->hops_with_gw = (GeeList*) _tmp86_;
		{
			NetsukukuRoute* _tmp87_;
			GeeList* _tmp88_;
			GeeList* _tmp89_;
			GeeList* _tmp90_;
			GeeList* _hop_list;
			GeeList* _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			gint _hop_size;
			gint _hop_index;
			_tmp87_ = route;
			_tmp88_ = netsukuku_route_get_hops_with_gw (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = _g_object_ref0 (_tmp89_);
			_hop_list = _tmp90_;
			_tmp91_ = _hop_list;
			_tmp92_ = gee_collection_get_size ((GeeCollection*) _tmp91_);
			_tmp93_ = _tmp92_;
			_hop_size = _tmp93_;
			_hop_index = -1;
			while (TRUE) {
				gint _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				GeeList* _tmp97_;
				gint _tmp98_;
				gpointer _tmp99_ = NULL;
				NetsukukuHCoord* hop;
				NetsukukuHCoord* _tmp100_;
				gint _tmp101_ = 0;
				guchar* _tmp102_ = NULL;
				guchar* _tmp103_;
				gint _tmp103__length1;
				zcdISerializable* _tmp104_ = NULL;
				zcdISerializable* _tmp105_;
				zcdISerializable* _tmp106_;
				NetsukukuHCoord* hop2;
				GeeList* _tmp107_;
				NetsukukuHCoord* _tmp108_;
				_tmp94_ = _hop_index;
				_hop_index = _tmp94_ + 1;
				_tmp95_ = _hop_index;
				_tmp96_ = _hop_size;
				if (!(_tmp95_ < _tmp96_)) {
					break;
				}
				_tmp97_ = _hop_list;
				_tmp98_ = _hop_index;
				_tmp99_ = gee_list_get (_tmp97_, _tmp98_);
				hop = (NetsukukuHCoord*) _tmp99_;
				_tmp100_ = hop;
				_tmp102_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp100_, &_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp103__length1 = _tmp101_;
				_tmp104_ = zcd_iserializable_deserialize (_tmp103_, _tmp101_, &_inner_error_);
				_tmp105_ = _tmp104_;
				_tmp103_ = (g_free (_tmp103_), NULL);
				_tmp106_ = _tmp105_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (hop);
					_g_object_unref0 (_hop_list);
					if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
						goto __catch51_zcd_serializer_error;
					}
					_g_object_unref0 (hop);
					_g_object_unref0 (_hop_list);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				hop2 = G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, NETSUKUKU_TYPE_HCOORD, NetsukukuHCoord);
				_tmp107_ = self->hops_with_gw;
				_tmp108_ = hop2;
				gee_collection_add ((GeeCollection*) _tmp107_, _tmp108_);
				_g_object_unref0 (hop2);
				_g_object_unref0 (hop);
			}
			_g_object_unref0 (_hop_list);
		}
		_tmp109_ = route;
		_tmp110_ = _tmp109_->routenode;
		_tmp111_ = _tmp110_->maproute;
		_tmp112_ = netsukuku_map_get_me (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = _g_object_ref0 (_tmp113_);
		_g_object_unref0 (self->mymap_me);
		self->mymap_me = _tmp114_;
	}
	goto __finally51;
	__catch51_zcd_serializer_error:
	{
		GError* e = NULL;
		GQuark _tmp115_;
		const gchar* _tmp116_ = NULL;
		gint _tmp117_;
		gchar* _tmp118_ = NULL;
		gchar* _tmp119_;
		const gchar* _tmp120_;
		const gchar* _tmp121_ = NULL;
		gchar* _tmp122_ = NULL;
		gchar* _tmp123_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp115_ = e->domain;
		_tmp116_ = g_quark_to_string (_tmp115_);
		_tmp117_ = e->code;
		_tmp118_ = g_strdup_printf ("%i", _tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = e->message;
		_tmp121_ = string_to_string (_tmp120_);
		_tmp122_ = g_strconcat ("CloneRoute: Caught exception while deserializing members ", _tmp116_, " code ", _tmp119_, ": ", _tmp121_, NULL);
		_tmp123_ = _tmp122_;
		g_error ("maproute.vala:195: %s", _tmp123_);
		_g_free0 (_tmp123_);
		_g_free0 (_tmp119_);
		_g_error_free0 (e);
	}
	__finally51:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


NetsukukuCloneRoute* netsukuku_clone_route_new (NetsukukuRoute* route) {
	return netsukuku_clone_route_construct (NETSUKUKU_TYPE_CLONE_ROUTE, route);
}


gboolean netsukuku_clone_route_equal_func (NetsukukuCloneRoute* a, NetsukukuCloneRoute* b) {
	gboolean result = FALSE;
	NetsukukuCloneRoute* _tmp0_;
	NetsukukuCloneRoute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	NetsukukuCloneRoute* _tmp3_;
	gboolean _tmp5_;
	NetsukukuCloneRoute* _tmp6_;
	NetsukukuHCoord* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	NetsukukuCloneRoute* _tmp10_;
	NetsukukuHCoord* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_;
	NetsukukuCloneRoute* _tmp15_;
	const gchar* _tmp16_;
	NetsukukuCloneRoute* _tmp17_;
	const gchar* _tmp18_;
	NetsukukuCloneRoute* _tmp19_;
	const gchar* _tmp20_;
	NetsukukuCloneRoute* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* a_list;
	gchar* _tmp41_;
	gchar* b_list;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	_tmp0_ = a;
	_tmp1_ = b;
	if (_tmp0_ == _tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = a;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		NetsukukuCloneRoute* _tmp4_;
		_tmp4_ = b;
		_tmp2_ = _tmp4_ == NULL;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = a;
	_tmp7_ = _tmp6_->dest;
	_tmp8_ = netsukuku_hcoord_to_string (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = b;
	_tmp11_ = _tmp10_->dest;
	_tmp12_ = netsukuku_hcoord_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strcmp0 (_tmp9_, _tmp13_) != 0;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp9_);
	if (_tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp15_ = a;
	_tmp16_ = _tmp15_->gwipstr;
	_tmp17_ = b;
	_tmp18_ = _tmp17_->gwipstr;
	if (g_strcmp0 (_tmp16_, _tmp18_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp19_ = a;
	_tmp20_ = _tmp19_->gwdev;
	_tmp21_ = b;
	_tmp22_ = _tmp21_->gwdev;
	if (g_strcmp0 (_tmp20_, _tmp22_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp23_ = g_strdup ("");
	a_list = _tmp23_;
	{
		NetsukukuCloneRoute* _tmp24_;
		GeeList* _tmp25_;
		GeeList* _tmp26_;
		GeeList* _hop_list;
		GeeList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _hop_size;
		gint _hop_index;
		_tmp24_ = a;
		_tmp25_ = _tmp24_->hops;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_hop_list = _tmp26_;
		_tmp27_ = _hop_list;
		_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_hop_size = _tmp29_;
		_hop_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			GeeList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_ = NULL;
			NetsukukuHCoord* hop;
			const gchar* _tmp36_;
			NetsukukuHCoord* _tmp37_;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp30_ = _hop_index;
			_hop_index = _tmp30_ + 1;
			_tmp31_ = _hop_index;
			_tmp32_ = _hop_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _hop_list;
			_tmp34_ = _hop_index;
			_tmp35_ = gee_list_get (_tmp33_, _tmp34_);
			hop = (NetsukukuHCoord*) _tmp35_;
			_tmp36_ = a_list;
			_tmp37_ = hop;
			_tmp38_ = netsukuku_hcoord_to_string (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
			_g_free0 (a_list);
			a_list = _tmp40_;
			_g_free0 (_tmp39_);
			_g_object_unref0 (hop);
		}
		_g_object_unref0 (_hop_list);
	}
	_tmp41_ = g_strdup ("");
	b_list = _tmp41_;
	{
		NetsukukuCloneRoute* _tmp42_;
		GeeList* _tmp43_;
		GeeList* _tmp44_;
		GeeList* _hop_list;
		GeeList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _hop_size;
		gint _hop_index;
		_tmp42_ = b;
		_tmp43_ = _tmp42_->hops;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		_hop_list = _tmp44_;
		_tmp45_ = _hop_list;
		_tmp46_ = gee_collection_get_size ((GeeCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_hop_size = _tmp47_;
		_hop_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			GeeList* _tmp51_;
			gint _tmp52_;
			gpointer _tmp53_ = NULL;
			NetsukukuHCoord* hop;
			const gchar* _tmp54_;
			NetsukukuHCoord* _tmp55_;
			gchar* _tmp56_ = NULL;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp48_ = _hop_index;
			_hop_index = _tmp48_ + 1;
			_tmp49_ = _hop_index;
			_tmp50_ = _hop_size;
			if (!(_tmp49_ < _tmp50_)) {
				break;
			}
			_tmp51_ = _hop_list;
			_tmp52_ = _hop_index;
			_tmp53_ = gee_list_get (_tmp51_, _tmp52_);
			hop = (NetsukukuHCoord*) _tmp53_;
			_tmp54_ = b_list;
			_tmp55_ = hop;
			_tmp56_ = netsukuku_hcoord_to_string (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strconcat (_tmp54_, _tmp57_, NULL);
			_g_free0 (b_list);
			b_list = _tmp58_;
			_g_free0 (_tmp57_);
			_g_object_unref0 (hop);
		}
		_g_object_unref0 (_hop_list);
	}
	_tmp59_ = a_list;
	_tmp60_ = b_list;
	if (g_strcmp0 (_tmp59_, _tmp60_) != 0) {
		result = FALSE;
		_g_free0 (b_list);
		_g_free0 (a_list);
		return result;
	}
	result = TRUE;
	_g_free0 (b_list);
	_g_free0 (a_list);
	return result;
}


guint netsukuku_clone_route_hash_func (NetsukukuCloneRoute* a) {
	guint result = 0U;
	NetsukukuCloneRoute* _tmp0_;
	NetsukukuHCoord* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	NetsukukuCloneRoute* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	NetsukukuCloneRoute* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	guint _tmp12_ = 0U;
	guint _tmp13_;
	g_return_val_if_fail (a != NULL, 0U);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->dest;
	_tmp2_ = netsukuku_hcoord_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = a;
	_tmp5_ = _tmp4_->gwipstr;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = a;
	_tmp8_ = _tmp7_->gwdev;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp3_, "_", _tmp6_, "_", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_str_hash (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp3_);
	result = _tmp13_;
	return result;
}


gchar* netsukuku_clone_route_to_string (NetsukukuCloneRoute* self) {
	gchar* result = NULL;
	NetsukukuHCoord* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	NetsukukuNIP* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	NetsukukuREM* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->dest;
	_tmp1_ = netsukuku_hcoord_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->gwnip;
	_tmp4_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->gwdev;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = self->gwrem;
	_tmp9_ = netsukuku_rem_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("<CloneRoute to ", _tmp2_, " via ", _tmp5_, " dev ", _tmp7_, " rem ", _tmp10_, ">", NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp12_;
	return result;
}


/** The route 'this' is better (greater) than 'other' if its rem is better
          */
gint netsukuku_clone_route_compare_func (NetsukukuCloneRoute* a, NetsukukuCloneRoute* b) {
	gint result = 0;
	NetsukukuCloneRoute* _tmp0_;
	NetsukukuCloneRoute* _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	_tmp2_ = netsukuku_clone_route_compare_to (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gint netsukuku_clone_route_compare_to (NetsukukuCloneRoute* self, NetsukukuCloneRoute* other) {
	gint result = 0;
	NetsukukuREM* _tmp0_;
	NetsukukuCloneRoute* _tmp1_;
	NetsukukuREM* _tmp2_;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = self->rem;
	_tmp1_ = other;
	_tmp2_ = _tmp1_->rem;
	_tmp3_ = netsukuku_rem_compare_to (_tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}


/** The path contains a specified hop?
          */
gboolean netsukuku_clone_route_contains (NetsukukuCloneRoute* self, NetsukukuHCoord* hop) {
	gboolean result = FALSE;
	NetsukukuHCoord* _tmp0_;
	NetsukukuHCoord* _tmp1_;
	gboolean _tmp2_ = FALSE;
	NetsukukuHCoord* _tmp3_;
	NetsukukuHCoord* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeList* _tmp6_;
	NetsukukuHCoord* _tmp7_;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hop != NULL, FALSE);
	_tmp0_ = hop;
	_tmp1_ = self->dest;
	_tmp2_ = netsukuku_hcoord_is_equal (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = hop;
	_tmp4_ = self->first_hop;
	_tmp5_ = netsukuku_hcoord_is_equal (_tmp3_, _tmp4_);
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	_tmp6_ = self->hops;
	_tmp7_ = hop;
	_tmp8_ = gee_collection_contains ((GeeCollection*) _tmp6_, _tmp7_);
	if (_tmp8_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean netsukuku_clone_route_contains_nip (NetsukukuCloneRoute* self, NetsukukuNIP* nip) {
	gboolean result = FALSE;
	NetsukukuNIP* _tmp0_;
	NetsukukuHCoord* _tmp1_ = NULL;
	NetsukukuHCoord* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	_tmp0_ = nip;
	_tmp1_ = netsukuku_clone_route_nip_to_lvlid (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_clone_route_contains (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


NetsukukuHCoord* netsukuku_clone_route_nip_to_lvlid (NetsukukuCloneRoute* self, NetsukukuNIP* nip) {
	NetsukukuHCoord* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuHCoord* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = self->mymap_me;
	_tmp2_ = netsukuku_partial_nip_get_hcoord_relative_to ((NetsukukuPartialNIP*) _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


NetsukukuPartialNIP* netsukuku_clone_route_lvlid_to_nip (NetsukukuCloneRoute* self, NetsukukuHCoord* lvlid) {
	NetsukukuPartialNIP* result = NULL;
	NetsukukuHCoord* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuPartialNIP* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lvlid != NULL, NULL);
	_tmp0_ = lvlid;
	_tmp1_ = self->mymap_me;
	_tmp2_ = netsukuku_hcoord_get_partialnip_relative_to (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void netsukuku_clone_route_class_init (NetsukukuCloneRouteClass * klass) {
	netsukuku_clone_route_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_clone_route_finalize;
}


static void netsukuku_clone_route_instance_init (NetsukukuCloneRoute * self) {
}


static void netsukuku_clone_route_finalize (GObject* obj) {
	NetsukukuCloneRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_CLONE_ROUTE, NetsukukuCloneRoute);
	_g_free0 (self->gwdev);
	_g_object_unref0 (self->gwrem);
	_g_object_unref0 (self->gwnip);
	_g_free0 (self->gwipstr);
	_g_object_unref0 (self->rem);
	_g_object_unref0 (self->rem_at_gw);
	_g_object_unref0 (self->dest);
	_g_object_unref0 (self->first_hop);
	_g_object_unref0 (self->hops);
	_g_object_unref0 (self->hops_with_gw);
	_g_object_unref0 (self->mymap_me);
	G_OBJECT_CLASS (netsukuku_clone_route_parent_class)->finalize (obj);
}


GType netsukuku_clone_route_get_type (void) {
	static volatile gsize netsukuku_clone_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_clone_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCloneRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_clone_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCloneRoute), 0, (GInstanceInitFunc) netsukuku_clone_route_instance_init, NULL };
		GType netsukuku_clone_route_type_id;
		netsukuku_clone_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuCloneRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_clone_route_type_id__volatile, netsukuku_clone_route_type_id);
	}
	return netsukuku_clone_route_type_id__volatile;
}


static gboolean _netsukuku_route_equal_func_in_routenode_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_route_equal_func_in_routenode (a, b);
	return result;
}


static void netsukuku_route_node_real_initialize (NetsukukuDataClass* base, GObject* map, gint lvl, gint pos, gboolean its_me) {
	NetsukukuRouteNode * self;
	GObject* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	GeeArrayList* _tmp4_;
	self = (NetsukukuRouteNode*) base;
	g_return_if_fail (map != NULL);
	_tmp0_ = map;
	self->maproute = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, NETSUKUKU_TYPE_MAP) ? ((NetsukukuMap*) _tmp0_) : NULL;
	_tmp1_ = lvl;
	self->lvl = _tmp1_;
	_tmp2_ = pos;
	self->pos = _tmp2_;
	_tmp3_ = its_me;
	self->its_me = _tmp3_;
	self->busy = FALSE;
	_tmp4_ = gee_array_list_new (NETSUKUKU_TYPE_ROUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_route_equal_func_in_routenode_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->routes);
	self->routes = _tmp4_;
}


/** Returns the route having as gateway `gw'
              */
NetsukukuRoute* netsukuku_route_node_route_get_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* gw) {
	NetsukukuRoute* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gw != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _r_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _r_size;
		gint _r_index;
		_tmp0_ = self->routes;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_r_list = _tmp1_;
		_tmp2_ = _r_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_r_size = _tmp4_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuRoute* r;
			NetsukukuRoute* _tmp11_;
			NetsukukuAggregatedNeighbour* _tmp12_;
			NetsukukuAggregatedNeighbour* _tmp13_;
			_tmp5_ = _r_index;
			_r_index = _tmp5_ + 1;
			_tmp6_ = _r_index;
			_tmp7_ = _r_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _r_list;
			_tmp9_ = _r_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			r = (NetsukukuRoute*) _tmp10_;
			_tmp11_ = r;
			_tmp12_ = _tmp11_->gw;
			_tmp13_ = gw;
			if (_tmp12_ == _tmp13_) {
				result = r;
				_g_object_unref0 (_r_list);
				return result;
			}
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_list);
	}
	result = NULL;
	return result;
}


void netsukuku_route_node_update_route_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* nr, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid) {
	NetsukukuAggregatedNeighbour* _tmp0_;
	NetsukukuRoute* _tmp1_ = NULL;
	NetsukukuRoute* r;
	NetsukukuRoute* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nr != NULL);
	g_return_if_fail (rem_at_gw != NULL);
	g_return_if_fail (hops != NULL);
	g_return_if_fail (gid != NULL);
	_tmp0_ = nr;
	_tmp1_ = netsukuku_route_node_route_get_by_gw (self, _tmp0_);
	r = _tmp1_;
	_tmp2_ = r;
	if (_tmp2_ == NULL) {
		GeeArrayList* _tmp3_;
		NetsukukuAggregatedNeighbour* _tmp4_;
		NetsukukuREM* _tmp5_;
		GeeList* _tmp6_;
		NetsukukuGNodeID* _tmp7_;
		NetsukukuRoute* _tmp8_;
		NetsukukuRoute* _tmp9_;
		_tmp3_ = self->routes;
		_tmp4_ = nr;
		_tmp5_ = rem_at_gw;
		_tmp6_ = hops;
		_tmp7_ = gid;
		_tmp8_ = netsukuku_route_new (_tmp4_, _tmp5_, _tmp6_, _tmp7_, self);
		_tmp9_ = _tmp8_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp9_);
		_g_object_unref0 (_tmp9_);
	} else {
		NetsukukuRoute* _tmp10_;
		NetsukukuREM* _tmp11_;
		GeeList* _tmp12_;
		NetsukukuGNodeID* _tmp13_;
		NetsukukuREM* _tmp14_ = NULL;
		NetsukukuREM* _tmp15_;
		_tmp10_ = r;
		_tmp11_ = rem_at_gw;
		_tmp12_ = hops;
		_tmp13_ = gid;
		_tmp14_ = netsukuku_route_rem_modify (_tmp10_, _tmp11_, _tmp12_, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp15_);
	}
	self->busy = TRUE;
	netsukuku_route_node_sort (self);
	_g_object_unref0 (r);
}


/** Delete a route.
              * Returns 1 if the route has been deleted, otherwise 0
              */
gint netsukuku_route_node_route_del_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* gw) {
	gint result = 0;
	NetsukukuAggregatedNeighbour* _tmp0_;
	NetsukukuRoute* _tmp1_ = NULL;
	NetsukukuRoute* r;
	NetsukukuRoute* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (gw != NULL, 0);
	_tmp0_ = gw;
	_tmp1_ = netsukuku_route_node_route_get_by_gw (self, _tmp0_);
	r = _tmp1_;
	_tmp2_ = r;
	if (_tmp2_ != NULL) {
		GeeArrayList* _tmp3_;
		NetsukukuRoute* _tmp4_;
		_tmp3_ = self->routes;
		_tmp4_ = r;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _tmp4_);
		result = 1;
		_g_object_unref0 (r);
		return result;
	}
	result = 0;
	_g_object_unref0 (r);
	return result;
}


static gint netsukuku_route_node_reverse_compare_func (NetsukukuRoute* a, NetsukukuRoute* b) {
	gint result = 0;
	NetsukukuRoute* _tmp0_;
	NetsukukuRoute* _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	_tmp2_ = netsukuku_route_compare_func (_tmp0_, _tmp1_);
	result = -_tmp2_;
	return result;
}


/** Order the routes
              * Order the routes in decrescent order of efficiency, so that
              *  routes[0] is the best one
              */
static gint _netsukuku_route_node_reverse_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = netsukuku_route_node_reverse_compare_func (a, b);
	return result;
}


void netsukuku_route_node_sort (NetsukukuRouteNode* self) {
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->routes;
	gee_list_sort ((GeeList*) _tmp0_, _netsukuku_route_node_reverse_compare_func_gcompare_data_func, NULL, NULL);
}


gboolean netsukuku_route_node_is_empty (NetsukukuRouteNode* self) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->routes;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static gboolean netsukuku_route_node_real_is_free (NetsukukuDataClass* base) {
	NetsukukuRouteNode * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (NetsukukuRouteNode*) base;
	_tmp0_ = self->its_me;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->busy;
	result = !_tmp1_;
	return result;
}


NetsukukuGNodeID* netsukuku_route_node_get_eldest_gid (NetsukukuRouteNode* self) {
	NetsukukuGNodeID* result = NULL;
	NetsukukuGNodeID* ret;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _r_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _r_size;
		gint _r_index;
		_tmp0_ = self->routes;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_r_list = _tmp1_;
		_tmp2_ = _r_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_r_size = _tmp4_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuRoute* r;
			NetsukukuGNodeID* _tmp11_;
			_tmp5_ = _r_index;
			_r_index = _tmp5_ + 1;
			_tmp6_ = _r_index;
			_tmp7_ = _r_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _r_list;
			_tmp9_ = _r_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			r = (NetsukukuRoute*) _tmp10_;
			_tmp11_ = ret;
			if (_tmp11_ == NULL) {
				NetsukukuRoute* _tmp12_;
				NetsukukuGNodeID* _tmp13_;
				NetsukukuGNodeID* _tmp14_;
				_tmp12_ = r;
				_tmp13_ = _tmp12_->gid;
				_tmp14_ = _g_object_ref0 (_tmp13_);
				_g_object_unref0 (ret);
				ret = _tmp14_;
			} else {
				NetsukukuGNodeID* _tmp15_;
				NetsukukuRoute* _tmp16_;
				NetsukukuGNodeID* _tmp17_;
				NetsukukuGNodeID* _tmp18_ = NULL;
				_tmp15_ = ret;
				_tmp16_ = r;
				_tmp17_ = _tmp16_->gid;
				_tmp18_ = netsukuku_gnode_id_will_bubble (_tmp15_, _tmp17_);
				_g_object_unref0 (ret);
				ret = _tmp18_;
			}
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_list);
	}
	result = ret;
	return result;
}


GeeList* netsukuku_route_node_all_valid_routes (NetsukukuRouteNode* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_ROUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_route_equal_func_in_routenode_gee_equal_data_func, NULL, NULL);
	ret = _tmp0_;
	netsukuku_route_node_sort (self);
	_tmp1_ = self->routes;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		NetsukukuGNodeID* _tmp4_ = NULL;
		NetsukukuGNodeID* eldest;
		_tmp4_ = netsukuku_route_node_get_eldest_gid (self);
		eldest = _tmp4_;
		{
			GeeArrayList* _tmp5_;
			GeeArrayList* _tmp6_;
			GeeArrayList* _r_list;
			GeeArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _r_size;
			gint _r_index;
			_tmp5_ = self->routes;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_r_list = _tmp6_;
			_tmp7_ = _r_list;
			_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_r_size = _tmp9_;
			_r_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				GeeArrayList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_ = NULL;
				NetsukukuRoute* r;
				NetsukukuRoute* _tmp16_;
				NetsukukuGNodeID* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				NetsukukuGNodeID* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				_tmp10_ = _r_index;
				_r_index = _tmp10_ + 1;
				_tmp11_ = _r_index;
				_tmp12_ = _r_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _r_list;
				_tmp14_ = _r_index;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
				r = (NetsukukuRoute*) _tmp15_;
				_tmp16_ = r;
				_tmp17_ = _tmp16_->gid;
				_tmp18_ = netsukuku_gnode_id_get_ident (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = eldest;
				_tmp21_ = netsukuku_gnode_id_get_ident (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp19_ == _tmp22_) {
					GeeArrayList* _tmp23_;
					NetsukukuRoute* _tmp24_;
					_tmp23_ = ret;
					_tmp24_ = r;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
				}
				_g_object_unref0 (r);
			}
			_g_object_unref0 (_r_list);
		}
		_g_object_unref0 (eldest);
	}
	result = (GeeList*) ret;
	return result;
}


gint netsukuku_route_node_nroutes (NetsukukuRouteNode* self) {
	gint result = 0;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = netsukuku_route_node_all_valid_routes (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


NetsukukuRoute* netsukuku_route_node_best_route (NetsukukuRouteNode* self) {
	NetsukukuRoute* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* filtered;
	GeeList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeList* _tmp4_;
	gpointer _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_route_node_all_valid_routes (self);
	filtered = _tmp0_;
	_tmp1_ = filtered;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = NULL;
		_g_object_unref0 (filtered);
		return result;
	}
	_tmp4_ = filtered;
	_tmp5_ = gee_list_get (_tmp4_, 0);
	result = (NetsukukuRoute*) _tmp5_;
	_g_object_unref0 (filtered);
	return result;
}


NetsukukuRoute* netsukuku_route_node_best_route_without (NetsukukuRouteNode* self, NetsukukuHCoord* hop) {
	NetsukukuRoute* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* filtered;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hop != NULL, NULL);
	_tmp0_ = netsukuku_route_node_all_valid_routes (self);
	filtered = _tmp0_;
	{
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _r_list;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _r_size;
		gint _r_index;
		_tmp1_ = filtered;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_r_list = _tmp2_;
		_tmp3_ = _r_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_r_size = _tmp5_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			NetsukukuRoute* r;
			NetsukukuRoute* _tmp12_;
			NetsukukuHCoord* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp6_ = _r_index;
			_r_index = _tmp6_ + 1;
			_tmp7_ = _r_index;
			_tmp8_ = _r_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _r_list;
			_tmp10_ = _r_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			r = (NetsukukuRoute*) _tmp11_;
			_tmp12_ = r;
			_tmp13_ = hop;
			_tmp14_ = netsukuku_route_contains (_tmp12_, _tmp13_);
			if (!_tmp14_) {
				result = r;
				_g_object_unref0 (_r_list);
				_g_object_unref0 (filtered);
				return result;
			}
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_list);
	}
	result = NULL;
	_g_object_unref0 (filtered);
	return result;
}


NetsukukuRouteNode* netsukuku_route_node_construct (GType object_type) {
	NetsukukuRouteNode * self = NULL;
	self = (NetsukukuRouteNode*) netsukuku_dataclass_construct (object_type);
	return self;
}


NetsukukuRouteNode* netsukuku_route_node_new (void) {
	return netsukuku_route_node_construct (NETSUKUKU_TYPE_ROUTE_NODE);
}


static void netsukuku_route_node_class_init (NetsukukuRouteNodeClass * klass) {
	netsukuku_route_node_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_DATACLASS_CLASS (klass)->initialize = netsukuku_route_node_real_initialize;
	NETSUKUKU_DATACLASS_CLASS (klass)->is_free = netsukuku_route_node_real_is_free;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_route_node_finalize;
}


static void netsukuku_route_node_instance_init (NetsukukuRouteNode * self) {
}


static void netsukuku_route_node_finalize (GObject* obj) {
	NetsukukuRouteNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode);
	_g_object_unref0 (self->routes);
	G_OBJECT_CLASS (netsukuku_route_node_parent_class)->finalize (obj);
}


/** List of paths to a known destination.
      *
      * This class is basically a list of Route instances, where the
      * destination node and its level are fixed and known.
      *
      * Note: for each gateway G there's only one route in self.routes,
      *       which has the same gateway G
      */
GType netsukuku_route_node_get_type (void) {
	static volatile gsize netsukuku_route_node_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_route_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRouteNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_route_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRouteNode), 0, (GInstanceInitFunc) netsukuku_route_node_instance_init, NULL };
		GType netsukuku_route_node_type_id;
		netsukuku_route_node_type_id = g_type_register_static (NETSUKUKU_TYPE_DATACLASS, "NetsukukuRouteNode", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_route_node_type_id__volatile, netsukuku_route_node_type_id);
	}
	return netsukuku_route_node_type_id__volatile;
}


NetsukukuGIDChecker* netsukuku_gid_checker_construct (GType object_type) {
	NetsukukuGIDChecker * self = NULL;
	gdouble _tmp0_ = 0.0;
	gint32 _tmp1_ = 0;
	NetsukukuTimeCapsule* _tmp2_;
	GeeArrayList* _tmp3_;
	self = (NetsukukuGIDChecker*) g_object_new (object_type, NULL);
	_tmp0_ = pow ((gdouble) 2, (gdouble) 32);
	_tmp1_ = g_random_int_range ((gint32) 0, (gint32) (((gint) _tmp0_) - 1));
	self->my_req_id = (gint) _tmp1_;
	_tmp2_ = netsukuku_time_capsule_new ((gint64) 120000);
	_g_object_unref0 (self->ttl);
	self->ttl = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->received_req_ids);
	self->received_req_ids = _tmp3_;
	return self;
}


NetsukukuGIDChecker* netsukuku_gid_checker_new (void) {
	return netsukuku_gid_checker_construct (NETSUKUKU_TYPE_GID_CHECKER);
}


static void netsukuku_gid_checker_class_init (NetsukukuGIDCheckerClass * klass) {
	netsukuku_gid_checker_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_gid_checker_finalize;
}


static void netsukuku_gid_checker_instance_init (NetsukukuGIDChecker * self) {
}


static void netsukuku_gid_checker_finalize (GObject* obj) {
	NetsukukuGIDChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_GID_CHECKER, NetsukukuGIDChecker);
	_g_object_unref0 (self->ttl);
	_g_object_unref0 (self->received_req_ids);
	G_OBJECT_CLASS (netsukuku_gid_checker_parent_class)->finalize (obj);
}


GType netsukuku_gid_checker_get_type (void) {
	static volatile gsize netsukuku_gid_checker_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_gid_checker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuGIDCheckerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_gid_checker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuGIDChecker), 0, (GInstanceInitFunc) netsukuku_gid_checker_instance_init, NULL };
		GType netsukuku_gid_checker_type_id;
		netsukuku_gid_checker_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuGIDChecker", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_gid_checker_type_id__volatile, netsukuku_gid_checker_type_id);
	}
	return netsukuku_gid_checker_type_id__volatile;
}


void netsukuku_struct_helper_maproute_periodically_check_gid_copy (const Netsukukustruct_helper_MapRoute_periodically_check_gid* self, Netsukukustruct_helper_MapRoute_periodically_check_gid* dest) {
	NetsukukuMapRoute* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	gint _tmp2_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).level;
	(*dest).level = _tmp2_;
}


void netsukuku_struct_helper_maproute_periodically_check_gid_destroy (Netsukukustruct_helper_MapRoute_periodically_check_gid* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_MapRoute_periodically_check_gid* netsukuku_struct_helper_maproute_periodically_check_gid_dup (const Netsukukustruct_helper_MapRoute_periodically_check_gid* self) {
	Netsukukustruct_helper_MapRoute_periodically_check_gid* dup;
	dup = g_new0 (Netsukukustruct_helper_MapRoute_periodically_check_gid, 1);
	netsukuku_struct_helper_maproute_periodically_check_gid_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_maproute_periodically_check_gid_free (Netsukukustruct_helper_MapRoute_periodically_check_gid* self) {
	netsukuku_struct_helper_maproute_periodically_check_gid_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_maproute_periodically_check_gid_get_type (void) {
	static volatile gsize netsukuku_struct_helper_maproute_periodically_check_gid_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_maproute_periodically_check_gid_type_id__volatile)) {
		GType netsukuku_struct_helper_maproute_periodically_check_gid_type_id;
		netsukuku_struct_helper_maproute_periodically_check_gid_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_MapRoute_periodically_check_gid", (GBoxedCopyFunc) netsukuku_struct_helper_maproute_periodically_check_gid_dup, (GBoxedFreeFunc) netsukuku_struct_helper_maproute_periodically_check_gid_free);
		g_once_init_leave (&netsukuku_struct_helper_maproute_periodically_check_gid_type_id__volatile, netsukuku_struct_helper_maproute_periodically_check_gid_type_id);
	}
	return netsukuku_struct_helper_maproute_periodically_check_gid_type_id__volatile;
}


NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, gint levels, gint gsize, NetsukukuNIP* me, NetsukukuGNodeID** id_myself, int id_myself_length1, NetsukukuAddressManager* address_manager) {
	NetsukukuMapRoute * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuGNodeID** _tmp3_;
	gint _tmp3__length1;
	NetsukukuAddressManager* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeArrayList* _tmp6_;
	g_return_val_if_fail (me != NULL, NULL);
	g_return_val_if_fail (address_manager != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = me;
	self = (NetsukukuMapRoute*) netsukuku_map_construct (object_type, NETSUKUKU_TYPE_ROUTE_NODE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = id_myself;
	_tmp3__length1 = id_myself_length1;
	netsukuku_map_route_set_id_myself (self, _tmp3_, _tmp3__length1);
	_tmp4_ = address_manager;
	netsukuku_map_route_set_address_manager (self, _tmp4_);
	_tmp5_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, NETSUKUKU_TYPE_GID_CHECKER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->checking_gid);
	self->priv->checking_gid = _tmp5_;
	_tmp6_ = gee_array_list_new (TASKLETS_TYPE_TASKLET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->check_gid_handle);
	self->priv->check_gid_handle = _tmp6_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				gint _tmp11_;
				GeeArrayList* _tmp12_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = levels;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = self->priv->check_gid_handle;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, NULL);
			}
		}
	}
	return self;
}


NetsukukuMapRoute* netsukuku_map_route_new (gint levels, gint gsize, NetsukukuNIP* me, NetsukukuGNodeID** id_myself, int id_myself_length1, NetsukukuAddressManager* address_manager) {
	return netsukuku_map_route_construct (NETSUKUKU_TYPE_MAP_ROUTE, levels, gsize, me, id_myself, id_myself_length1, address_manager);
}


static void netsukuku_map_route_real_stop_operations (NetsukukuMap* base) {
	NetsukukuMapRoute * self;
	self = (NetsukukuMapRoute*) base;
	NETSUKUKU_MAP_CLASS (netsukuku_map_route_parent_class)->stop_operations (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_MAP, NetsukukuMap));
	{
		gint l;
		l = 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_ = NULL;
				TaskletsTasklet* t;
				TaskletsTasklet* _tmp9_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l;
					l = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = l;
				_tmp4_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->check_gid_handle;
				_tmp7_ = l;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp7_);
				t = (TaskletsTasklet*) _tmp8_;
				_tmp9_ = t;
				if (_tmp9_ != NULL) {
					TaskletsTasklet* _tmp10_;
					GeeArrayList* _tmp11_;
					gint _tmp12_;
					_tmp10_ = t;
					tasklets_tasklet_abort (_tmp10_);
					_tmp11_ = self->priv->check_gid_handle;
					_tmp12_ = l;
					gee_abstract_list_set ((GeeAbstractList*) _tmp11_, _tmp12_, NULL);
				}
				_g_object_unref0 (t);
			}
		}
	}
}


static GeeList* netsukuku_map_route_real_report_routes (NetsukukuIMapRoute* base, GError** error) {
	NetsukukuMapRoute * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	self = (NetsukukuMapRoute*) base;
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_INFO_ROUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint _tmp1_;
		gint _tmp2_;
		gint level;
		_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
		_tmp2_ = _tmp1_;
		level = _tmp2_ - 1;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = level;
					level = _tmp5_ - 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = level;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				{
					gint dest;
					dest = 0;
					{
						gboolean _tmp7_;
						_tmp7_ = TRUE;
						while (TRUE) {
							gboolean _tmp8_;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							NetsukukuNIP* _tmp13_;
							NetsukukuNIP* _tmp14_;
							gint _tmp15_;
							gint _tmp16_ = 0;
							gint _tmp17_;
							_tmp8_ = _tmp7_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = dest;
								dest = _tmp9_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp10_ = dest;
							_tmp11_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
							_tmp12_ = _tmp11_;
							if (!(_tmp10_ < _tmp12_)) {
								break;
							}
							_tmp13_ = netsukuku_map_get_me ((NetsukukuMap*) self);
							_tmp14_ = _tmp13_;
							_tmp15_ = level;
							_tmp16_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp14_, _tmp15_);
							_tmp17_ = dest;
							if (_tmp16_ != _tmp17_) {
								gint _tmp18_;
								gint _tmp19_;
								gpointer _tmp20_ = NULL;
								NetsukukuRouteNode* node;
								NetsukukuRouteNode* _tmp21_;
								gint _tmp22_ = 0;
								_tmp18_ = level;
								_tmp19_ = dest;
								_tmp20_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp18_, _tmp19_);
								node = (NetsukukuRouteNode*) _tmp20_;
								_tmp21_ = node;
								_tmp22_ = netsukuku_route_node_nroutes (_tmp21_);
								if (_tmp22_ > 0) {
									{
										NetsukukuRouteNode* _tmp23_;
										GeeList* _tmp24_ = NULL;
										GeeList* _r_list;
										GeeList* _tmp25_;
										gint _tmp26_;
										gint _tmp27_;
										gint _r_size;
										gint _r_index;
										_tmp23_ = node;
										_tmp24_ = netsukuku_route_node_all_valid_routes (_tmp23_);
										_r_list = _tmp24_;
										_tmp25_ = _r_list;
										_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
										_tmp27_ = _tmp26_;
										_r_size = _tmp27_;
										_r_index = -1;
										while (TRUE) {
											gint _tmp28_;
											gint _tmp29_;
											gint _tmp30_;
											GeeList* _tmp31_;
											gint _tmp32_;
											gpointer _tmp33_ = NULL;
											NetsukukuRoute* r;
											NetsukukuRoute* _tmp34_;
											NetsukukuREM* _tmp35_;
											NetsukukuREM* _tmp36_;
											GType _tmp37_ = 0UL;
											gboolean _tmp38_ = FALSE;
											_tmp28_ = _r_index;
											_r_index = _tmp28_ + 1;
											_tmp29_ = _r_index;
											_tmp30_ = _r_size;
											if (!(_tmp29_ < _tmp30_)) {
												break;
											}
											_tmp31_ = _r_list;
											_tmp32_ = _r_index;
											_tmp33_ = gee_list_get (_tmp31_, _tmp32_);
											r = (NetsukukuRoute*) _tmp33_;
											_tmp34_ = r;
											_tmp35_ = netsukuku_route_get_rem (_tmp34_);
											_tmp36_ = _tmp35_;
											_tmp37_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp36_);
											_tmp38_ = g_type_is_a (_tmp37_, NETSUKUKU_TYPE_DEAD_REM);
											if (!_tmp38_) {
												GeeArrayList* _tmp39_;
												gint _tmp40_;
												gint _tmp41_;
												NetsukukuHCoord* _tmp42_;
												NetsukukuHCoord* _tmp43_;
												NetsukukuRoute* _tmp44_;
												NetsukukuGNodeID* _tmp45_;
												NetsukukuRoute* _tmp46_;
												NetsukukuAggregatedNeighbour* _tmp47_;
												NetsukukuNIP* _tmp48_;
												NetsukukuRoute* _tmp49_;
												NetsukukuAggregatedNeighbour* _tmp50_;
												const gchar* _tmp51_;
												const gchar* _tmp52_;
												NetsukukuRoute* _tmp53_;
												GeeList* _tmp54_;
												GeeList* _tmp55_;
												NetsukukuRoute* _tmp56_;
												NetsukukuREM* _tmp57_;
												NetsukukuREM* _tmp58_;
												NetsukukuInfoRoute* _tmp59_;
												NetsukukuInfoRoute* _tmp60_;
												_tmp39_ = ret;
												_tmp40_ = level;
												_tmp41_ = dest;
												_tmp42_ = netsukuku_hcoord_new (_tmp40_, _tmp41_);
												_tmp43_ = _tmp42_;
												_tmp44_ = r;
												_tmp45_ = _tmp44_->gid;
												_tmp46_ = r;
												_tmp47_ = _tmp46_->gw;
												_tmp48_ = _tmp47_->nip;
												_tmp49_ = r;
												_tmp50_ = _tmp49_->gw;
												_tmp51_ = netsukuku_aggregated_neighbour_get_dev (_tmp50_);
												_tmp52_ = _tmp51_;
												_tmp53_ = r;
												_tmp54_ = netsukuku_route_get_hops_with_gw (_tmp53_);
												_tmp55_ = _tmp54_;
												_tmp56_ = r;
												_tmp57_ = netsukuku_route_get_rem (_tmp56_);
												_tmp58_ = _tmp57_;
												_tmp59_ = netsukuku_info_route_new (_tmp43_, _tmp45_, _tmp48_, _tmp52_, _tmp55_, _tmp58_);
												_tmp60_ = _tmp59_;
												gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp60_);
												_g_object_unref0 (_tmp60_);
												_g_object_unref0 (_tmp43_);
											}
											_g_object_unref0 (r);
										}
										_g_object_unref0 (_r_list);
									}
								}
								_g_object_unref0 (node);
							}
						}
					}
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
		}
	}
	result = (GeeList*) ret;
	return result;
}


static GeeList* netsukuku_map_route_real_report_gid_list (NetsukukuIMapRoute* base, GError** error) {
	NetsukukuMapRoute * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	gint _tmp1_ = 0;
	NetsukukuGNodeID** _tmp2_ = NULL;
	self = (NetsukukuMapRoute*) base;
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_GNODE_ID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	_tmp2_ = netsukuku_map_route_get_gid_list (self, &_tmp1_);
	{
		NetsukukuGNodeID** g_collection = NULL;
		gint g_collection_length1 = 0;
		gint _g_collection_size_ = 0;
		gint g_it = 0;
		g_collection = _tmp2_;
		g_collection_length1 = _tmp1_;
		for (g_it = 0; g_it < _tmp1_; g_it = g_it + 1) {
			NetsukukuGNodeID* _tmp3_;
			NetsukukuGNodeID* g = NULL;
			_tmp3_ = _g_object_ref0 (g_collection[g_it]);
			g = _tmp3_;
			{
				GeeArrayList* _tmp4_;
				NetsukukuGNodeID* _tmp5_;
				_tmp4_ = ret;
				_tmp5_ = g;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
				_g_object_unref0 (g);
			}
		}
		g_collection = (_vala_array_free (g_collection, g_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	result = (GeeList*) ret;
	return result;
}


static NetsukukuInfoNode* netsukuku_map_route_real_report_yourself (NetsukukuIMapRoute* base, GError** error) {
	NetsukukuMapRoute * self;
	NetsukukuInfoNode* result = NULL;
	NetsukukuNetworkID* _tmp0_ = NULL;
	NetsukukuNetworkID* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuAddressManager* _tmp4_;
	NetsukukuKeyPair* _tmp5_;
	NetsukukuPublicKeyWrapper* _tmp6_;
	NetsukukuPublicKeyWrapper* _tmp7_;
	NetsukukuPublicKey* _tmp8_ = NULL;
	NetsukukuPublicKey* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	NetsukukuInfoNode* _tmp14_;
	NetsukukuInfoNode* _tmp15_;
	self = (NetsukukuMapRoute*) base;
	_tmp0_ = netsukuku_map_route_get_main_netid (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = netsukuku_map_get_me ((NetsukukuMap*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_address_manager;
	_tmp5_ = _tmp4_->keypair;
	_tmp6_ = netsukuku_key_pair_get_pub_key (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = netsukuku_public_key_wrapper_to_pubkey (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = netsukuku_info_node_new (_tmp1_, _tmp3_, _tmp9_, _tmp11_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp1_);
	result = _tmp15_;
	return result;
}


/** My GNode ID list
          */
NetsukukuGNodeID** netsukuku_map_route_get_gid_list (NetsukukuMapRoute* self, int* result_length1) {
	NetsukukuGNodeID** result = NULL;
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	NetsukukuGNodeID** _tmp2_ = NULL;
	NetsukukuGNodeID** ret;
	gint ret_length1;
	gint _ret_size_;
	NetsukukuGNodeID** _tmp17_;
	gint _tmp17__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_map_route_get_id_myself (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = g_new0 (NetsukukuGNodeID*, _tmp1__length1 + 1);
	ret = _tmp2_;
	ret_length1 = _tmp1__length1;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				NetsukukuGNodeID** _tmp7_;
				gint _tmp7__length1;
				NetsukukuGNodeID** _tmp8_;
				gint _tmp8__length1;
				NetsukukuGNodeID** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				NetsukukuGNodeID** _tmp11_;
				gint _tmp11__length1;
				NetsukukuGNodeID** _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				NetsukukuGNodeID* _tmp14_;
				NetsukukuGNodeID* _tmp15_;
				NetsukukuGNodeID* _tmp16_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = netsukuku_map_route_get_id_myself (self, &_tmp7__length1);
				_tmp8_ = _tmp7_;
				_tmp8__length1 = _tmp7__length1;
				if (!(_tmp6_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = ret;
				_tmp9__length1 = ret_length1;
				_tmp10_ = i;
				_tmp11_ = netsukuku_map_route_get_id_myself (self, &_tmp11__length1);
				_tmp12_ = _tmp11_;
				_tmp12__length1 = _tmp11__length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = _g_object_ref0 (_tmp14_);
				_g_object_unref0 (_tmp9_[_tmp10_]);
				_tmp9_[_tmp10_] = _tmp15_;
				_tmp16_ = _tmp9_[_tmp10_];
			}
		}
	}
	_tmp17_ = ret;
	_tmp17__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	return result;
}


NetsukukuGNodeID** netsukuku_map_route_get_gid_uppermost_list (NetsukukuMapRoute* self, gint level_of_gnode, int* result_length1) {
	NetsukukuGNodeID** result = NULL;
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	NetsukukuGNodeID** _tmp3_ = NULL;
	NetsukukuGNodeID** ret;
	gint ret_length1;
	gint _ret_size_;
	NetsukukuGNodeID** _tmp20_;
	gint _tmp20__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_map_route_get_id_myself (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = level_of_gnode;
	_tmp3_ = g_new0 (NetsukukuGNodeID*, (_tmp1__length1 - _tmp2_) + 1);
	ret = _tmp3_;
	ret_length1 = _tmp1__length1 - _tmp2_;
	_ret_size_ = ret_length1;
	{
		gint _tmp4_;
		gint i;
		_tmp4_ = level_of_gnode;
		i = _tmp4_;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				NetsukukuGNodeID** _tmp9_;
				gint _tmp9__length1;
				NetsukukuGNodeID** _tmp10_;
				gint _tmp10__length1;
				NetsukukuGNodeID** _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				gint _tmp13_;
				NetsukukuGNodeID** _tmp14_;
				gint _tmp14__length1;
				NetsukukuGNodeID** _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				NetsukukuGNodeID* _tmp17_;
				NetsukukuGNodeID* _tmp18_;
				NetsukukuGNodeID* _tmp19_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = netsukuku_map_route_get_id_myself (self, &_tmp9__length1);
				_tmp10_ = _tmp9_;
				_tmp10__length1 = _tmp9__length1;
				if (!(_tmp8_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = ret;
				_tmp11__length1 = ret_length1;
				_tmp12_ = i;
				_tmp13_ = level_of_gnode;
				_tmp14_ = netsukuku_map_route_get_id_myself (self, &_tmp14__length1);
				_tmp15_ = _tmp14_;
				_tmp15__length1 = _tmp14__length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp18_ = _g_object_ref0 (_tmp17_);
				_g_object_unref0 (_tmp11_[_tmp12_ - _tmp13_]);
				_tmp11_[_tmp12_ - _tmp13_] = _tmp18_;
				_tmp19_ = _tmp11_[_tmp12_ - _tmp13_];
			}
		}
	}
	_tmp20_ = ret;
	_tmp20__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}


NetsukukuGNodeID* netsukuku_map_route_get_gid_at_level (NetsukukuMapRoute* self, gint lvl) {
	NetsukukuGNodeID* result = NULL;
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	NetsukukuGNodeID* _tmp3_;
	NetsukukuGNodeID* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_map_route_get_id_myself (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = lvl;
	_tmp3_ = _tmp1_[_tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


/** My node ID
          */
gint netsukuku_map_route_get_my_id (NetsukukuMapRoute* self) {
	gint result = 0;
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	NetsukukuGNodeID* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = netsukuku_map_route_get_id_myself (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = netsukuku_gnode_id_get_ident (_tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}


/** This method returns a Networkid. The aim is to be able to
          *  testify to a neighbour that we already hooked in its same network.
          * Since the network could split, and we could detect the change
          *  moments before our neighbour does, then we must compare not just the
          *  GID of level 'levels' -- which is the min of GIDs of level 'levels-1'
          *  but we must compare all the GIDs of level levels-1.
          * Add to this, that at the very beginning of our hook when we did not
          *  receive an etp yet, we do not have in the maproute the necessary
          *  gids, we just received the main one in self.id_myself[-1]
          * Furthermore we have to consider self.id_myself[-2] for our GID at
          *  level 'levels-1'.
          * TODO We still have a weakness here. 2 neighbours that belong to the same
          *  network but in different gnodes at the uppermost level (eg 1.1.1 and 2.2.2
          *  in a network of 3 levels) have in common only the gnodes of level 2, so
          *  they can compare the GIDs at level 2 and the one GID at level 3 (that is
          *  the min of GIDs at level 2). If the gsize is quite small (say gsize=4) we
          *  have very few IDs (4) that we can compare. They exist for the lifespan of
          *  few single nodes. If all these nodes die quite at the same time,
          *  then we'll experience a massive rehook.
          */
static gboolean _netsukuku_gnode_id_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_gnode_id_equal_func (a, b);
	return result;
}


static void _vala_array_add11 (NetsukukuRouteNode*** array, int* length, int* size, NetsukukuRouteNode* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuRouteNode*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


NetsukukuNetworkID* netsukuku_map_route_get_main_netid (NetsukukuMapRoute* self) {
	NetsukukuNetworkID* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	NetsukukuRouteNode** _tmp1_ = NULL;
	NetsukukuRouteNode** r1;
	gint r1_length1;
	gint _r1_size_;
	NetsukukuRouteNode** _tmp13_;
	gint _tmp13__length1;
	GeeArrayList* _tmp21_;
	NetsukukuGNodeID** _tmp22_;
	gint _tmp22__length1;
	NetsukukuGNodeID** _tmp23_;
	gint _tmp23__length1;
	NetsukukuGNodeID** _tmp24_;
	gint _tmp24__length1;
	NetsukukuGNodeID** _tmp25_;
	gint _tmp25__length1;
	NetsukukuGNodeID* _tmp26_;
	GeeArrayList* _tmp27_;
	NetsukukuGNodeID** _tmp28_;
	gint _tmp28__length1;
	NetsukukuGNodeID** _tmp29_;
	gint _tmp29__length1;
	NetsukukuGNodeID** _tmp30_;
	gint _tmp30__length1;
	NetsukukuGNodeID** _tmp31_;
	gint _tmp31__length1;
	NetsukukuGNodeID* _tmp32_;
	GeeArrayList* _tmp33_;
	NetsukukuNetworkID* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_GNODE_ID, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_gnode_id_equal_func_gee_equal_data_func, NULL, NULL);
	ret = _tmp0_;
	_tmp1_ = g_new0 (NetsukukuRouteNode*, 0 + 1);
	r1 = _tmp1_;
	r1_length1 = 0;
	_r1_size_ = r1_length1;
	{
		gint pos;
		pos = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				NetsukukuRouteNode** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gpointer _tmp12_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = pos;
					pos = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = pos;
				_tmp6_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
				_tmp7_ = _tmp6_;
				if (!(_tmp5_ < _tmp7_)) {
					break;
				}
				_tmp8_ = r1;
				_tmp8__length1 = r1_length1;
				_tmp9_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
				_tmp10_ = _tmp9_;
				_tmp11_ = pos;
				_tmp12_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp10_ - 1, _tmp11_);
				_vala_array_add11 (&r1, &r1_length1, &_r1_size_, (NetsukukuRouteNode*) _tmp12_);
			}
		}
	}
	_tmp13_ = r1;
	_tmp13__length1 = r1_length1;
	{
		NetsukukuRouteNode** node_collection = NULL;
		gint node_collection_length1 = 0;
		gint _node_collection_size_ = 0;
		gint node_it = 0;
		node_collection = _tmp13_;
		node_collection_length1 = _tmp13__length1;
		for (node_it = 0; node_it < _tmp13__length1; node_it = node_it + 1) {
			NetsukukuRouteNode* _tmp14_;
			NetsukukuRouteNode* node = NULL;
			_tmp14_ = _g_object_ref0 (node_collection[node_it]);
			node = _tmp14_;
			{
				NetsukukuRouteNode* _tmp15_;
				gboolean _tmp16_ = FALSE;
				_tmp15_ = node;
				_tmp16_ = netsukuku_route_node_is_empty (_tmp15_);
				if (!_tmp16_) {
					GeeArrayList* _tmp17_;
					NetsukukuRouteNode* _tmp18_;
					NetsukukuGNodeID* _tmp19_ = NULL;
					NetsukukuGNodeID* _tmp20_;
					_tmp17_ = ret;
					_tmp18_ = node;
					_tmp19_ = netsukuku_route_node_get_eldest_gid (_tmp18_);
					_tmp20_ = _tmp19_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp20_);
					_g_object_unref0 (_tmp20_);
				}
				_g_object_unref0 (node);
			}
		}
	}
	_tmp21_ = ret;
	_tmp22_ = netsukuku_map_route_get_id_myself (self, &_tmp22__length1);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp22__length1;
	_tmp24_ = netsukuku_map_route_get_id_myself (self, &_tmp24__length1);
	_tmp25_ = _tmp24_;
	_tmp25__length1 = _tmp24__length1;
	_tmp26_ = _tmp23_[_tmp25__length1 - 2];
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp26_);
	_tmp27_ = ret;
	_tmp28_ = netsukuku_map_route_get_id_myself (self, &_tmp28__length1);
	_tmp29_ = _tmp28_;
	_tmp29__length1 = _tmp28__length1;
	_tmp30_ = netsukuku_map_route_get_id_myself (self, &_tmp30__length1);
	_tmp31_ = _tmp30_;
	_tmp31__length1 = _tmp30__length1;
	_tmp32_ = _tmp29_[_tmp31__length1 - 1];
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp32_);
	_tmp33_ = ret;
	_tmp34_ = netsukuku_network_id_new ((GeeList*) _tmp33_);
	result = _tmp34_;
	r1 = (_vala_array_free (r1, r1_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (ret);
	return result;
}


/** Is this netid in my network
          */
gboolean netsukuku_map_route_is_in_my_network (NetsukukuMapRoute* self, NetsukukuNetworkID* netid) {
	gboolean result = FALSE;
	NetsukukuNetworkID* _tmp0_ = NULL;
	NetsukukuNetworkID* _tmp1_;
	NetsukukuNetworkID* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (netid != NULL, FALSE);
	_tmp0_ = netsukuku_map_route_get_main_netid (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = netid;
	_tmp3_ = netsukuku_network_id_is_same_network (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


/** Is this netid preferred over mine
          */
gboolean netsukuku_map_route_is_preferred_network (NetsukukuMapRoute* self, NetsukukuNetworkID* netid) {
	gboolean result = FALSE;
	NetsukukuNetworkID* _tmp0_;
	NetsukukuNetworkID* _tmp1_ = NULL;
	NetsukukuNetworkID* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (netid != NULL, FALSE);
	_tmp0_ = netid;
	_tmp1_ = netsukuku_map_route_get_main_netid (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_network_id_is_preferred_over (_tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


/** Verify the validity of the GNode ID.
          * This has to be called just once after a ROUTES_UPDATED event,
          * to keep updated the GNodeid at various levels.
          */
void netsukuku_map_route_evaluate_changed_netid (NetsukukuMapRoute* self) {
	NetsukukuAddressManager* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_address_manager;
	_tmp1_ = _tmp0_->is_mature;
	if (!_tmp1_) {
		return;
	}
	{
		gint j;
		j = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				NetsukukuGNodeID** _tmp8_;
				gint _tmp8__length1;
				NetsukukuGNodeID** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				NetsukukuGNodeID* _tmp11_;
				NetsukukuGNodeID* _tmp12_;
				NetsukukuGNodeID* eldest_internal_to_j_plus_1;
				NetsukukuGNodeID** _tmp29_;
				gint _tmp29__length1;
				NetsukukuGNodeID** _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_;
				NetsukukuGNodeID* _tmp32_;
				NetsukukuGNodeID* _tmp33_;
				gboolean _tmp34_ = FALSE;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = j;
					j = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = j;
				_tmp6_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
				_tmp7_ = _tmp6_;
				if (!(_tmp5_ < _tmp7_)) {
					break;
				}
				_tmp8_ = netsukuku_map_route_get_id_myself (self, &_tmp8__length1);
				_tmp9_ = _tmp8_;
				_tmp9__length1 = _tmp8__length1;
				_tmp10_ = j;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = _g_object_ref0 (_tmp11_);
				eldest_internal_to_j_plus_1 = _tmp12_;
				{
					gint pos;
					pos = 0;
					{
						gboolean _tmp13_;
						_tmp13_ = TRUE;
						while (TRUE) {
							gboolean _tmp14_;
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							gpointer _tmp21_ = NULL;
							NetsukukuRouteNode* jpos;
							NetsukukuRouteNode* _tmp22_;
							gboolean _tmp23_ = FALSE;
							_tmp14_ = _tmp13_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = pos;
								pos = _tmp15_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp16_ = pos;
							_tmp17_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
							_tmp18_ = _tmp17_;
							if (!(_tmp16_ < _tmp18_)) {
								break;
							}
							_tmp19_ = j;
							_tmp20_ = pos;
							_tmp21_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp19_, _tmp20_);
							jpos = (NetsukukuRouteNode*) _tmp21_;
							_tmp22_ = jpos;
							_tmp23_ = netsukuku_route_node_is_empty (_tmp22_);
							if (!_tmp23_) {
								NetsukukuGNodeID* _tmp24_;
								NetsukukuRouteNode* _tmp25_;
								NetsukukuGNodeID* _tmp26_ = NULL;
								NetsukukuGNodeID* _tmp27_;
								NetsukukuGNodeID* _tmp28_ = NULL;
								_tmp24_ = eldest_internal_to_j_plus_1;
								_tmp25_ = jpos;
								_tmp26_ = netsukuku_route_node_get_eldest_gid (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = netsukuku_gnode_id_will_bubble (_tmp24_, _tmp27_);
								_g_object_unref0 (eldest_internal_to_j_plus_1);
								eldest_internal_to_j_plus_1 = _tmp28_;
								_g_object_unref0 (_tmp27_);
							}
							_g_object_unref0 (jpos);
						}
					}
				}
				_tmp29_ = netsukuku_map_route_get_id_myself (self, &_tmp29__length1);
				_tmp30_ = _tmp29_;
				_tmp30__length1 = _tmp29__length1;
				_tmp31_ = j;
				_tmp32_ = _tmp30_[_tmp31_ + 1];
				_tmp33_ = eldest_internal_to_j_plus_1;
				_tmp34_ = netsukuku_gnode_id_change_values (_tmp32_, _tmp33_);
				if (_tmp34_) {
					gint _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					_tmp35_ = j;
					g_signal_emit_by_name (self, "id-gnode-changed", _tmp35_ + 1);
					_tmp36_ = j;
					_tmp37_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
					_tmp38_ = _tmp37_;
					if (_tmp36_ < (_tmp38_ - 1)) {
						gint _tmp39_;
						_tmp39_ = j;
						netsukuku_map_route_handle_check_gid (self, _tmp39_ + 1);
					}
				}
				_g_object_unref0 (eldest_internal_to_j_plus_1);
			}
		}
	}
}


/** A node which wants to rest assured that its GID at level lvl is valid will launch handle_check_gid. This
          *  will start operations (if not already in progress) and make sure that for a certain time
          *  from now the check will be periodically sent in broadcast until a response (ok or rehook)
          *  is received or the time expires.
          *  Note that handle_check_gid is not a microfunc and when it returns we can immediately add an id to its answer_queue.
          * When a node receives such a request and it is in the same gnode, it will launch handle_check_gid. Then it adds
          *  the received request_id to the answer_queue for the level.
          * To formulate the request to be sent, a node generates a request_id. It will use this request_id in all messages
          *  sent until response/expiration.
          * When a response is received that is for us and is ok, the same answer is sent again in broadcast to all the id
          *  that we have in answer_queue.
          * When a response is received that is for us and is rehook, the maproute emits a signal that will cause the
          *  ntkd_node to start a rehook. The signal contains all data needed to reply the same answer after the rehook has
          *  been completed. The reply will occurr only after the node has is_mature, because, until then, the node will not
          *  be able to serve a hook request.
          *  The exact sequence of operations when ntkd_node detects the signal is:
          *    . (assert the splitted was a primary_address)
          *    . start rehook from primary_address to [answering_nip]
          *    . tc=TimeCapsule(xx)
          *    . while True:
          *    .   if tc.expired(): break
          *    .   if rehook failed: break
          *    .   if addresses.primary_address.is_mature:
          *    .     for queued_id in queue:
          *    .       broadcast_client.maproute.answer_gid( \
          *    .              addresses.primary_address.maproute.me, \
          *    .              queued_id, \
          *    .              actual_gid)
          *    .     break
          *    .   swait a bit
          *  So, the data needed with the signal 'GNODE_SPLITTED' are: (neighbours=[answering_nip], queue, actual_gid)
          * Note_1: An address_manager nom-autonomous will ignore messages request_gid.
          * Note_2: An address_manager nom-autonomous that detects a possible gnode split will start handle_check_gid, but if
          *          it receives a rehook then it just dies. (this check is in ntkd_node)
          * Note_3: An address_manager that has not is_mature will ignore messages request_gid.
          */
void netsukuku_map_route_handle_check_gid (NetsukukuMapRoute* self, gint level) {
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp8_;
	gint _tmp9_;
	NetsukukuGIDChecker* _tmp10_;
	NetsukukuGIDChecker* _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->checking_gid;
	_tmp1_ = level;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (_tmp2_) {
		GeeHashMap* _tmp3_;
		gint _tmp4_;
		gpointer _tmp5_ = NULL;
		NetsukukuGIDChecker* _tmp6_;
		NetsukukuTimeCapsule* _tmp7_;
		_tmp3_ = self->priv->checking_gid;
		_tmp4_ = level;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) _tmp4_));
		_tmp6_ = (NetsukukuGIDChecker*) _tmp5_;
		_tmp7_ = netsukuku_time_capsule_new ((gint64) 120000);
		_g_object_unref0 (_tmp6_->ttl);
		_tmp6_->ttl = _tmp7_;
		_g_object_unref0 (_tmp6_);
		return;
	}
	_tmp8_ = self->priv->checking_gid;
	_tmp9_ = level;
	_tmp10_ = netsukuku_gid_checker_new ();
	_tmp11_ = _tmp10_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, (gpointer) ((gintptr) _tmp9_), _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = level;
	netsukuku_map_route_periodically_check_gid (self, _tmp12_);
}


static void netsukuku_map_route_impl_periodically_check_gid (NetsukukuMapRoute* self, gint level, GError** error) {
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	TaskletsTasklet* _tmp2_ = NULL;
	TaskletsTasklet* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("MapRoute.periodically_check_gid");
	_tmp0_ = self->priv->check_gid_handle;
	_tmp1_ = level;
	_tmp2_ = tasklets_tasklet_self ();
	_tmp3_ = _tmp2_;
	gee_abstract_list_set ((GeeAbstractList*) _tmp0_, _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	tasklets_ms_wait ((gint64) 1000);
	while (TRUE) {
		{
			GeeHashMap* _tmp4_;
			gint _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeHashMap* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_ = NULL;
			NetsukukuGIDChecker* _tmp10_;
			NetsukukuTimeCapsule* _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_;
			gint _tmp14_;
			_tmp4_ = self->priv->checking_gid;
			_tmp5_ = level;
			_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, (gpointer) ((gintptr) _tmp5_));
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = self->priv->checking_gid;
			_tmp8_ = level;
			_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((gintptr) _tmp8_));
			_tmp10_ = (NetsukukuGIDChecker*) _tmp9_;
			_tmp11_ = _tmp10_->ttl;
			_tmp12_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp11_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				break;
			}
			_tmp14_ = level;
			netsukuku_map_route_send_request_gid (self, _tmp14_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch52_g_error;
			}
			tasklets_ms_wait ((gint64) 5000);
		}
		goto __finally52;
		__catch52_g_error:
		{
			GError* e = NULL;
			NetsukukuNIP* _tmp15_;
			NetsukukuNIP* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) self);
			_tmp16_ = _tmp15_;
			_tmp17_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = level;
			_tmp20_ = g_strdup_printf ("%i", _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			_tmp24_ = string_to_string (_tmp23_);
			_tmp25_ = g_strconcat ("Maproute for ", _tmp18_, " at level ", _tmp21_, " : periodically_check_gid error: ", _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			netsukuku_log_warn (_tmp26_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp18_);
			_g_error_free0 (e);
		}
		__finally52:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void* netsukuku_map_route_helper_periodically_check_gid (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_MapRoute_periodically_check_gid* tuple_p;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuMapRoute* self_save;
	gint _tmp3_;
	gint level_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_MapRoute_periodically_check_gid*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).level;
	level_save = _tmp3_;
	tasklets_tasklet_schedule_back ();
	netsukuku_map_route_impl_periodically_check_gid (self_save, level_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_map_route_periodically_check_gid (NetsukukuMapRoute* self, gint level) {
	Netsukukustruct_helper_MapRoute_periodically_check_gid arg = {0};
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	TaskletsTasklet* _tmp2_ = NULL;
	TaskletsTasklet* _tmp3_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_MapRoute_periodically_check_gid));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = level;
	arg.level = _tmp1_;
	_tmp2_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_map_route_helper_periodically_check_gid, &arg, FALSE, -1);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	netsukuku_struct_helper_maproute_periodically_check_gid_destroy (&arg);
}


void netsukuku_map_route_send_request_gid (NetsukukuMapRoute* self, gint level, GError** error) {
	NetsukukuAddressManager* _tmp0_;
	NetsukukuAddressManagerFakeRmt* _tmp1_ = NULL;
	NetsukukuAddressManagerFakeRmt* bclient;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	gint _tmp4_;
	NetsukukuPartialNIP* _tmp5_ = NULL;
	NetsukukuPartialNIP* gprefix;
	NetsukukuNetworkID* _tmp6_ = NULL;
	NetsukukuNetworkID* gnetid;
	GeeHashMap* _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_ = NULL;
	NetsukukuGIDChecker* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint request_id;
	NetsukukuIMapRoute* _tmp13_;
	NetsukukuIMapRoute* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_address_manager;
	_tmp1_ = netsukuku_address_manager_get_broadcast_client (_tmp0_);
	bclient = _tmp1_;
	_tmp2_ = netsukuku_map_get_me ((NetsukukuMap*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = level;
	_tmp5_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp3_, _tmp4_);
	gprefix = _tmp5_;
	_tmp6_ = netsukuku_map_route_get_main_netid (self);
	gnetid = _tmp6_;
	_tmp7_ = self->priv->checking_gid;
	_tmp8_ = level;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((gintptr) _tmp8_));
	_tmp10_ = (NetsukukuGIDChecker*) _tmp9_;
	_tmp11_ = _tmp10_->my_req_id;
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	request_id = _tmp12_;
	_tmp13_ = netsukuku_iaddress_manager_root_dispatcher_get_maproute ((NetsukukuIAddressManagerRootDispatcher*) bclient);
	_tmp14_ = _tmp13_;
	netsukuku_imap_route_request_gid (_tmp14_, request_id, gnetid, gprefix, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (gnetid);
			_g_object_unref0 (gprefix);
			_g_object_unref0 (bclient);
			return;
		} else {
			_g_object_unref0 (gnetid);
			_g_object_unref0 (gprefix);
			_g_object_unref0 (bclient);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (gnetid);
	_g_object_unref0 (gprefix);
	_g_object_unref0 (bclient);
}


static void netsukuku_map_route_real_request_gid (NetsukukuIMapRoute* base, gint request_id, NetsukukuNetworkID* gnetid, NetsukukuPartialNIP* gprefix, GError** error) {
	NetsukukuMapRoute * self;
	NetsukukuAddressManager* _tmp0_;
	gboolean _tmp1_;
	NetsukukuNetworkID* _tmp2_;
	gboolean _tmp3_ = FALSE;
	NetsukukuAddressManager* _tmp4_;
	gboolean _tmp5_;
	NetsukukuPartialNIP* _tmp6_;
	gint _tmp7_ = 0;
	gint level;
	NetsukukuNIP* _tmp8_;
	NetsukukuNIP* _tmp9_;
	NetsukukuPartialNIP* _tmp10_;
	gint _tmp11_ = 0;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuMapRoute*) base;
	g_return_if_fail (gnetid != NULL);
	g_return_if_fail (gprefix != NULL);
	_tmp0_ = self->priv->_address_manager;
	_tmp1_ = _tmp0_->is_mature;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gnetid;
	_tmp3_ = netsukuku_map_route_is_in_my_network (self, _tmp2_);
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->_address_manager;
	_tmp5_ = _tmp4_->operative;
	if (!_tmp5_) {
		return;
	}
	_tmp6_ = gprefix;
	_tmp7_ = netsukuku_partial_nip_level_of_gnode (_tmp6_);
	level = _tmp7_;
	_tmp8_ = netsukuku_map_get_me ((NetsukukuMap*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gprefix;
	_tmp11_ = netsukuku_partial_nip_compare ((NetsukukuPartialNIP*) _tmp9_, _tmp10_);
	_tmp12_ = level;
	if (_tmp11_ < _tmp12_) {
		NetsukukuNIP* _tmp13_;
		NetsukukuNIP* _tmp14_;
		NetsukukuPartialNIP* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_;
		_tmp13_ = netsukuku_map_get_me ((NetsukukuMap*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = gprefix;
		_tmp16_ = netsukuku_partial_nip_compare ((NetsukukuPartialNIP*) _tmp14_, _tmp15_);
		_tmp17_ = level;
		if (_tmp16_ < (_tmp17_ + 1)) {
			return;
		} else {
			gint _tmp18_;
			NetsukukuPartialNIP* _tmp19_;
			gint _tmp20_;
			gint _tmp21_ = 0;
			gpointer _tmp22_ = NULL;
			NetsukukuRouteNode* _tmp23_;
			NetsukukuGNodeID* _tmp24_ = NULL;
			NetsukukuGNodeID* _tmp25_;
			NetsukukuGNodeID* actual_gid;
			NetsukukuGNodeID* _tmp26_;
			GeeArrayList* _tmp27_;
			GeeArrayList* queue;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			GeeArrayList* _tmp30_;
			NetsukukuGNodeID* _tmp31_;
			_tmp18_ = level;
			_tmp19_ = gprefix;
			_tmp20_ = level;
			_tmp21_ = netsukuku_partial_nip_position_at (_tmp19_, _tmp20_);
			_tmp22_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp18_, _tmp21_);
			_tmp23_ = (NetsukukuRouteNode*) _tmp22_;
			_tmp24_ = netsukuku_route_node_get_eldest_gid (_tmp23_);
			_tmp25_ = _tmp24_;
			_g_object_unref0 (_tmp23_);
			actual_gid = _tmp25_;
			_tmp26_ = actual_gid;
			if (_tmp26_ == NULL) {
				_g_object_unref0 (actual_gid);
				return;
			}
			_tmp27_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
			queue = _tmp27_;
			_tmp28_ = queue;
			_tmp29_ = request_id;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (gpointer) ((gintptr) _tmp29_));
			_tmp30_ = queue;
			_tmp31_ = actual_gid;
			netsukuku_map_route_send_answer_gid (self, (GeeList*) _tmp30_, _tmp31_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (queue);
					_g_object_unref0 (actual_gid);
					return;
				} else {
					_g_object_unref0 (queue);
					_g_object_unref0 (actual_gid);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_object_unref0 (queue);
			_g_object_unref0 (actual_gid);
		}
	} else {
		gint _tmp32_;
		GeeHashMap* _tmp33_;
		gint _tmp34_;
		gpointer _tmp35_ = NULL;
		NetsukukuGIDChecker* _tmp36_;
		GeeArrayList* _tmp37_;
		gint _tmp38_;
		_tmp32_ = level;
		netsukuku_map_route_handle_check_gid (self, _tmp32_);
		_tmp33_ = self->priv->checking_gid;
		_tmp34_ = level;
		_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, (gpointer) ((gintptr) _tmp34_));
		_tmp36_ = (NetsukukuGIDChecker*) _tmp35_;
		_tmp37_ = _tmp36_->received_req_ids;
		_tmp38_ = request_id;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, (gpointer) ((gintptr) _tmp38_));
		_g_object_unref0 (_tmp36_);
	}
}


void netsukuku_map_route_send_answer_gid (NetsukukuMapRoute* self, GeeList* queue, NetsukukuGNodeID* actual_gid, GError** error) {
	NetsukukuAddressManager* _tmp0_;
	NetsukukuAddressManagerFakeRmt* _tmp1_ = NULL;
	NetsukukuAddressManagerFakeRmt* bclient;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (queue != NULL);
	g_return_if_fail (actual_gid != NULL);
	_tmp0_ = self->priv->_address_manager;
	_tmp1_ = netsukuku_address_manager_get_broadcast_client (_tmp0_);
	bclient = _tmp1_;
	{
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _queued_id_list;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _queued_id_size;
		gint _queued_id_index;
		_tmp2_ = queue;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_queued_id_list = _tmp3_;
		_tmp4_ = _queued_id_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_queued_id_size = _tmp6_;
		_queued_id_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			gint queued_id;
			NetsukukuAddressManagerFakeRmt* _tmp13_;
			NetsukukuIMapRoute* _tmp14_;
			NetsukukuIMapRoute* _tmp15_;
			NetsukukuNIP* _tmp16_;
			NetsukukuNIP* _tmp17_;
			gint _tmp18_;
			NetsukukuGNodeID* _tmp19_;
			_tmp7_ = _queued_id_index;
			_queued_id_index = _tmp7_ + 1;
			_tmp8_ = _queued_id_index;
			_tmp9_ = _queued_id_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _queued_id_list;
			_tmp11_ = _queued_id_index;
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
			queued_id = (gint) ((gintptr) _tmp12_);
			_tmp13_ = bclient;
			_tmp14_ = netsukuku_iaddress_manager_root_dispatcher_get_maproute ((NetsukukuIAddressManagerRootDispatcher*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = netsukuku_map_get_me ((NetsukukuMap*) self);
			_tmp17_ = _tmp16_;
			_tmp18_ = queued_id;
			_tmp19_ = actual_gid;
			netsukuku_imap_route_answer_gid (_tmp15_, _tmp17_, _tmp18_, _tmp19_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (_queued_id_list);
					_g_object_unref0 (bclient);
					return;
				} else {
					_g_object_unref0 (_queued_id_list);
					_g_object_unref0 (bclient);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		_g_object_unref0 (_queued_id_list);
	}
	_g_object_unref0 (bclient);
}


static gboolean _netsukuku_aggregated_neighbour_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_aggregated_neighbour_equal_func (a, b);
	return result;
}


static void netsukuku_map_route_real_answer_gid (NetsukukuIMapRoute* base, NetsukukuNIP* answering_nip, gint request_id, NetsukukuGNodeID* actual_gid, GError** error) {
	NetsukukuMapRoute * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuMapRoute*) base;
	g_return_if_fail (answering_nip != NULL);
	g_return_if_fail (actual_gid != NULL);
	{
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _level_it;
		_tmp0_ = self->priv->checking_gid;
		_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_level_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gint level;
			GeeHashMap* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			NetsukukuGIDChecker* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gboolean _tmp16_;
			_tmp6_ = _level_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _level_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			level = (gint) ((gintptr) _tmp9_);
			_tmp10_ = self->priv->checking_gid;
			_tmp11_ = level;
			_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) _tmp11_));
			_tmp13_ = (NetsukukuGIDChecker*) _tmp12_;
			_tmp14_ = _tmp13_->my_req_id;
			_tmp15_ = request_id;
			_tmp16_ = _tmp14_ == _tmp15_;
			_g_object_unref0 (_tmp13_);
			if (_tmp16_) {
				GeeHashMap* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_ = NULL;
				NetsukukuGIDChecker* _tmp20_;
				GeeArrayList* _tmp21_;
				GeeArrayList* _tmp22_;
				GeeArrayList* _tmp23_;
				GeeArrayList* queue;
				NetsukukuGNodeID* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				NetsukukuGNodeID** _tmp27_;
				gint _tmp27__length1;
				NetsukukuGNodeID** _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				NetsukukuGNodeID* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				_tmp17_ = self->priv->checking_gid;
				_tmp18_ = level;
				_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, (gpointer) ((gintptr) _tmp18_));
				_tmp20_ = (NetsukukuGIDChecker*) _tmp19_;
				_tmp21_ = _tmp20_->received_req_ids;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_tmp23_ = _tmp22_;
				_g_object_unref0 (_tmp20_);
				queue = _tmp23_;
				_tmp24_ = actual_gid;
				_tmp25_ = netsukuku_gnode_id_get_min_will_not_rehook (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = netsukuku_map_route_get_id_myself (self, &_tmp27__length1);
				_tmp28_ = _tmp27_;
				_tmp28__length1 = _tmp27__length1;
				_tmp29_ = level;
				_tmp30_ = _tmp28_[_tmp29_];
				_tmp31_ = netsukuku_gnode_id_get_min_will_not_rehook (_tmp30_);
				_tmp32_ = _tmp31_;
				if (_tmp26_ < _tmp32_) {
					NetsukukuAddressManager* _tmp33_;
					NetsukukuAggregatedNeighbourManager* _tmp34_;
					gboolean _tmp35_;
					GeeList* _tmp36_ = NULL;
					GeeList* neighbours0;
					GeeArrayList* _tmp37_;
					GeeArrayList* neighbours;
					GeeArrayList* _tmp55_;
					gboolean _tmp56_;
					gboolean _tmp57_;
					GeeArrayList* _tmp58_;
					GeeArrayList* _tmp59_;
					NetsukukuGNodeID* _tmp60_;
					GeeHashMap* _tmp61_;
					gint _tmp62_;
					_tmp33_ = self->priv->_address_manager;
					_tmp34_ = _tmp33_->aggregated_neighbour_manager;
					_tmp35_ = TRUE;
					_tmp36_ = netsukuku_aggregated_neighbour_manager_neighbour_list (_tmp34_, &_tmp35_, NULL);
					neighbours0 = _tmp36_;
					_tmp37_ = gee_array_list_new (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_aggregated_neighbour_equal_func_gee_equal_data_func, NULL, NULL);
					neighbours = _tmp37_;
					{
						GeeList* _tmp38_;
						GeeList* _tmp39_;
						GeeList* _n_list;
						GeeList* _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						gint _n_size;
						gint _n_index;
						_tmp38_ = neighbours0;
						_tmp39_ = _g_object_ref0 (_tmp38_);
						_n_list = _tmp39_;
						_tmp40_ = _n_list;
						_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
						_tmp42_ = _tmp41_;
						_n_size = _tmp42_;
						_n_index = -1;
						while (TRUE) {
							gint _tmp43_;
							gint _tmp44_;
							gint _tmp45_;
							GeeList* _tmp46_;
							gint _tmp47_;
							gpointer _tmp48_ = NULL;
							NetsukukuAggregatedNeighbour* n;
							NetsukukuAggregatedNeighbour* _tmp49_;
							NetsukukuNIP* _tmp50_;
							NetsukukuNIP* _tmp51_;
							gint _tmp52_ = 0;
							_tmp43_ = _n_index;
							_n_index = _tmp43_ + 1;
							_tmp44_ = _n_index;
							_tmp45_ = _n_size;
							if (!(_tmp44_ < _tmp45_)) {
								break;
							}
							_tmp46_ = _n_list;
							_tmp47_ = _n_index;
							_tmp48_ = gee_list_get (_tmp46_, _tmp47_);
							n = (NetsukukuAggregatedNeighbour*) _tmp48_;
							_tmp49_ = n;
							_tmp50_ = _tmp49_->nip;
							_tmp51_ = answering_nip;
							_tmp52_ = netsukuku_partial_nip_compare ((NetsukukuPartialNIP*) _tmp50_, (NetsukukuPartialNIP*) _tmp51_);
							if (_tmp52_ == (-1)) {
								GeeArrayList* _tmp53_;
								NetsukukuAggregatedNeighbour* _tmp54_;
								_tmp53_ = neighbours;
								_tmp54_ = n;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, _tmp54_);
							}
							_g_object_unref0 (n);
						}
						_g_object_unref0 (_n_list);
					}
					_tmp55_ = neighbours;
					_tmp56_ = gee_collection_get_is_empty ((GeeCollection*) _tmp55_);
					_tmp57_ = _tmp56_;
					if (_tmp57_) {
						_g_object_unref0 (neighbours);
						_g_object_unref0 (neighbours0);
						_g_object_unref0 (queue);
						_g_object_unref0 (_level_it);
						return;
					}
					_tmp58_ = neighbours;
					_tmp59_ = queue;
					_tmp60_ = actual_gid;
					g_signal_emit_by_name (self, "gnode-splitted", (GeeList*) _tmp58_, (GeeList*) _tmp59_, _tmp60_);
					_tmp61_ = self->priv->checking_gid;
					_tmp62_ = level;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp61_, (gpointer) ((gintptr) _tmp62_), NULL);
					_g_object_unref0 (neighbours);
					_g_object_unref0 (neighbours0);
					_g_object_unref0 (queue);
					_g_object_unref0 (_level_it);
					return;
				} else {
					GeeHashMap* _tmp63_;
					gint _tmp64_;
					GeeArrayList* _tmp65_;
					NetsukukuGNodeID** _tmp66_;
					gint _tmp66__length1;
					NetsukukuGNodeID** _tmp67_;
					gint _tmp67__length1;
					gint _tmp68_;
					NetsukukuGNodeID* _tmp69_;
					_tmp63_ = self->priv->checking_gid;
					_tmp64_ = level;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp63_, (gpointer) ((gintptr) _tmp64_), NULL);
					_tmp65_ = queue;
					_tmp66_ = netsukuku_map_route_get_id_myself (self, &_tmp66__length1);
					_tmp67_ = _tmp66_;
					_tmp67__length1 = _tmp66__length1;
					_tmp68_ = level;
					_tmp69_ = _tmp67_[_tmp68_];
					netsukuku_map_route_send_answer_gid (self, (GeeList*) _tmp65_, _tmp69_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZCD_RPC_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (queue);
							_g_object_unref0 (_level_it);
							return;
						} else {
							_g_object_unref0 (queue);
							_g_object_unref0 (_level_it);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				_g_object_unref0 (queue);
				_g_object_unref0 (_level_it);
				return;
			}
		}
		_g_object_unref0 (_level_it);
	}
}


/** Returns the REM of the best path that we have to
          *  reach a destination which is inside our gnode of level level_of_gnode
          *  and which has the worst REM among such destinations.
          */
static NetsukukuREM* netsukuku_map_route_real_worst_internal_bestrem (NetsukukuIMapRoute* base, gint level_of_gnode, GError** error) {
	NetsukukuMapRoute * self;
	NetsukukuREM* result = NULL;
	NetsukukuNullREM* _tmp0_;
	NetsukukuREM* worstrem;
	self = (NetsukukuMapRoute*) base;
	_tmp0_ = netsukuku_null_rem_new ();
	worstrem = (NetsukukuREM*) _tmp0_;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = lvl;
					lvl = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = lvl;
				_tmp5_ = level_of_gnode;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				{
					gint dst;
					dst = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_;
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							NetsukukuNIP* _tmp12_;
							NetsukukuNIP* _tmp13_;
							gint _tmp14_;
							gint _tmp15_ = 0;
							gint _tmp16_;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = dst;
								dst = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = dst;
							_tmp10_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
							_tmp11_ = _tmp10_;
							if (!(_tmp9_ < _tmp11_)) {
								break;
							}
							_tmp12_ = netsukuku_map_get_me ((NetsukukuMap*) self);
							_tmp13_ = _tmp12_;
							_tmp14_ = lvl;
							_tmp15_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp13_, _tmp14_);
							_tmp16_ = dst;
							if (_tmp15_ != _tmp16_) {
								gint _tmp17_;
								gint _tmp18_;
								gpointer _tmp19_ = NULL;
								NetsukukuRouteNode* node;
								NetsukukuRouteNode* _tmp20_;
								gboolean _tmp21_ = FALSE;
								_tmp17_ = lvl;
								_tmp18_ = dst;
								_tmp19_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp17_, _tmp18_);
								node = (NetsukukuRouteNode*) _tmp19_;
								_tmp20_ = node;
								_tmp21_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp20_);
								if (!_tmp21_) {
									NetsukukuRouteNode* _tmp22_;
									NetsukukuRoute* _tmp23_ = NULL;
									NetsukukuRoute* _tmp24_;
									NetsukukuREM* _tmp25_;
									NetsukukuREM* _tmp26_;
									NetsukukuREM* _tmp27_;
									NetsukukuREM* _tmp28_;
									NetsukukuREM* bestrem;
									gboolean _tmp29_ = FALSE;
									NetsukukuREM* _tmp30_;
									GType _tmp31_ = 0UL;
									gboolean _tmp34_;
									_tmp22_ = node;
									_tmp23_ = netsukuku_route_node_best_route (_tmp22_);
									_tmp24_ = _tmp23_;
									_tmp25_ = netsukuku_route_get_rem (_tmp24_);
									_tmp26_ = _tmp25_;
									_tmp27_ = _g_object_ref0 (_tmp26_);
									_tmp28_ = _tmp27_;
									_g_object_unref0 (_tmp24_);
									bestrem = _tmp28_;
									_tmp30_ = bestrem;
									_tmp31_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp30_);
									if (_tmp31_ != NETSUKUKU_TYPE_ALMOST_DEAD_REM) {
										NetsukukuREM* _tmp32_;
										GType _tmp33_ = 0UL;
										_tmp32_ = bestrem;
										_tmp33_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp32_);
										_tmp29_ = _tmp33_ != NETSUKUKU_TYPE_DEAD_REM;
									} else {
										_tmp29_ = FALSE;
									}
									_tmp34_ = _tmp29_;
									if (_tmp34_) {
										NetsukukuREM* _tmp35_;
										NetsukukuREM* _tmp36_;
										gint _tmp37_ = 0;
										_tmp35_ = worstrem;
										_tmp36_ = bestrem;
										_tmp37_ = netsukuku_rem_compare_to (_tmp35_, _tmp36_);
										if (_tmp37_ > 0) {
											NetsukukuREM* _tmp38_;
											NetsukukuREM* _tmp39_;
											_tmp38_ = bestrem;
											_tmp39_ = _g_object_ref0 (_tmp38_);
											_g_object_unref0 (worstrem);
											worstrem = _tmp39_;
										}
									}
									_g_object_unref0 (bestrem);
								}
								_g_object_unref0 (node);
							}
						}
					}
				}
			}
		}
	}
	result = worstrem;
	return result;
}


/** Returns minimum distance in number of hops
          */
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


gint* netsukuku_map_route_get_distance (NetsukukuMapRoute* self, gint lvl, gint pos) {
	gint* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_ = NULL;
	NetsukukuRouteNode* node;
	NetsukukuRouteNode* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gint ret;
	gint* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_map_get_me ((NetsukukuMap*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = lvl;
	_tmp3_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp1_, _tmp2_);
	_tmp4_ = pos;
	if (_tmp3_ == _tmp4_) {
		gint _tmp5_;
		gint* _tmp6_;
		_tmp5_ = 0;
		_tmp6_ = __int_dup0 (&_tmp5_);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = lvl;
	_tmp8_ = pos;
	_tmp9_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp7_, _tmp8_);
	node = (NetsukukuRouteNode*) _tmp9_;
	_tmp10_ = node;
	_tmp11_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp10_);
	if (_tmp11_) {
		result = NULL;
		_g_object_unref0 (node);
		return result;
	}
	ret = -1;
	{
		NetsukukuRouteNode* _tmp12_;
		GeeList* _tmp13_ = NULL;
		GeeList* _r_list;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _r_size;
		gint _r_index;
		_tmp12_ = node;
		_tmp13_ = netsukuku_route_node_all_valid_routes (_tmp12_);
		_r_list = _tmp13_;
		_tmp14_ = _r_list;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_r_size = _tmp16_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GeeList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_ = NULL;
			NetsukukuRoute* r;
			NetsukukuRoute* _tmp23_;
			GeeList* _tmp24_;
			GeeList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint dist;
			gboolean _tmp28_ = FALSE;
			gint _tmp29_;
			gboolean _tmp32_;
			_tmp17_ = _r_index;
			_r_index = _tmp17_ + 1;
			_tmp18_ = _r_index;
			_tmp19_ = _r_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _r_list;
			_tmp21_ = _r_index;
			_tmp22_ = gee_list_get (_tmp20_, _tmp21_);
			r = (NetsukukuRoute*) _tmp22_;
			_tmp23_ = r;
			_tmp24_ = netsukuku_route_get_hops_with_gw (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			dist = _tmp27_;
			_tmp29_ = ret;
			if (_tmp29_ == (-1)) {
				_tmp28_ = TRUE;
			} else {
				gint _tmp30_;
				gint _tmp31_;
				_tmp30_ = dist;
				_tmp31_ = ret;
				_tmp28_ = _tmp30_ < _tmp31_;
			}
			_tmp32_ = _tmp28_;
			if (_tmp32_) {
				gint _tmp33_;
				_tmp33_ = dist;
				ret = _tmp33_;
			}
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_list);
	}
	_tmp34_ = __int_dup0 (&ret);
	result = _tmp34_;
	_g_object_unref0 (node);
	return result;
}


/** Methods that modify routes **/
void netsukuku_map_route_update_route_by_gw (NetsukukuMapRoute* self, NetsukukuHCoord* dest, NetsukukuAggregatedNeighbour* nr, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid) {
	NetsukukuHCoord* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint lvl;
	NetsukukuHCoord* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint dst;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_;
	gint _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gpointer _tmp13_ = NULL;
	NetsukukuRouteNode* paths;
	NetsukukuREM* _tmp14_;
	GType _tmp15_ = 0UL;
	NetsukukuRouteNode* _tmp23_;
	gboolean _tmp24_ = FALSE;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest != NULL);
	g_return_if_fail (nr != NULL);
	g_return_if_fail (rem_at_gw != NULL);
	g_return_if_fail (hops != NULL);
	_tmp0_ = dest;
	_tmp1_ = netsukuku_hcoord_get_lvl (_tmp0_);
	_tmp2_ = _tmp1_;
	lvl = _tmp2_;
	_tmp3_ = dest;
	_tmp4_ = netsukuku_hcoord_get_pos (_tmp3_);
	_tmp5_ = _tmp4_;
	dst = _tmp5_;
	_tmp6_ = netsukuku_map_get_me ((NetsukukuMap*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = lvl;
	_tmp9_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp7_, _tmp8_);
	_tmp10_ = dst;
	if (_tmp9_ == _tmp10_) {
		return;
	}
	_tmp11_ = lvl;
	_tmp12_ = dst;
	_tmp13_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp11_, _tmp12_);
	paths = (NetsukukuRouteNode*) _tmp13_;
	_tmp14_ = rem_at_gw;
	_tmp15_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp14_);
	if (_tmp15_ == NETSUKUKU_TYPE_DEAD_REM) {
		NetsukukuRouteNode* _tmp16_;
		NetsukukuAggregatedNeighbour* _tmp17_;
		_tmp16_ = paths;
		_tmp17_ = nr;
		netsukuku_route_node_route_del_by_gw (_tmp16_, _tmp17_);
	} else {
		NetsukukuRouteNode* _tmp18_;
		NetsukukuAggregatedNeighbour* _tmp19_;
		NetsukukuREM* _tmp20_;
		GeeList* _tmp21_;
		NetsukukuGNodeID* _tmp22_;
		_tmp18_ = paths;
		_tmp19_ = nr;
		_tmp20_ = rem_at_gw;
		_tmp21_ = hops;
		_tmp22_ = gid;
		netsukuku_route_node_update_route_by_gw (_tmp18_, _tmp19_, _tmp20_, _tmp21_, _tmp22_);
	}
	_tmp23_ = paths;
	_tmp24_ = netsukuku_route_node_is_empty (_tmp23_);
	if (_tmp24_) {
		gint _tmp25_;
		gint _tmp26_;
		_tmp25_ = lvl;
		_tmp26_ = dst;
		netsukuku_map_node_remove ((NetsukukuMap*) self, _tmp25_, _tmp26_);
	}
	_tmp27_ = lvl;
	_tmp28_ = dst;
	netsukuku_map_check_node ((NetsukukuMap*) self, _tmp27_, _tmp28_);
	_tmp29_ = lvl;
	_tmp30_ = dst;
	_netsukuku_map_route_emit_routes_updated (self, _tmp29_, _tmp30_);
	_g_object_unref0 (paths);
}


void netsukuku_map_route_route_del_by_gw (NetsukukuMapRoute* self, gint lvl, gint dst, NetsukukuAggregatedNeighbour* gw) {
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_ = NULL;
	NetsukukuRouteNode* paths;
	NetsukukuRouteNode* _tmp8_;
	NetsukukuAggregatedNeighbour* _tmp9_;
	NetsukukuRouteNode* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gw != NULL);
	_tmp0_ = netsukuku_map_get_me ((NetsukukuMap*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = lvl;
	_tmp3_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp1_, _tmp2_);
	_tmp4_ = dst;
	if (_tmp3_ == _tmp4_) {
		return;
	}
	_tmp5_ = lvl;
	_tmp6_ = dst;
	_tmp7_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp5_, _tmp6_);
	paths = (NetsukukuRouteNode*) _tmp7_;
	_tmp8_ = paths;
	_tmp9_ = gw;
	netsukuku_route_node_route_del_by_gw (_tmp8_, _tmp9_);
	_tmp10_ = paths;
	_tmp11_ = netsukuku_route_node_is_empty (_tmp10_);
	if (_tmp11_) {
		gint _tmp12_;
		gint _tmp13_;
		_tmp12_ = lvl;
		_tmp13_ = dst;
		netsukuku_map_node_remove ((NetsukukuMap*) self, _tmp12_, _tmp13_);
	}
	_tmp14_ = lvl;
	_tmp15_ = dst;
	netsukuku_map_check_node ((NetsukukuMap*) self, _tmp14_, _tmp15_);
	_tmp16_ = lvl;
	_tmp17_ = dst;
	_netsukuku_map_route_emit_routes_updated (self, _tmp16_, _tmp17_);
	_g_object_unref0 (paths);
}


void netsukuku_map_route_route_signal_rem_changed (NetsukukuMapRoute* self, gint lvl, gint dst) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lvl;
	_tmp1_ = dst;
	_netsukuku_map_route_emit_routes_updated (self, _tmp0_, _tmp1_);
}


void _netsukuku_map_route_emit_routes_updated (NetsukukuMapRoute* self, gint lvl, gint dst) {
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuHCoord* _tmp2_;
	NetsukukuHCoord* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lvl;
	_tmp1_ = dst;
	_tmp2_ = netsukuku_hcoord_new (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (self, "routes-updated", _tmp3_);
	_g_object_unref0 (_tmp3_);
}


/** Delete from the MapRoute all the routes passing from the
          * gateway `neighbour' and delete the node `neighbour' itself
          * (if present)
          */
void netsukuku_map_route_delete_routes_via_neighbour (NetsukukuMapRoute* self, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (aggregated_neighbour != NULL);
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = lvl;
					lvl = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = lvl;
				_tmp4_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				{
					gint dst;
					dst = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_;
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							NetsukukuNIP* _tmp12_;
							NetsukukuNIP* _tmp13_;
							gint _tmp14_;
							gint _tmp15_ = 0;
							gint _tmp16_;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = dst;
								dst = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = dst;
							_tmp10_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
							_tmp11_ = _tmp10_;
							if (!(_tmp9_ < _tmp11_)) {
								break;
							}
							_tmp12_ = netsukuku_map_get_me ((NetsukukuMap*) self);
							_tmp13_ = _tmp12_;
							_tmp14_ = lvl;
							_tmp15_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp13_, _tmp14_);
							_tmp16_ = dst;
							if (_tmp15_ != _tmp16_) {
								gint _tmp17_;
								gint _tmp18_;
								gpointer _tmp19_ = NULL;
								NetsukukuRouteNode* node;
								NetsukukuRouteNode* _tmp20_;
								gboolean _tmp21_ = FALSE;
								_tmp17_ = lvl;
								_tmp18_ = dst;
								_tmp19_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp17_, _tmp18_);
								node = (NetsukukuRouteNode*) _tmp19_;
								_tmp20_ = node;
								_tmp21_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp20_);
								if (!_tmp21_) {
									NetsukukuRouteNode* _tmp22_;
									NetsukukuAggregatedNeighbour* _tmp23_;
									NetsukukuRoute* _tmp24_ = NULL;
									NetsukukuRoute* _tmp25_;
									gboolean _tmp26_;
									_tmp22_ = node;
									_tmp23_ = aggregated_neighbour;
									_tmp24_ = netsukuku_route_node_route_get_by_gw (_tmp22_, _tmp23_);
									_tmp25_ = _tmp24_;
									_tmp26_ = _tmp25_ != NULL;
									_g_object_unref0 (_tmp25_);
									if (_tmp26_) {
										gint _tmp27_;
										gint _tmp28_;
										NetsukukuAggregatedNeighbour* _tmp29_;
										_tmp27_ = lvl;
										_tmp28_ = dst;
										_tmp29_ = aggregated_neighbour;
										netsukuku_map_route_route_del_by_gw (self, _tmp27_, _tmp28_, _tmp29_);
									}
								}
								_g_object_unref0 (node);
							}
						}
					}
				}
			}
		}
	}
}


/** Helpers **/
NetsukukuPartialNIP* netsukuku_map_route_choose_between (NetsukukuMapRoute* self, GeeList* choose_from) {
	NetsukukuPartialNIP* result = NULL;
	gint32 probabilitysum;
	GeeArrayList* _tmp0_;
	GeeArrayList* numbers;
	gint32 _tmp56_;
	gint32 _tmp57_ = 0;
	gint32 chosen;
	gint pos;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (choose_from != NULL, NULL);
	probabilitysum = (gint32) 0;
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	numbers = _tmp0_;
	{
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _nip_list;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _nip_size;
		gint _nip_index;
		_tmp1_ = choose_from;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_nip_list = _tmp2_;
		_tmp3_ = _nip_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_nip_size = _tmp5_;
		_nip_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			NetsukukuPartialNIP* nip;
			NetsukukuNIP* _tmp12_;
			NetsukukuNIP* _tmp13_;
			NetsukukuPartialNIP* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GeeArrayList* _tmp54_;
			gint32 _tmp55_;
			_tmp6_ = _nip_index;
			_nip_index = _tmp6_ + 1;
			_tmp7_ = _nip_index;
			_tmp8_ = _nip_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _nip_list;
			_tmp10_ = _nip_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			nip = (NetsukukuPartialNIP*) _tmp11_;
			_tmp12_ = netsukuku_map_get_me ((NetsukukuMap*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = nip;
			_tmp15_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp13_, _tmp14_);
			if (_tmp15_) {
				result = nip;
				_g_object_unref0 (_nip_list);
				_g_object_unref0 (numbers);
				return result;
			} else {
				NetsukukuPartialNIP* _tmp16_;
				NetsukukuNIP* _tmp17_;
				NetsukukuNIP* _tmp18_;
				NetsukukuHCoord* _tmp19_ = NULL;
				NetsukukuHCoord* lvl_pos;
				NetsukukuHCoord* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				NetsukukuHCoord* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gpointer _tmp26_ = NULL;
				NetsukukuRouteNode* rn;
				NetsukukuRouteNode* _tmp27_;
				gboolean _tmp28_ = FALSE;
				_tmp16_ = nip;
				_tmp17_ = netsukuku_map_get_me ((NetsukukuMap*) self);
				_tmp18_ = _tmp17_;
				_tmp19_ = netsukuku_partial_nip_get_hcoord_relative_to (_tmp16_, _tmp18_);
				lvl_pos = _tmp19_;
				_tmp20_ = lvl_pos;
				_tmp21_ = netsukuku_hcoord_get_lvl (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = lvl_pos;
				_tmp24_ = netsukuku_hcoord_get_pos (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp22_, _tmp25_);
				rn = (NetsukukuRouteNode*) _tmp26_;
				_tmp27_ = rn;
				_tmp28_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp27_);
				if (_tmp28_) {
				} else {
					NetsukukuRouteNode* _tmp29_;
					NetsukukuRoute* _tmp30_ = NULL;
					NetsukukuRoute* best;
					gboolean _tmp31_ = FALSE;
					gboolean _tmp32_ = FALSE;
					NetsukukuRoute* _tmp33_;
					gboolean _tmp38_;
					gboolean _tmp43_;
					_tmp29_ = rn;
					_tmp30_ = netsukuku_route_node_best_route (_tmp29_);
					best = _tmp30_;
					_tmp33_ = best;
					if (_tmp33_ == NULL) {
						_tmp32_ = TRUE;
					} else {
						NetsukukuRoute* _tmp34_;
						NetsukukuREM* _tmp35_;
						NetsukukuREM* _tmp36_;
						GType _tmp37_ = 0UL;
						_tmp34_ = best;
						_tmp35_ = netsukuku_route_get_rem (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp36_);
						_tmp32_ = _tmp37_ == NETSUKUKU_TYPE_DEAD_REM;
					}
					_tmp38_ = _tmp32_;
					if (_tmp38_) {
						_tmp31_ = TRUE;
					} else {
						NetsukukuRoute* _tmp39_;
						NetsukukuREM* _tmp40_;
						NetsukukuREM* _tmp41_;
						GType _tmp42_ = 0UL;
						_tmp39_ = best;
						_tmp40_ = netsukuku_route_get_rem (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp41_);
						_tmp31_ = _tmp42_ == NETSUKUKU_TYPE_ALMOST_DEAD_REM;
					}
					_tmp43_ = _tmp31_;
					if (_tmp43_) {
					} else {
						NetsukukuRoute* _tmp44_;
						NetsukukuREM* _tmp45_;
						NetsukukuREM* _tmp46_;
						GType _tmp47_ = 0UL;
						gint32 _tmp48_;
						NetsukukuRoute* _tmp49_;
						NetsukukuREM* _tmp50_;
						NetsukukuREM* _tmp51_;
						gint _tmp52_;
						gint _tmp53_;
						_tmp44_ = best;
						_tmp45_ = netsukuku_route_get_rem (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp46_);
						_vala_assert (_tmp47_ == NETSUKUKU_TYPE_RTT, "best.rem.get_type() == typeof(RTT)");
						_tmp48_ = probabilitysum;
						_tmp49_ = best;
						_tmp50_ = netsukuku_route_get_rem (_tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = netsukuku_rtt_get_delay (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, NETSUKUKU_TYPE_RTT) ? ((NetsukukuRTT*) _tmp51_) : NULL);
						_tmp53_ = _tmp52_;
						probabilitysum = _tmp48_ + (((gint32) 100000) / _tmp53_);
					}
					_g_object_unref0 (best);
				}
				_g_object_unref0 (rn);
				_g_object_unref0 (lvl_pos);
			}
			_tmp54_ = numbers;
			_tmp55_ = probabilitysum;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, (gpointer) ((gintptr) _tmp55_));
			_g_object_unref0 (nip);
		}
		_g_object_unref0 (_nip_list);
	}
	_tmp56_ = probabilitysum;
	_tmp57_ = g_random_int_range ((gint32) 0, _tmp56_);
	chosen = _tmp57_;
	pos = 0;
	{
		GeeList* _tmp58_;
		GeeList* _tmp59_;
		GeeList* _nip_list;
		GeeList* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		gint _nip_size;
		gint _nip_index;
		_tmp58_ = choose_from;
		_tmp59_ = _g_object_ref0 (_tmp58_);
		_nip_list = _tmp59_;
		_tmp60_ = _nip_list;
		_tmp61_ = gee_collection_get_size ((GeeCollection*) _tmp60_);
		_tmp62_ = _tmp61_;
		_nip_size = _tmp62_;
		_nip_index = -1;
		while (TRUE) {
			gint _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			GeeList* _tmp66_;
			gint _tmp67_;
			gpointer _tmp68_ = NULL;
			NetsukukuPartialNIP* nip;
			GeeArrayList* _tmp69_;
			gint _tmp70_;
			gpointer _tmp71_ = NULL;
			gint32 threshold;
			gint32 _tmp72_;
			gint32 _tmp73_;
			_tmp63_ = _nip_index;
			_nip_index = _tmp63_ + 1;
			_tmp64_ = _nip_index;
			_tmp65_ = _nip_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _nip_list;
			_tmp67_ = _nip_index;
			_tmp68_ = gee_list_get (_tmp66_, _tmp67_);
			nip = (NetsukukuPartialNIP*) _tmp68_;
			_tmp69_ = numbers;
			_tmp70_ = pos;
			pos = _tmp70_ + 1;
			_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, _tmp70_);
			threshold = (gint32) ((gintptr) _tmp71_);
			_tmp72_ = chosen;
			_tmp73_ = threshold;
			if (_tmp72_ <= _tmp73_) {
				result = nip;
				_g_object_unref0 (_nip_list);
				_g_object_unref0 (numbers);
				return result;
			}
			_g_object_unref0 (nip);
		}
		_g_object_unref0 (_nip_list);
	}
	result = NULL;
	_g_object_unref0 (numbers);
	return result;
}


NetsukukuPartialNIP* netsukuku_map_route_choose_fast (NetsukukuMapRoute* self, GeeList* choose_from) {
	NetsukukuPartialNIP* result = NULL;
	GeeList* _tmp0_;
	NetsukukuPartialNIP* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (choose_from != NULL, NULL);
	_tmp0_ = choose_from;
	_tmp1_ = netsukuku_map_route_choose_between (self, _tmp0_);
	result = _tmp1_;
	return result;
}


NetsukukuAddressManager* netsukuku_map_route_get_address_manager (NetsukukuMapRoute* self) {
	NetsukukuAddressManager* result;
	NetsukukuAddressManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address_manager;
	result = _tmp0_;
	return result;
}


static void netsukuku_map_route_set_address_manager (NetsukukuMapRoute* self, NetsukukuAddressManager* value) {
	NetsukukuAddressManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_address_manager = _tmp0_;
	g_object_notify ((GObject *) self, "address-manager");
}


NetsukukuGNodeID** netsukuku_map_route_get_id_myself (NetsukukuMapRoute* self, int* result_length1) {
	NetsukukuGNodeID** result;
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id_myself;
	_tmp0__length1 = self->priv->_id_myself_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static NetsukukuGNodeID** _vala_array_dup7 (NetsukukuGNodeID** self, int length) {
	NetsukukuGNodeID** result;
	int i;
	result = g_new0 (NetsukukuGNodeID*, length + 1);
	for (i = 0; i < length; i++) {
		NetsukukuGNodeID* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void netsukuku_map_route_set_id_myself (NetsukukuMapRoute* self, NetsukukuGNodeID** value, int value_length1) {
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup7 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_id_myself = (_vala_array_free (self->priv->_id_myself, self->priv->_id_myself_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_id_myself = _tmp1_;
	self->priv->_id_myself_length1 = _tmp1__length1;
	self->priv->__id_myself_size_ = self->priv->_id_myself_length1;
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
}


static void netsukuku_map_route_class_init (NetsukukuMapRouteClass * klass) {
	netsukuku_map_route_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuMapRoutePrivate));
	NETSUKUKU_MAP_CLASS (klass)->stop_operations = netsukuku_map_route_real_stop_operations;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_map_route_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_map_route_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_route_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_MAP_ROUTE_ADDRESS_MANAGER, g_param_spec_object ("address-manager", "address-manager", "address-manager", NETSUKUKU_TYPE_ADDRESS_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("routes_updated", NETSUKUKU_TYPE_MAP_ROUTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_HCOORD);
	g_signal_new ("gnode_splitted", NETSUKUKU_TYPE_MAP_ROUTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, GEE_TYPE_LIST, GEE_TYPE_LIST, NETSUKUKU_TYPE_GNODE_ID);
	g_signal_new ("id_gnode_changed", NETSUKUKU_TYPE_MAP_ROUTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void netsukuku_map_route_netsukuku_imap_route_interface_init (NetsukukuIMapRouteIface * iface) {
	netsukuku_map_route_netsukuku_imap_route_parent_iface = g_type_interface_peek_parent (iface);
	iface->report_routes = (GeeList* (*)(NetsukukuIMapRoute*, GError**)) netsukuku_map_route_real_report_routes;
	iface->report_gid_list = (GeeList* (*)(NetsukukuIMapRoute*, GError**)) netsukuku_map_route_real_report_gid_list;
	iface->report_yourself = (NetsukukuInfoNode* (*)(NetsukukuIMapRoute*, GError**)) netsukuku_map_route_real_report_yourself;
	iface->request_gid = (void (*)(NetsukukuIMapRoute*, gint, NetsukukuNetworkID*, NetsukukuPartialNIP*, GError**)) netsukuku_map_route_real_request_gid;
	iface->answer_gid = (void (*)(NetsukukuIMapRoute*, NetsukukuNIP*, gint, NetsukukuGNodeID*, GError**)) netsukuku_map_route_real_answer_gid;
	iface->worst_internal_bestrem = (NetsukukuREM* (*)(NetsukukuIMapRoute*, gint, GError**)) netsukuku_map_route_real_worst_internal_bestrem;
	iface->free_nodes_nb = (gint (*)(NetsukukuIMapRoute*, gint)) netsukuku_map_free_nodes_nb;
}


static void netsukuku_map_route_instance_init (NetsukukuMapRoute * self) {
	self->priv = NETSUKUKU_MAP_ROUTE_GET_PRIVATE (self);
}


static void netsukuku_map_route_finalize (GObject* obj) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	self->priv->_id_myself = (_vala_array_free (self->priv->_id_myself, self->priv->_id_myself_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->checking_gid);
	_g_object_unref0 (self->priv->check_gid_handle);
	G_OBJECT_CLASS (netsukuku_map_route_parent_class)->finalize (obj);
}


/** Map of routes, all of a same Rem type.
      *
      * MapRoute.node[lvl][id] is a RouteNode class, i.e. a list of routes
      * having as destination the node (lvl, id)
      */
GType netsukuku_map_route_get_type (void) {
	static volatile gsize netsukuku_map_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMapRoute), 0, (GInstanceInitFunc) netsukuku_map_route_instance_init, NULL };
		static const GInterfaceInfo netsukuku_imap_route_info = { (GInterfaceInitFunc) netsukuku_map_route_netsukuku_imap_route_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_map_route_type_id;
		netsukuku_map_route_type_id = g_type_register_static (NETSUKUKU_TYPE_MAP, "NetsukukuMapRoute", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_map_route_type_id, NETSUKUKU_TYPE_IMAP_ROUTE, &netsukuku_imap_route_info);
		g_once_init_leave (&netsukuku_map_route_type_id__volatile, netsukuku_map_route_type_id);
	}
	return netsukuku_map_route_type_id__volatile;
}


static void _vala_netsukuku_map_route_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	switch (property_id) {
		case NETSUKUKU_MAP_ROUTE_ADDRESS_MANAGER:
		g_value_set_object (value, netsukuku_map_route_get_address_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_map_route_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	switch (property_id) {
		case NETSUKUKU_MAP_ROUTE_ADDRESS_MANAGER:
		netsukuku_map_route_set_address_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



