/* coord.c generated by valac 0.20.1, the Vala compiler
 * generated from coord.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/*   peerbuilder.in
errors:
 HookingError
  INEXISTENT_GNODE
  GENERIC
 QspnError
  NOT_YOUR_GATEWAY
  ALREADY_UP_TO_DATE
  GENERIC
 PeerRefuseServiceError
  GENERIC
 TunnelError
  GENERIC
 BorderNodesError
  WRONG_GNODE
  NOT_BORDER_NODE
  WILL_NOT_TUNNEL
  TIMEOUT
  GENERIC
 AndnaError
  GENERIC
serializables:
 TimeCapsule
 ParticipantNode
 PackedParticipantNodes
 OptionalServiceParticipants
 SetOptionalServiceParticipants
 PeerToPeerTracerPacketList
 PairNipDistance
 BnodeRecord
 BnodeList
 PairLvlNumberOfFreeNodes
 HCoord
 PartialNIP
 NIP
 REM
 NullREM
 DeadREM
 AlmostDeadREM
 RTT
 TracerPacketList
 RouteInSet
 PositionInRoutesSetPerLevel
 RoutesSetPerLevel
 RoutesSet
 ExtendedTracerPacket
 GNodeID
 NetworkID
 InfoNeighbour
 InfoRoute
 InfoNode
 QspnStats
 InfoBorderNode
 PublicKey
 AndnaServiceKey
 AndnaServerRecord
 AndnaDomainRecord
 AndnaServer
 AndnaServers
 RegisterHostnameArguments
 CounterNipRecord
 CounterSetDataResponse
 CounterCheckHostnameResponse
 AndnaConfirmPubkResponse
 AndnaRegisterMainResponse
 AndnaRegisterSpreadResponse
 AndnaGetServersResponse
 AndnaGetRegistrarResponse
 AndnaGetCacheRecordsResponse
 CoordinatorBooking
 CoordinatorMemory
 CoordinatorReservation
 CoordinatorGetCacheRecordsResponse
 BroadcastID
 UnicastID
peers:
 Coordinator
  methods:
   CoordinatorReservation reserve
    arguments:
     PartialNIP gnode
    throws:
     PeerRefuseServiceError
     HookingError
   void backup_memory
    arguments:
     CoordinatorMemory mem
    throws:
   CoordinatorGetCacheRecordsResponse get_cache_records
    arguments:
    throws:
     PeerRefuseServiceError
*/

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <zcd.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <tasklet.h>


#define NETSUKUKU_TYPE_ICOORDINATOR_AS_PEER (netsukuku_icoordinator_as_peer_get_type ())
#define NETSUKUKU_ICOORDINATOR_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ICOORDINATOR_AS_PEER, NetsukukuICoordinatorAsPeer))
#define NETSUKUKU_IS_ICOORDINATOR_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ICOORDINATOR_AS_PEER))
#define NETSUKUKU_ICOORDINATOR_AS_PEER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_ICOORDINATOR_AS_PEER, NetsukukuICoordinatorAsPeerIface))

typedef struct _NetsukukuICoordinatorAsPeer NetsukukuICoordinatorAsPeer;
typedef struct _NetsukukuICoordinatorAsPeerIface NetsukukuICoordinatorAsPeerIface;

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_RMT_COORDINATOR_PEER (netsukuku_rmt_coordinator_peer_get_type ())
#define NETSUKUKU_RMT_COORDINATOR_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_COORDINATOR_PEER, NetsukukuRmtCoordinatorPeer))
#define NETSUKUKU_RMT_COORDINATOR_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_COORDINATOR_PEER, NetsukukuRmtCoordinatorPeerClass))
#define NETSUKUKU_IS_RMT_COORDINATOR_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_COORDINATOR_PEER))
#define NETSUKUKU_IS_RMT_COORDINATOR_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_COORDINATOR_PEER))
#define NETSUKUKU_RMT_COORDINATOR_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_COORDINATOR_PEER, NetsukukuRmtCoordinatorPeerClass))

typedef struct _NetsukukuRmtCoordinatorPeer NetsukukuRmtCoordinatorPeer;
typedef struct _NetsukukuRmtCoordinatorPeerClass NetsukukuRmtCoordinatorPeerClass;
typedef struct _NetsukukuRmtCoordinatorPeerPrivate NetsukukuRmtCoordinatorPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

#define NETSUKUKU_TYPE_COORDINATOR (netsukuku_coordinator_get_type ())
#define NETSUKUKU_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator))
#define NETSUKUKU_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))
#define NETSUKUKU_IS_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_IS_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_COORDINATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))

typedef struct _NetsukukuCoordinator NetsukukuCoordinator;
typedef struct _NetsukukuCoordinatorClass NetsukukuCoordinatorClass;
typedef struct _NetsukukuCoordinatorPrivate NetsukukuCoordinatorPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuICoordinatorAsPeerIface {
	GTypeInterface parent_iface;
	NetsukukuCoordinatorReservation* (*reserve) (NetsukukuICoordinatorAsPeer* self, NetsukukuPartialNIP* gnode, GError** error);
	void (*backup_memory) (NetsukukuICoordinatorAsPeer* self, NetsukukuCoordinatorMemory* mem, GError** error);
	NetsukukuCoordinatorGetCacheRecordsResponse* (*get_cache_records) (NetsukukuICoordinatorAsPeer* self, GError** error);
};

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtCoordinatorPeer {
	NetsukukuRmtPeer parent_instance;
	NetsukukuRmtCoordinatorPeerPrivate * priv;
};

struct _NetsukukuRmtCoordinatorPeerClass {
	NetsukukuRmtPeerClass parent_class;
};

struct _NetsukukuPeerToPeer {
	zcdRPCDispatcher parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	gint pid;
	gboolean has_valid_map;
};

struct _NetsukukuPeerToPeerClass {
	zcdRPCDispatcherClass parent_class;
	void (*start_operations) (NetsukukuPeerToPeer* self);
	void (*stop_operations) (NetsukukuPeerToPeer* self);
	gboolean (*is_participant) (NetsukukuPeerToPeer* self, gint lvl, gint pos);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuCoordinator {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuCoordinatorPrivate * priv;
	gboolean memory_initialized;
};

struct _NetsukukuCoordinatorClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuCoordinatorPrivate {
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	GeeArrayList* bookings;
	GeeArrayList* last_assigned_elderships;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()

static gpointer netsukuku_rmt_coordinator_peer_parent_class = NULL;
static NetsukukuICoordinatorAsPeerIface* netsukuku_rmt_coordinator_peer_netsukuku_icoordinator_as_peer_parent_iface = NULL;
static gpointer netsukuku_coordinator_parent_class = NULL;
static NetsukukuICoordinatorAsPeerIface* netsukuku_coordinator_netsukuku_icoordinator_as_peer_parent_iface = NULL;
static NetsukukuICoordinatorIface* netsukuku_coordinator_netsukuku_icoordinator_parent_iface = NULL;

GType netsukuku_icoordinator_as_peer_get_type (void) G_GNUC_CONST;
NetsukukuCoordinatorReservation* netsukuku_icoordinator_as_peer_reserve (NetsukukuICoordinatorAsPeer* self, NetsukukuPartialNIP* gnode, GError** error);
void netsukuku_icoordinator_as_peer_backup_memory (NetsukukuICoordinatorAsPeer* self, NetsukukuCoordinatorMemory* mem, GError** error);
NetsukukuCoordinatorGetCacheRecordsResponse* netsukuku_icoordinator_as_peer_get_cache_records (NetsukukuICoordinatorAsPeer* self, GError** error);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_rmt_coordinator_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_COORDINATOR_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtCoordinatorPeer* netsukuku_rmt_coordinator_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtCoordinatorPeer* netsukuku_rmt_coordinator_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static NetsukukuCoordinatorReservation* netsukuku_rmt_coordinator_peer_real_reserve (NetsukukuICoordinatorAsPeer* base, NetsukukuPartialNIP* gnode, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static void netsukuku_rmt_coordinator_peer_real_backup_memory (NetsukukuICoordinatorAsPeer* base, NetsukukuCoordinatorMemory* mem, GError** error);
static NetsukukuCoordinatorGetCacheRecordsResponse* netsukuku_rmt_coordinator_peer_real_get_cache_records (NetsukukuICoordinatorAsPeer* base, GError** error);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_coordinator_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_COORDINATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorPrivate))
enum  {
	NETSUKUKU_COORDINATOR_DUMMY_PROPERTY
};
#define NETSUKUKU_COORDINATOR_mypid 1
#define NETSUKUKU_COORDINATOR_DUPLICATION 10
NetsukukuCoordinator* netsukuku_coordinator_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuCoordinator* netsukuku_coordinator_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GQuark netsukuku_peer_to_peer_error_quark (void);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
static void netsukuku_coordinator_empty_cache (NetsukukuCoordinator* self);
void netsukuku_coordinator_init_memory (NetsukukuCoordinator* self);
static void _netsukuku_coordinator_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self);
gint netsukuku_map_get_levels (NetsukukuMap* self);
static gboolean _netsukuku_coordinator_booking_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void netsukuku_coordinator_update_cache (NetsukukuCoordinator* self);
static gboolean netsukuku_coordinator_bookings_contains (NetsukukuCoordinator* self, gint level_of_nodes, gint pos);
static NetsukukuCoordinatorMemory* netsukuku_coordinator_produce_memory (NetsukukuCoordinator* self);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
static void netsukuku_coordinator_reproduce_memory (NetsukukuCoordinator* self, NetsukukuCoordinatorMemory* mem);
NetsukukuRmtCoordinatorPeer* netsukuku_coordinator_peer (NetsukukuCoordinator* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static zcdISerializable* netsukuku_coordinator_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error);
static NetsukukuNIP* netsukuku_coordinator_nip_for_lvl_pos (NetsukukuCoordinator* self, gint lvl, gint pos);
static void netsukuku_coordinator_impl_init_memory (NetsukukuCoordinator* self, GError** error);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
void netsukuku_log_info (const gchar* msg);
static void __lambda2_ (NetsukukuCoordinator* self, GError** error);
void netsukuku_log_warn (const gchar* msg);
static void ___lambda2__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static NetsukukuNIP* netsukuku_coordinator_real_h (NetsukukuPeerToPeer* base, GObject* k);
static NetsukukuCoordinatorReservation* netsukuku_coordinator_real_reserve_into (NetsukukuICoordinator* base, NetsukukuPartialNIP* gnode, GError** error);
static NetsukukuCoordinatorInfo* netsukuku_coordinator_real_report_status (NetsukukuICoordinator* base, gint lvl, GError** error);
static NetsukukuCoordinatorReservation* netsukuku_coordinator_real_reserve (NetsukukuICoordinatorAsPeer* base, NetsukukuPartialNIP* gnode, GError** error);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
gint* netsukuku_map_free_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1);
NetsukukuGNodeID** netsukuku_map_route_get_gid_uppermost_list (NetsukukuMapRoute* self, gint level_of_gnode, int* result_length1);
static void __lambda3_ (NetsukukuCoordinator* self, GObject* tpar1, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error);
static void _____lambda4_ (NetsukukuCoordinator* self, GObject* tpar1, GError** error);
static void ______lambda4__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static void ___lambda3__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static NetsukukuGNodeID** _vala_array_dup2 (NetsukukuGNodeID** self, int length);
static void netsukuku_coordinator_real_backup_memory (NetsukukuICoordinatorAsPeer* base, NetsukukuCoordinatorMemory* mem, GError** error);
static NetsukukuCoordinatorGetCacheRecordsResponse* netsukuku_coordinator_real_get_cache_records (NetsukukuICoordinatorAsPeer* base, GError** error);
static void netsukuku_coordinator_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


NetsukukuCoordinatorReservation* netsukuku_icoordinator_as_peer_reserve (NetsukukuICoordinatorAsPeer* self, NetsukukuPartialNIP* gnode, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOORDINATOR_AS_PEER_GET_INTERFACE (self)->reserve (self, gnode, error);
}


void netsukuku_icoordinator_as_peer_backup_memory (NetsukukuICoordinatorAsPeer* self, NetsukukuCoordinatorMemory* mem, GError** error) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_ICOORDINATOR_AS_PEER_GET_INTERFACE (self)->backup_memory (self, mem, error);
}


NetsukukuCoordinatorGetCacheRecordsResponse* netsukuku_icoordinator_as_peer_get_cache_records (NetsukukuICoordinatorAsPeer* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOORDINATOR_AS_PEER_GET_INTERFACE (self)->get_cache_records (self, error);
}


static void netsukuku_icoordinator_as_peer_base_init (NetsukukuICoordinatorAsPeerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType netsukuku_icoordinator_as_peer_get_type (void) {
	static volatile gsize netsukuku_icoordinator_as_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_icoordinator_as_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuICoordinatorAsPeerIface), (GBaseInitFunc) netsukuku_icoordinator_as_peer_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType netsukuku_icoordinator_as_peer_type_id;
		netsukuku_icoordinator_as_peer_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetsukukuICoordinatorAsPeer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (netsukuku_icoordinator_as_peer_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&netsukuku_icoordinator_as_peer_type_id__volatile, netsukuku_icoordinator_as_peer_type_id);
	}
	return netsukuku_icoordinator_as_peer_type_id__volatile;
}


NetsukukuRmtCoordinatorPeer* netsukuku_rmt_coordinator_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCoordinatorPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	GObject* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuAggregatedNeighbour* _tmp3_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = key;
	_tmp2_ = hIP;
	_tmp3_ = aggregated_neighbour;
	self = (NetsukukuRmtCoordinatorPeer*) netsukuku_rmt_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NetsukukuRmtCoordinatorPeer* netsukuku_rmt_coordinator_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_coordinator_peer_construct (NETSUKUKU_TYPE_RMT_COORDINATOR_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static NetsukukuCoordinatorReservation* netsukuku_rmt_coordinator_peer_real_reserve (NetsukukuICoordinatorAsPeer* base, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuRmtCoordinatorPeer * self;
	NetsukukuCoordinatorReservation* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuPartialNIP* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordinatorPeer*) base;
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("reserve");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = gnode;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	{
		zcdRemoteCall* _tmp5_;
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_ = NULL;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_ = NULL;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_;
		zcdISerializable* _tmp16_;
		zcdISerializable* _tmp17_ = NULL;
		zcdISerializable* _tmp18_;
		zcdISerializable* _tmp19_;
		_tmp5_ = rc;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch27_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				goto __catch27_netsukuku_peer_refuse_service_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch27_netsukuku_hooking_error;
			}
			goto __catch27_g_error;
		}
		_tmp8_ = _tmp7_;
		_tmp9_ = netsukuku_filter_exception_HookingError (_tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch27_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				goto __catch27_netsukuku_peer_refuse_service_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch27_netsukuku_hooking_error;
			}
			goto __catch27_g_error;
		}
		_tmp12_ = _tmp11_;
		_tmp13_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp12_, &_inner_error_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch27_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				goto __catch27_netsukuku_peer_refuse_service_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch27_netsukuku_hooking_error;
			}
			goto __catch27_g_error;
		}
		_tmp16_ = _tmp15_;
		_tmp17_ = zcd_filter_exception (_tmp16_, &_inner_error_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch27_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				goto __catch27_netsukuku_peer_refuse_service_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch27_netsukuku_hooking_error;
			}
			goto __catch27_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, NETSUKUKU_TYPE_COORDINATOR_RESERVATION, NetsukukuCoordinatorReservation);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally27;
	__catch27_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		GError* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _g_error_copy0 (_tmp20_);
		_inner_error_ = _tmp21_;
		_g_error_free0 (e);
		goto __finally27;
	}
	goto __finally27;
	__catch27_netsukuku_peer_refuse_service_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally27;
	}
	goto __finally27;
	__catch27_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GError* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _g_error_copy0 (_tmp24_);
		_inner_error_ = _tmp25_;
		_g_error_free0 (e);
		goto __finally27;
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		GQuark _tmp27_;
		const gchar* _tmp28_ = NULL;
		GError* _tmp29_;
		gint _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		GError* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		GError* _tmp38_;
		GError* _tmp39_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->domain;
		_tmp28_ = g_quark_to_string (_tmp27_);
		_tmp29_ = e;
		_tmp30_ = _tmp29_->code;
		_tmp31_ = g_strdup_printf ("%i", _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		_tmp35_ = string_to_string (_tmp34_);
		_tmp36_ = g_strconcat ("Unexpected error ", _tmp28_, ".", _tmp32_, " '", _tmp35_, "'", NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp37_);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp37_);
		_g_free0 (_tmp32_);
		_inner_error_ = _tmp39_;
		_g_error_free0 (e);
		goto __finally27;
	}
	__finally27:
	if (((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) || (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_coordinator_peer_real_backup_memory (NetsukukuICoordinatorAsPeer* base, NetsukukuCoordinatorMemory* mem, GError** error) {
	NetsukukuRmtCoordinatorPeer * self;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuCoordinatorMemory* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordinatorPeer*) base;
	g_return_if_fail (mem != NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("backup_memory");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = mem;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	{
		zcdRemoteCall* _tmp5_;
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_ = NULL;
		zcdISerializable* _tmp10_;
		_tmp5_ = rc;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch28_zcd_rpc_error;
			}
			goto __catch28_g_error;
		}
		_tmp8_ = _tmp7_;
		_tmp9_ = zcd_filter_exception (_tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch28_zcd_rpc_error;
			}
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		GError* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _g_error_copy0 (_tmp11_);
		_inner_error_ = _tmp12_;
		_g_error_free0 (e);
		goto __finally28;
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		GQuark _tmp14_;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		GError* _tmp25_;
		GError* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->domain;
		_tmp15_ = g_quark_to_string (_tmp14_);
		_tmp16_ = e;
		_tmp17_ = _tmp16_->code;
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = g_strconcat ("Unexpected error ", _tmp15_, ".", _tmp19_, " '", _tmp22_, "'", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp24_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp19_);
		_inner_error_ = _tmp26_;
		_g_error_free0 (e);
		goto __finally28;
	}
	__finally28:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rc);
			return;
		} else {
			_g_object_unref0 (rc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (rc);
}


static NetsukukuCoordinatorGetCacheRecordsResponse* netsukuku_rmt_coordinator_peer_real_get_cache_records (NetsukukuICoordinatorAsPeer* base, GError** error) {
	NetsukukuRmtCoordinatorPeer * self;
	NetsukukuCoordinatorGetCacheRecordsResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordinatorPeer*) base;
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_cache_records");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	{
		zcdRemoteCall* _tmp3_;
		zcdISerializable* _tmp4_ = NULL;
		zcdISerializable* _tmp5_;
		zcdISerializable* _tmp6_;
		zcdISerializable* _tmp7_ = NULL;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		_tmp3_ = rc;
		_tmp4_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch29_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				goto __catch29_netsukuku_peer_refuse_service_error;
			}
			goto __catch29_g_error;
		}
		_tmp6_ = _tmp5_;
		_tmp7_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch29_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				goto __catch29_netsukuku_peer_refuse_service_error;
			}
			goto __catch29_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = zcd_filter_exception (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch29_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				goto __catch29_netsukuku_peer_refuse_service_error;
			}
			goto __catch29_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, NETSUKUKU_TYPE_COORDINATOR_GET_CACHE_RECORDS_RESPONSE, NetsukukuCoordinatorGetCacheRecordsResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally29;
	__catch29_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally29;
	}
	goto __finally29;
	__catch29_netsukuku_peer_refuse_service_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GError* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _g_error_copy0 (_tmp16_);
		_inner_error_ = _tmp17_;
		_g_error_free0 (e);
		goto __finally29;
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		GQuark _tmp19_;
		const gchar* _tmp20_ = NULL;
		GError* _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		GError* _tmp30_;
		GError* _tmp31_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->domain;
		_tmp20_ = g_quark_to_string (_tmp19_);
		_tmp21_ = e;
		_tmp22_ = _tmp21_->code;
		_tmp23_ = g_strdup_printf ("%i", _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = string_to_string (_tmp26_);
		_tmp28_ = g_strconcat ("Unexpected error ", _tmp20_, ".", _tmp24_, " '", _tmp27_, "'", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp29_);
		_tmp31_ = _tmp30_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp24_);
		_inner_error_ = _tmp31_;
		_g_error_free0 (e);
		goto __finally29;
	}
	__finally29:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_coordinator_peer_class_init (NetsukukuRmtCoordinatorPeerClass * klass) {
	netsukuku_rmt_coordinator_peer_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_rmt_coordinator_peer_netsukuku_icoordinator_as_peer_interface_init (NetsukukuICoordinatorAsPeerIface * iface) {
	netsukuku_rmt_coordinator_peer_netsukuku_icoordinator_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->reserve = (NetsukukuCoordinatorReservation* (*)(NetsukukuICoordinatorAsPeer*, NetsukukuPartialNIP*, GError**)) netsukuku_rmt_coordinator_peer_real_reserve;
	iface->backup_memory = (void (*)(NetsukukuICoordinatorAsPeer*, NetsukukuCoordinatorMemory*, GError**)) netsukuku_rmt_coordinator_peer_real_backup_memory;
	iface->get_cache_records = (NetsukukuCoordinatorGetCacheRecordsResponse* (*)(NetsukukuICoordinatorAsPeer*, GError**)) netsukuku_rmt_coordinator_peer_real_get_cache_records;
}


static void netsukuku_rmt_coordinator_peer_instance_init (NetsukukuRmtCoordinatorPeer * self) {
}


GType netsukuku_rmt_coordinator_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_coordinator_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_coordinator_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtCoordinatorPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_coordinator_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtCoordinatorPeer), 0, (GInstanceInitFunc) netsukuku_rmt_coordinator_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icoordinator_as_peer_info = { (GInterfaceInitFunc) netsukuku_rmt_coordinator_peer_netsukuku_icoordinator_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_rmt_coordinator_peer_type_id;
		netsukuku_rmt_coordinator_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_RMT_PEER, "NetsukukuRmtCoordinatorPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_rmt_coordinator_peer_type_id, NETSUKUKU_TYPE_ICOORDINATOR_AS_PEER, &netsukuku_icoordinator_as_peer_info);
		g_once_init_leave (&netsukuku_rmt_coordinator_peer_type_id__volatile, netsukuku_rmt_coordinator_peer_type_id);
	}
	return netsukuku_rmt_coordinator_peer_type_id__volatile;
}


static void _netsukuku_coordinator_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self) {
	netsukuku_coordinator_init_memory (self);
}


NetsukukuCoordinator* netsukuku_coordinator_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	NetsukukuCoordinator * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	self = (NetsukukuCoordinator*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, NETSUKUKU_COORDINATOR_mypid);
	{
		NetsukukuPeerToPeerAll* _tmp2_;
		_tmp2_ = peer_to_peer_all;
		netsukuku_peer_to_peer_all_peer_to_peer_register (_tmp2_, (NetsukukuPeerToPeer*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				goto __catch30_netsukuku_peer_to_peer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally30;
	__catch30_netsukuku_peer_to_peer_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("Coordinator service: registering failed: ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		g_error ("coord.vala:241: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally30:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	netsukuku_coordinator_empty_cache (self);
	self->memory_initialized = FALSE;
	g_signal_connect_object ((NetsukukuPeerToPeer*) self, "map-peer-to-peer-validated", (GCallback) _netsukuku_coordinator_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated, self, 0);
	return self;
}


NetsukukuCoordinator* netsukuku_coordinator_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	return netsukuku_coordinator_construct (NETSUKUKU_TYPE_COORDINATOR, aggregated_neighbour_manager, maproute, peer_to_peer_all);
}


static gboolean _netsukuku_coordinator_booking_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_coordinator_booking_equal_func (a, b);
	return result;
}


static void netsukuku_coordinator_empty_cache (NetsukukuCoordinator* self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->bookings);
	self->priv->bookings = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->last_assigned_elderships);
	self->priv->last_assigned_elderships = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				NetsukukuMapRoute* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				GeeArrayList* _tmp9_;
				GeeLinkedList* _tmp10_;
				GeeLinkedList* _tmp11_;
				GeeArrayList* _tmp12_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp7_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = self->priv->bookings;
				_tmp10_ = gee_linked_list_new (NETSUKUKU_TYPE_COORDINATOR_BOOKING, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_coordinator_booking_equal_func_gee_equal_data_func, NULL, NULL);
				_tmp11_ = _tmp10_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp11_);
				_g_object_unref0 (_tmp11_);
				_tmp12_ = self->priv->last_assigned_elderships;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (gpointer) ((gintptr) 0));
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void netsukuku_coordinator_update_cache (NetsukukuCoordinator* self) {
	g_return_if_fail (self != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				NetsukukuMapRoute* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GeeArrayList* _tmp7_;
				GeeArrayList* to_del;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp5_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = gee_array_list_new (NETSUKUKU_TYPE_COORDINATOR_BOOKING, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				to_del = _tmp7_;
				{
					GeeArrayList* _tmp8_;
					gint _tmp9_;
					gpointer _tmp10_ = NULL;
					GeeLinkedList* _b_list;
					GeeLinkedList* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					gint _b_size;
					gint _b_index;
					_tmp8_ = self->priv->bookings;
					_tmp9_ = i;
					_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
					_b_list = (GeeLinkedList*) _tmp10_;
					_tmp11_ = _b_list;
					_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
					_tmp13_ = _tmp12_;
					_b_size = _tmp13_;
					_b_index = -1;
					while (TRUE) {
						gint _tmp14_;
						gint _tmp15_;
						gint _tmp16_;
						GeeLinkedList* _tmp17_;
						gint _tmp18_;
						gpointer _tmp19_ = NULL;
						NetsukukuCoordinatorBooking* b;
						NetsukukuCoordinatorBooking* _tmp20_;
						NetsukukuTimeCapsule* _tmp21_;
						NetsukukuTimeCapsule* _tmp22_;
						gboolean _tmp23_ = FALSE;
						_tmp14_ = _b_index;
						_b_index = _tmp14_ + 1;
						_tmp15_ = _b_index;
						_tmp16_ = _b_size;
						if (!(_tmp15_ < _tmp16_)) {
							break;
						}
						_tmp17_ = _b_list;
						_tmp18_ = _b_index;
						_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
						b = (NetsukukuCoordinatorBooking*) _tmp19_;
						_tmp20_ = b;
						_tmp21_ = netsukuku_coordinator_booking_get_tc_expire (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp22_);
						if (_tmp23_) {
							GeeArrayList* _tmp24_;
							NetsukukuCoordinatorBooking* _tmp25_;
							_tmp24_ = to_del;
							_tmp25_ = b;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
						}
						_g_object_unref0 (b);
					}
					_g_object_unref0 (_b_list);
				}
				{
					GeeArrayList* _tmp26_;
					GeeArrayList* _tmp27_;
					GeeArrayList* _b_list;
					GeeArrayList* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gint _b_size;
					gint _b_index;
					_tmp26_ = to_del;
					_tmp27_ = _g_object_ref0 (_tmp26_);
					_b_list = _tmp27_;
					_tmp28_ = _b_list;
					_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp28_);
					_tmp30_ = _tmp29_;
					_b_size = _tmp30_;
					_b_index = -1;
					while (TRUE) {
						gint _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						GeeArrayList* _tmp34_;
						gint _tmp35_;
						gpointer _tmp36_ = NULL;
						NetsukukuCoordinatorBooking* b;
						GeeArrayList* _tmp37_;
						gint _tmp38_;
						gpointer _tmp39_ = NULL;
						GeeLinkedList* _tmp40_;
						NetsukukuCoordinatorBooking* _tmp41_;
						_tmp31_ = _b_index;
						_b_index = _tmp31_ + 1;
						_tmp32_ = _b_index;
						_tmp33_ = _b_size;
						if (!(_tmp32_ < _tmp33_)) {
							break;
						}
						_tmp34_ = _b_list;
						_tmp35_ = _b_index;
						_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
						b = (NetsukukuCoordinatorBooking*) _tmp36_;
						_tmp37_ = self->priv->bookings;
						_tmp38_ = i;
						_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _tmp38_);
						_tmp40_ = (GeeLinkedList*) _tmp39_;
						_tmp41_ = b;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp40_, _tmp41_);
						_g_object_unref0 (_tmp40_);
						_g_object_unref0 (b);
					}
					_g_object_unref0 (_b_list);
				}
				_g_object_unref0 (to_del);
			}
		}
	}
}


static gboolean netsukuku_coordinator_bookings_contains (NetsukukuCoordinator* self, gint level_of_nodes, gint pos) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	{
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gpointer _tmp2_ = NULL;
		GeeLinkedList* _b0_list;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _b0_size;
		gint _b0_index;
		_tmp0_ = self->priv->bookings;
		_tmp1_ = level_of_nodes;
		_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, _tmp1_);
		_b0_list = (GeeLinkedList*) _tmp2_;
		_tmp3_ = _b0_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_b0_size = _tmp5_;
		_b0_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			NetsukukuCoordinatorBooking* b0;
			NetsukukuCoordinatorBooking* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp6_ = _b0_index;
			_b0_index = _tmp6_ + 1;
			_tmp7_ = _b0_index;
			_tmp8_ = _b0_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _b0_list;
			_tmp10_ = _b0_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			b0 = (NetsukukuCoordinatorBooking*) _tmp11_;
			_tmp12_ = b0;
			_tmp13_ = netsukuku_coordinator_booking_get_pos (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = pos;
			if (_tmp14_ == _tmp15_) {
				found = TRUE;
				_g_object_unref0 (b0);
				break;
			}
			_g_object_unref0 (b0);
		}
		_g_object_unref0 (_b0_list);
	}
	result = found;
	return result;
}


static NetsukukuCoordinatorMemory* netsukuku_coordinator_produce_memory (NetsukukuCoordinator* self) {
	NetsukukuCoordinatorMemory* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuCoordinatorMemory* _tmp3_;
	NetsukukuCoordinatorMemory* ret;
	g_return_val_if_fail (self != NULL, NULL);
	netsukuku_coordinator_update_cache (self);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_coordinator_memory_new (_tmp2_);
	ret = _tmp3_;
	{
		gint l;
		l = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				NetsukukuMapRoute* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				NetsukukuMapRoute* _tmp11_;
				NetsukukuNIP* _tmp12_;
				NetsukukuNIP* _tmp13_;
				gint _tmp14_;
				NetsukukuPartialNIP* _tmp15_ = NULL;
				NetsukukuPartialNIP* gnode;
				NetsukukuCoordinatorMemory* _tmp16_;
				NetsukukuPartialNIP* _tmp17_;
				GeeArrayList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_ = NULL;
				GeeArrayList* _tmp21_;
				gint _tmp22_;
				gpointer _tmp23_ = NULL;
				GeeLinkedList* _tmp24_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = l;
					l = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = l;
				_tmp8_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp9_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp12_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = l;
				_tmp15_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp13_, _tmp14_ + 1);
				gnode = _tmp15_;
				_tmp16_ = ret;
				_tmp17_ = gnode;
				_tmp18_ = self->priv->last_assigned_elderships;
				_tmp19_ = l;
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
				_tmp21_ = self->priv->bookings;
				_tmp22_ = l;
				_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp22_);
				_tmp24_ = (GeeLinkedList*) _tmp23_;
				netsukuku_coordinator_memory_set_gnode (_tmp16_, _tmp17_, (gint) ((gintptr) _tmp20_), (GeeList*) _tmp24_);
				_g_object_unref0 (_tmp24_);
				_g_object_unref0 (gnode);
			}
		}
	}
	result = ret;
	return result;
}


static void netsukuku_coordinator_reproduce_memory (NetsukukuCoordinator* self, NetsukukuCoordinatorMemory* mem) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mem != NULL);
	{
		NetsukukuCoordinatorMemory* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _gnode_it;
		_tmp0_ = mem;
		_tmp1_ = netsukuku_coordinator_memory_get_keys (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_gnode_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GeeIterator* _tmp6_;
			gpointer _tmp7_ = NULL;
			NetsukukuPartialNIP* gnode;
			NetsukukuMapRoute* _tmp8_;
			NetsukukuNIP* _tmp9_;
			NetsukukuNIP* _tmp10_;
			NetsukukuPartialNIP* _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp4_ = _gnode_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _gnode_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			gnode = (NetsukukuPartialNIP*) _tmp7_;
			_tmp8_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp9_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gnode;
			_tmp12_ = netsukuku_partial_nip_belongs_to ((NetsukukuPartialNIP*) _tmp10_, _tmp11_);
			if (_tmp12_) {
				NetsukukuPartialNIP* _tmp13_;
				gint _tmp14_ = 0;
				gint l;
				NetsukukuCoordinatorMemory* _tmp15_;
				NetsukukuPartialNIP* _tmp16_;
				gint _tmp17_ = 0;
				gint new_last_assigned_eldership;
				GeeArrayList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_ = NULL;
				gint _tmp21_;
				_tmp13_ = gnode;
				_tmp14_ = netsukuku_partial_nip_level_of_gnode (_tmp13_);
				l = _tmp14_ - 1;
				_tmp15_ = mem;
				_tmp16_ = gnode;
				_tmp17_ = netsukuku_coordinator_memory_get_last_assigned_eldership (_tmp15_, _tmp16_);
				new_last_assigned_eldership = _tmp17_;
				_tmp18_ = self->priv->last_assigned_elderships;
				_tmp19_ = l;
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
				_tmp21_ = new_last_assigned_eldership;
				if (((gint) ((gintptr) _tmp20_)) < _tmp21_) {
					GeeArrayList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					_tmp22_ = self->priv->last_assigned_elderships;
					_tmp23_ = l;
					_tmp24_ = new_last_assigned_eldership;
					gee_abstract_list_set ((GeeAbstractList*) _tmp22_, _tmp23_, (gpointer) ((gintptr) _tmp24_));
				}
				{
					NetsukukuCoordinatorMemory* _tmp25_;
					NetsukukuPartialNIP* _tmp26_;
					GeeList* _tmp27_ = NULL;
					GeeList* _b_list;
					GeeList* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gint _b_size;
					gint _b_index;
					_tmp25_ = mem;
					_tmp26_ = gnode;
					_tmp27_ = netsukuku_coordinator_memory_get_bookings (_tmp25_, _tmp26_);
					_b_list = _tmp27_;
					_tmp28_ = _b_list;
					_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
					_tmp30_ = _tmp29_;
					_b_size = _tmp30_;
					_b_index = -1;
					while (TRUE) {
						gint _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						GeeList* _tmp34_;
						gint _tmp35_;
						gpointer _tmp36_ = NULL;
						NetsukukuCoordinatorBooking* b;
						gboolean found;
						gboolean _tmp72_;
						_tmp31_ = _b_index;
						_b_index = _tmp31_ + 1;
						_tmp32_ = _b_index;
						_tmp33_ = _b_size;
						if (!(_tmp32_ < _tmp33_)) {
							break;
						}
						_tmp34_ = _b_list;
						_tmp35_ = _b_index;
						_tmp36_ = gee_list_get (_tmp34_, _tmp35_);
						b = (NetsukukuCoordinatorBooking*) _tmp36_;
						found = FALSE;
						{
							GeeArrayList* _tmp37_;
							gint _tmp38_;
							gpointer _tmp39_ = NULL;
							GeeLinkedList* _b0_list;
							GeeLinkedList* _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							gint _b0_size;
							gint _b0_index;
							_tmp37_ = self->priv->bookings;
							_tmp38_ = l;
							_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _tmp38_);
							_b0_list = (GeeLinkedList*) _tmp39_;
							_tmp40_ = _b0_list;
							_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
							_tmp42_ = _tmp41_;
							_b0_size = _tmp42_;
							_b0_index = -1;
							while (TRUE) {
								gint _tmp43_;
								gint _tmp44_;
								gint _tmp45_;
								GeeLinkedList* _tmp46_;
								gint _tmp47_;
								gpointer _tmp48_ = NULL;
								NetsukukuCoordinatorBooking* b0;
								NetsukukuCoordinatorBooking* _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
								NetsukukuCoordinatorBooking* _tmp52_;
								gint _tmp53_;
								gint _tmp54_;
								_tmp43_ = _b0_index;
								_b0_index = _tmp43_ + 1;
								_tmp44_ = _b0_index;
								_tmp45_ = _b0_size;
								if (!(_tmp44_ < _tmp45_)) {
									break;
								}
								_tmp46_ = _b0_list;
								_tmp47_ = _b0_index;
								_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _tmp47_);
								b0 = (NetsukukuCoordinatorBooking*) _tmp48_;
								_tmp49_ = b0;
								_tmp50_ = netsukuku_coordinator_booking_get_pos (_tmp49_);
								_tmp51_ = _tmp50_;
								_tmp52_ = b;
								_tmp53_ = netsukuku_coordinator_booking_get_pos (_tmp52_);
								_tmp54_ = _tmp53_;
								if (_tmp51_ == _tmp54_) {
									NetsukukuCoordinatorBooking* _tmp55_;
									NetsukukuTimeCapsule* _tmp56_;
									NetsukukuTimeCapsule* _tmp57_;
									NetsukukuCoordinatorBooking* _tmp58_;
									NetsukukuTimeCapsule* _tmp59_;
									NetsukukuTimeCapsule* _tmp60_;
									gboolean _tmp61_ = FALSE;
									found = TRUE;
									_tmp55_ = b0;
									_tmp56_ = netsukuku_coordinator_booking_get_tc_expire (_tmp55_);
									_tmp57_ = _tmp56_;
									_tmp58_ = b;
									_tmp59_ = netsukuku_coordinator_booking_get_tc_expire (_tmp58_);
									_tmp60_ = _tmp59_;
									_tmp61_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp57_, (TaskletsTimer*) _tmp60_);
									if (_tmp61_) {
										GeeArrayList* _tmp62_;
										gint _tmp63_;
										gpointer _tmp64_ = NULL;
										GeeLinkedList* _tmp65_;
										NetsukukuCoordinatorBooking* _tmp66_;
										GeeArrayList* _tmp67_;
										gint _tmp68_;
										gpointer _tmp69_ = NULL;
										GeeLinkedList* _tmp70_;
										NetsukukuCoordinatorBooking* _tmp71_;
										_tmp62_ = self->priv->bookings;
										_tmp63_ = l;
										_tmp64_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, _tmp63_);
										_tmp65_ = (GeeLinkedList*) _tmp64_;
										_tmp66_ = b0;
										gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp65_, _tmp66_);
										_g_object_unref0 (_tmp65_);
										_tmp67_ = self->priv->bookings;
										_tmp68_ = l;
										_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp67_, _tmp68_);
										_tmp70_ = (GeeLinkedList*) _tmp69_;
										_tmp71_ = b;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, _tmp71_);
										_g_object_unref0 (_tmp70_);
									}
									_g_object_unref0 (b0);
									break;
								}
								_g_object_unref0 (b0);
							}
							_g_object_unref0 (_b0_list);
						}
						_tmp72_ = found;
						if (!_tmp72_) {
							GeeArrayList* _tmp73_;
							gint _tmp74_;
							gpointer _tmp75_ = NULL;
							GeeLinkedList* _tmp76_;
							NetsukukuCoordinatorBooking* _tmp77_;
							_tmp73_ = self->priv->bookings;
							_tmp74_ = l;
							_tmp75_ = gee_abstract_list_get ((GeeAbstractList*) _tmp73_, _tmp74_);
							_tmp76_ = (GeeLinkedList*) _tmp75_;
							_tmp77_ = b;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, _tmp77_);
							_g_object_unref0 (_tmp76_);
						}
						_g_object_unref0 (b);
					}
					_g_object_unref0 (_b_list);
				}
			}
			_g_object_unref0 (gnode);
		}
		_g_object_unref0 (_gnode_it);
	}
}


NetsukukuRmtCoordinatorPeer* netsukuku_coordinator_peer (NetsukukuCoordinator* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCoordinatorPeer* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuNIP* _tmp1_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuRmtCoordinatorPeer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = hIP;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = _tmp2_ != NULL;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "hIP != null || key != null");
	_tmp4_ = key;
	_tmp5_ = hIP;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = netsukuku_rmt_coordinator_peer_new ((NetsukukuPeerToPeer*) self, _tmp4_, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


/** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
static zcdISerializable* netsukuku_coordinator_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error) {
	NetsukukuCoordinator * self;
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** pieces;
	gint pieces_length1;
	gint _pieces_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	const gchar* _tmp50_;
	GObject* _tmp61_;
	zcdRemoteCall* _tmp62_;
	zcdISerializable* _tmp63_ = NULL;
	zcdISerializable* _tmp64_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoordinator*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->method_name;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	pieces = _tmp3_;
	pieces_length1 = _vala_array_length (_tmp2_);
	_pieces_size_ = pieces_length1;
	_tmp4_ = pieces;
	_tmp4__length1 = pieces_length1;
	_tmp5_ = _tmp4_[0];
	if (g_strcmp0 (_tmp5_, "reserve") == 0) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		zcdRemoteCall* _tmp8_;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		zcdRemoteCall* _tmp14_;
		GeeList* _tmp15_;
		GeeList* _tmp16_;
		gpointer _tmp17_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp18_;
		GType _tmp19_ = 0UL;
		gboolean _tmp20_ = FALSE;
		zcdISerializable* _tmp22_;
		NetsukukuPartialNIP* _tmp23_;
		NetsukukuPartialNIP* gnode;
		NetsukukuPartialNIP* _tmp24_;
		NetsukukuCoordinatorReservation* _tmp25_ = NULL;
		NetsukukuCoordinatorReservation* _tmp26_;
		_tmp6_ = pieces;
		_tmp6__length1 = pieces_length1;
		if (_tmp6__length1 != 1) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve is a function.");
			_inner_error_ = _tmp7_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp8_ = data;
		_tmp9_ = zcd_remote_call_get_parameters (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != 1) {
			GError* _tmp13_;
			_tmp13_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve wants 1 parameter.");
			_inner_error_ = _tmp13_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp14_ = data;
		_tmp15_ = zcd_remote_call_get_parameters (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_list_get (_tmp16_, 0);
		iser0 = (zcdISerializable*) _tmp17_;
		_tmp18_ = iser0;
		_tmp19_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp18_);
		_tmp20_ = g_type_is_a (_tmp19_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp20_) {
			GError* _tmp21_;
			_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp21_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp22_ = iser0;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp23_;
		_tmp24_ = gnode;
		_tmp25_ = netsukuku_icoordinator_as_peer_reserve ((NetsukukuICoordinatorAsPeer*) self, _tmp24_, &_inner_error_);
		_tmp26_ = _tmp25_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp26_;
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp27_ = pieces;
	_tmp27__length1 = pieces_length1;
	_tmp28_ = _tmp27_[0];
	if (g_strcmp0 (_tmp28_, "backup_memory") == 0) {
		gchar** _tmp29_;
		gint _tmp29__length1;
		zcdRemoteCall* _tmp31_;
		GeeList* _tmp32_;
		GeeList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		zcdRemoteCall* _tmp37_;
		GeeList* _tmp38_;
		GeeList* _tmp39_;
		gpointer _tmp40_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp41_;
		GType _tmp42_ = 0UL;
		gboolean _tmp43_ = FALSE;
		zcdISerializable* _tmp45_;
		NetsukukuCoordinatorMemory* _tmp46_;
		NetsukukuCoordinatorMemory* mem;
		NetsukukuCoordinatorMemory* _tmp47_;
		zcdSerializableNone* _tmp48_;
		_tmp29_ = pieces;
		_tmp29__length1 = pieces_length1;
		if (_tmp29__length1 != 1) {
			GError* _tmp30_;
			_tmp30_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "backup_memory is a function.");
			_inner_error_ = _tmp30_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp31_ = data;
		_tmp32_ = zcd_remote_call_get_parameters (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = gee_collection_get_size ((GeeCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ != 1) {
			GError* _tmp36_;
			_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "backup_memory wants 1 parameter.");
			_inner_error_ = _tmp36_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp37_ = data;
		_tmp38_ = zcd_remote_call_get_parameters (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = gee_list_get (_tmp39_, 0);
		iser0 = (zcdISerializable*) _tmp40_;
		_tmp41_ = iser0;
		_tmp42_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp41_);
		_tmp43_ = g_type_is_a (_tmp42_, NETSUKUKU_TYPE_COORDINATOR_MEMORY);
		if (!_tmp43_) {
			GError* _tmp44_;
			_tmp44_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "backup_memory parameter 1 is not a CoordinatorMemory.");
			_inner_error_ = _tmp44_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp45_ = iser0;
		_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, NETSUKUKU_TYPE_COORDINATOR_MEMORY, NetsukukuCoordinatorMemory));
		mem = _tmp46_;
		_tmp47_ = mem;
		netsukuku_icoordinator_as_peer_backup_memory ((NetsukukuICoordinatorAsPeer*) self, _tmp47_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (mem);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp48_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp48_;
		_g_object_unref0 (mem);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp49_ = pieces;
	_tmp49__length1 = pieces_length1;
	_tmp50_ = _tmp49_[0];
	if (g_strcmp0 (_tmp50_, "get_cache_records") == 0) {
		gchar** _tmp51_;
		gint _tmp51__length1;
		zcdRemoteCall* _tmp53_;
		GeeList* _tmp54_;
		GeeList* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		NetsukukuCoordinatorGetCacheRecordsResponse* _tmp59_ = NULL;
		NetsukukuCoordinatorGetCacheRecordsResponse* _tmp60_;
		_tmp51_ = pieces;
		_tmp51__length1 = pieces_length1;
		if (_tmp51__length1 != 1) {
			GError* _tmp52_;
			_tmp52_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records is a function.");
			_inner_error_ = _tmp52_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp53_ = data;
		_tmp54_ = zcd_remote_call_get_parameters (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = gee_collection_get_size ((GeeCollection*) _tmp55_);
		_tmp57_ = _tmp56_;
		if (_tmp57_ != 0) {
			GError* _tmp58_;
			_tmp58_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records wants no parameters.");
			_inner_error_ = _tmp58_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp59_ = netsukuku_icoordinator_as_peer_get_cache_records ((NetsukukuICoordinatorAsPeer*) self, &_inner_error_);
		_tmp60_ = _tmp59_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp60_;
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp61_ = caller;
	_tmp62_ = data;
	_tmp63_ = ZCD_RPC_DISPATCHER_CLASS (netsukuku_coordinator_parent_class)->_dispatch ((zcdRPCDispatcher*) G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer), _tmp61_, _tmp62_, &_inner_error_);
	_tmp64_ = _tmp63_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = _tmp64_;
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static NetsukukuNIP* netsukuku_coordinator_nip_for_lvl_pos (NetsukukuCoordinator* self, gint lvl, gint pos) {
	NetsukukuNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint* ret;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NetsukukuNIP* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp2_, &_tmp3_);
	ret = _tmp4_;
	ret_length1 = _tmp3_;
	_ret_size_ = ret_length1;
	_tmp5_ = lvl;
	_tmp6_ = pos;
	ret[_tmp5_] = _tmp6_;
	_tmp7_ = ret[_tmp5_];
	_tmp8_ = netsukuku_nip_new (ret, ret_length1);
	result = _tmp8_;
	ret = (g_free (ret), NULL);
	return result;
}


static void netsukuku_coordinator_impl_init_memory (NetsukukuCoordinator* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coordinator.init_memory");
	netsukuku_coordinator_empty_cache (self);
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				NetsukukuMapRoute* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint* first_forward = NULL;
				gint* first_back = NULL;
				gint* last_back = NULL;
				gint _tmp7_;
				gint* _tmp8_ = NULL;
				gint* _tmp9_ = NULL;
				gint* _tmp10_ = NULL;
				gint* _tmp11_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = lvl;
					lvl = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = lvl;
				_tmp4_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp5_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = lvl;
				netsukuku_peer_to_peer_find_hook_peers ((NetsukukuPeerToPeer*) self, &_tmp8_, &_tmp9_, &_tmp10_, _tmp7_, NETSUKUKU_COORDINATOR_DUPLICATION, 120000);
				_g_free0 (first_forward);
				first_forward = _tmp8_;
				_g_free0 (first_back);
				first_back = _tmp9_;
				_g_free0 (last_back);
				last_back = _tmp10_;
				_tmp11_ = first_forward;
				if (_tmp11_ == NULL) {
				} else {
					gint* _tmp12_;
					_tmp12_ = first_back;
					if (_tmp12_ == NULL) {
						gint _tmp13_;
						gint* _tmp14_;
						NetsukukuNIP* _tmp15_ = NULL;
						NetsukukuNIP* nip_first_forward;
						NetsukukuNIP* _tmp16_;
						NetsukukuRmtCoordinatorPeer* _tmp17_ = NULL;
						NetsukukuRmtCoordinatorPeer* peer_first_forward;
						NetsukukuRmtCoordinatorPeer* _tmp18_;
						NetsukukuCoordinatorGetCacheRecordsResponse* _tmp19_ = NULL;
						NetsukukuCoordinatorGetCacheRecordsResponse* cache_first_forward;
						NetsukukuCoordinatorGetCacheRecordsResponse* _tmp20_;
						NetsukukuCoordinatorMemory* _tmp21_;
						NetsukukuCoordinatorMemory* _tmp22_;
						_tmp13_ = lvl;
						_tmp14_ = first_forward;
						_tmp15_ = netsukuku_coordinator_nip_for_lvl_pos (self, _tmp13_, *_tmp14_);
						nip_first_forward = _tmp15_;
						_tmp16_ = nip_first_forward;
						_tmp17_ = netsukuku_coordinator_peer (self, _tmp16_, NULL, NULL);
						peer_first_forward = _tmp17_;
						_tmp18_ = peer_first_forward;
						_tmp19_ = netsukuku_icoordinator_as_peer_get_cache_records ((NetsukukuICoordinatorAsPeer*) _tmp18_, &_inner_error_);
						cache_first_forward = _tmp19_;
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							return;
						}
						_tmp20_ = cache_first_forward;
						_tmp21_ = netsukuku_coordinator_get_cache_records_response_get_memory (_tmp20_);
						_tmp22_ = _tmp21_;
						netsukuku_coordinator_reproduce_memory (self, _tmp22_);
						_g_object_unref0 (cache_first_forward);
						_g_object_unref0 (peer_first_forward);
						_g_object_unref0 (nip_first_forward);
						_g_free0 (last_back);
						_g_free0 (first_back);
						_g_free0 (first_forward);
						break;
					} else {
						gint _tmp23_;
						gint* _tmp24_;
						NetsukukuNIP* _tmp25_ = NULL;
						NetsukukuNIP* nip_first_back;
						NetsukukuNIP* _tmp26_;
						NetsukukuRmtCoordinatorPeer* _tmp27_ = NULL;
						NetsukukuRmtCoordinatorPeer* peer_first_back;
						NetsukukuRmtCoordinatorPeer* _tmp28_;
						NetsukukuCoordinatorGetCacheRecordsResponse* _tmp29_ = NULL;
						NetsukukuCoordinatorGetCacheRecordsResponse* cache_first_back;
						NetsukukuCoordinatorGetCacheRecordsResponse* _tmp30_;
						NetsukukuCoordinatorMemory* _tmp31_;
						NetsukukuCoordinatorMemory* _tmp32_;
						gint _tmp33_;
						gint* _tmp34_;
						NetsukukuNIP* _tmp35_ = NULL;
						NetsukukuNIP* nip_first_forward;
						NetsukukuNIP* _tmp36_;
						NetsukukuRmtCoordinatorPeer* _tmp37_ = NULL;
						NetsukukuRmtCoordinatorPeer* peer_first_forward;
						NetsukukuRmtCoordinatorPeer* _tmp38_;
						NetsukukuCoordinatorGetCacheRecordsResponse* _tmp39_ = NULL;
						NetsukukuCoordinatorGetCacheRecordsResponse* cache_first_forward;
						NetsukukuCoordinatorGetCacheRecordsResponse* _tmp40_;
						NetsukukuCoordinatorMemory* _tmp41_;
						NetsukukuCoordinatorMemory* _tmp42_;
						_tmp23_ = lvl;
						_tmp24_ = first_back;
						_tmp25_ = netsukuku_coordinator_nip_for_lvl_pos (self, _tmp23_, *_tmp24_);
						nip_first_back = _tmp25_;
						_tmp26_ = nip_first_back;
						_tmp27_ = netsukuku_coordinator_peer (self, _tmp26_, NULL, NULL);
						peer_first_back = _tmp27_;
						_tmp28_ = peer_first_back;
						_tmp29_ = netsukuku_icoordinator_as_peer_get_cache_records ((NetsukukuICoordinatorAsPeer*) _tmp28_, &_inner_error_);
						cache_first_back = _tmp29_;
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (peer_first_back);
							_g_object_unref0 (nip_first_back);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							return;
						}
						_tmp30_ = cache_first_back;
						_tmp31_ = netsukuku_coordinator_get_cache_records_response_get_memory (_tmp30_);
						_tmp32_ = _tmp31_;
						netsukuku_coordinator_reproduce_memory (self, _tmp32_);
						_tmp33_ = lvl;
						_tmp34_ = first_forward;
						_tmp35_ = netsukuku_coordinator_nip_for_lvl_pos (self, _tmp33_, *_tmp34_);
						nip_first_forward = _tmp35_;
						_tmp36_ = nip_first_forward;
						_tmp37_ = netsukuku_coordinator_peer (self, _tmp36_, NULL, NULL);
						peer_first_forward = _tmp37_;
						_tmp38_ = peer_first_forward;
						_tmp39_ = netsukuku_icoordinator_as_peer_get_cache_records ((NetsukukuICoordinatorAsPeer*) _tmp38_, &_inner_error_);
						cache_first_forward = _tmp39_;
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_object_unref0 (cache_first_back);
							_g_object_unref0 (peer_first_back);
							_g_object_unref0 (nip_first_back);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							return;
						}
						_tmp40_ = cache_first_forward;
						_tmp41_ = netsukuku_coordinator_get_cache_records_response_get_memory (_tmp40_);
						_tmp42_ = _tmp41_;
						netsukuku_coordinator_reproduce_memory (self, _tmp42_);
						_g_object_unref0 (cache_first_forward);
						_g_object_unref0 (peer_first_forward);
						_g_object_unref0 (nip_first_forward);
						_g_object_unref0 (cache_first_back);
						_g_object_unref0 (peer_first_back);
						_g_object_unref0 (nip_first_back);
						_g_free0 (last_back);
						_g_free0 (first_back);
						_g_free0 (first_forward);
						break;
					}
				}
				_g_free0 (last_back);
				_g_free0 (first_back);
				_g_free0 (first_forward);
			}
		}
	}
	self->memory_initialized = TRUE;
	netsukuku_log_info ("Coordinator service: memory ready.");
	g_signal_emit_by_name (self, "coordinator-ready");
}


static void __lambda2_ (NetsukukuCoordinator* self, GError** error) {
	GError * _inner_error_ = NULL;
	while (TRUE) {
		{
			netsukuku_coordinator_impl_init_memory (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch31_g_error;
			}
			break;
		}
		goto __finally31;
		__catch31_g_error:
		{
			GError* e = NULL;
			GError* _tmp0_;
			GQuark _tmp1_;
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp0_ = e;
			_tmp1_ = _tmp0_->domain;
			_tmp2_ = g_quark_to_string (_tmp1_);
			_tmp3_ = string_to_string (_tmp2_);
			_tmp4_ = e;
			_tmp5_ = _tmp4_->code;
			_tmp6_ = g_strdup_printf ("%i", _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = g_strconcat ("got ", _tmp3_, " ", _tmp7_, " ", _tmp10_, ". ", NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("Coordinator.init_memory: ", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp14_, "Trying again.\n", NULL);
			_tmp16_ = _tmp15_;
			netsukuku_log_warn (_tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			tasklets_ms_wait ((gint64) 100);
			_g_error_free0 (e);
		}
		__finally31:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void ___lambda2__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	__lambda2_ (self, error);
}


void netsukuku_coordinator_init_memory (NetsukukuCoordinator* self) {
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tasklets_tasklet_tasklet_callback (___lambda2__tasklets_tasklet_callback, self, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


/** This is the function h:KEY-->hIP.
          */
static NetsukukuNIP* netsukuku_coordinator_real_h (NetsukukuPeerToPeer* base, GObject* k) {
	NetsukukuCoordinator * self;
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuPartialNIP* _tmp1_;
	NetsukukuPartialNIP* key;
	NetsukukuPartialNIP* _tmp2_;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	gint* _tmp14_;
	gint _tmp14__length1;
	NetsukukuNIP* _tmp15_;
	self = (NetsukukuCoordinator*) base;
	g_return_val_if_fail (k != NULL, NULL);
	_tmp0_ = k;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
	key = _tmp1_;
	_tmp2_ = key;
	_tmp4_ = netsukuku_partial_nip_get_positions (_tmp2_, &_tmp3_);
	positions = _tmp4_;
	positions_length1 = _tmp3_;
	_positions_size_ = positions_length1;
	{
		gint l;
		l = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				NetsukukuPartialNIP* _tmp9_;
				gint _tmp10_ = 0;
				gint* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				gint _tmp13_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = l;
					l = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = l;
				_tmp9_ = key;
				_tmp10_ = netsukuku_partial_nip_level_of_gnode (_tmp9_);
				if (!(_tmp8_ < _tmp10_)) {
					break;
				}
				_tmp11_ = positions;
				_tmp11__length1 = positions_length1;
				_tmp12_ = l;
				_tmp11_[_tmp12_] = 0;
				_tmp13_ = _tmp11_[_tmp12_];
			}
		}
	}
	_tmp14_ = positions;
	_tmp14__length1 = positions_length1;
	_tmp15_ = netsukuku_nip_new (_tmp14_, _tmp14__length1);
	result = _tmp15_;
	positions = (g_free (positions), NULL);
	_g_object_unref0 (key);
	return result;
}


/** Remotables from neighbours **/
static NetsukukuCoordinatorReservation* netsukuku_coordinator_real_reserve_into (NetsukukuICoordinator* base, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuCoordinator * self;
	NetsukukuCoordinatorReservation* result = NULL;
	NetsukukuCoordinatorReservation* ret = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuRmtCoordinatorPeer* _tmp1_ = NULL;
	NetsukukuRmtCoordinatorPeer* _peer;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoordinator*) base;
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coordinator_peer (self, NULL, (GObject*) _tmp0_, NULL);
	_peer = _tmp1_;
	while (TRUE) {
		{
			NetsukukuRmtCoordinatorPeer* _tmp2_;
			NetsukukuPartialNIP* _tmp3_;
			NetsukukuCoordinatorReservation* _tmp4_ = NULL;
			NetsukukuCoordinatorReservation* _tmp5_;
			_tmp2_ = _peer;
			_tmp3_ = gnode;
			_tmp4_ = netsukuku_icoordinator_as_peer_reserve ((NetsukukuICoordinatorAsPeer*) _tmp2_, _tmp3_, &_inner_error_);
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					goto __catch32_netsukuku_peer_refuse_service_error;
				}
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					goto __catch32_zcd_rpc_error;
				}
				goto __finally32;
			}
			_g_object_unref0 (ret);
			ret = _tmp5_;
			break;
		}
		goto __finally32;
		__catch32_netsukuku_peer_refuse_service_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			_tmp8_ = string_to_string (_tmp7_);
			_tmp9_ = g_strconcat ("Coordinator.reserve_into: got PeerRefuseServiceError ", _tmp8_, ".\n", NULL);
			_tmp10_ = _tmp9_;
			netsukuku_log_warn (_tmp10_);
			_g_free0 (_tmp10_);
			tasklets_ms_wait ((gint64) 100);
			_g_error_free0 (e);
		}
		goto __finally32;
		__catch32_zcd_rpc_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			_tmp13_ = string_to_string (_tmp12_);
			_tmp14_ = g_strconcat ("Coordinator.reserve_into: got RPCError ", _tmp13_, ".\n", NULL);
			_tmp15_ = _tmp14_;
			netsukuku_log_warn (_tmp15_);
			_g_free0 (_tmp15_);
			tasklets_ms_wait ((gint64) 100);
			_g_error_free0 (e);
		}
		__finally32:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (_peer);
				_g_object_unref0 (ret);
				return NULL;
			} else {
				_g_object_unref0 (_peer);
				_g_object_unref0 (ret);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = ret;
	_g_object_unref0 (_peer);
	return result;
}


static NetsukukuCoordinatorInfo* netsukuku_coordinator_real_report_status (NetsukukuICoordinator* base, gint lvl, GError** error) {
	NetsukukuCoordinator * self;
	NetsukukuCoordinatorInfo* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	gboolean _tmp14_;
	NetsukukuCoordinatorInfo* _tmp16_;
	NetsukukuCoordinatorInfo* ret;
	NetsukukuCoordinatorInfo* _tmp17_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gpointer _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoordinator*) base;
	_tmp1_ = lvl;
	if (_tmp1_ < 1) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		NetsukukuMapRoute* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = lvl;
		_tmp3_ = ((NetsukukuPeerToPeer*) self)->maproute;
		_tmp4_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ > _tmp5_;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		gint _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp7_ = lvl;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Bad level number: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = self->memory_initialized;
	if (!_tmp14_) {
		GError* _tmp15_;
		_tmp15_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "Memory not ready yet");
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	netsukuku_coordinator_update_cache (self);
	_tmp16_ = netsukuku_coordinator_info_new ();
	ret = _tmp16_;
	_tmp17_ = ret;
	_tmp18_ = self->priv->last_assigned_elderships;
	_tmp19_ = lvl;
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_ - 1);
	_tmp17_->last_assigned_eldership = (gint) ((gintptr) _tmp20_);
	{
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gpointer _tmp23_ = NULL;
		GeeLinkedList* _b_list;
		GeeLinkedList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _b_size;
		gint _b_index;
		_tmp21_ = self->priv->bookings;
		_tmp22_ = lvl;
		_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp22_ - 1);
		_b_list = (GeeLinkedList*) _tmp23_;
		_tmp24_ = _b_list;
		_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_b_size = _tmp26_;
		_b_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			GeeLinkedList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_ = NULL;
			NetsukukuCoordinatorBooking* b;
			NetsukukuCoordinatorInfo* _tmp33_;
			NetsukukuCoordinatorBooking* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			_tmp27_ = _b_index;
			_b_index = _tmp27_ + 1;
			_tmp28_ = _b_index;
			_tmp29_ = _b_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _b_list;
			_tmp31_ = _b_index;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
			b = (NetsukukuCoordinatorBooking*) _tmp32_;
			_tmp33_ = ret;
			_tmp34_ = b;
			_tmp35_ = netsukuku_coordinator_booking_get_pos (_tmp34_);
			_tmp36_ = _tmp35_;
			netsukuku_coordinator_info_add_pos (_tmp33_, _tmp36_);
			_g_object_unref0 (b);
		}
		_g_object_unref0 (_b_list);
	}
	result = ret;
	return result;
}


/** Remotables from peers **/
static void _____lambda4_ (NetsukukuCoordinator* self, GObject* tpar1, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tonip;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tonip = _tmp1_;
	tasklets_tasklet_declare_self ("Coordinator replica to one");
	{
		NetsukukuRmtCoordinatorPeer* _tmp2_ = NULL;
		NetsukukuRmtCoordinatorPeer* _tmp3_;
		NetsukukuCoordinatorMemory* _tmp4_ = NULL;
		NetsukukuCoordinatorMemory* _tmp5_;
		_tmp2_ = netsukuku_coordinator_peer (self, tonip, NULL, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = netsukuku_coordinator_produce_memory (self);
		_tmp5_ = _tmp4_;
		netsukuku_icoordinator_as_peer_backup_memory ((NetsukukuICoordinatorAsPeer*) _tmp3_, _tmp5_, &_inner_error_);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (_tmp3_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch33_zcd_rpc_error;
			}
			_g_object_unref0 (tonip);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally33;
	__catch33_zcd_rpc_error:
	{
		GError* e = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		GQuark _tmp11_;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) tonip);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("Coordinator: forwarding to ", _tmp7_, ":", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->domain;
		_tmp12_ = g_quark_to_string (_tmp11_);
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = e;
		_tmp15_ = _tmp14_->code;
		_tmp16_ = g_strdup_printf ("%i", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat (" got ", _tmp13_, " ", _tmp17_, " ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp9_, _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		netsukuku_log_warn (_tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (tonip);
		return;
	}
	_g_object_unref0 (tonip);
}


static void ______lambda4__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_____lambda4_ (self, obj1, error);
}


static void __lambda3_ (NetsukukuCoordinator* self, GObject* tpar1, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tasklet_hip;
	GeeList* _tmp2_ = NULL;
	GeeList* replica_nodes;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tasklet_hip = _tmp1_;
	tasklets_tasklet_declare_self ("Coordinator replica");
	_tmp2_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) self, tasklet_hip, NETSUKUKU_COORDINATOR_DUPLICATION, NULL, &_inner_error_);
	replica_nodes = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (tasklet_hip);
		return;
	}
	{
		GeeList* _tmp3_;
		GeeList* _replica_node_list;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _replica_node_size;
		gint _replica_node_index;
		_tmp3_ = _g_object_ref0 (replica_nodes);
		_replica_node_list = _tmp3_;
		_tmp4_ = _replica_node_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_replica_node_size = _tmp6_;
		_replica_node_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			NetsukukuNIP* replica_node;
			NetsukukuNIP* _tmp13_;
			NetsukukuMapRoute* _tmp14_;
			NetsukukuNIP* _tmp15_;
			NetsukukuNIP* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp7_ = _replica_node_index;
			_replica_node_index = _tmp7_ + 1;
			_tmp8_ = _replica_node_index;
			_tmp9_ = _replica_node_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _replica_node_list;
			_tmp11_ = _replica_node_index;
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
			replica_node = (NetsukukuNIP*) _tmp12_;
			_tmp13_ = replica_node;
			_tmp14_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp13_, (NetsukukuPartialNIP*) _tmp16_);
			if (!_tmp17_) {
				NetsukukuNIP* _tmp18_;
				TaskletsTasklet* _tmp19_ = NULL;
				TaskletsTasklet* _tmp20_;
				_tmp18_ = replica_node;
				_tmp19_ = tasklets_tasklet_tasklet_callback (______lambda4__tasklets_tasklet_callback, self, (GObject*) _tmp18_, NULL, NULL, NULL);
				_tmp20_ = _tmp19_;
				_g_object_unref0 (_tmp20_);
			}
			_g_object_unref0 (replica_node);
		}
		_g_object_unref0 (_replica_node_list);
	}
	_g_object_unref0 (replica_nodes);
	_g_object_unref0 (tasklet_hip);
}


static void ___lambda3__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	__lambda3_ (self, obj1, error);
}


static NetsukukuGNodeID** _vala_array_dup2 (NetsukukuGNodeID** self, int length) {
	NetsukukuGNodeID** result;
	int i;
	result = g_new0 (NetsukukuGNodeID*, length + 1);
	for (i = 0; i < length; i++) {
		NetsukukuGNodeID* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static NetsukukuCoordinatorReservation* netsukuku_coordinator_real_reserve (NetsukukuICoordinatorAsPeer* base, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuCoordinator * self;
	NetsukukuCoordinatorReservation* result = NULL;
	gboolean _tmp0_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	NetsukukuPartialNIP* _tmp9_;
	gboolean _tmp10_ = FALSE;
	NetsukukuPartialNIP* _tmp12_;
	NetsukukuNIP* _tmp13_ = NULL;
	NetsukukuNIP* hip;
	NetsukukuNIP* _tmp14_;
	NetsukukuHCoord* _tmp15_ = NULL;
	NetsukukuHCoord* Hhip;
	NetsukukuHCoord* _tmp16_;
	NetsukukuPartialNIP* _tmp18_;
	gint _tmp19_ = 0;
	gint level_of_gnode;
	gint _tmp20_;
	gint level_of_nodes;
	NetsukukuMapRoute* _tmp21_;
	gint _tmp22_;
	gint _tmp23_ = 0;
	gint* _tmp24_ = NULL;
	gint* _fnl;
	gint _fnl_length1;
	gint __fnl_size_;
	GeeArrayList* _tmp25_;
	GeeArrayList* fnl;
	gint* _tmp26_;
	gint _tmp26__length1;
	GeeArrayList* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	GeeArrayList* _tmp36_;
	GeeArrayList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint32 _tmp40_ = 0;
	gpointer _tmp41_ = NULL;
	gint pos;
	GeeArrayList* _tmp42_;
	gint _tmp43_;
	gpointer _tmp44_ = NULL;
	GeeLinkedList* _tmp45_;
	gint _tmp46_;
	NetsukukuCoordinatorBooking* _tmp47_;
	NetsukukuCoordinatorBooking* _tmp48_;
	GeeArrayList* _tmp49_;
	gint _tmp50_;
	gpointer _tmp51_ = NULL;
	gint eldership;
	GeeArrayList* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	NetsukukuMapRoute* _tmp55_;
	gint _tmp56_;
	gint _tmp57_ = 0;
	NetsukukuGNodeID** _tmp58_ = NULL;
	NetsukukuGNodeID** gids;
	gint gids_length1;
	gint _gids_size_;
	NetsukukuNIP* _tmp59_;
	TaskletsTasklet* _tmp60_ = NULL;
	TaskletsTasklet* _tmp61_;
	NetsukukuCoordinatorReservation* _tmp62_;
	NetsukukuCoordinatorReservation* ret;
	NetsukukuCoordinatorReservation* _tmp63_;
	gint _tmp64_;
	NetsukukuCoordinatorReservation* _tmp65_;
	gint _tmp66_;
	NetsukukuCoordinatorReservation* _tmp67_;
	NetsukukuGNodeID** _tmp68_;
	gint _tmp68__length1;
	NetsukukuGNodeID** _tmp69_;
	gint _tmp69__length1;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoordinator*) base;
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) || (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_coordinator_update_cache (self);
	_tmp6_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gnode;
	_tmp10_ = netsukuku_partial_nip_belongs_to ((NetsukukuPartialNIP*) _tmp8_, _tmp9_);
	if (!_tmp10_) {
		GError* _tmp11_;
		_tmp11_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "The node is not in that gnode.");
		_inner_error_ = _tmp11_;
		if (((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) || (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = gnode;
	_tmp13_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp12_);
	hip = _tmp13_;
	_tmp14_ = hip;
	_tmp15_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp14_, 1, &_inner_error_);
	Hhip = _tmp15_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) || (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hip);
			return NULL;
		} else {
			_g_object_unref0 (hip);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = Hhip;
	if (_tmp16_ != NULL) {
		GError* _tmp17_;
		_tmp17_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "The node is not the Coordinator.");
		_inner_error_ = _tmp17_;
		if (((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) || (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (Hhip);
			_g_object_unref0 (hip);
			return NULL;
		} else {
			_g_object_unref0 (Hhip);
			_g_object_unref0 (hip);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp18_ = gnode;
	_tmp19_ = netsukuku_partial_nip_level_of_gnode (_tmp18_);
	level_of_gnode = _tmp19_;
	_tmp20_ = level_of_gnode;
	level_of_nodes = _tmp20_ - 1;
	_tmp21_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp22_ = level_of_nodes;
	_tmp24_ = netsukuku_map_free_nodes_list ((NetsukukuMap*) _tmp21_, _tmp22_, &_tmp23_);
	_fnl = _tmp24_;
	_fnl_length1 = _tmp23_;
	__fnl_size_ = _fnl_length1;
	_tmp25_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	fnl = _tmp25_;
	_tmp26_ = _fnl;
	_tmp26__length1 = _fnl_length1;
	{
		gint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp26_;
		i_collection_length1 = _tmp26__length1;
		for (i_it = 0; i_it < _tmp26__length1; i_it = i_it + 1) {
			gint i = 0;
			i = i_collection[i_it];
			{
				gint _tmp27_;
				gint _tmp28_;
				gboolean _tmp29_ = FALSE;
				_tmp27_ = level_of_nodes;
				_tmp28_ = i;
				_tmp29_ = netsukuku_coordinator_bookings_contains (self, _tmp27_, _tmp28_);
				if (!_tmp29_) {
					GeeArrayList* _tmp30_;
					gint _tmp31_;
					_tmp30_ = fnl;
					_tmp31_ = i;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, (gpointer) ((gintptr) _tmp31_));
				}
			}
		}
	}
	_tmp32_ = fnl;
	_tmp33_ = gee_collection_get_is_empty ((GeeCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_) {
		GError* _tmp35_;
		_tmp35_ = g_error_new_literal (NETSUKUKU_HOOKING_ERROR, NETSUKUKU_HOOKING_ERROR_GENERIC, "No free positions");
		_inner_error_ = _tmp35_;
		if (((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) || (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fnl);
			_fnl = (g_free (_fnl), NULL);
			_g_object_unref0 (Hhip);
			_g_object_unref0 (hip);
			return NULL;
		} else {
			_g_object_unref0 (fnl);
			_fnl = (g_free (_fnl), NULL);
			_g_object_unref0 (Hhip);
			_g_object_unref0 (hip);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp36_ = fnl;
	_tmp37_ = fnl;
	_tmp38_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_random_int_range ((gint32) 0, (gint32) _tmp39_);
	_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, (gint) _tmp40_);
	pos = (gint) ((gintptr) _tmp41_);
	_tmp42_ = self->priv->bookings;
	_tmp43_ = level_of_nodes;
	_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _tmp43_);
	_tmp45_ = (GeeLinkedList*) _tmp44_;
	_tmp46_ = pos;
	_tmp47_ = netsukuku_coordinator_booking_new (_tmp46_);
	_tmp48_ = _tmp47_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	_g_object_unref0 (_tmp45_);
	_tmp49_ = self->priv->last_assigned_elderships;
	_tmp50_ = level_of_nodes;
	_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _tmp50_);
	eldership = ((gint) ((gintptr) _tmp51_)) + 1;
	_tmp52_ = self->priv->last_assigned_elderships;
	_tmp53_ = level_of_nodes;
	_tmp54_ = eldership;
	gee_abstract_list_set ((GeeAbstractList*) _tmp52_, _tmp53_, (gpointer) ((gintptr) _tmp54_));
	_tmp55_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp56_ = level_of_gnode;
	_tmp58_ = netsukuku_map_route_get_gid_uppermost_list (_tmp55_, _tmp56_, &_tmp57_);
	gids = _tmp58_;
	gids_length1 = _tmp57_;
	_gids_size_ = gids_length1;
	_tmp59_ = hip;
	_tmp60_ = tasklets_tasklet_tasklet_callback (___lambda3__tasklets_tasklet_callback, self, (GObject*) _tmp59_, NULL, NULL, NULL);
	_tmp61_ = _tmp60_;
	_g_object_unref0 (_tmp61_);
	_tmp62_ = netsukuku_coordinator_reservation_new ();
	ret = _tmp62_;
	_tmp63_ = ret;
	_tmp64_ = pos;
	_tmp63_->pos = _tmp64_;
	_tmp65_ = ret;
	_tmp66_ = eldership;
	_tmp65_->eldership = _tmp66_;
	_tmp67_ = ret;
	_tmp68_ = gids;
	_tmp68__length1 = gids_length1;
	_tmp69_ = (_tmp68_ != NULL) ? _vala_array_dup2 (_tmp68_, _tmp68__length1) : ((gpointer) _tmp68_);
	_tmp69__length1 = _tmp68__length1;
	_tmp67_->gids = (_vala_array_free (_tmp67_->gids, _tmp67_->gids_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp67_->gids = _tmp69_;
	_tmp67_->gids_length1 = _tmp69__length1;
	result = ret;
	gids = (_vala_array_free (gids, gids_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (fnl);
	_fnl = (g_free (_fnl), NULL);
	_g_object_unref0 (Hhip);
	_g_object_unref0 (hip);
	return result;
}


static void netsukuku_coordinator_real_backup_memory (NetsukukuICoordinatorAsPeer* base, NetsukukuCoordinatorMemory* mem, GError** error) {
	NetsukukuCoordinator * self;
	gboolean _tmp0_;
	NetsukukuCoordinatorMemory* _tmp2_;
	self = (NetsukukuCoordinator*) base;
	g_return_if_fail (mem != NULL);
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		while (TRUE) {
			gboolean _tmp1_;
			_tmp1_ = self->memory_initialized;
			if (!(!_tmp1_)) {
				break;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
	}
	_tmp2_ = mem;
	netsukuku_coordinator_reproduce_memory (self, _tmp2_);
}


static NetsukukuCoordinatorGetCacheRecordsResponse* netsukuku_coordinator_real_get_cache_records (NetsukukuICoordinatorAsPeer* base, GError** error) {
	NetsukukuCoordinator * self;
	NetsukukuCoordinatorGetCacheRecordsResponse* result = NULL;
	gboolean _tmp0_;
	NetsukukuCoordinatorMemory* _tmp6_ = NULL;
	NetsukukuCoordinatorMemory* _tmp7_;
	NetsukukuCoordinatorGetCacheRecordsResponse* _tmp8_;
	NetsukukuCoordinatorGetCacheRecordsResponse* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoordinator*) base;
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 2000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	_tmp6_ = netsukuku_coordinator_produce_memory (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = netsukuku_coordinator_get_cache_records_response_new (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	result = _tmp9_;
	return result;
}


static void netsukuku_coordinator_class_init (NetsukukuCoordinatorClass * klass) {
	netsukuku_coordinator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCoordinatorPrivate));
	ZCD_RPC_DISPATCHER_CLASS (klass)->_dispatch = netsukuku_coordinator_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_coordinator_real_h;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coordinator_finalize;
	g_signal_new ("coordinator_ready", NETSUKUKU_TYPE_COORDINATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_coordinator_netsukuku_icoordinator_as_peer_interface_init (NetsukukuICoordinatorAsPeerIface * iface) {
	netsukuku_coordinator_netsukuku_icoordinator_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->reserve = (NetsukukuCoordinatorReservation* (*)(NetsukukuICoordinatorAsPeer*, NetsukukuPartialNIP*, GError**)) netsukuku_coordinator_real_reserve;
	iface->backup_memory = (void (*)(NetsukukuICoordinatorAsPeer*, NetsukukuCoordinatorMemory*, GError**)) netsukuku_coordinator_real_backup_memory;
	iface->get_cache_records = (NetsukukuCoordinatorGetCacheRecordsResponse* (*)(NetsukukuICoordinatorAsPeer*, GError**)) netsukuku_coordinator_real_get_cache_records;
}


static void netsukuku_coordinator_netsukuku_icoordinator_interface_init (NetsukukuICoordinatorIface * iface) {
	netsukuku_coordinator_netsukuku_icoordinator_parent_iface = g_type_interface_peek_parent (iface);
	iface->reserve_into = (NetsukukuCoordinatorReservation* (*)(NetsukukuICoordinator*, NetsukukuPartialNIP*, GError**)) netsukuku_coordinator_real_reserve_into;
	iface->report_status = (NetsukukuCoordinatorInfo* (*)(NetsukukuICoordinator*, gint, GError**)) netsukuku_coordinator_real_report_status;
}


static void netsukuku_coordinator_instance_init (NetsukukuCoordinator * self) {
	self->priv = NETSUKUKU_COORDINATOR_GET_PRIVATE (self);
}


static void netsukuku_coordinator_finalize (GObject* obj) {
	NetsukukuCoordinator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	_g_object_unref0 (self->priv->bookings);
	_g_object_unref0 (self->priv->last_assigned_elderships);
	G_OBJECT_CLASS (netsukuku_coordinator_parent_class)->finalize (obj);
}


GType netsukuku_coordinator_get_type (void) {
	static volatile gsize netsukuku_coordinator_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coordinator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoordinatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coordinator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoordinator), 0, (GInstanceInitFunc) netsukuku_coordinator_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icoordinator_as_peer_info = { (GInterfaceInitFunc) netsukuku_coordinator_netsukuku_icoordinator_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo netsukuku_icoordinator_info = { (GInterfaceInitFunc) netsukuku_coordinator_netsukuku_icoordinator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_coordinator_type_id;
		netsukuku_coordinator_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuCoordinator", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_coordinator_type_id, NETSUKUKU_TYPE_ICOORDINATOR_AS_PEER, &netsukuku_icoordinator_as_peer_info);
		g_type_add_interface_static (netsukuku_coordinator_type_id, NETSUKUKU_TYPE_ICOORDINATOR, &netsukuku_icoordinator_info);
		g_once_init_leave (&netsukuku_coordinator_type_id__volatile, netsukuku_coordinator_type_id);
	}
	return netsukuku_coordinator_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



