/**  Stub classes generated by rpcdesign.
  */

using Gee;
using zcd;

namespace Andns
{
    /** The following classes are used to perform
      *  RPC call using the following form:
      *
      *    var x = remote_instance.property1.property2.method0(p1, p2, p3);
      *
      *  instead of:
      *
      *    RemoteCall rc = new RemoteCall();
      *    rc.method_name = "property1.property2.method0";
      *    rc.add_parameter(p1);
      *    rc.add_parameter(p2);
      *    rc.add_parameter(p3);
      *    var x = (SerClass)remote_instance.rmt(rc);
      *
      * The actual implementation of method rmt is a duty of a derived class.
      */

    public abstract class AndnaResolveFakeRmt : Object, IAndnaResolveRootDispatcher, FakeRmt
    {
        public IAndnaQueryHandler get_query_handler(int request_id)
        {
            RemoteAndnaQueryHandler ret = new RemoteAndnaQueryHandler();
            ret.root = this;
            ret.accumulated = @"get_query_handler($(request_id))";
            return ret;
        }

        public abstract ISerializable rmt(RemoteCall data) throws RPCError;
    }

    public class RemoteAndnaQueryHandler : Object, IAndnaQueryHandler
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public AndnaResponse resolve(AndnaQuery query) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".resolve";
            rc.add_parameter(query);
            return (AndnaResponse)
                filter_exception(
                root.rmt(rc)
            );
        }

    }

    /** An implementation of AndnaResolveFakeRmt that sends a message via TCP.
      */
    public class AndnaResolveTCPClient : AndnaResolveFakeRmt
    {
        private TCPClient inner;
        public AndnaResolveTCPClient(string dest_addr, uint16? dest_port=null, string? my_addr=null, bool wait_response=true)
        {
            inner = new TCPClient(dest_addr, dest_port, my_addr, wait_response);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }

        public uint16 dest_port {
            get {
                return inner.dest_port;
            }
        }

        public string dest_addr {
            get {
                return inner.dest_addr;
            }
        }

        public bool calling {
            get {
                return inner.calling;
            }
        }

        public bool retry_connect {
            get {
                return inner.retry_connect;
            }
            set {
                inner.retry_connect = value;
            }
        }

        public void close() throws RPCError
        {
            inner.close();
        }
    }

    /** An implementation of AndnaResolveFakeRmt that sends a message 
      *  to its neighbours in broadcast via UDP.
      */
    public class AndnaResolveBroadcastClient : AndnaResolveFakeRmt
    {
        private BroadcastClient inner;
        public AndnaResolveBroadcastClient(ISerializable broadcast_id, string[] devs, uint16 port=269)
        {
            inner = new BroadcastClient(broadcast_id, devs, port);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }

        public uint16 port {
            get {
                return inner.dest_port;
            }
        }
    }

    /** An implementation of AndnaResolveFakeRmt that sends requests to
      *  a set of local dispatchers. Simulates a BroadcastClient.
      */
    public class AndnaResolvePseudoBroadcastClient : AndnaResolveFakeRmt
    {
        private PseudoBroadcastClient inner;
        public AndnaResolvePseudoBroadcastClient(Gee.List<RPCDispatcher> rpcdispatchers)
        {
            inner = new PseudoBroadcastClient(rpcdispatchers);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }
    }

    /** An implementation of AndnaResolveFakeRmt that sends a message
      *  to a neighbour via UDP.
      */
    public class AndnaResolveNeighbourClient : AndnaResolveFakeRmt
    {
        private NeighbourClient inner;
        public AndnaResolveNeighbourClient(ISerializable unicast_id, string[] devs, uint16? port=null,  bool wait_response=true)
        {
            inner = new NeighbourClient(unicast_id, devs, port, wait_response);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }

        public uint16 port {
            get {
                return inner.dest_port;
            }
        }
    }

    /** An implementation of AndnaResolveFakeRmt that sends requests to a
      *  local dispatcher. Simulates a NeighbourClient.
      */
    public class AndnaResolvePseudoNeighbourClient : AndnaResolveFakeRmt
    {
        private PseudoNeighbourClient inner;
        public AndnaResolvePseudoNeighbourClient(RPCDispatcher rpcdispatcher, bool wait_response=true)
        {
            inner = new PseudoNeighbourClient(rpcdispatcher, wait_response);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }
    }

    /** An implementation of AndnaResolveFakeRmt that sends a message (usually without waiting for
      *  a result) to two remote objects.
      */
    public class CoupleAndnaResolveFakeRmt : AndnaResolveFakeRmt
    {
        private AndnaResolveFakeRmt f1;
        private AndnaResolveFakeRmt f2;
        public CoupleAndnaResolveFakeRmt(AndnaResolveFakeRmt f1, AndnaResolveFakeRmt f2)
        {
            this.f1 = f1;
            this.f2 = f2;
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            f1.rmt(data);
            return f2.rmt(data);
        }
    }
}
