/*-GNU-GPL-BEGIN-*
nepim - network pipemeter - measuring network bandwidth between hosts
Copyright (C) 2005  Everton da Silva Marques

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING; if not, write to the
Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
MA 02110-1301 USA
*-GNU-GPL-END-*/

/* $Id: bit.c,v 1.2 2005/11/04 09:56:14 evertonm Exp $ */

#include <stdlib.h>
#include <assert.h>

#include "bit.h"

#define NEPIM_WORD_BITLEN (8 * sizeof(uint32_t))

void nepim_bit_init(nepim_bit_t *set, uint32_t bit_size)
{
  int i;
  int word_size;

  assert(sizeof(uint32_t) == sizeof(*set->words));

  word_size = bit_size / NEPIM_WORD_BITLEN;
  if (bit_size % NEPIM_WORD_BITLEN)
    ++word_size;

  assert(word_size > 0);

  set->words = malloc(word_size * sizeof(uint32_t));
  assert(set->words);
  
  for (i = 0; i < word_size; ++i)
    set->words[i] = 0;

  set->word_size = word_size;
}

void nepim_bit_del(nepim_bit_t *set)
{
  free(set->words);
  set->words = 0;
}

int nepim_bit_isset(nepim_bit_t *set, uint32_t bit)
{
  int word_offset;
  int bit_offset;
  uint32_t bit_mask;

  assert(set->word_size > 0);

  word_offset = bit / NEPIM_WORD_BITLEN;

  assert(word_offset < set->word_size);

  bit_offset  = bit % NEPIM_WORD_BITLEN;
  bit_mask    = 1 << bit_offset;

  return set->words[word_offset] & bit_mask;
}

void nepim_bit_set(nepim_bit_t *set, uint32_t bit)
{
  int word_offset;
  int bit_offset;
  uint32_t bit_mask;

  assert(set->word_size > 0);

  word_offset = bit / NEPIM_WORD_BITLEN;

  assert(word_offset < set->word_size);

  bit_offset  = bit % NEPIM_WORD_BITLEN;
  bit_mask    = 1 << bit_offset;

  set->words[word_offset] |= bit_mask;

  assert(nepim_bit_isset(set, bit));
}

void nepim_bit_clear(nepim_bit_t *set, uint32_t bit)
{
  int word_offset;
  int bit_offset;
  uint32_t bit_mask;

  assert(set->word_size > 0);

  word_offset = bit / NEPIM_WORD_BITLEN;

  assert(word_offset < set->word_size);

  bit_offset  = bit % NEPIM_WORD_BITLEN;
  bit_mask    = 1 << bit_offset;

  set->words[word_offset] &= ~bit_mask;

  assert(!nepim_bit_isset(set, bit));
}

