// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/unittest.h>
#include <mobius/core/application.h>
#include <mobius/core/config.h>
#include <mobius/core/resource.h>

static void
testcase_application ()
{
  mobius::unittest test ("mobius::core::application");
  mobius::core::application app;
  mobius::core::application app2;

  // constants
  test.ASSERT_EQUAL (app.get_name (), "Mobius Forensic Toolkit");
  test.ASSERT_NOT_EQUAL (app.get_version (), "");
  test.ASSERT_NOT_EQUAL (app.get_title (), "");
  test.ASSERT_NOT_EQUAL (app.get_copyright (), "");

  // unique reference
  test.ASSERT_EQUAL (app.get_name (), app2.get_name ());
  test.ASSERT_EQUAL (app.get_version (), app2.get_version ());
  test.ASSERT_EQUAL (app.get_title (), app2.get_title ());
  test.ASSERT_EQUAL (app.get_copyright (), app2.get_copyright ());

  // paths
  test.ASSERT_TRUE (app.get_config_path ("").length () > 0);
  test.ASSERT_EQUAL (app.get_config_path ("./"), app.get_config_path (""));

  test.ASSERT_TRUE (app.get_cache_path ("").length () > 0);
  test.ASSERT_EQUAL (app.get_cache_path ("./"), app.get_cache_path (""));

  test.ASSERT_TRUE (app.get_data_path ("").length () > 0);
  test.ASSERT_EQUAL (app.get_data_path ("./"), app.get_data_path (""));

  ASSERT_EXCEPTION (test, app.get_config_path ("../usr/lib"), std::invalid_argument);
  ASSERT_EXCEPTION (test, app.get_cache_path ("../usr/lib"), std::invalid_argument);

  test.end ();
}

static void
testcase_config ()
{
  mobius::unittest test ("mobius::core::config");

  // config
  mobius::core::set_config ("unittest", 1);
  test.ASSERT_TRUE (mobius::core::has_config ("unittest"));
  test.ASSERT_EQUAL (mobius::core::get_config ("unittest"), 1);

  mobius::core::set_config ("unittest", "abc");
  test.ASSERT_TRUE (mobius::core::has_config ("unittest"));
  test.ASSERT_EQUAL (mobius::core::get_config ("unittest"), "abc");

  test.ASSERT_FALSE (mobius::core::has_config ("unittest-aaaa"));
  test.ASSERT_EQUAL (mobius::core::get_config ("unittest-aaaa"), mobius::pod::data ());

  test.end ();
}

static void
testcase_resource ()
{
  mobius::unittest test ("mobius::core::resource");

  mobius::core::add_resource ("unittest.x", "x var", 5);
  mobius::core::add_resource ("unittest.y", "y var", std::string ("abc"));

  test.ASSERT_TRUE (mobius::core::has_resource ("unittest.x"));
  test.ASSERT_TRUE (mobius::core::has_resource ("unittest.y"));
  test.ASSERT_FALSE (mobius::core::has_resource ("unittest.z"));

  test.ASSERT_EQUAL (mobius::core::get_resource_value <int> ("unittest.x"), 5);
  test.ASSERT_EQUAL (mobius::core::get_resource_value <std::string> ("unittest.y"), "abc");
  ASSERT_EXCEPTION (test, mobius::core::get_resource_value <std::string> ("unittest.x"), std::invalid_argument);
  ASSERT_EXCEPTION (test, mobius::core::get_resource_value <int> ("unittest.z"), std::runtime_error);

  auto resources = mobius::core::get_resources ("unittest");
  test.ASSERT_EQUAL (resources.size (), 2);
  
  mobius::core::remove_resource ("unittest.z");
  mobius::core::remove_resource ("unittest.x");
  test.ASSERT_FALSE (mobius::core::has_resource ("unittest.x"));
  test.ASSERT_TRUE (mobius::core::has_resource ("unittest.y"));
  
  resources = mobius::core::get_resources ("unittest");
  test.ASSERT_EQUAL (resources.size (), 1);

  test.end ();
}

void
unittest_core ()
{
  testcase_application ();
  testcase_config ();
  testcase_resource ();
}
