#!/usr/bin/env python

import mobius
import sys

def get_hash (reader):
  h = mobius.crypt.hash ('sha2_512')
  data = reader.read (65536)
  while data:
    h.update (data)
    data = reader.read (65536)
    
  return h.get_hex_digest ()

def print_kff_folder (folder, path):

  try:
    if folder.is_reallocated ():
      return

    for child in folder.get_children ():
      if child.is_folder ():
        print_kff_folder (child, path + '/' + child.name)

      elif not child.is_deleted ():
        reader = child.new_reader ()
        if reader:
          h = get_hash (reader)
          print '%s\t%s/%s' % (h, path, child.name)
  except Exception, e:
    print 'Warning:', str (e)

def print_kff (disk):
  for idx, fs in enumerate (disk.get_filesystems ()):
    root = fs.get_root_folder ()
    print_kff_folder (root, chr (ord ('C') + idx) + ':')

for url in sys.argv[1:]:
   disk = mobius.disk.new_disk_from_url (url)

   if disk.is_available ():
     print_kff (disk)
