#ifndef MOBIUS_CRYPT_CIPHER_RC4_H
#define MOBIUS_CRYPT_CIPHER_RC4_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <cstdint>
#include <mobius/crypt/cipher_stream.h>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Alleged RC4 stream cipher algorithm
//! \author Eduardo Aguiar
//! \see http://en.wikipedia.org/wiki/RC4
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_rc4 : public cipher_stream
{
public:
  explicit cipher_rc4 (const mobius::bytearray&);
  void reset () override;

private:
  std::uint8_t start_s_[256];
  std::uint8_t i_ = 0;
  std::uint8_t j_ = 0;
  std::uint8_t S_[256];

  std::uint8_t _crypt_byte (std::uint8_t) noexcept;

  std::uint8_t
  _encrypt_byte (std::uint8_t b) noexcept override
  {
    return _crypt_byte (b);
  }

  std::uint8_t
  _decrypt_byte (std::uint8_t b) noexcept override
  {
    return _crypt_byte (b);
  }
};

} // namespace crypt
} // namespace mobius

#endif
