# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import pymobius
import pymobius.app.skype

ATTR_NAME = 'data.chats'

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Model class
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class model (object):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Initialize object
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self, item):
    self.__item = item

    if item.has_attribute (ATTR_NAME):
      self.__entries = item.get_attribute (ATTR_NAME)
      self.__entries_loaded = True

    else:
      self.__entries = []
      self.__entries_loaded = False

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Get data from model
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def get (self):
    if not self.__entries_loaded:
      self.__retrieve_entries ()
      self.__entries_loaded = True
      self.__item.set_attribute (ATTR_NAME, self.__entries)

    return self.__entries

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Get data from model
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def refresh (self):
    self.__item.remove_attribute (ATTR_NAME)
    self.__entries = []
    self.__entries_loaded = False

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Retrieve data
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __retrieve_entries (self):
    self.__retrieve_skype ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Retrieve data from Skype
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __retrieve_skype (self):
    MESSAGE_STATUS = {1 : 'Sending', 2 : 'Sent', 3 : 'Received', 4 : 'Read'}
    model = pymobius.app.skype.model (self.__item)

    # add messages
    for profile in model.get_profiles ():
      for m in profile.get_chat_messages ():
        entry = pymobius.Data ()
        entry.timestamp = m.timestamp
        entry.username = profile.username
        entry.sender_id = m.sender_id
        entry.sender_name = m.sender_name or m.sender_id
        entry.text_elements = []
        entry.raw_text = m.raw_text
        entry.text = m.text
        entry.app_id = 'skype'
        entry.app_name = 'Skype'
        entry.item = self.__item.get_attribute ('name')

        # message type
        type_text = str (m.type)
        if m.type_str:
          type_text += ' (%s)' % m.type_str

        # from/to
        entry.sender = entry.sender_id

        if entry.sender_name:
          entry.sender += ' (%s)' % entry.sender_name
          
        entry.recipients = []
        entry.recipients_id = []

        for r_id, r_name in m.recipients:

          r = r_id
          if r_name and r_name != r_id:
            r += ' (%s)' % r_name

          entry.recipients.append (r)
          entry.recipients_id.append (r_id)

        # metadata
        entry.metadata = []
        entry.metadata.append (('Chat ID', m.id))
        
        if hasattr (m, 'chatmsg_type'):
          entry.metadata.append (('Chat message type', m.chatmsg_type))

        entry.metadata.append (('Message type', type_text))
        entry.metadata.append (('From Skype account', entry.sender))
        entry.metadata.append (('To Skype accounts', '\n'.join (sorted (entry.recipients))))
        
        if hasattr (m, 'conversation_id'):
          entry.metadata.append (('Conversation ID', m.conversation_id))

        if m.status:
          entry.metadata.append (('Status', MESSAGE_STATUS.get (m.status, 'Unknown: %d' % m.status)))

        entry.metadata.append (('Profile', profile.name))
        entry.metadata.append (('Profile path', profile.path))

        self.__entries.append (entry)
