/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __MISC_H
#define __MISC_H

#include <stdlib.h>
#include <stdbool.h>

static inline  void *
safe_realloc (void *ptr, size_t size)
{
  void *new_ptr = realloc (ptr, size);
  if (!new_ptr)
    abort ();
  return new_ptr;
}

enum msglevel
  {
    MSG_FATAL = 0,
    MSG_ERROR,
    MSG_WARNING,
    MSG_INFORMATION,
    MSG_NOTE,
    MSG_DIAGNOSTIC
  };


void upad_msg (enum msglevel, const char *fmt, ...);
void upad_errno (enum msglevel lvl, const char *fmt, ...);

bool process_command (const char *cmd, size_t cmd_length, int fpr);

struct bounce_code_usage;
struct upload_format;
int upload_format (int des, struct upload_format *uf, const struct bounce_code_usage
		   *bcu);

#endif

