/*
    upad - A program for debugging, and uploading code to embedded devices.
    Copyright (C) 2016 John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
#ifndef FLASH_H
#define FLASH_H

#include <stdint.h>
#include <stdbool.h>

#define FLASH_CMD_LEN 28

struct flash_command
{
  uint8_t cmd;
  bool aux_arg;
  int n_args;
  char name[FLASH_CMD_LEN];
};

extern const struct flash_command flash_commands[];

#define Z12FL_ERASE_VERIFY_ALL                  0x01
#define Z12FL_ERASE_VERIFY_BLOCK                0x02
#define Z12FL_ERASE_VERIFY_PFLASH               0x03
#define Z12FL_READ_ONCE                         0x04
#define Z12FL_PROGRAM_PFLASH                    0x06
#define Z12FL_PROGRAM_ONCE                      0x07
#define Z12FL_ERASE_ALL_BLOCKS                  0x08
#define Z12FL_ERASE_FLASH_BLOCK                 0x09
#define Z12FL_ERASE_PFLASH_SECTOR               0x0A
#define Z12FL_UNSECURE_FLASH                    0x0B
#define Z12FL_VERIFY_BACKDOOR_ACCESS_KEY        0x0C
#define Z12FL_SET_USER_MARGIN_LEVEL             0x0D
#define Z12FL_SET_FIELD_MARGIN_LEVEL            0x0E
#define Z12FL_ERASE_VERIFY_EEPROM_SECTION       0x10
#define Z12FL_PROGRAM_EEPROM                    0x11
#define Z12FL_ERASE_EEPROM_SECTOR               0x12
#define Z12FL_PROTECTION_OVERRIDE               0x13

enum flash_cmd
  {
    ERASE_VERIFY_ALL,
    ERASE_VERIFY_BLOCK,
    ERASE_VERIFY_PFLASH,
    READ_ONCE,
    PROGRAM_PFLASH,
    PROGRAM_ONCE,
    ERASE_ALL_BLOCKS,
    ERASE_FLASH_BLOCK,
    ERASE_PFLASH_SECTOR,
    UNSECURE_FLASH,
    VERIFY_BACKDOOR_ACCESS_KEY,
    SET_USER_MARGIN_LEVEL,
    SET_FIELD_MARGIN_LEVEL,
    ERASE_VERIFY_EEPROM_SECTION,
    PROGRAM_EEPROM,
    ERASE_EEPROM_SECTOR,
    PROTECTION_OVERRIDE,
    n_FLASH_CMDS,
    invalid
  };

void flash_setup (void);

struct cache
{
  uint8_t fstat;
};


bool flash_command (uint8_t code, uint8_t arg_aux, int n_args,
		    const uint16_t *args, struct cache *cache);


#endif
