// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/log.h>
#include <wx/image.h>

#include <new>

#include <config.h>
#include "../checksetup.h"

#include "onedata.h"

namespace One
{

bool myErrorHandler(int err, char *msg)
{
  if(err == WXEXPR_ERROR_SYNTAX)
  {
    wxLogError(_("Syntax error in data file: %s"), msg);
  }
  else
  {
    wxLogError(_("Error while processing data file: %s"), msg);
  }
  return true;			// Continue anyway
}


OneData::OneData(const wxString &filename, One *one)
  throw(Exception) try:
  m_db(NULL),
  m_one(one)
{
  wxLogTrace("entering", "OneData constructor");
  m_current_screen = "first";
  m_db = new wxExprDatabase(myErrorHandler);
  if(!m_db->Read(filename))
    throw NoisyException(_("Could not read data file"));
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

Screen *OneData::cGetScreen() throw(Exception)
{
  wxASSERT(m_db != NULL);
  m_db->BeginFind();
  wxExpr *e_screen = m_db->FindClauseByFunctor(m_current_screen);

  if(e_screen == NULL)
    throw NoisyException(wxString::Format
			 (_("Error in data file. Could not retrieve "
			   "the clause named \"%s\"."),
			  m_current_screen.c_str()));

  Screen *screen = cScreen();

  wxExpr *e_imlist = NULL;
  e_screen->GetAttributeValue("images", &e_imlist);

  wxString image_filename; wxBitmap *bitmap;
  if(! wxImage::FindHandler(wxBITMAP_TYPE_PNG))
    wxImage::AddHandler(new wxPNGHandler());
  if(! wxImage::FindHandler(wxBITMAP_TYPE_JPEG))
    wxImage::AddHandler(new wxJPEGHandler());

  // Note that there might not be any images in the resulting Screen object.
  if(e_imlist != NULL)
  {
    for(wxExpr *item = e_imlist->GetFirst(); item != NULL; item = item->GetNext())
    {
      if(item->Type() != wxExprString)
      {
	wxLogWarning(_("Each image listed in the data file must be a string."));
	continue;
      }

      image_filename = GetApp()->config->GetModuleDataFile(item->StringValue());

      wxLogTrace("image", "Found image item \"%s\".", image_filename.c_str());

      bitmap = new wxBitmap(image_filename, wxBITMAP_TYPE_ANY);
      if(bitmap != NULL)
	screen->images.push_back(bitmap);
      bitmap = NULL;
    }
  }

  AddAnswersToScreen(e_screen, screen);

  return screen;
}


void OneData::SaveData(const wxString &title) const throw()
try
{
  // FIXME

//   wxExpr *el = new wxExpr(wxExprList);

//   for(list<SelfCorrecting*>::iterator iter = m_sc.begin();
//       iter != m_sc.end();
//       ++iter)
//   {
//     if(*iter != NULL)
//     {
//       el->Append(new wxExpr(wxExprString, (*iter)->GetValue()));
//     }
//     else
//     {
//       el->Append(new wxExpr(wxExprString, ""));
//     }
//   }

//   // AddLabelledData() makes a local copy.
//   GetApp()->AddLabelledData(title, el);

//   delete el;
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}


// void ChooseOnePanel::LoadData() throw()
// try
// {
//   wxExpr *el = GetApp()->cGetData(m_ms->expr->Functor() + "_data");

//   if(el->Type() == wxExprList)
//   {
//     wxExpr *item = el->GetFirst();
//     list<SelfCorrecting*>::iterator iter = m_sc.begin();
//     for(; item != NULL && iter != m_sc.end(); (item = item->GetNext()), ++iter)
//     {
//       if(item->Type() == wxExprString)
//       {
// 	if(*iter != NULL)
// 	{
// 	  (*iter)->SetValue(item->StringValue());
// 	}
//       }
//     }
//   }

//   delete el;

//   // If there was any data, it was probably in a file the user had
//   // saved, and should not be used again during this session.
//   GetApp()->ForgetData(m_ms->expr->Functor() + "_data");
// }
// catch(NullException &ex)
// {
//   wxLogDebug("There is no saved data for this object.");
// }
}
