// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <new>

#include <config.h>
#include "../checksetup.h"

#include "../application.h"
#include "../htmlpanel.h"
#include "../introwc.h"
#include "multsim.h"
#include "multsimpanel.h"
#include "multsimdata.h"

extern "C" char *version(void)
{
  return PACKAGE_STRING;
}

extern "C" char *type(void)
{
  return "WindowContents";	// This is a WindowContents object
}

void MultSim::Init(const wxExpr *ex,
		   wxPanel *panel) throw(Exception)
try
{
  wxLogTrace("entering", "MultSim::Init()");

  try
  {
    GetApp()->GetCurrentWC()->Destroy();
  }
  catch(NullException &ex) {} 	// harmless, there is no current wc.

  IntroWC::Init(ex, panel);

  m_correct = 0;

  m_data = new MultSimData(this, expr);

  wxString theme_name;
  expr->GetAttributeValue("theme", theme_name);
  if(theme_name != wxEmptyString)
    m_theme = new Theme(theme_name);
  else
    m_theme = NULL;
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

void MultSim::EnterRoom() throw(Exception)
try
{
  wxLogTrace("entering", "MultSim::EnterRoom()");

  m_panel = new MultSimPanel(this, expr);  
  m_panel->GiveOneFocus();
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

wxExpr* MultSim::cHibernate() throw(Exception)
try
{
  wxASSERT(expr != NULL);

  if(m_panel != NULL)
    m_panel->SaveData(expr->Functor() + "_data");
  return expr->Copy();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

void MultSim::OneMoreCorrect() throw()
try
{
  wxASSERT(m_data != NULL);

  m_correct++;
  if(m_correct >= m_data->GetColumns() * m_data->GetRows())
    GoThroughDoor("success");

#if __WXDEBUG__
  wxWindow *win = wxWindow::FindFocus();
  if(win == NULL)
    wxLogDebug("No window has focus");
  else
    wxLogDebug("A window has focus");

#endif
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}
catch(Exception &ex)
{
  if(!ex.Close())
    abort();
}

void MultSim::Destroy() throw()
{
  wxLogTrace("entering", "MultSim::Destroy(): clearing window.");
  
  main_panel->DestroyChildren(); 

  if(m_theme != NULL)
  {
    delete m_theme;
    m_theme = NULL;
  }

  if(m_data != NULL)
  {
    delete m_data;
    m_data = NULL;
  }
}

// The class factories

extern "C" WindowContents* create(void)
{
  wxLogDebug("Creating an MultSim object.");
  return new(std::nothrow) MultSim();
}

extern "C" void destroy(WindowContents *w)
{
  wxLogDebug("Deleting a WindowContents object (i.e. an MultSim object)");
  delete w;
}
