;;;; FILE IDENTIFICATION
;;;; 
;;;; Name:		utility.lisp
;;;; Purpose:		Generic utility functions and macros
;;;; Programmer:	Raffaele Arecchi
;;;; Date Started:	11 Sep 2007
;;;;
;;;; Copyright (C) 2007 Raffaele Arecchi 
;;;;
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2 of the License, or
;;;; (at your option) any later version.


(defpackage :utility
	(:use :cl)
	(:export #:member-rec
		#:memberp
		#:nremove
		#:first->last
		#:find-sym
		#:find-num
		#:while))

(in-package :utility)

(defun member-rec (x y) (member x y :test #'equal))			; member test for sublists (recursive)

(defun memberp (x y) (not (equal (member x y) NIL)))			; is x member of the y list?

(defmacro first->last (y) `(let ((q (car ,y))) (nconc ,y (list q))))	; insert the first of y into the last of y

(defun find-sym (x) (if (symbolp (car x))
			(car x)
			(find-sym (cdr x))))				; find any symbol in a list
(defmacro nremove (x y) `(setf ,y (remove ,x ,y :test #'equal)))	; from the y list permanently


; this function returns all numbers in x sorted and without repetitions
(defun find-num (z)
	(let ((y (remove NIL (mapcar #'(lambda (x) (if (numberp x) x NIL)) z)))) ; y is z without non-numbers
	     (dolist (i y)
		     (progn (nremove i y) (push i y)))			; remove repetitions
	     (sort y #'<)))						; finally sort the result


(defmacro while (test &body body)					; the while loop!
	`(do ()
	     ((not ,test))
	 ,@body))
