/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "cfg.h"

#define TEST_CFG "test.xml"
#define TEST_ARGC 3
#define TEST_ARGV0 "abc"
#define TEST_ARGV1 "--fullscreen"
#define TEST_ARGV2 "--width=800"
#define TEST_UNIFIED_KEY_YES LW6DEF_WIDTH
#define TEST_UNIFIED_KEY_NO "unknown"

/*
 * Testing loading/saving
 */
static int
test_load_save ()
{
  int ret = 1;
  void *context;
  int argc = TEST_ARGC;
  char *argv[TEST_ARGC] = { TEST_ARGV0, TEST_ARGV1, TEST_ARGV2 };
  char *user_dir = NULL;
  char *test_cfg = NULL;

  LW6SYS_TEST_FUNCTION_BEGIN;

  context = lw6cfg_init (argc, argv);
  if (context)
    {
      user_dir = lw6sys_get_default_user_dir ();
      if (user_dir)
	{
	  if (!lw6sys_dir_exists (user_dir))
	    {
	      lw6sys_create_dir (user_dir);
	    }
	  test_cfg = lw6sys_path_concat (user_dir, TEST_CFG);
	  if (test_cfg)
	    {
	      /*
	       * Note: we don't consider the test as invalid if the
	       * file does not exist, after all, it's a normal behavior
	       * of the game to be launched without any config file.
	       */
	      lw6cfg_load (context, test_cfg);
	      lw6cfg_save (context, test_cfg);

	      LW6SYS_FREE (test_cfg);
	    }
	  LW6SYS_FREE (user_dir);
	}
      lw6cfg_quit (context);
    }
  else
    {
      ret = 0;
    }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/*
 * Test unified options
 */
static int
test_unified ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;
  int argc = TEST_ARGC;
  char *argv[TEST_ARGC] = { TEST_ARGV0, TEST_ARGV1, TEST_ARGV2 };

  {
    char *value;

    value = lw6cfg_unified_get_value (argc, argv, TEST_UNIFIED_KEY_YES);
    if (value)
      {
	lw6sys_log (LW6SYS_LOG_NOTICE, _("value for \"%s\" is \"%s\""),
		    TEST_UNIFIED_KEY_YES, value);
	LW6SYS_FREE (value);
      }
    else
      {
	ret = 0;
      }

    value = lw6cfg_unified_get_value (argc, argv, TEST_UNIFIED_KEY_NO);
    if (value)
      {
	lw6sys_log (LW6SYS_LOG_WARNING,
		    _("key \"%s\" has value \"%s\", should be NULL"),
		    TEST_UNIFIED_KEY_NO, value);
	LW6SYS_FREE (value);
	ret = 0;
      }
    else
      {
	// OK
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

int
lw6cfg_test ()
{
  int ret = 0;

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
    }

  ret = test_load_save () && test_unified ();

  return ret;
}
