/*
Copyright (C) 2015 John Tse

This file is part of Libknit.

Libknit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Libknit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Libknit.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <string.h>
#include <stdint.h>
#include "_knit.h"

void ofb(void (*cipher)(uint64_t, uint64_t *), size_t block_size, size_t n_blocks, uint64_t iv, void *i, void *o) {
	uint64_t ib;
	uint64_t ob;

	for (uint32_t j = 0; j < n_blocks; j++) {
		ib = s2i(i + j * block_size, block_size);

		(*cipher)(iv, &ob);

		iv = ob;

		memcpy(o + j * block_size, i2s(ob ^ ib, block_size), block_size);
	}
}
