/*
Copyright (C) 2015 John Tse

This file is part of Libknit.

Libknit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Libknit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Libknit.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <stdint.h>

uint64_t _s2i(uint8_t *s, uint32_t n) {
	uint64_t i = 0;

	for (uint16_t m = 0; m < n; m++)
		i |= ((((uint64_t) s[m]) << ((n * 8) - ((m + 1) * 8))));

	return i;
}

uint64_t s2i(uint8_t *s, int32_t n) {
	uint64_t i = 0;

	for (uint64_t m = 1; --n >= 0; m <<= 8)
		i += s[n] * m;

	return i;
}

uint8_t * i2s(uint64_t i, uint32_t n) {
	uint8_t *s = calloc(n, 1);

	for (uint8_t m = 0; m < 8; m++)
		s[m] = (uint8_t) ((i >> ((n * 8) - ((m + 1) * 8))));

	return s;
}
