/*
Copyright (C) 2015 John Tse

This file is part of Libknit.

Libknit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Libknit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Libknit.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#define F(X,Y,Z) ((X & Y) | ((~X) & Z))
#define G(X,Y,Z) ((X & Y) | (X & Z) | (Y & Z))
#define H(X,Y,Z) (X ^ Y ^ Z)

#define rol32(X,Y) ((X << Y) | (X >> (32 - Y)))

static uint8_t * append(uint8_t *t, uint64_t b, uint32_t *N) {
	uint8_t *m;
	uint64_t n;

	n = b + (64 - ((b - 56) % 64)) + 8;

	m = calloc(n, 1);

	memcpy(m, t, b);

	m[b] = 0x80;

	b *= 8;

	for (uint16_t i = 8, j = 0; i > 0; i--, j += 8)
		m[n - i] = (uint8_t) (b >> j) & 0xff;

	*N = n / 4;

	return m;
}

uint8_t * md4(uint8_t *m, uint64_t b) {
	uint32_t *M;
	uint32_t N;
	uint32_t A, B, C, D;
	uint32_t AA, BB, CC, DD;
	uint32_t X[16];
	uint32_t *MD[4];
	uint8_t *h;

	m = append(m, b, &N);

	M = calloc(N, 4);

	for (uint32_t i = 0, j = 0; i < N; i++, j += 4)
		M[i] = (uint32_t) ((int32_t) m[j + 3] << 24) | ((int32_t) m[j + 2] << 16) | ((int32_t) m[j + 1] << 8) | ((int32_t) m[j]);

	A = 0x67452301;
	B = 0xefcdab89;
	C = 0x98badcfe;
	D = 0x10325476;

	MD[0] = &A;
	MD[1] = &B;
	MD[2] = &C;
	MD[3] = &D;

	for (uint32_t i = 0; i < N / 16; i++) {
		for (uint8_t j = 0; j < 16; j++)
			X[j] = M[i * 16 + j];

		AA = A;
		BB = B;
		CC = C;
		DD = D;

		// Round 1
		A = rol32((A + F(B,C,D) + X[0]), 3);
		D = rol32((D + F(A,B,C) + X[1]), 7);
		C = rol32((C + F(D,A,B) + X[2]), 11);
		B = rol32((B + F(C,D,A) + X[3]), 19);

		A = rol32((A + F(B,C,D) + X[4]), 3);
		D = rol32((D + F(A,B,C) + X[5]), 7);
		C = rol32((C + F(D,A,B) + X[6]), 11);
		B = rol32((B + F(C,D,A) + X[7]), 19);

		A = rol32((A + F(B,C,D) + X[8]),  3);
		D = rol32((D + F(A,B,C) + X[9]),  7);
		C = rol32((C + F(D,A,B) + X[10]), 11);
		B = rol32((B + F(C,D,A) + X[11]), 19);

		A = rol32((A + F(B,C,D) + X[12]), 3);
		D = rol32((D + F(A,B,C) + X[13]), 7);
		C = rol32((C + F(D,A,B) + X[14]), 11);
		B = rol32((B + F(C,D,A) + X[15]), 19);

		// Round 2
		A = rol32((A + G(B,C,D) + X[0]  + 0x5a827999), 3);
		D = rol32((D + G(A,B,C) + X[4]  + 0x5a827999), 5);
		C = rol32((C + G(D,A,B) + X[8]  + 0x5a827999), 9);
		B = rol32((B + G(C,D,A) + X[12] + 0x5a827999), 13);

		A = rol32((A + G(B,C,D) + X[1]  + 0x5a827999), 3);
		D = rol32((D + G(A,B,C) + X[5]  + 0x5a827999), 5);
		C = rol32((C + G(D,A,B) + X[9]  + 0x5a827999), 9);
		B = rol32((B + G(C,D,A) + X[13] + 0x5a827999), 13);

		A = rol32((A + G(B,C,D) + X[2]  + 0x5a827999), 3);
		D = rol32((D + G(A,B,C) + X[6]  + 0x5a827999), 5);
		C = rol32((C + G(D,A,B) + X[10] + 0x5a827999), 9);
		B = rol32((B + G(C,D,A) + X[14] + 0x5a827999), 13);

		A = rol32((A + G(B,C,D) + X[3]  + 0x5a827999), 3);
		D = rol32((D + G(A,B,C) + X[7]  + 0x5a827999), 5);
		C = rol32((C + G(D,A,B) + X[11] + 0x5a827999), 9);
		B = rol32((B + G(C,D,A) + X[15] + 0x5a827999), 13);

		// Round 3
		A = rol32((A + H(B,C,D) + X[0]  + 0x6ed9eba1), 3);
		D = rol32((D + H(A,B,C) + X[8]  + 0x6ed9eba1), 9);
		C = rol32((C + H(D,A,B) + X[4]  + 0x6ed9eba1), 11);
		B = rol32((B + H(C,D,A) + X[12] + 0x6ed9eba1), 15);

		A = rol32((A + H(B,C,D) + X[2]  + 0x6ed9eba1), 3);
		D = rol32((D + H(A,B,C) + X[10] + 0x6ed9eba1), 9);
		C = rol32((C + H(D,A,B) + X[6]  + 0x6ed9eba1), 11);
		B = rol32((B + H(C,D,A) + X[14] + 0x6ed9eba1), 15);

		A = rol32((A + H(B,C,D) + X[1]  + 0x6ed9eba1), 3);
		D = rol32((D + H(A,B,C) + X[9]  + 0x6ed9eba1), 9);
		C = rol32((C + H(D,A,B) + X[5]  + 0x6ed9eba1), 11);
		B = rol32((B + H(C,D,A) + X[13] + 0x6ed9eba1), 15);

		A = rol32((A + H(B,C,D) + X[3]  + 0x6ed9eba1), 3);
		D = rol32((D + H(A,B,C) + X[11] + 0x6ed9eba1), 9);
		C = rol32((C + H(D,A,B) + X[7]  + 0x6ed9eba1), 11);
		B = rol32((B + H(C,D,A) + X[15] + 0x6ed9eba1), 15);

		A = A + AA;
		B = B + BB;
		C = C + CC;
		D = D + DD;
	}

	free(M);

	h = calloc(16, 1);

	for (uint8_t i = 0; i < 4; i++)
		for (uint8_t j = 0; j < 4; j++)
			h[i * 4 + j] = (uint8_t) (*MD[i] >> (j * 8)) & 0xff;

	return h;
}
