/*
Copyright (C) 2015 John Tse

This file is part of Libknit.

Libknit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Libknit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Libknit.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <stdint.h>

#define KNIT_BLOWFISH_BLOCK_SIZE   8
#define KNIT_BLOWFISH_MIN_KEY_SIZE 4
#define KNIT_BLOWFISH_MAX_KEY_SIZE 56

#define KNIT_RC2_BLOCK_SIZE   8
#define KNIT_RC2_MIN_KEY_SIZE 1
#define KNIT_RC2_MAX_KEY_SIZE 128

#define KNIT_RC4_MIN_KEY_SIZE 5
#define KNIT_RC4_MAX_KEY_SIZE 256

#define KNIT_MD2_BLOCK_SIZE  16
#define KNIT_MD2_DIGEST_SIZE 16

#define KNIT_MD4_BLOCK_SIZE  64
#define KNIT_MD4_DIGEST_SIZE 16

#define KNIT_MD5_BLOCK_SIZE  64
#define KNIT_MD5_DIGEST_SIZE 16

// set constants

//// 2 bits for ciphers
#define KNIT_BLOWFISH 1
#define KNIT_RC2      2
#define KNIT_RC4      3

//// 2 bits for hashing
#define KNIT_MD2  4
#define KNIT_MD4  8
#define KNIT_MD5 12

//// 2 bits for modes
#define KNIT_ECB 16
#define KNIT_CBC 32
#define KNIT_OFB 48

//// 1 bit for macs
#define KNIT_HMAC 64

#define KNIT_KEY 128
#define KNIT_IV  256
#define KNIT_EKB 512

// do constants
#define KNIT_ENCRYPT 1
#define KNIT_DECRYPT 2
#define KNIT_HASH    4
#define KNIT_MAC     8

// error constants
#define KNIT_ERROR_OK           0
#define KNIT_ERROR_NO_OP        1
#define KNIT_ERROR_NO_ALGO      2
#define KNIT_ERROR_NO_KEY       3
#define KNIT_ERROR_NO_IV        4
#define KNIT_ERROR_MIN_KEY_SIZE 5

typedef struct knit_ctx {
	uint8_t cipher;
	uint8_t hash;
	uint8_t mac;
	uint8_t mode;

	void *k;
	size_t k_length;

	void *iv;
	size_t iv_length;

	size_t ekb;
} * KNIT;

KNIT knit_new();

void knit_free(KNIT);

void knit_set(KNIT, uint32_t, ...);

uint8_t knit_do(KNIT, uint8_t, void *, size_t, ...);

uint8_t * knit_error(uint8_t);
