{- This source file is part of mmisar - a tool for converting
Metamath proofs to Isabelle/Isar.
Copyright 2006 Slawomir Kolodynski

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-}


{-module Inner(mmForm2Isar)
    where
-}

module Inner
    where

import Maybe
import ParseMM
import Export2Isabelle

-- translates a Metamath formula into an Isar formula. 
-- Examples:
-- mmForm2Isar "a /\\ ( b -> c )" == "a \\<and> ( b \\<longleftrightarrow> c )"
-- mmForm2Isar "ph -> A e. CC" == "\<phi> --> A \<in> \<complex>"
-- mmForm2Isar "A e. RR -> A e. CC" == "A \<in> \<real> --> A \<in> \<complex>"
-- mmForm2Isar "E! x e. A ph <-> ( E. x e. A ph /\ A. x e. A A. y e. A ( ( ph /\ ps ) -> x = y ) )"
-- == "(\<exists>! x. x \<in> A \<and> \<phi> ) \<longleftrightarrow> ( ( \<exists> x \<in> A. \<phi> ) \<and> ( \<forall> x
-- \<in> A . \<forall> y \<in> A . ( ( \<phi> \<and> \<psi> ) \<longrightarrow> x = y ) ) )"
-- "A <_ B \\/ B <_ A"
-- "B < A <-> -. A <_ B"
-- A = if ( A e. RR , A , 0 )
-- "0 < ( 1 / A )"
-- "E. x e. RR ( 0 < x /\\ ( x < A /\\ x < B ) )
-- "NN e. V"
-- "x e. { y | ph }"
-- "x e. { y e. A | ph }"
-- "A. y e. { x e. NN | ph } ( y + 1 ) e. { x e. NN | ph }"


mmForm2Isar :: String -> String
mmForm2Isar mmexp = if isNothing parsed then error ("can not parse " ++ mmexp) 
                    else "\"" ++ (exp2Isabelle 0 $ fromJust parsed) ++ "\""
                       where parsed = str2LogExpr $ words mmexp