/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model.user;

import javax.mail.internet.InternetAddress;
import javax.mail.internet.AddressException;

import net.jatec.ironmailer.model.ModelException;


public class Addresses
{
    public final static String KEY = "Addresses";
    // user types used in this class (including superclasses of used types)
    public final static Class[] TYPES = {Addresses.class, AddressItem.class, InternetAddress.class, javax.mail.Address.class};

    private AddressItem[] items;

    public Addresses() {
	items = new AddressItem[0];
    }

    public void setItems(AddressItem[] items) {
	this.items = items;
    }

    public AddressItem[] getItems() {
	return items;
    }

    /** for debugging */
    public String toString() {
	StringBuffer ret = new StringBuffer();
	if (items.length == 0)
	    ret.append("(empty list");
	else
	    for (int i = 0; i < items.length; i++)
		ret.append("address " + (i+1) + ": " + items[i].toString());
	return ret.toString();
    }

    public static Addresses getTestAddresses() throws ModelException
    {
	Addresses al = new Addresses();
	try {
	    AddressItem ai = new AddressItem("dpp", new InternetAddress("depp@arschgeige.com"));
	    AddressItem ai2 = new AddressItem("a va pter", new InternetAddress("idiot@debile.fr"));
	    AddressItem[] ail = new AddressItem[]{ai,ai2};
	    al.setItems(ail);
	}
	catch (AddressException e) {
	    throw new ModelException("setup error", e);
	}
	return al;
    }
}
