/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;

import org.apache.log4j.Logger;

import net.jatec.ironmailer.framework.MailTools;
import net.jatec.ironmailer.framework.StringTools;

/**
 * Part of the client model.
 * Contains information about the sending of a message
 */
public class SendInfo
{
    private final Logger log = Logger.getLogger(SendInfo.class);
    private boolean isOK;
    private String subject;
    private String recipients;
    private String date;
    private String validSentAddresses;
    private String validUnsentAddresses;
    private String invalidAddresses;
    private String serviceMessage;

    public SendInfo(MimeMessage mm, MessagingException e) 
	throws IllegalArgumentException, MessagingException
    {
	isOK = (e == null);
	log.debug("SendInfo() called, did sending work ? " + isOK);
	subject = mm.getSubject();
	recipients = MailTools.toString(mm.getAllRecipients());
	date = StringTools.getCurrentDateAsString();

	if (isOK) {
	    validSentAddresses = null;
	    validUnsentAddresses = null;
	    invalidAddresses = null;
	    serviceMessage = null;
	}
	else {
	    if (log.isDebugEnabled())
		log.debug("SendInfo() handling case where sending failed, due to exception " + e.getMessage());

	    if (e instanceof SendFailedException) {
		SendFailedException sfe = (SendFailedException)e;
		validSentAddresses = MailTools.toString(sfe.getValidSentAddresses());
		validUnsentAddresses = MailTools.toString(sfe.getValidUnsentAddresses());
		invalidAddresses = MailTools.toString(sfe.getInvalidAddresses());
		serviceMessage = MailTools.toDisplayableString(sfe);
	    }
	    else
		if (e instanceof AddressException) {
		    // TO DO: use the specific knowledge of this exception for
		    // more user friendly message ?
		    serviceMessage = MailTools.toDisplayableString(e);
		}
		else {
		    serviceMessage = MailTools.toDisplayableString(e);
		}
	}

    }
    
    /** 
     * Is set only in error case, to distinguish successful addresses
     * from the others
     */
    public String getValidSentAddresses() { return validSentAddresses;}

    public String getValidUnsentAddresses() { return validUnsentAddresses;}

    public String getInvalidAddresses() { return invalidAddresses;}

    public String getServiceMessage() { return serviceMessage;}

    public boolean isOK() { return isOK;}

    public String getSubject() { return subject;}

    public String getRecipients() { return recipients;}

    public String getDate() { return date;}
}

