/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

/**
 * Thrown when attempting to add a duplicate contact
 */
public class ContactDuplicateException extends ModelException
{
    private Contact newContact;
    private Contact inList;
    private int positionInList;

    public ContactDuplicateException(Contact newContact, Contact inList, int positionInList) {
	super("contact duplicate");
	this.newContact = newContact;
	this.inList = inList;
	this.positionInList = positionInList;
    }

}
