/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import javax.mail.Address;
import javax.mail.internet.InternetAddress;

import org.apache.log4j.Logger;


/**
 * Part of the client model.
 * Contains information about a contact.
 * Implementation note: this must be a bean, as it will be serialized as XML
 */
public class Contact
{
    private final Logger log = Logger.getLogger(Contact.class);
    // user types used in this class (including superclasses of used types)
    public final static Class[] TYPES = {Contact.class, InternetAddress.class, Address.class};

    private String nickname;
    private InternetAddress emailAddress;

    public Contact() {}

    public String getNickname() {
	return nickname;
    }

    public void setNickname(String nickname) {
	this.nickname = nickname;
    }

    public InternetAddress getEmailAddress() {
	return emailAddress;
    }

    public void setEmailAddress(InternetAddress emailAddress) {
	this.emailAddress = emailAddress;
    }


}
