/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import java.io.File;
import java.util.Vector;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.internet.MimeBodyPart;
import org.apache.log4j.Logger;


/**
 * When creating attachment to a new mail message,
 * this class holds the necessary information
 * Encapsulates for the GUI the underlying implementation of
 * attachments
 */
public class AttachmentHolder
{
    private final Logger log = Logger.getLogger(AttachmentHolder.class);
    private Vector attachments;
    private long totalSize;
    private long maxSize;

    public AttachmentHolder(long maxSize) {
	attachments = new Vector(3);
	totalSize = 0;
	this.maxSize = maxSize;
    }

    public void add(File f) 
	throws AttachmentSizeExceededException, ModelException
    {
	FileAttachment fa = new FileAttachment(f);
	long thisSize = fa.getSize();
	if ((totalSize + thisSize) > maxSize) {
	    String thisName = fa.getName();
	    fa.destroy();
	    throw new AttachmentSizeExceededException(maxSize, totalSize, thisSize, thisName);
	}
	attachments.add(fa);
	totalSize += fa.getSize();
    }

    public void delete(int index) {
	FileAttachment fa = (FileAttachment)attachments.remove(index);
	totalSize -= fa.getSize();
	fa.destroy();
    }

    public int getNbAttachments() {
	if (attachments != null)
	    return attachments.size();
	else
	    return 0;
    }

    public String getAttachmentName(int index) {
	return ((FileAttachment)attachments.get(index)).getName();
    }

    public String getAttachmentSize(int index) {
	return ((FileAttachment)attachments.get(index)).getSizeAsString();
    }

    public MimeBodyPart getAttachment(int index) {
	FileAttachment fa = (FileAttachment)attachments.get(index);
	return fa.getMimeBodyPart();	
    }
//     public DataSource getAttachmentDataSource(int index) {
// 	FileAttachment fa = (FileAttachment)attachments.get(index);
// 	return fa.getDataSource();
//     }

    public long getTotalSize() {
	return totalSize;
    }

    public long getMaxSize() {
	return maxSize;
    }

    /**
     * convenience method to get the list of names of all attachments
     */
    public String getAttachmentNames(String separator) {
	StringBuffer ret = new StringBuffer();
	for (int i = 0; i < getNbAttachments(); i++) {
	    if (i > 0)
		ret.append(separator);
	    ret.append(getAttachmentName(i));
	}
	return ret.toString();
    }

    public void destroy() {
	log.debug("destroy() called");
	for (int i = getNbAttachments() - 1; i >= 0 ; i--)
	    delete(i);
	attachments = null;
    }

}

