/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.framework;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.parameters.ParameterException;

/**
 * Receptable for Cocoon (or Cocoon-related) utilities
 * @author jwk
 */
public class CocoonTools
{

    /**
     * for debugging
     */
    public static String toString(Parameters par)
    {
	StringBuffer ret = new StringBuffer();
	ret.append("<" + Parameters.class + " ");
	String[] parNames = par.getNames();
	for (int i = 0; i < parNames.length; i++) {
	    String val = null;
	    try {
		val = par.getParameter(parNames[i]);
	    } catch (ParameterException e) {
		val = e.toString();
	    }
	    ret.append(parNames[i] + "=" + val + " ");
	}
	ret.append("/>");
	return ret.toString();
    }
}
