/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import java.util.Collections;
import java.util.Map;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;

// cocoon
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.Constants;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.cocoon.acting.AbstractAction;

// for logging use log4j
import org.apache.log4j.Logger;

import net.jatec.ironmailer.framework.HttpSessionManager;
import net.jatec.ironmailer.framework.StringTools;


/**
 * @author wk
 */
public class LogoutAction extends AbstractAction
{
    private final Logger log = Logger.getLogger(LogoutAction.class);
    
    /**
     * Interface implementation
     * @throws Exception according to interface, but should never happen.
     * If there is some error, null is returned and the exception is logged.
     */
    public Map act(Redirector redirector, SourceResolver resolver, 
		   Map objectModel, String source,
		   Parameters par) 
	throws Exception 
    {
        HttpServletRequest req =(HttpServletRequest)objectModel.get(HttpEnvironment.HTTP_REQUEST_OBJECT);

	try {
	    log.debug("act() called");
	    HttpSessionManager.getInstance().invalidateSession(req);
	    log.debug("act() done");
	    return Collections.EMPTY_MAP;
	}
	catch (Throwable t) {
	    // All errors result in the action failing, and in the setting
	    // of error fields in the request for possible later display 
	    log.error("act() got some unexpected error", t);
	    req.setAttribute("error.content", t.toString());
	    req.setAttribute("error.stack", StringTools.getStackTraceAsString(t));		
	    return null;
	}
	
    }
}

