/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailWorkerBean;

public class ActionDispatcher
{
    private final Logger log = Logger.getLogger(ActionDispatcher.class);
    private HashMap actionMap;

    public ActionDispatcher() {
	actionMap = new HashMap(7);
	actionMap.put("navbar", new NavbarAction());
	actionMap.put("folder", new FolderAction());
	actionMap.put("message", new MessageAction());
	actionMap.put("getattachment", new GetAttachmentAction());
	actionMap.put("setflag", new SetFlagAction());
	actionMap.put("compose", new ComposeAction());
	actionMap.put("leavecompose", new LeaveComposeAction());
	actionMap.put("setupfolders", new SetupFoldersAction());
	actionMap.put("setupuser", new SetupUserAction());
	actionMap.put("message_as_pdf", new MessageAsPdfAction());
	actionMap.put("addresses", new AddressesAction());
	actionMap.put("contact", new ContactAction());
	actionMap.put("attach", new AttachAction());
	actionMap.put("fileattach", new FileAttachAction());
    }

    public interface ActionStrategy {
	void process(ServletRequest req, MailWorkerBean wb, 
		     Redirector redirector, Map objectModel) 
	    throws ControllerException;
    }

    public void processRequest(String actionName, ServletRequest req,
			       MailWorkerBean wb, 
			       Redirector redirector, Map objectModel)
	throws ControllerException
    {
	if (log.isDebugEnabled())
	    log.debug("processRequest() called for actionName " + actionName);

	if (actionName == null || actionName.equals("")) return;

	ActionStrategy action = (ActionStrategy)actionMap.get(actionName);
	if (action == null)
	    throw new ControllerException("no action found for name " + actionName, null);
	action.process(req, wb, redirector, objectModel);
    }

}

