/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller;

import org.apache.log4j.Logger;

import net.jatec.ironmailer.model.MailMessage;
import net.jatec.ironmailer.model.MailPart;
import net.jatec.ironmailer.model.ModelException;

/**
 * Controller for attachments
 */
public class AttachmentController
{
    private final Logger log = Logger.getLogger(AttachmentController.class);

    private MailboxController mailboxController;
    private int cached_folderNr;
    private int cached_messageNr;
    private int cached_attachmentNr;
    private int cached_partNr;
    private MailPart cached_attachment;
    private MailPart cached_attachmentPart;

    public AttachmentController(MailboxController mailboxController) 
	throws ControllerException
    {
	this.mailboxController = mailboxController;
    }


    /**
     * To be called by controller action, when content of an attachment is 
     * requested
     */ 
    public void setMailAttachment(int folderNr, int messageNr, 
				  int attachmentNr)
	throws ControllerException
    {
	log.debug("setMailAttachment() called with folderNr=" + folderNr
		  + " and messageNr=" + messageNr + " and attachmentNr=" + attachmentNr);

	MailMessage mm = mailboxController.getMailMessage(folderNr, messageNr);
	if (mm == null)
	    throw new ControllerException("message not found, can't read attachment", null);

	MailPart ma = null;
	try {
	    ma = mm.getMailAttachment(attachmentNr);
	}
	catch (ModelException e) {
	    throw new ControllerException("error getting mail attachment", e);
	}
	cached_attachment = ma;
	cached_folderNr = folderNr;
	cached_messageNr = messageNr;
	cached_attachmentNr = attachmentNr;
    }

    /**
     * Accessor for GUI - will only work if controller previously called
     * setMessageAttachment() with the same parameters.
     * Otherwise returns null
     */
    public MailPart getMailAttachment(int folderNr, int messageNr, 
					    int attachmentNr)
    {
	log.debug("getMailAttachment() called with folderNr=" + folderNr
		  + " and messageNr=" + messageNr + " and attachmentNr=" + attachmentNr);
	if (cached_folderNr == folderNr &&
	    cached_messageNr == messageNr &&
	    cached_attachmentNr == attachmentNr)
	    return cached_attachment;
	else {
	    log.error("getMailAttachment() illegal usage, set not previously called - parameters folderNr=" + folderNr + " and messageNr=" + messageNr + " and attachmentNr=" + attachmentNr);
	    return null;
	}
    }

    /**
     * To be called by controller action, when content of an attachment 
     * part is requested
     */ 
    public void setMailAttachmentPart(int folderNr, int messageNr, 
				      int attachmentNr, int partNr)
	throws ControllerException
    {
	if (log.isDebugEnabled())
	    log.debug("setMailAttachmentPart() called with folderNr=" + folderNr
		      + " and messageNr=" + messageNr + " and attachmentNr=" + attachmentNr + " and partNr=" + partNr);

	MailPart attachment = getMailAttachment(folderNr, messageNr, attachmentNr);
	if (attachment == null)
	    throw new ControllerException("part not found, no attachment present", null);

	MailPart part = attachment.getSubParts()[partNr];

	cached_partNr = partNr;
	cached_attachmentPart = part;
    }

    /**
     * Accessor for GUI - will only work if controller previously called
     * setMailAttachmentPart() with the same parameters.
     * Otherwise returns null
     */
    public MailPart getMailAttachmentPart(int folderNr, int messageNr, 
					  int attachmentNr, int partNr)
    {
	if (log.isDebugEnabled())
	    log.debug("getMailAttachmentPart() called with folderNr=" + folderNr
		      + " and messageNr=" + messageNr + " and attachmentNr=" + attachmentNr + " and partNr=" + partNr);
	if (cached_folderNr == folderNr &&
	    cached_messageNr == messageNr &&
	    cached_attachmentNr == attachmentNr &&
	    cached_partNr == partNr)
	    return cached_attachmentPart;
	else {
	    log.error("getMailAttachmentPart() illegal usage, set not previously called - parameters folderNr=" + folderNr + " and messageNr=" + messageNr + " and attachmentNr=" + attachmentNr + " and partNr=" + partNr);
	    return null;
	}
    }



}

