/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller;

import java.net.URL;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

// use log4j logging
import org.apache.log4j.Logger;

// for parameter holding, use Avalon framework
// (if you want to avoid dependance on avalon, then just convert it to a hashtable)
import org.apache.avalon.framework.parameters.Parameters;


public abstract class AbstractWorkerBean implements HttpSessionBindingListener 
{
    private final Logger log = Logger.getLogger(AbstractWorkerBean.class);
    protected ServerConnection serverConnection;
    protected URL contextURL;

    public ServerConnection getServerConnection() {
	return serverConnection;
    }

    /**
     * Important note: supposes server connection passed as argument is valid
     * (i.e. user successfully authenticated). 
     * @param par collection of parameters which may be used to configure worker bean after a login
     * @throws IllegalArgumentException if no connection passed
     * @throws Exception - specified so concrete implementations may throw
     * exceptions when overriding this method
     */
    public void initialize(ServerConnection serverConnection, URL contextURL, Parameters par)
	throws IllegalArgumentException, Exception
    {
	if (serverConnection == null) 
	    throw new IllegalArgumentException("parameter serverConnection must have a value");
	this.serverConnection = serverConnection;
	this.contextURL = contextURL;
    }
    
    public void valueBound(HttpSessionBindingEvent event) { 
	// who cares
    }
    
    public void valueUnbound(HttpSessionBindingEvent event) {
	log.debug("valueUnbound(): calling close()");
	try {
	    close();
	} 
	catch (Exception e) {
	    log.warn("valueUnbound() error while closing resources: " + e.toString(), e);
	}
    }
    
    public void close() 
	throws Exception
    {
	// close the connection
	if (serverConnection != null) {
	    log.debug("close() closing connection");
	    serverConnection.disconnect();
	}

	// perform any other required clean up by overriding this class
	// (but don't forget to call super.close() )
    }

    public String getUser() {
	if (serverConnection != null)
	    return serverConnection.getUser();
	else
	    return null;
    }

}

