<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="flagbox.xsl" />
<xsl:import href="copybox.xsl" />
<xsl:import href="mailpartheader.xsl" />

<xsl:template match="page/message">
 <content>

   <xsl:variable name="folder_param" 
      select="concat('folderNr=',normalize-space(message/folderNr))"/>
   <xsl:variable name="folder_msg_params" 
      select="concat($folder_param,'&amp;messageNr=',number(normalize-space(message/nr)))"/>
   <xsl:variable name="link_to_pdfmessage" 
      select="concat('message_as_pdf?act=message_as_pdf&amp;',$folder_msg_params)" />
   <xsl:variable name="message_link_prefix"
      select="concat('message.xsl?act=message&amp;',$folder_param,'&amp;messageNr=')"/>
   <xsl:variable name="list_link"
      select="concat('folder.xsl?act=folder&amp;',$folder_param)"/>
   <xsl:variable name="link_to_reply" 
      select="concat('compose.xsl?act=compose&amp;',$folder_msg_params,'&amp;isreply=true')" />
   <xsl:variable name="link_to_forward" 
      select="concat('compose.xsl?act=compose&amp;',$folder_msg_params,'&amp;isforward=true')" />
   <xsl:variable name="link_to_flag_action" 
      select="concat('folder.xsl?act=setflag&amp;',$folder_param,'&amp;checkedmessage=',normalize-space(message/nr))"/>
   <xsl:variable name="addcontact_link_prefix" 
      select="'contact.xsl?act=contact&amp;new=true&amp;address='" />



	<table cellpadding="0" cellspacing="0" border="0" width="100%">
	<tbody>

	    <!-- Header row -->
	    <tr>
		<td width="10%">
			<img align="middle" hspace="5" border="0" src="images/gnome/envelope-48.png" />
		</td>
		<td width="40%">
			<span class="simpletext"><xsl:value-of select="normalize-space(headertext1)" /></span>
		</td>
		<td width="5%">
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$link_to_pdfmessage"/></xsl:attribute>
				<img hspace="5" border="0" src="images/gnome/pdf-48.png" />
			</a>
		</td>
		<td width="45%">
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$link_to_pdfmessage"/></xsl:attribute>
				<xsl:value-of select="normalize-space(headertext7)" />
			</a>
		</td>
	       </tr>
	</tbody></table>

	<!--
	    Header bar: contains links previous, up, next
   	-->
	<table cellpadding="0" cellspacing="0" border="0" width="100%">
	<tbody><tr class="bg_for_invert">

		<!-- link "previous message" (icon and text) -->
		<xsl:variable name="link_previous" 
                   select="concat($message_link_prefix,number(normalize-space(message/nr)) - 1)"/>
		<td align="center" valign="middle" width="5%">
			<xsl:if test="number(normalize-space(message/nr)) > 1">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="$link_previous" /></xsl:attribute>
					<img border="0" src="images/gnome/arrow_back.png" />
				</a>
			</xsl:if>
		</td>
		<td valign="middle" width="30%">
			<xsl:if test="number(normalize-space(message/nr)) > 1">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="$link_previous" /></xsl:attribute>
					<span class="white_text"><xsl:value-of select="normalize-space(bartext1)" /></span>
				</a>
			</xsl:if>
		</td>
	
		<!-- link "return to list" -->
		<td align="center" valign="middle" width="30%">
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$list_link" /></xsl:attribute>
				<img border="0" src="images/gnome/arrow_home.png" /><br />
				<span class="white_text"><xsl:value-of select="normalize-space(bartext2)" /></span>
			</a>
		</td>
	
		<!-- link "next message" (text and icon) -->
		<xsl:variable name="link_next" 
                   select="concat($message_link_prefix,number(normalize-space(message/nr)) + 1)"/>
		<td align="right" valign="middle" width="30%">
			<xsl:if test="not(message/islast)">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="$link_next"/></xsl:attribute>
					<span class="white_text"><xsl:value-of select="normalize-space(bartext3)" /></span>
				</a>
			</xsl:if>
		</td>
		<td align="center" valign="middle" width="5%">
			<xsl:if test="not(message/islast)">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="$link_next"/></xsl:attribute>
					<img border="0" src="images/gnome/arrow_forward.png" />
				</a>
			</xsl:if>
		</td>
	
		</tr>
	</tbody></table>
	<!-- Header bar finished -->
	
	<!-- Message header information -->
	<table cellpadding="4" cellspacing="2" border="0" width="100%"><tbody>
		<tr class="field_dark_bg">
			<td class="link_text" colspan="3">
				<xsl:value-of select="normalize-space(message/subject)" />
			</td>
		</tr>
		<tr class="field_light_bg">
			<td width="13%" class="link_text">
				<xsl:value-of select="normalize-space(headertext2)" />
			</td>
			<td width="57%" class="simpletext">
				<xsl:value-of select="normalize-space(message/from)" />
        		</td>
			<td width="30%" class="navigation">
				<a>
				   <xsl:attribute name="href">
				      <xsl:value-of select="concat($addcontact_link_prefix,normalize-space(message/from))"/>
				   </xsl:attribute>
				   <img border="0" src="images/gnome/addresses-small.png"/>
				   <xsl:value-of select="normalize-space(addcontacttext)" />
				</a>
        		</td>
        	</tr>
        	<tr class="field_middle_bg">
        		<td width="13%" class="link_text">
				<xsl:value-of select="normalize-space(headertext3)" />
			</td>
			<td width="87%" class="simpletext" colspan="2">
				<xsl:value-of select="normalize-space(message/to)" />
			</td>
		</tr>
		<tr class="field_light_bg">
			<td width="13%" class="link_text">
				<xsl:value-of select="normalize-space(headertext4)" />
			</td>
			<td width="87%" class="simpletext" colspan="2">
				<xsl:value-of select="normalize-space(message/reply-to)" />
			</td>
		</tr>
		<tr class="field_middle_bg">
			<td width="13%" class="link_text">
				<xsl:value-of select="normalize-space(headertext5)" />
			</td>
			<td width="87%" class="simpletext" colspan="2">
				<xsl:value-of select="normalize-space(message/cc)" />
			</td>
		</tr>
		<tr class="field_light_bg">
			<td width="13%" class="link_text">
				<xsl:value-of select="normalize-space(headertext6)" />
			</td>
			<td width="87%" class="simpletext" colspan="2">
				<xsl:value-of select="normalize-space(message/date)" />
			</td>
		</tr>
	</tbody></table>


	<table class="bg_for_invert" cellpadding="3" cellspacing="2" border="0" width="100%"><tbody>

		<tr>
		      <!-- Reply field -->
		      <form method="post" >
			<xsl:attribute name="action"><xsl:value-of select="$link_to_reply"/></xsl:attribute>
		        <td class="white_text" align="left">

			  <button class="bg_for_invert" name="reply" type="submit" value="reply">
				<img border="0" src="images/gnome/reply-16.png"/>
				<span class="white_text"><xsl:value-of select="normalize-space(bartext4)" />...</span>
			  </button>
			  <img hspace="3" border="0" src="images/gnome/reply_to_all-16.png"/>
                    	  <input name="to_all" value="true" type="checkbox">
				<xsl:if test="value_all_set">
				    <xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
                    	  </input>
			  <xsl:value-of select="normalize-space(replyalltext)" />
  		       </td>
		      </form>

			<!-- Forward field -->
		    <td class="white_text" align="right">
		      <form method="post" >
			<xsl:attribute name="action"><xsl:value-of select="$link_to_forward"/></xsl:attribute>

			<button class="bg_for_invert" name="forward" type="submit" value="forward">
				<img hspace="3" border="0" src="images/gnome/forward-16.png"/>
				<span class="white_text"><xsl:value-of select="normalize-space(bartext5)" /></span>
			</button>
                    	  <input name="forward_as_attachment" value="true" type="checkbox">
				<xsl:if test="value_forward_attachment_set">
				    <xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
                    	  </input>
			  <xsl:value-of select="normalize-space(forwardattachmenttext)" />

		      </form>
		    </td>

		</tr>

	</tbody></table>
	<!-- done with message header info table -->

	<!-- body within a table -->
	<table class="message_body_table" border="0" cellpadding="0" cellspacing="3" width="100%">
	  <!-- Message body : header -->		
	  <tr>
	     <td align="middle" class="headertext">
		 <xsl:value-of select="normalize-space(bodytext1)" />
             </td>
          </tr>
	  <!-- Message body: the actual content -->
           <tr>
	     <td align="left" class="message_body">
                <xsl:for-each select="message/body/line">
                   <xsl:choose>
                    <xsl:when test="not(isempty)">
		     <xsl:for-each select="whitespace">
		         &#160;
		     </xsl:for-each>
		     <xsl:value-of select="content"/><br/>
	            </xsl:when>
                    <xsl:otherwise>
		     <br/>
                    </xsl:otherwise>
                   </xsl:choose>
                </xsl:for-each>
             </td>
           </tr>
 


	<!-- Attachments -->
        <xsl:for-each select="message/attachment">
	   <tr><td>

	   <!-- define a variable for the link to the attachment:
		if it's a multipart, link to viewattachment page. If
		not, link to download action 
	   -->

	   <xsl:variable name="link_refs">
	         <xsl:value-of
	         select="concat('folderNr=',normalize-space(../folderNr),'&amp;messageNr=',normalize-space(../nr),'&amp;attachmentNr=',normalize-space(nr))"
	         />
           </xsl:variable>

	   <xsl:variable name="link_to_part">
	      <xsl:choose>
	          <xsl:when test="multipart">
			<xsl:value-of select="concat('viewattachment?act=getattachment&amp;',$link_refs)" />
	          </xsl:when>
	          <xsl:otherwise>
			<xsl:value-of select="concat('getattachment/',normalize-space(filename),'?act=getattachment&amp;',$link_refs)" />
	          </xsl:otherwise>
	      </xsl:choose>
	   </xsl:variable>

  	   <xsl:call-template name="mailpartheader">
	       <xsl:with-param name="link_to_part"><xsl:value-of select="$link_to_part"/></xsl:with-param>
	   </xsl:call-template>

	  </td>
	  </tr>
        </xsl:for-each>

        </table>



	<!-- Actions -->
	<table cellspacing="0" cellpadding="0" border="0" width="100%">
	<tbody>
		<!-- Action form to set flags or move this message.
		     This is the same form as in the folder detail screen, except that
		     it will act only on this message and not on all checked messages -->
		<form method="post" >
			<xsl:attribute name="action"><xsl:value-of select="$link_to_flag_action"/></xsl:attribute>
			<tr>
				<xsl:call-template name="flagbox">
				   <xsl:with-param name="index" select="'1'"/>
				</xsl:call-template>
				<xsl:call-template name="copybox">
				   <xsl:with-param name="index" select="'1'"/>
				</xsl:call-template>
			</tr>
		</form>

	</tbody>
	</table>

  </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
