--  lib-runtime.ads: Specification of functions needed by the compiler.
--  Copyright (C) 2021 streaksu
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program.  If not, see <http://www.gnu.org/licenses/>.

with System;
with Interfaces.C; use Interfaces.C;
with Interfaces;   use Interfaces;

--  This are glue functions generated by the compiler that we must fill.
--  Most of them are for error-reporting, and the names are preset.

--  This doesnt need to be SPARK.
package Lib.Runtime with SPARK_Mode => Off is
   --  These functions are called for runtime checks.
   procedure Access_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_CE_Access_Check";
   procedure Index_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_CE_Index_Check";
   procedure Range_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_CE_Range_Check";
   procedure Accessib_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_PE_Accessibility_Check";
   procedure Overflow_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_CE_Overflow_Check";
   procedure Large_Object_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_SE_Object_Too_Large";
   procedure Invalid_Data_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_CE_Invalid_Data";
   procedure Divide_By_Zero_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_CE_Divide_By_Zero";
   procedure Length_Check (File : System.Address; Line : Integer)
      with Export, External_Name => "__gnat_rcheck_CE_Length_Check";
   procedure Assert_Failure (Message : String)
      with Export, External_Name => "system__assertions__raise_assert_failure";
   ----------------------------------------------------------------------------
   --  These functions are called for memory moves and copying primitives.
   function MemCmp (S1, S2 : System.Address; Size : size_t) return int
      with Export, Convention => C, External_Name => "memcmp";
   function MemCpy
      (Desto, Source : System.Address;
       Size          : size_t) return System.Address
      with Export, Convention => C, External_Name => "memcpy";
   function MemMove
      (Desto, Source : System.Address;
       Size          : size_t) return System.Address
      with Export, Convention => C, External_Name => "memmove";
   function MemSet
      (Desto : System.Address;
       Value : Integer;
       Size  : size_t) return System.Address
      with Export, Convention => C, External_Name => "memset";

private

   procedure Print_Exception
      (Message      : String;
       File_Address : System.Address;
       Line_Number  : Integer) with No_Return;
end Lib.Runtime;
