<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "network";
include_once "inc/header.inc.php";


//setup social network
require_once('class/SocialNetwork.class.php');
$sn = new Socialnetwork(null, $db);

if (isset($me['user_id'])) {
	$sn->user_id = $me['user_id'];
}

$sn->relation_type_ids = $c_node['user']['relation_type'];
$sn->status_ids = $c_node['user']['status'];


if (isset($_REQUEST['user_id'])) {
	//get the user
	$output_user = $user->getUser($_REQUEST['user_id']);
	
	if (empty($output_user['user_id'])) {
		header("Location: sn_list.php?" . strip_tags(SID));
		exit;
	}
	
	if (isset($me['user_id']) && $output_user['user_id'] == $me['user_id']) {
		$user->true_self = 1; //
		$output_profile = $user->selProfile(null, $output_user['user_id']);
	}
	else {
		if (isset($me['user_id'])) {
			// Am I a relation to this person?
			$am_relation_to_them = $sn->selRelation($output_user['user_id'], $me['user_id']);
			
			//will then let me see their true self?
			if (!empty($am_relation_to_them['relation_show_true_self'])) {
				$user->true_self = 1; //
				
			}
		}
		
		$output_profile = $user->selProfile(null, $output_user['user_id']);
		
		if (isset($me['user_id'])) {
			if (!empty($am_relation_to_them)) {
				$output_profile['am_relation_to_them'] = $am_relation_to_them;
			}
		
			// Is this person a relation to me?
			$relation_to = $sn->selRelation($me['user_id'], $output_user['user_id']);
			
			if (!empty($relation_to)) {
				$output_profile['relation_to'] = $relation_to;
			}
		}
	}
}


//setup file
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];


//setup file
if (isset($output_profile['file_id'])) {
	$file->file_id = $output_profile['file_id'];
	$output_profile['image'] = $file->getFileRecord();
}
if (isset($output_profile) && empty($output_profile['image'])) {
	$output_profile['image']['file_title'] = "";
	$output_profile['image']['file'] = $file->noimage;
}



//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languagePath . 'sn_common.lang.php');

?>
