<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "structure";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['tagging'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}

// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');


// SETUP TAGS
require_once('class/Tag.class.php');
$tag = new Tag($db, null);
$tag->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
$tag->level_id = $c_node['tag']['level']['recommended'];


// PROCESS FORM ----------------------------------------------------------
if (isset($_POST['update_schedule_tag'])) {
	$del_arr = explode(',', $frmdata['tags']);
	$del_arr = array_unique($del_arr); //remove duplicates
		
	$tag->deleteTags($del_arr);
	
	$tag->user_id = $me['user_id'];
	$tag->insertTags($frmdata);
	
	return header("Location: node_tags.php?" . strip_tags(SID));
	exit;
}


//schedule tags
unset($tag->rsp_item_type_ids, $tag->user_id);
$tag->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
$tag->level_id = $c_node['tag']['level']['recommended'];
$output_schedule_tags = $tag->selTags();

//node tags
unset($tag->rsp_item_type_id, $tag->level_id);
$tag->user_id = $me['user_id'];
$tag->rsp_item_type_id = $c_node['rsp']['item_type']['network'];
$output_node_tags = $tag->selTags(1, 1);



//move to template
if (!empty($output_node_tags)) {
	$body->set('node_tags', $output_node_tags);
}

if (!empty($output_schedule_tags)) {
	$body->set('schedule_tags', $output_schedule_tags);
}

include "inc/footer.inc.php";

?>
