+++ A guide to formatting wiki content

You can format articles using the wiki formatting tools or by typing in the following syntax:

[[toc]]

++++ Bold
You can make any text bold by putting three apostrophe's before and after the word(s) like:

``'''words to bold'''``

''' words to bold ''' 

++++ Code
For technical manuals you may wish to write code examples by enclosing the code in < code >a code tag </ code>. You can also specify at "type" as either "php" or "html".

``< code type="php" >``
// comment
$variable = 'Hello world!';
echo($variable);
``< /code >``

<code type="php">
// comment
$variable = 'Hello world!';
echo($variable);
</code>

++++ Heading
How big you want your heading text. Just put a plus sign (+) in front of the text.


``+ Heading Level 1``
``++ Heading Level 2``
``+++ Heading Level 3``
``++++ Heading Level 4``
``+++++ Heading Level 5``
``++++++ Heading Level 6``

++++ Horizontal rule
On a line by itself at the beginning of the line put ---- to create a horizontal rule:

----

++++ Break
You may want to create an explicit line break (force a line break). You can use it in lists, tables, etc. to break lines without breaking the element. Any line ending with a space and an underscore will create a break.

``The quick brown _``
``foxs jumps over``
``the lazy dog.``

The quick brown _
foxs jumps over 
the lazy dog.

++++ Blockquote
any line starting with one or more > signs, followed by a space will create a blockquote:

> one > is one tab in (blockquote) 
>> two>> is two tab in (blockquotes) 

++++ Lists
Use this to create ordered lists with a # character, or unordered lists with a * marker. Adding spaces before the marking indents the list items. You can mix ordered and unordered lists. If you put a blank line between list item lines, you will start a new list.

``# one``
``# two ``

# one
# two 

``* three``
``* four``

* three
* four


++++ Table
| | at the beginning of a line, with || to separate cells, and | | at the end of the line, with optional alignment character (< for left, = for center, > for right).


``|| Cell 1 || Cell 2 ||``
``|| Cell 3 || Cell 4 ||``

|| Cell 1 || Cell 2 ||
|| Cell 3 || Cell 4 ||

You can span cells by using more than one set of | | markers.

``|| Cell 1 || Cell 2 ||``
``|||| Cell span ||``

|| Cell 1 || Cell 2 ||
|||| Cell span ||

You can align the contents of a cell by including a <, =, or > character after the || marker.

``||< left ||= center ||> right ||``
``|| The quick brown || fox jumps over || the lazy dog. ||``

||< left ||= center ||> right ||
|| The quick brown || fox jumps over || the lazy dog. ||

If you include a blank line between table lines, you will start a new table.

``|| cell 1 || cell 2 ||``

``|| cell 3 || cell 4 ||``

|| cell 1 || cell 2 ||

|| cell 3 || cell 4 ||

++++ Image
You can place an image in your document. You may optionally link to another page in the wiki, and you may optionally indicate HTML attributes for your image, such as 'align' and 'hspace'. There can be no spaces in the image file name, and the macro arguments must be of the form 'arg="value"'.

Look in you file section under 'Me' and see the filename of your image:

``[[image your_image.jpg]]``

``[[image your_image.jpg align="left" hspace="8"]]``

You can make the image a link to a page in the wiki by adding a link="..." argument:

``[[image your_image.jpg link="FormatingFields"]]``

You can put a picture in a page by typing the URL to the picture (it must end in gif, jpg, or png).

``http://www.yourdomain.com/asset/ your_image.jpg``

http://www.yourdomain.com/asset/ your_image.jpg

You can use the described-reference URL markup to give the image an ALT tag. You should do this as it helps people with visual disabilities. It also means that when you roll over the image with your mouse you see the ALT tag:

``[[http://www.yourdomain.com/asset/ your_image.jpg my file]]``

[[http://www.yourdomain.com/asset/ your_image.jpg my file]]

When you uploaded your image Igloo created 3 thumbnail images:
t1 = 158 pixels wide
t2 = 80 pixels wide
t3 = 32 pixels wide

You can choose to display a thumbnail image rather than the full size image that was uploaded by adding a attribute called 'thumb':

``[[image your_image.jpg thumb="1"]]``

``[[image your_image.jpg thumb="1"]]``

Use thumb="1", thumb="2" or thumb="3" to display the thumbnail you require.

++++ File
If you have uploaded files you can display links to them 


You can place a link to a file in your document. You may optionally indicate HTML attributes for your image, such as 'align' and 'hspace'. There can be no spaces in the image file name, and the macro arguments must be of the form 'arg="value"'. We add an additional attribute to show a thumbnail image next to the link.

Look in you file section under 'Me' and see the filename of your file:

With thumb
``[[file your_pdf.pdf thumb="1"]]``

Aligned right
``[[file your_pdf.pdf thumb="1" align="right"]]``

Link only:
``[[file your_pdf.pdf]]``


++++ Table of contents
Looks through all the heading elements in the source text and creates a table of contents from them; each table of contents entry is linked to the appropriate heading, so you can click on it to go to the heading.


``[[toc]]``

++++ Centre
Any line starting with an = sign followed by a space will centre a paragraph line:


``= This line is centered.``

= This line is centred.

++++ Raw
Use this when you want to mark text that should not be processed by the remaining Wiki rules (i.e., it should be displayed literally as it is).


**I'm strong!**  ``**I'm strong!**``

++++ Links
You can make a link by simply typing some words together (called smashing words together) with a CAPS at the start of each word !LikeTheseWords. For instance this page name is called FormatingFields.

If you want to create a new page in the !ThenTypeSomethingNew and you will see a questionmark appear after it like  !ThenTypeSomethingNew[?]. This means that the page has not been created yet, however if you then click on the link the page will be created and you can type information into it.

If you do not want the text to creata a link up an exclamation mark in front of it:


``!ThenTypeSomethingNew``

!ThenTypeSomethingNew

You can create a "described" or "labeled" link to a wiki page by putting the page name in brackets, followed by some text.

``[FormatingFields This is a link to this page]``

[FormatingFields This is a link to this page]



++++ Uniform resource locators (urls)
Create a remote link by simply typing in it's url: http://www.barnraiser.org/ .

Remember to include the whole url including the http: segment. You do not need to put the trailing slash, however it is good policy to do so.

If you like, enclose it in brackets to create a numbered reference and avoid cluttering the page; [http://www.barnraiser.org/].

Or you can have a described-reference instead of a numbered reference:


``[http://www.barnraiser.org/ Barnraiser is super cool]`` 

[http://www.barnraiser.org/ Barnraiser is super cool]

++++ Textcolour
You can color text like this:

``##red|This is red text, ## but this is not.``


##aqua|This is aqua text, ## but this is not.
##black|This is black text, ## but this is default browser text colour.
##blue|This is blue text, ## but this is not.
##fuchsia|This is fuchsia text, ## but this is not.
##gray|This is gray text, ## but this is not.
##green|This is green text, ## but this is not.
##lime|This is lime text, ## but this is not.
##maroon|This is maroon text, ## but this is not.
##olive|This is olive text, ## but this is not.
##purple|This is purple text, ## but this is not.
##red|This is red text, ## but this is not.
##silver|This is silver text, ## but this is not.
##teal|This is teal text, ## but this is not.
##yellow|This is yellow text, ## but this is not.

If you are familiar with hex code you can also use those:


``More text, and then ##ff9933|this is kind of orange.##``

More text, and then ##ff9933|this is kind of orange.##

++++ Teletype text
To create teletype (monospace) text:

``This is {{teletype}} text.``

This is {{teletype}} text.


++++ Italic text
To create italic text:


``This is ''italic'' text.``

This is ''italic'' text.

++++ HTML support
If you have enabled html support in the config file you can include html between html wiki tags:

<html>
<b>some html'ed bold text</b>
</html>
