/* game.h: Prototypes and declarations for game.c
 * Copyright (C) 2013 Julian Graham
 *
 * gzochi is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GZOCHID_GAME_H
#define GZOCHID_GAME_H

#include <glib.h>
#include <sys/time.h>

#include "app.h"
#include "context.h"
#include "event.h"
#include "schedule.h"
#include "socket.h"

enum gzochid_game_state 
  {
    GZOCHID_GAME_STATE_INITIALIZING,
    GZOCHID_GAME_STATE_RUNNING,
    GZOCHID_GAME_STATE_STOPPED
  };

typedef struct _gzochid_game_context 
{
  gzochid_context base;
  GThreadPool *pool;
  gzochid_task_queue *task_queue;
  
  int port;
  char *apps_dir;
  char *work_dir;
  struct timeval tx_timeout;

  GHashTable *applications;
  GHashTable *auth_plugins;
  gzochid_socket_server_context *server;

  GMainLoop *event_loop;
} gzochid_game_context;

gzochid_game_context *gzochid_game_context_new (void);
void gzochid_game_context_free (gzochid_game_context *);
void gzochid_game_context_init 
(gzochid_game_context *, gzochid_context *, GHashTable *);

void gzochid_game_context_register_application
(gzochid_game_context *, char *, gzochid_application_context *);
void gzochid_game_context_unregister_application
(gzochid_game_context *, char *);
gzochid_application_context *gzochid_game_context_lookup_application
(gzochid_game_context *, char *);
GList *gzochid_game_context_get_applications (gzochid_game_context *);

#endif /* GZOCHID_GAME_H */
