/* font.c: Bitmap font data for gzochi mazewar example game
 * Copyright (C) 2012 Julian Graham
 *
 * This is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "font.h"

/* The 8x13 font, in the form of a single bitmap in a packed PBM-like 
   format. This data is used with permission from Andreas Schiffler. */

unsigned char mazewar_font_8x13_bytes[] =
  {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0x55, 0xff, 0x7d, 0xff, 0x7d, 0xff, 0x7d, 
    0xff, 0x55, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 
    0xc7, 0x83, 0x01, 0x83, 0xc7, 0xef, 0xff, 0xff, 
    0xff, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 
    0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xff, 0xff, 
    0x5f, 0x5f, 0x1f, 0x5f, 0x51, 0xfb, 0xfb, 0xfb, 
    0xfb, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x7f, 0x3f, 
    0x7f, 0x71, 0xf7, 0xf3, 0xf7, 0xf7, 0xff, 0xff, 
    0xff, 0xff, 0x9f, 0x7f, 0x7f, 0x7f, 0x93, 0xf5, 
    0xf3, 0xf5, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x7f, 0x7f, 0x7f, 0x11, 0xf7, 0xf3, 0xf7, 0xf7, 
    0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb, 0xdb, 0xe7, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xef, 0xef, 0x83, 0xef, 0xef, 0xff, 
    0x83, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x5f, 
    0x5f, 0x5f, 0x57, 0xf7, 0xf7, 0xf7, 0xf1, 0xff, 
    0xff, 0xff, 0xff, 0x77, 0x77, 0xaf, 0xaf, 0xd1, 
    0xfb, 0xfb, 0xfb, 0xfb, 0xff, 0xff, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0x0f, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0x0f, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xe0, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 
    0x00, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0x00, 0xef, 0xef, 0xef, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xe0, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0x0f, 0xef, 0xef, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 
    0xef, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xcf, 0x3f, 
    0xcf, 0xf1, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0x1f, 0xe7, 0xf9, 0xe7, 0x1f, 0xff, 
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x01, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xfb, 0xfb, 0x81, 0xf7, 0xef, 
    0x81, 0xdf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xe3, 
    0xdd, 0xdf, 0x8f, 0xdf, 0xdf, 0xdf, 0x9d, 0x23, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xff, 0xef, 0xff, 
    0xff, 0xff, 0xff, 0xdb, 0xdb, 0xdb, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xdb, 0xdb, 0x81, 0xdb, 0x81, 0xdb, 0xdb, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xc3, 0xaf, 
    0xaf, 0xc7, 0xeb, 0xeb, 0x87, 0xef, 0xff, 0xff, 
    0xff, 0xff, 0xdd, 0xad, 0xdb, 0xf7, 0xf7, 0xef, 
    0xdb, 0xd5, 0xbb, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xcf, 0xb7, 0xb7, 0xcf, 0xb5, 0xbb, 0xc5, 
    0xff, 0xff, 0xff, 0xff, 0xef, 0xef, 0xef, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xfb, 0xf7, 0xf7, 0xef, 0xef, 0xef, 0xf7, 
    0xf7, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xef, 
    0xef, 0xf7, 0xf7, 0xf7, 0xef, 0xef, 0xdf, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xe7, 0x81, 
    0xe7, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xef, 0xef, 0x83, 0xef, 0xef, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xc7, 0xcf, 0xbf, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x83, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xc7, 
    0xef, 0xff, 0xff, 0xff, 0xfd, 0xfd, 0xfb, 0xf7, 
    0xef, 0xdf, 0xbf, 0x7f, 0x7f, 0xff, 0xff, 0xff, 
    0xff, 0xe7, 0xdb, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 
    0xdb, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xef, 0xcf, 
    0xaf, 0xef, 0xef, 0xef, 0xef, 0xef, 0x83, 0xff, 
    0xff, 0xff, 0xff, 0xc3, 0xbd, 0xbd, 0xfd, 0xfb, 
    0xe7, 0xdf, 0xbf, 0x81, 0xff, 0xff, 0xff, 0xff, 
    0x81, 0xfd, 0xfb, 0xf7, 0xe3, 0xfd, 0xfd, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf3, 0xeb, 
    0xdb, 0xbb, 0xbb, 0x81, 0xfb, 0xfb, 0xff, 0xff, 
    0xff, 0xff, 0x81, 0xbf, 0xbf, 0xa3, 0x9d, 0xfd, 
    0xfd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xe3, 
    0xdf, 0xbf, 0xbf, 0xa3, 0x9d, 0xbd, 0xbd, 0xc3, 
    0xff, 0xff, 0xff, 0xff, 0x81, 0xfd, 0xfb, 0xf7, 
    0xf7, 0xef, 0xef, 0xdf, 0xdf, 0xff, 0xff, 0xff, 
    0xff, 0xc3, 0xbd, 0xbd, 0xbd, 0xc3, 0xbd, 0xbd, 
    0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xbd, 
    0xbd, 0xb9, 0xc5, 0xfd, 0xfd, 0xfb, 0xc7, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xc7, 0xef, 
    0xff, 0xff, 0xef, 0xc7, 0xef, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xef, 0xc7, 0xef, 0xff, 0xff, 0xc7, 
    0xcf, 0xbf, 0xff, 0xff, 0xff, 0xfd, 0xfb, 0xf7, 
    0xef, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 
    0x81, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0xdf, 0xef, 0xf7, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 
    0xff, 0xff, 0xff, 0xff, 0xc3, 0xbd, 0xbd, 0xfd, 
    0xfb, 0xf7, 0xf7, 0xff, 0xf7, 0xff, 0xff, 0xff, 
    0xff, 0xc3, 0xbd, 0xbd, 0xb1, 0xad, 0xa9, 0xb5, 
    0xbf, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb, 
    0xbd, 0xbd, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 
    0xff, 0xff, 0xff, 0x87, 0xbb, 0xbd, 0xbb, 0x87, 
    0xbb, 0xbd, 0xbb, 0x87, 0xff, 0xff, 0xff, 0xff, 
    0xc3, 0xbd, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0x87, 0xbb, 0xbd, 
    0xbd, 0xbd, 0xbd, 0xbd, 0xbb, 0x87, 0xff, 0xff, 
    0xff, 0xff, 0x81, 0xbf, 0xbf, 0xbf, 0x87, 0xbf, 
    0xbf, 0xbf, 0x81, 0xff, 0xff, 0xff, 0xff, 0x81, 
    0xbf, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0xbf, 0xbf, 
    0xff, 0xff, 0xff, 0xff, 0xc3, 0xbd, 0xbf, 0xbf, 
    0xbf, 0xb1, 0xbd, 0xb9, 0xc5, 0xff, 0xff, 0xff, 
    0xff, 0xbd, 0xbd, 0xbd, 0xbd, 0x81, 0xbd, 0xbd, 
    0xbd, 0xbd, 0xff, 0xff, 0xff, 0xff, 0x83, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0x83, 0xff, 
    0xff, 0xff, 0xff, 0xe0, 0xfb, 0xfb, 0xfb, 0xfb, 
    0xfb, 0xfb, 0xbb, 0xc7, 0xff, 0xff, 0xff, 0xff, 
    0xbd, 0xbb, 0xb7, 0xaf, 0x9f, 0xaf, 0xb7, 0xbb, 
    0xbd, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xbf, 0xbf, 
    0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0x81, 0xff, 0xff, 
    0xff, 0xff, 0x7d, 0x7d, 0x39, 0x55, 0x6d, 0x6d, 
    0x7d, 0x7d, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xbd, 
    0xbd, 0x9d, 0xad, 0xb5, 0xb9, 0xbd, 0xbd, 0xbd, 
    0xff, 0xff, 0xff, 0xff, 0xc3, 0xbd, 0xbd, 0xbd, 
    0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 
    0xff, 0x83, 0xbd, 0xbd, 0xbd, 0x83, 0xbf, 0xbf, 
    0xbf, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xbd, 
    0xbd, 0xbd, 0xbd, 0xbd, 0xad, 0xb5, 0xc3, 0xfd, 
    0xff, 0xff, 0xff, 0x83, 0xbd, 0xbd, 0xbd, 0x83, 
    0xaf, 0xb7, 0xbb, 0xbd, 0xff, 0xff, 0xff, 0xff, 
    0xc3, 0xbd, 0xbf, 0xbf, 0xc3, 0xfd, 0xfd, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0x01, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xff, 0xff, 
    0xff, 0xff, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 
    0xbd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 0x7d, 
    0x7d, 0xbb, 0xbb, 0xbb, 0xd7, 0xd7, 0xd7, 0xef, 
    0xff, 0xff, 0xff, 0xff, 0x7d, 0x7d, 0x7d, 0x7d, 
    0x6d, 0x6d, 0x6d, 0x55, 0xbb, 0xff, 0xff, 0xff, 
    0xff, 0x7d, 0x7d, 0xbb, 0xd7, 0xef, 0xd7, 0xbb, 
    0x7d, 0x7d, 0xff, 0xff, 0xff, 0xff, 0x7d, 0x7d, 
    0xbb, 0xd7, 0xef, 0xef, 0xef, 0xef, 0xef, 0xff, 
    0xff, 0xff, 0xff, 0x81, 0xfd, 0xfb, 0xf7, 0xef, 
    0xdf, 0xbf, 0xbf, 0x81, 0xff, 0xff, 0xff, 0xff, 
    0xc3, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0xbf, 
    0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0x87, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 
    0xf7, 0xf7, 0x87, 0xff, 0xff, 0xff, 0xff, 0xef, 
    0xd7, 0xbb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0xff, 0xff, 
    0xef, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xc3, 0xfd, 0xc1, 0xbd, 0xb9, 0xc5, 0xff, 
    0xff, 0xff, 0xff, 0xbf, 0xbf, 0xbf, 0xa3, 0x9d, 
    0xbd, 0xbd, 0x9d, 0xa3, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xc3, 0xbd, 0xbf, 0xbf, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfd, 0xfd, 
    0xc5, 0xb9, 0xbd, 0xbd, 0xb9, 0xc5, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xbd, 0x81, 
    0xbf, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xe3, 
    0xdd, 0xdf, 0xdf, 0x83, 0xdf, 0xdf, 0xdf, 0xdf, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc5, 
    0xbb, 0xbb, 0xc7, 0xbf, 0xc3, 0xbd, 0xc3, 0xff, 
    0xff, 0xbf, 0xbf, 0xbf, 0xa3, 0x9d, 0xbd, 0xbd, 
    0xbd, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 
    0xff, 0xcf, 0xef, 0xef, 0xef, 0xef, 0x83, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xf3, 0xfb, 
    0xfb, 0xfb, 0xfb, 0xbb, 0xbb, 0xc7, 0xff, 0xff, 
    0xbf, 0xbf, 0xbf, 0xbb, 0xb7, 0x8f, 0xb7, 0xbb, 
    0xbd, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0x83, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0x13, 0x6d, 0x6d, 
    0x6d, 0x6d, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xa3, 0x9d, 0xbd, 0xbd, 0xbd, 0xbd, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 
    0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xa3, 0x9d, 0xbd, 0x9d, 
    0xa3, 0xbf, 0xbf, 0xbf, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xc5, 0xb9, 0xbd, 0xb9, 0xc5, 0xfd, 0xfd, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa3, 0xdd, 
    0xdf, 0xdf, 0xdf, 0xdf, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xc3, 0xbd, 0xcf, 0xf3, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 
    0x83, 0xdf, 0xdf, 0xdf, 0xdd, 0xe3, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xbb, 0xbb, 0xbb, 
    0xbb, 0xbb, 0xc5, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xbb, 0xbb, 0xbb, 0xd7, 0xd7, 0xef, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7d, 
    0x7d, 0x6d, 0x6d, 0x55, 0xbb, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xbd, 0xdb, 0xe7, 0xe7, 
    0xdb, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xbd, 0xbd, 0xbd, 0xb9, 0xc5, 0xfd, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0xfb, 
    0xf7, 0xef, 0xdf, 0x81, 0xff, 0xff, 0xff, 0xff, 
    0xf1, 0xef, 0xef, 0xf7, 0xcf, 0xf7, 0xef, 0xef, 
    0xf1, 0xff, 0xff, 0xff, 0xff, 0xef, 0xef, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xff, 0xff, 
    0xff, 0xff, 0x8f, 0xf7, 0xf7, 0xef, 0xf3, 0xef, 
    0xf7, 0xf7, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xdb, 
    0xab, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xff, 
    0xff, 0xff, 0xff, 0xef, 0xc7, 0xab, 0xaf, 0xaf, 
    0xab, 0xc7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xe3, 0xdd, 0xdf, 0x8f, 0xdf, 0xdf, 0xdf, 0x9d, 
    0x23, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbd, 
    0xc3, 0xdb, 0xdb, 0xc3, 0xbd, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0x7d, 0x7d, 0xbb, 0xd7, 0x83, 0xef, 
    0x83, 0xef, 0xef, 0xff, 0xff, 0xff, 0xff, 0xef, 
    0xef, 0xef, 0xef, 0xff, 0xef, 0xef, 0xef, 0xef, 
    0xff, 0xff, 0xff, 0xe7, 0xdb, 0xdf, 0xe7, 0xdb, 
    0xdb, 0xe7, 0xfb, 0xdb, 0xe7, 0xff, 0xff, 0xff, 
    0xdb, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xbb, 0x6d, 
    0x55, 0x5d, 0x55, 0x6d, 0xbb, 0xc7, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xc7, 0xfb, 0xc3, 0xbb, 0xc3, 
    0xff, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xed, 0xdb, 0xb7, 0x6f, 0xb7, 0xdb, 0xed, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0x81, 0xfd, 0xfd, 0xfd, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xbb, 
    0x6d, 0x55, 0x55, 0x4d, 0x55, 0xbb, 0xc7, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xe7, 0xdb, 0xdb, 0xe7, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 
    0xef, 0x83, 0xef, 0xef, 0xff, 0x83, 0xff, 0xff, 
    0xff, 0xff, 0xcf, 0xb7, 0xf7, 0xcf, 0xbf, 0x87, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 
    0xb7, 0xef, 0xf7, 0xb7, 0xcf, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xf7, 0xef, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xbd, 0xbd, 
    0xbd, 0x99, 0xa5, 0xbf, 0xff, 0xff, 0xff, 0xc1, 
    0x8b, 0x8b, 0x8b, 0xcb, 0xeb, 0xeb, 0xeb, 0xeb, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xf7, 0xe7, 0xff, 0xdf, 0x9f, 0xdf, 
    0xdf, 0xdf, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xcf, 0xb7, 0xb7, 0xcf, 0xff, 
    0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0x6f, 0xb7, 0xdb, 0xed, 0xdb, 0xb7, 0x6f, 
    0xff, 0xff, 0xff, 0xff, 0xbf, 0x3f, 0xbf, 0xbf, 
    0xbd, 0x19, 0xf5, 0xed, 0xe5, 0xf9, 0xff, 0xff, 
    0xff, 0xbf, 0x3f, 0xbf, 0xbf, 0xb3, 0x0d, 0xfd, 
    0xf3, 0xef, 0xe1, 0xff, 0xff, 0xff, 0x9f, 0x6f, 
    0xdf, 0xef, 0x6d, 0x99, 0xf5, 0xed, 0xe5, 0xf9, 
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xef, 0xef, 
    0xdf, 0xbf, 0xbd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 
    0xef, 0xf7, 0xff, 0xe7, 0xdb, 0xbd, 0xbd, 0x81, 
    0xbd, 0xbd, 0xff, 0xff, 0xff, 0xf7, 0xef, 0xff, 
    0xe7, 0xdb, 0xbd, 0xbd, 0x81, 0xbd, 0xbd, 0xff, 
    0xff, 0xff, 0xe7, 0xdb, 0xff, 0xe7, 0xdb, 0xbd, 
    0xbd, 0x81, 0xbd, 0xbd, 0xff, 0xff, 0xff, 0xcd, 
    0xb3, 0xff, 0xe7, 0xdb, 0xbd, 0xbd, 0x81, 0xbd, 
    0xbd, 0xff, 0xff, 0xff, 0xdb, 0xdb, 0xff, 0xe7, 
    0xdb, 0xbd, 0xbd, 0x81, 0xbd, 0xbd, 0xff, 0xff, 
    0xff, 0xe7, 0xdb, 0xe7, 0xe7, 0xdb, 0xbd, 0xbd, 
    0x81, 0xbd, 0xbd, 0xff, 0xff, 0xff, 0xff, 0x91, 
    0x6f, 0x6f, 0x6f, 0x63, 0x0f, 0x6f, 0x6f, 0x61, 
    0xff, 0xff, 0xff, 0xff, 0xc3, 0xbd, 0xbf, 0xbf, 
    0xbf, 0xbf, 0xbf, 0xbd, 0xc3, 0xf7, 0xef, 0xff, 
    0xef, 0xf7, 0xff, 0x81, 0xbf, 0xbf, 0x87, 0xbf, 
    0xbf, 0x81, 0xff, 0xff, 0xff, 0xf7, 0xef, 0xff, 
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0x81, 0xff, 
    0xff, 0xff, 0xe7, 0xdb, 0xff, 0x81, 0xbf, 0xbf, 
    0x87, 0xbf, 0xbf, 0x81, 0xff, 0xff, 0xff, 0xdb, 
    0xdb, 0xff, 0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 
    0x81, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0x83, 
    0xef, 0xef, 0xef, 0xef, 0xef, 0x83, 0xff, 0xff, 
    0xff, 0xf7, 0xef, 0xff, 0x83, 0xef, 0xef, 0xef, 
    0xef, 0xef, 0x83, 0xff, 0xff, 0xff, 0xe7, 0xdb, 
    0xff, 0x83, 0xef, 0xef, 0xef, 0xef, 0xef, 0x83, 
    0xff, 0xff, 0xff, 0xbb, 0xbb, 0xff, 0x83, 0xef, 
    0xef, 0xef, 0xef, 0xef, 0x83, 0xff, 0xff, 0xff, 
    0xff, 0x87, 0xbb, 0xbd, 0xbd, 0x1d, 0xbd, 0xbd, 
    0xbb, 0x87, 0xff, 0xff, 0xff, 0x9b, 0x67, 0xff, 
    0x7d, 0x3d, 0x5d, 0x6d, 0x75, 0x79, 0x7d, 0xff, 
    0xff, 0xff, 0xdf, 0xef, 0xff, 0x83, 0x7d, 0x7d, 
    0x7d, 0x7d, 0x7d, 0x83, 0xff, 0xff, 0xff, 0xf7, 
    0xef, 0xff, 0x83, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 
    0x83, 0xff, 0xff, 0xff, 0xe7, 0xdb, 0xff, 0x83, 
    0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x83, 0xff, 0xff, 
    0xff, 0x9b, 0x67, 0xff, 0x83, 0x7d, 0x7d, 0x7d, 
    0x7d, 0x7d, 0x83, 0xff, 0xff, 0xff, 0xbb, 0xbb, 
    0xff, 0x83, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x83, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xdb, 
    0xe7, 0xe7, 0xdb, 0xbd, 0xff, 0xff, 0xff, 0xff, 
    0xfd, 0xc3, 0xb9, 0xb5, 0xb5, 0xad, 0xad, 0xad, 
    0x9d, 0xc3, 0xbf, 0xff, 0xff, 0xdf, 0xef, 0xff, 
    0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 
    0xff, 0xff, 0xf7, 0xef, 0xff, 0xbd, 0xbd, 0xbd, 
    0xbd, 0xbd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xe7, 
    0xdb, 0xff, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xdb, 0xdb, 0xff, 0xbd, 
    0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 0xff, 
    0xff, 0xf7, 0xef, 0xff, 0xbb, 0xbb, 0xd7, 0xef, 
    0xef, 0xef, 0xef, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0x83, 0xbd, 0xbd, 0xbd, 0x83, 0xbf, 0xbf, 0xbf, 
    0xff, 0xff, 0xff, 0xff, 0xc7, 0xbb, 0xbb, 0xb7, 
    0xaf, 0xb3, 0xbd, 0xbd, 0xa3, 0xff, 0xff, 0xff, 
    0xff, 0xef, 0xf7, 0xff, 0xc3, 0xfd, 0xc1, 0xbd, 
    0xb9, 0xc5, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf7, 
    0xff, 0xc3, 0xfd, 0xc1, 0xbd, 0xb9, 0xc5, 0xff, 
    0xff, 0xff, 0xff, 0xe7, 0xdb, 0xff, 0xc3, 0xfd, 
    0xc1, 0xbd, 0xb9, 0xc5, 0xff, 0xff, 0xff, 0xff, 
    0xcd, 0xb3, 0xff, 0xc3, 0xfd, 0xc1, 0xbd, 0xb9, 
    0xc5, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xdb, 0xff, 
    0xc3, 0xfd, 0xc1, 0xbd, 0xb9, 0xc5, 0xff, 0xff, 
    0xff, 0xe7, 0xdb, 0xe7, 0xff, 0xc3, 0xfd, 0xc1, 
    0xbd, 0xb9, 0xc5, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0x93, 0xed, 0x83, 0x6f, 0x6d, 0x93, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 
    0xbd, 0xbf, 0xbf, 0xbd, 0xc3, 0xf7, 0xef, 0xff, 
    0xff, 0xef, 0xf7, 0xff, 0xc3, 0xbd, 0x81, 0xbf, 
    0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xef, 
    0xff, 0xc3, 0xbd, 0x81, 0xbf, 0xbd, 0xc3, 0xff, 
    0xff, 0xff, 0xff, 0xe7, 0xdb, 0xff, 0xc3, 0xbd, 
    0x81, 0xbf, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 
    0xdb, 0xdb, 0xff, 0xc3, 0xbd, 0x81, 0xbf, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 
    0xcf, 0xef, 0xef, 0xef, 0xef, 0x83, 0xff, 0xff, 
    0xff, 0xff, 0xef, 0xdf, 0xff, 0xcf, 0xef, 0xef, 
    0xef, 0xef, 0x83, 0xff, 0xff, 0xff, 0xff, 0xcf, 
    0xb7, 0xff, 0xcf, 0xef, 0xef, 0xef, 0xef, 0x83, 
    0xff, 0xff, 0xff, 0xff, 0xb7, 0xb7, 0xff, 0xcf, 
    0xef, 0xef, 0xef, 0xef, 0x83, 0xff, 0xff, 0xff, 
    0xdb, 0xe7, 0xd7, 0xfb, 0xc3, 0xbd, 0xbd, 0xbd, 
    0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xcd, 0xb3, 
    0xff, 0xa3, 0x9d, 0xbd, 0xbd, 0xbd, 0xbd, 0xff, 
    0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0xc3, 0xbd, 
    0xbd, 0xbd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 
    0xf7, 0xef, 0xff, 0xc3, 0xbd, 0xbd, 0xbd, 0xbd, 
    0xc3, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb, 0xff, 
    0xc3, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 0xff, 
    0xff, 0xff, 0xcd, 0xb3, 0xff, 0xc3, 0xbd, 0xbd, 
    0xbd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xdb, 
    0xdb, 0xff, 0xc3, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xef, 0xff, 
    0x83, 0xff, 0xef, 0xef, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xfd, 0xc3, 0xb9, 0xb5, 0xad, 
    0x9d, 0xc3, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xef, 
    0xff, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xc5, 0xff, 
    0xff, 0xff, 0xff, 0xf7, 0xef, 0xff, 0xbb, 0xbb, 
    0xbb, 0xbb, 0xbb, 0xc5, 0xff, 0xff, 0xff, 0xff, 
    0xe7, 0xdb, 0xff, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 
    0xc5, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xd7, 0xff, 
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xc5, 0xff, 0xff, 
    0xff, 0xff, 0xf7, 0xef, 0xff, 0xbd, 0xbd, 0xbd, 
    0xb9, 0xc5, 0xfd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 
    0xbf, 0xbf, 0xa3, 0x9d, 0xbd, 0xbd, 0x9d, 0xa3, 
    0xbf, 0xbf, 0xff, 0xff, 0xdb, 0xdb, 0xff, 0xbd, 
    0xbd, 0xbd, 0xb9, 0xc5, 0xfd, 0xbd, 0xc3, 0xff
  };
