/* GSequencer - Advanced GTK Sequencer
 * Copyright (C) 2005-2025 Joël Krähemann
 *
 * This file is part of GSequencer.
 *
 * GSequencer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GSequencer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GSequencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __AGS_MODULATION_MATRIX_CALLBACKS_H__
#define __AGS_MODULATION_MATRIX_CALLBACKS_H__

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtk.h>

#include <ags/libags.h>
#include <ags/libags-audio.h>

#include <ags/libags-gui.h>

#include <ags/app/machine/ags_modulation_matrix.h>

G_BEGIN_DECLS

void ags_modulation_matrix_draw_callback(GtkWidget *drawing_area,
					 cairo_t *cr,
					 int width, int height,
					 AgsModulationMatrix *modulation_matrix);

gboolean ags_modulation_matrix_gesture_click_pressed_callback(GtkGestureClick *event_controller,
							      gint n_press,
							      gdouble x,
							      gdouble y,
							      AgsModulationMatrix *modulation_matrix);
gboolean ags_modulation_matrix_gesture_click_released_callback(GtkGestureClick *event_controller,
							       gint n_press,
							       gdouble x,
							       gdouble y,
							       AgsModulationMatrix *modulation_matrix);

gboolean ags_modulation_matrix_key_pressed_callback(GtkEventControllerKey *event_controller,
						    guint keyval,
						    guint keycode,
						    GdkModifierType state,
						    AgsModulationMatrix *modulation_matrix);
gboolean ags_modulation_matrix_key_released_callback(GtkEventControllerKey *event_controller,
						     guint keyval,
						     guint keycode,
						     GdkModifierType state,
						     AgsModulationMatrix *modulation_matrix);
gboolean ags_modulation_matrix_modifiers_callback(GtkEventControllerKey *event_controller,
						  GdkModifierType keyval,
						  AgsModulationMatrix *modulation_matrix);

G_END_DECLS

#endif /*__AGS_MODULATION_MATRIX_CALLBACKS_H__*/
