#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################
from OFS import SimpleItem
from Globals import DTMLFile,InitializeClass
from GNOWSYS import *
import string
import fpformat
import random
import os
import pickle
from Function import *

class FunctionType(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
           ZCatalog,
	   SimpleItem):
        """adding a function type"""
        
	meta_type='GFunctionType'
	
	_properties= (
        	{'id':'id', 'type':'string', 'mode':'r'},
        	{'id':'title', 'type':'string', 'mode':'r'},
		{'id':'module','type':'string','mode':'r'},
		)

	__ac_permissions__=(
        ('Manage Properties',('manage_addProperty',
                              'manage_editProperties',
                              'manage_delProperties',
                              'manage_changeProperties',
                              'Access content information')),
         )
        msg="Error"
    	manage_options =(
		{'label': 'Contents', 'action': 'manage_main'},
     		{'label': 'Properties', 'action': 'manage_propertiesForm'},
        	{'label': 'View', 'action': 'viewfun'},
		{'label': 'Constraint', 'action': 'customtype'},
        	)	

	def __init__(self,id,title,parameter,doc,module,dbname):
		""" Initialising the function type"""

		
		self.id=id			#id of the object
		self.title=title		#title of the object

		self.module=module		#Module to which the function belongs
## 		
		
		fp=open('/tmp/doc','r')
		docstr=fp.read()
		fp.close()
		self.doc=docstr
		self.manage_addProperty('documentation',docstr,'text')   # Add the documentation to property list
		self.dbname=dbname	
		self.parameter=parameter

		ft=open('/tmp/doc1.txt','w+')
 		ft.write(self.module)
 		ft.close()
		
		if self.module=="UserList":
			self.manage_addProperty('List','','string')

		arguments=string.split(parameter)
		
		tmplst=[]
		for tmp in arguments:		# Add the arguments to property list
			
			if tmp!='':
				if not( self.hasProperty(tmp) ):
					if tmp!='None':
						tmplst=string.split(tmp,'_')
						if tmplst[0]=='':
							tmplst[0]='$@$'
						tmp=string.join(tmplst,'')
						
						## fp=open('/tmp/t3.txt','w+')
## 						fp.write(tmp+'\n')
## 						fp.close()
						self.manage_addProperty(tmp,'','string')		
			if self.module=='umaths' or self.module=='maths':
				pname='min_'+t1[j]
        	                pname1='max_'+t1[j]
                	        pname=string.replace(pname,' ','')
                        	pname1=string.replace(pname1,' ','')
				lnam='userlist_'+t1[j]
				lnam=string.replace(lnam,' ','')
		self.manage_addProperty('Result','','string') # Add Result of function to property list
        	
	def __call__(self,*args):
                mod=self.getProperty('module')
		lis=[]
                if mod=='umaths':
                        mod='umath'
                if mod=='maths':
                        mod='math'
                if mod=='cmaths':
                        mod='cmath'
                title=self.getProperty('title')
		#return (args[0],args[1],len(args))
                evalst=compile('import '+mod,'','single') #Importing the module
                exec evalst
		for l in range(len(args)):
			lis.append(args[l])
                name=mod+'.'+title
                args=tuple(lis)     #Appending the values to function into a tuple for "apply"
                evalfun=compile('ans=apply('+name+','+str(args)+')','','single')  #Calling func with args
                exec evalfun
		if type(ans)==type(3.142):
                	ans=fpformat.fix(ans,2)
                #return '<html>'+str(ags)+'</html>'
		else:
			ans=str(ans)
                tp=ans
                return tp
	 
	def viewfun(self,RESPONSE=None):
		"""Redirect to CallPage"""
		RESPONSE.redirect('callPage')
	
	def callPage(self,REQUEST,RESPONSE=None):
		""" Accept arguments """
		if 'counter' in REQUEST.keys():
			self.cnt=int(REQUEST['counter'])
		else: 
			self.cnt=-1
		self.typ='simplefun'
		if 'objid' and 'result' and 'item' and 'exectyp' in REQUEST.form.keys():
			#return REQUEST
			REQUEST.set('result',REQUEST['result'])
			REQUEST.set('objid',REQUEST['objid'])
			REQUEST.set('item',REQUEST['item'])
			self.typ=REQUEST['exectyp']
			RESPONSE.redirect('inputPage?item=%s&objid=%s'%(REQUEST['item'],REQUEST['objid']))
		else:
			#REQUEST.set('result','')
			if 'objid' in REQUEST.keys():
                                did=REQUEST['objid']
                        else:
                                did=''
                        REQUEST.set('objid',did)
			RESPONSE.redirect('inputPage?objid=%s'%(did))

	def execfun(self,REQUEST,RESPONSE=None):
		"execute functions"
       		#return str(REQUEST)
		
		temp=[]
		n=[]
       		m=[]
		#phyurl=self.getPhysicalPath()[1]   #Get the product instance id
		phyurl=self.InstancePath
		proplist=[]
		if 'exectyp' in REQUEST.keys():
			self.typ=REQUEST['exectyp']
		if 'counter' in REQUEST.keys():
			self.cnt=int(REQUEST['counter'])
			#if REQUEST['counter']=="4":
		if self.typ=="halted":
			flowref=self.restrictedTraverse( phyurl +'PBase/FlowBase/'+REQUEST['objid'],default=None)
                       	s=flowref.propertyIds()
			#if self.cnt>0:
				#return '<html><body>'+'<br>'+str(self.cnt)+'</body></html>'
			for i in s:
				if string.find(i,'_')!=-1 and string.find(i,'Result')==-1 and string.find(i,'documentation')==-1 and string.find(i,'for_i_')==-1 and string.find(i,'if_')==-1 and string.find(i,'for')==-1 and string.find(i,'else')==-1 and string.find(i,'while') and string.find(i,'classname')==-1:
					funcnum=int(string.split(i,'_',2)[2])
					if funcnum==self.cnt:
						if string.find(i,'_id_')!=-1:
							funcid=string.split(i,'_id_',1)[0]
						if string.find(i,'_title_')!=-1:
							funcname=flowref.getProperty(i)
						if string.find(i,'_id_')==-1 and string.find(i,'_title_')==-1 and string.find(i,'_module_')==-1 and string.find(i,'_rangeofnum_')==-1 and string.find(i,'_documentation_')==-1:
							proplist.append(i)
							for j in REQUEST.form.keys():
                               					if string.find(i,'_'+j+'_')!=-1:
									flowref._updateProperty(i,REQUEST[j])
        		modulename=flowref.getProperty(funcid+'_module_'+str(self.cnt))
				
		else: 
			flowref=self
			s=flowref.propertyIds()
			for j in REQUEST.form.keys():
                               	if flowref.hasProperty(j):
					flowref._updateProperty(j,REQUEST[j])
			for i in s:
				if string.find(i,'id')==-1 and string.find(i,'title')==-1 and string.find(i,'module')==-1 and string.find(i,'documentation')==-1 and string.find(i,'rangeofnum')==-1 and string.find(i,'Result')==-1 and string.find(i,'for_i_')==-1 and string.find(i,'classname')==-1:
					proplist.append(i)
			modulename=flowref.getProperty('module')
	    		funcname=flowref.getProperty('title')
		n1=[]
        	sc=""
		tp={}
		if modulename=='Numeric':
			for j in proplist:
				if string.find(j,'=')==-1:
					t=flowref.getProperty(j)
					if string.find(t,'[')==-1:
						temp.append('['+t+']')
					else:
						temp.append(t)
				else:
					temp.append(str(flowref.getProperty(j)))
		elif modulename=='umaths':
			for j in proplist:
				temp.append(str(float(flowref.getProperty(j))))
		elif modulename=='UserList':
			if 'List' in proplist:
				proplist.remove('List')
			for j in proplist:
				temp.append(str(flowref.getProperty(j)))
		else:
			for j in proplist:
               	        	temp.append(str(flowref.getProperty(j)))
		for i in range(len(temp)):
               		c=temp[i].count('[')    #Checking if passed values r in a list
               		if c>0:
                       		rt=string.replace(temp[i],"[","")
                        	rtt=string.replace(rt,"]","")
				if string.find(rtt,', ')!=-1:
					rtt=string.replace(rtt,', ',',')
	                        liarg=string.split(rtt,",",-1)
		                for k in liarg:         #Checking for args datatype.
                	               	#k=str(k)
					if k.isdigit():#extra
                                        	n.append(int(k))#extra
					elif (re.search('^-[0-9]*[0-9]',k)!=None or re.search('^[0-9]*[0-9]',k)!=None):
                                   	
						if (re.search('[a-z]|[A-Z]',k)!=None):
							n.append(str(k))
						elif string.find(k,'.')!=-1:
                                                	n.append(float(k))
                                        	else:
                                                	n.append(int(k))
                               		elif k=="" or k=='None':
    	                           		n.append(None)
                                	elif k.endswith("'"):
                                        	n.append(string.replace(k,"'",""))
                                	else:
                                        	n.append(str(k))

                        	m.append(n)
                        	n=[]
                	else:           #Args which are not in a list
                        	if temp[i].isdigit():
                                	m.append(int(temp[i]))
                        	elif (re.search('^-[0-9]*[0-9]',temp[i])!=None or re.search('^[0-9]*[0-9]',temp[i])!=None):   

                             		if (re.search('[a-z]|[A-Z]',temp[i])!=None):
						m.append(str(temp[i]))
					elif string.find(temp[i],'.')!=-1:

                                        	m.append(float(temp[i]))
                                	else:
                                        	m.append(int(temp[i]))
                        	elif temp[i].isspace():
                                	m.append(' ')
                        	elif temp[i].endswith("'"):
                                	m.append(string.replace(temp[i],"'",""))
                       		elif temp[i]=='None' or temp[i]=="":
                                	m.append(None)
                       		else :
                                	if modulename=="cmaths":
						m.append(complex(str(temp[i])))
					else:
						m.append(str(temp[i]))
		
		if self.typ=="halted":

			s=flowref.propertyIds()
			for j in range(len(temp)):
				for i in s:
					if i.find('_'+proplist[j]+'_')!=-1 and i.find('_'+str(self.cnt))!=-1:
						flowref._updateProperty(i,temp[j])
		else:
			for j in range(len(temp)):
				flowref._updateProperty(proplist[j],temp[j])				
		args=tuple(m)           #Converting to tuple for passing args in Apply func

		dbname=self.dbname
		#return self.dbname+'::'+dbname
		dblist=[]
        	#For execution of the function selected
		if modulename=="maths" :
			dblist=string.split(dbname,'/')
			dblist.pop()
			dbname=string.join(dblist,'/')

			modulename="math"
		elif modulename=="Numeric" :
			dblist=string.split(dbname,'/')
			dblist.pop()
			dbname=string.join(dblist,'/')
			modulename="Numeric"
		elif modulename=="string":
			dblist=string.split(dbname,'/')
			dblist.pop()
			dbname=string.join(dblist,'/')

			modulename="string"
		
		elif modulename=="cmaths":
			dblist=string.split(dbname,'/')
			dblist.pop()
			dbname=string.join(dblist,'/')

			modulename="cmath"
		elif modulename=="umaths":
			dblist=string.split(dbname,'/')
			dblist.pop()
			dbname=string.join(dblist,'/')

			modulename="umath"
		else:
			dblist=string.split(dbname,'/')
			dblist.pop()
			dbname=string.join(dblist,'/')

			modulename=modulename
		
		os.chdir(dbname)


		st="import "+modulename

		evalst=compile(st,'','single') #Importing the module
   		exec evalst


		name=modulename+'.'+funcname

		evalfun=compile('b=apply('+name+','+str(args)+')','','single')  #Calling func with args

		exec evalfun
		if b is None:
			b='None'
		res=('result',b)
		if 'objid' in REQUEST.keys():
                	ob=REQUEST['objid']	
			if self.cnt!=-1:

				flowref._updateProperty(funcid+'_Result_'+str(self.cnt),b)
			else:
				self._updateProperty('Result',b)
        	else:
                	ob=''
        	if REQUEST['objid']!='' and self.typ=="halted":
			obj=REQUEST['objid']
			RESPONSE.redirect( phyurl + 'PBase/FlowBase/'+obj+'/execute')
		elif self.typ=="simplefun":
			REQUEST.set('result',str(b))
			REQUEST.set('func',flowref.id)

			RESPONSE.redirect('FunctionTResult?result=%s&func=%s'%(str(b),flowref.id))			


        
	
	def forminmax(self,REQUEST,RESPONSE=None):
                "For minmax in range"
                #return '<html>"hi"</html>'
		arg=self.propertyIds()
                cont={}
                for i in arg:
                        if i not in ['id','title','module','Result','documentation','typevar','userlist_x','userlist_y']:
                                if re.search('^min_',i)== None  and re.search('^max_',i)== None:
                                        cont[i]=''
                contkey=cont.keys()
                REQUEST.set('contarg',contkey)
                #return '<html><body>'+str(contkey)+'</body></html>'
                RESPONSE.redirect('rangenum?contarg=%s'%(contkey))

	def setrange(self,REQUEST,RESPONSE=None):
                "Sets the range for the function"
                #Called by the rangenum.dtml when the constraint tab is clicked
                #It takes in the range from the user for variable values in case of maths functions
		ulis=''
                con=string.replace(REQUEST['contarg'],'[','')#This contarg contains  property names of arguments
                con1=string.replace(con,']','')
		con1=string.replace(con1,' ','')
	        prop={}
		proptup=()
		t1=[]
                for i in string.split(con1,',',len(string.split(con1,','))):
		       t1.append(i)	 	
 	               if i!='':
         	              i=string.replace(i,' ','')
			      prop=REQUEST.form
			      	
                              errormsgnm="The number in max field should be more than that in min field."
                              errormsglis="Enter only numerical values in the userlist field."
                              #return '<html>'+str(prop)+'</html>'
		              REQUEST.set('ermsg',errormsgnm)
		
                	      if REQUEST['typevar']=='intg' or REQUEST['typevar']=='flot': #not for user entered list
                              		minv='min_'+i
					maxv='max_'+i
					if REQUEST['typevar']=='intg':
						if (float(prop[minv])>float(prop[maxv])):
							return '<html><body>'+errormsgnm+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
						
                          			min=str(int(prop[minv]))
						max=str(int(prop[maxv]))
					else:
						min=str(prop[minv])
                                        	max=str(prop[maxv])
					#for k in [min,max]:
						#if re.search('[^0-9]',k)!=None and string.count(k,'.')!=1:
						 	#if string.count(k,'-')>0:
								#d=string.count(k,'-')
								#if d==1:
									#if string.find(k,'-')!=0:
										#return '<html><body>'+errormsgnm+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
								#elif d>1:				 
									#return '<html><body>'+errormsgnm+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
							
                                                        #if string.count(k,'+')>0:
								#val=1
                                                                #d=string.count(k,'+')
                                                                #if d==1:
                                                                        #if string.find(k,'+')!=0:
										#return '<html><body>'+errormsgnm+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
								#elif d>1:				 
									#return '<html><body>'+errormsgnm+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
							#val=string.replace(k,'+','')
							#val=string.replace(val,'-','')
							#val=string.replace(val,'.','')
							#if re.search('[^0-9]',val)!=None:
								#return '<html><body>'+errormsgnm+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'

							
                                        #for matching with text box names
                                        minv=string.replace(minv,"'",'')
                                        maxv=string.replace(maxv,"'",'')
					minv=string.replace(minv,' ','')
					maxv=string.replace(maxv,' ','')
 					#setting min and max for each arg
                                        try:
						self.manage_addProperty(minv,min,'string')#adding new propeties of min and max
                                        	self.manage_addProperty(maxv,max,'string')
					except:
						if self.hasProperty(minv):
							self.manage_delProperties((minv,))
							self.manage_addProperty(minv,min,'string')#adding new propeties of min and max

						if self.hasProperty(maxv):
                                                        self.manage_delProperties((maxv,))
							self.manage_addProperty(maxv,max,'string')#adding new propetiesof min and max
					minv=maxv=""
			      elif REQUEST['typevar']=='ulist':#if user enters own list of numbers 
					userlist='userlist_'+i
					ulis=prop[userlist]
					#return '<html><body>'+str(ulis)+'</body></html>'
					dummylist=ulis			
					#checking to ensure that user has not entered any other characters other than numbers	
					for k in string.split(dummylist,',',len(string.split(dummylist,','))):
						if re.search('[^0-9]',k)!=None and string.count(k,'.')!=1:
						 	if string.count(k,'-')>0:
								d=string.count(k,'-')
								if d==1:
									if string.find(k,'-')!=0:
										return '<html><body>'+errormsglis+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
								elif d>1:				 
									return '<html><body>'+errormsglis+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
							
                                                        if string.count(k,'+')>0:
								val=1
                                                                d=string.count(k,'+')
                                                                if d==1:
                                                                        if string.find(k,'+')!=0:
										return '<html><body>'+errormsglis+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
								elif d>1:				 
									return '<html><body>'+errormsglis+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'
							val=string.replace(k,'+','')
							val=string.replace(val,'-','')
							val=string.replace(val,'.','')
							if re.search('[^0-9]',val)!=None:
								return '<html><body>'+errormsglis+'<form action="forminmax"><br><input type="submit" value="Correct constraints"></form></body></html>'

					#REQUEST.set('userlist',ulis)
					#ulis=str(ulis)
					#ulis=string.replace(ulis,'[','')
					#ulis=string.replace(ulis,']','')
					userlist=string.replace(userlist,"'",'')
					userlist=string.replace(userlist,' ','')
					try:
						self.manage_addProperty(userlist,ulis,'string')
					except:
						if self.hasProperty(userlist):
							self.manage_delProperties((userlist,))
							self.manage_addProperty(userlist,ulis,'string')

                titl=self.getProperty('title')
                REQUEST.set('tite','titl')
		try:
			self.manage_addProperty('typevar',REQUEST['typevar'],'string')
		except:
			self.manage_delProperties(('typevar',))
			self.manage_addProperty('typevar',REQUEST['typevar'],'string')
			
                proptup=self.propertyItems()#This will give all properties including newly added ones
		
		docu=str(self.getProperty('documentation'))
		proptup.pop(3)
		docu1=string.split(docu,'[',1)[1]
		ld=len(docu1)
		docu=docu1[0:ld-1]
		REQUEST.set('allprop',proptup)#Pass it to form
		REQUEST.set('docs',docu)
		self.manage_delProperties(('typevar',))#Delete new properties one by one 
		if self.hasProperty('min_x'):
			self.manage_delProperties(('min_x','max_x'))
		if self.hasProperty('min_y'):
			self.manage_delProperties(('min_y','max_y'))
		if self.hasProperty('userlist_x'):
                        self.manage_delProperties(('userlist_x',))
		if self.hasProperty('userlist_y'):
			self.manage_delProperties(('userlist_y',)) 

		RESPONSE.redirect(self.surl+'/manage_addProduct/GNOWSYS05/PBase/Custom/manage_addFunction?tite=%s&allprop=%s&docs=%s'%(titl,proptup,docu))

	def manage_newobj(self,REQUEST,RESPONSE=None):
		"""To create the object"""

		pt = self.InstancePath
		module=self.module              #Module to which the function belong
		funtype=self.id
		if module=="maths" or module=="Numeric" or module=="umaths" or module=="cmaths":
			reffunt=pt+'PBase/Functions/Math/'+funtype
		elif module=="string":
			reffunt=pt+'PBase/Functions/String/'+funtype
		else:
			reffunt=pt+'PBase/Functions/'+funtype
		pt1=pt+'PBase/Custom'
		pt2=self.restrictedTraverse(pt1)
		
		ptrft=self.restrictedTraverse(reffunt)
		id=REQUEST['id']

		title=self.title                #title of the object

                

                docstr=self.documentation

		fp=open('/tmp/doc','w+')
		pickle.dump(docstr,fp)
		fp.close()
		
		doc='/tmp/doc'

                dbname=self.dbname

                arguments=ptrft.propertyIds()
		
		arguments.remove('id')
		arguments.remove('title')
		arguments.remove('module')
		arguments.remove('documentation')
		arguments.remove('Result')
		
                parameter=string.join(arguments)
		pt2._setObject(id,FunctionType(id,title,parameter,doc,module,dbname))
#			       (id,title,doc,module,dbname,))
		if REQUEST is not None:
			try:    url=dispatcher.DestinationURL()
        		except: url=REQUEST['URL1']
        		vname='Function'
        		REQUEST.set('newid',vname)
        		REQUEST.RESPONSE.redirect(url+'/confirm?newname=%s&newid=%s' % (id,vname))

	def DelFunT(self,REQUEST,RESPONSE=None):
                """Delete the function type"""
                delid=REQUEST.form['id']
                #dest=dispatcher.Destination()
                self.PBase.Functions.manage_delObjects(delid)
		nm="FunctionType"
                REQUEST.set('newnm',nm)
                REQUEST.set('newid',delid)
                REQUEST.RESPONSE.redirect(REQUEST['URL2']+'/replydelete?newid=%s&newnm=%s' % (delid,nm))
                #return '<html><body>'+str(delid)+ ' has been deleted. </body></html>'
                #RESPONSE.redirect()

 	inputPage=DTMLFile('pdtml/inputPage',globals())
	viewfunction=DTMLFile('pdtml/viewfunction',globals())
	rangenum=DTMLFile('pdtml/rangenum',globals())
  	inputPagetry=DTMLFile('pdtml/inputPagetry',globals())
	operation=DTMLFile('pdtml/operation',globals())
	customtype=DTMLFile('pdtml/customtype',globals())
	manage_addnewobj=DTMLFile('pdtml/manage_addnewobj',globals())
 	FunctionTResult=DTMLFile('pdtml/FunctionTResult',globals())
		
def manage_FunctionType(dispatcher,id,name,documentstring,module,filepath,parameters,REQUEST=None):
    """constructor-add a functiontype to a folder."""
    dest=dispatcher.Destination()

    idt=dest.absolute_url()
    title=name
    dbname=filepath
    doc=documentstring
    para1=string.replace(parameters,"$"," ")
    param=string.strip(para1)
    parameter=string.split(param)
    for tmp in parameter:
	    if tmp=='id' or tmp=='title' or tmp=='module' or tmp=='self':
		    parameter.remove(tmp)
    parameter=string.join(parameter)
    dest.PBase.Functions._setObject(id,FunctionType(id,title,parameter,doc,module,dbname))
    REQUEST.set('newname','id')	
    #return '<html><body> ID:'+id+'<br>Docstr'+doc+'<br>'+'</body></html>'
    if REQUEST is not None:   
    	try:
		url=dispatcher.DestinationURL()   
	except:
		url=REQUEST['URL1']
	vname='FunctionType'
	REQUEST.set('newname',vname)
        REQUEST.RESPONSE.redirect(url+'/confirm?newname=%s&newid=%s'%(id,vname))

    #if REQUEST is not None:
        #return dispatcher.manage_main(dispatcher, REQUEST)

manage_addFunctionType=DTMLFile('pdtml/manage_addFunctionType',globals())
addnewFunctionform=DTMLFile('pdtml/addnewFunctionform',globals())

InitializeClass(FunctionType)
