#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from OFS import SimpleItem
from Globals import DTMLFile,InitializeClass
from listing import *
import string
from conditiontype import *

class FlowType(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
           ZCatalog,
	   SimpleItem):
        """adding a function type"""

        meta_type = 'GFlow Type'

	_properties= (
        {'id':'id', 'type':'string', 'mode':'r'},
        {'id':'title', 'type':'string', 'mode':'r'},
        {'id':'countfunc', 'type':'int', 'mode':'r'},
        )	

        manage_options = (
 		{'label': 'Contents', 'action': 'manage_main'},
		{'label': 'Properties', 'action':'manage_propertiesForm'},
                {'label':'View','action':'flowinfo',},
                {'label':'Edit','action':'editflow',},
		)

        def __init__(self,id,title,funobj,typ):
                """ Initialising the function type"""
                self.id=id			#id of the flow object
                self.title=title		#title of the flow object
		self.funobj=funobj		#The functions in a flow object
		self.FunObj=[]			
		self.counter=0		
 		self.url=[]
		self.typ=typ
		for i in string.split(self.funobj,'|',len(string.split(self.funobj,'|'))):
			self.FunObj.append(i)
		self.countfunc=len(self.FunObj)

	def callforinit(self,REQUEST,RESPONSE=None):
                """ Initailising the properties """
                msg="Error"
                self.modval=0
		k=-1
		w=-1
		self.ids=[]
	        #phyurl = self.getPhysicalPath()[1]
	        phyurl = self.InstancePath
                for i in range(len(self.FunObj)):
			s=[]
			if self.FunObj[i]!='if' and self.FunObj[i]!='endif' and self.FunObj[i]!='for' and self.FunObj[i]!='endfor' and self.FunObj[i]!='elif' and self.FunObj[i]!='else' and self.FunObj[i]!='while' and self.FunObj[i]!='endwhile':
				k=k+1
			else:
				w=w+1
			try:
				#print "Hi Functions"
                                path= phyurl +'PBase/Functions/'+self.FunObj[i]
                                m=self.restrictedTraverse(path,default=None)
				if m.hasProperty('module'):
                                	s.extend(m.propertyIds())
					self.modval=0
                        except AttributeError,msg:
                                try:
					#print "Hi Math"
                                        path= phyurl +'PBase/Functions/Math/'+self.FunObj[i]
                                        m=self.restrictedTraverse(path,default=None)
					if m.hasProperty('module'):
                                        	s.extend(m.propertyIds())
                                        	self.modval=1
					if self.FunObj[i]=='count':
						return '<html><body>'+str(m.propertyItems())+'<br>'+path+'</body></html>'
                                except AttributeError,msg:
					try:
						#print "Hi String"
						path= phyurl+ 'PBase/Functions/String/'+self.FunObj[i]
                                        	m=self.restrictedTraverse(path,default=None)
						if m.hasProperty('module'):
	                                        	s.extend(m.propertyIds())
        	                                	self.modval=2
					except AttributeError,msg:
						try:
							#print "Hi Flow"
							path= phyurl +'PBase/FlowBase/'+self.FunObj[i]
        	                                	m=self.restrictedTraverse(path,default=None)
			                        	s.extend(m.propertyIds())
       	                	                	self.modval=3
						except AttributeError,msg:
							#print "Hi Conditions"
							path= phyurl + 'PBase/Functions/Conditions/'+self.FunObj[i]
        	                                	m=self.restrictedTraverse(path,default=None)
                					s.extend(m.propertyIds())
							self.modval=4
			if self.modval==3:		
                       		for j in range(len(s)):
                                	if s[j]=="id" or string.find(s[j],'_id_')!=-1:
                                        	temp=m.getProperty(s[j])
                                        	if temp=='if' or temp=='elif' or temp=='while':
                                                	self.operlist=['<','>','==','!=','<=','>=']
                                        	if string.find(s[j],'_id_')!=-1:
 							if temp!='if' and temp!='endif' and temp!='for' and temp!='endfor' and temp!='elif' and temp!='else' and temp!='while' and temp!='endwhile':
								k=k+1
                                                	else:
                                                        	w=w+1
                                	elif s[j]=="title" or string.find(s[j],'_title_')!=-1:
                                        	temp=m.getProperty(s[j])
                                	elif s[j]=="module" or string.find(s[j],'_module')!=-1:
                                        	temp=m.getProperty(s[j])
                                	elif s[j]=="documentation" or string.find(s[j],'_documentation_')!=-1:
                                        	temp=m.getProperty(s[j])
                                	elif s[j]=="countfunc":
                                        	temp=m.getProperty('countfunc')
                                	elif s[j].find("= ")!=-1 and string.find(s[j],'_')==-1:
                                        	t=string.split(s[j],'=',1)[0]
                                        	temp=''
                                        	s[j]=t+"''"
                                	else:
                                        	temp=''
                                	proptype=m.getPropertyType(s[j])
 					if string.find(s[j],'max_')==-1 and string.find(s[j],'min_')==-1 and string.find(s[j],'typevar')==-1 and string.find(s[j],'rangeofnum')==-1 and self.modval!=3:
                                        	if self.FunObj[i]=='if' or self.FunObj[i]=='elif' or self.FunObj[i]=='else'  or self.FunObj[i]=='endif' or self.FunObj[i]=='for' or self.FunObj[i]=='endfor' or self.FunObj[i]=='while' or self.FunObj[i]=='endwhile':
                                                	s[j]=self.FunObj[i]+'_'+s[j]+'_'+str(w)
                                        	else:
                                                	s[j]=self.FunObj[i]+'_'+s[j]+'_'+str(k)
                                        	self.manage_addProperty(s[j],temp,proptype)
                                	elif self.modval==3 and string.find(s[j],'Final_Result')==-1:
                                        	st=string.split(s[j],'_',-1)
                                        	if len(st)==3:
                                                	s[j]=st[0]+'_'+st[1]+'_'+str(k)
                                                	self.manage_addProperty(s[j],temp,proptype)
                                	if string.find(s[j],'_id_',)!=-1:
                                        	self.ids.append(s[j])
			else:
			        for j in range(len(s)):
        	                        if s[j]=="id":
                	                        temp=m.getProperty('id')
						if temp=='if' or temp=='elif' or temp=='while':
							self.operlist=['<','>','==','!=','<=','>=']
					elif s[j]=="title":
                	                        temp=m.getProperty('title')
                        		elif s[j]=="module":
                                        	temp=m.getProperty('module')
					elif s[j]=="documentation":
                                        	temp=m.getProperty('documentation')                            
					elif s[j].find("= ")!=-1:
                                        	t=string.split(s[j],'=',1)[0]
                                        	temp=''
                                        	s[j]=t+"''"
                                	else:
                                        	temp=''
                                	proptype=m.getPropertyType(s[j])
					if proptype=='int':
						temp=m.getProperty(s[j])
					if string.find(s[j],'max_')==-1 and string.find(s[j],'min_')==-1 and string.find(s[j],'typevar')==-1 and string.find(s[j],'rangeofnum')==-1:
        			        	if self.FunObj[i]=='if' or self.FunObj[i]=='elif' or self.FunObj[i]=='else' or self.FunObj[i]=='endif' or self.FunObj[i]=='for' or self.FunObj[i]=='endfor' or self.FunObj[i]=='while' or self.FunObj[i]=='endwhile':
							s[j]=self.FunObj[i]+'_'+s[j]+'_'+str(w)
						else:
							s[j]=self.FunObj[i]+'_'+s[j]+'_'+str(k)
						if string.find(s[j],'_id_',)!=-1:
							self.ids.append(s[j])
						self.manage_addProperty(s[j],temp,proptype)
                	if self.modval==1:
                        	self.url.append(self.surl+'/PBase/Functions/Math/')
                	elif self.modval==2:
                        	self.url.append(self.surl+'/PBase/Functions/String/')
                	elif self.modval==3:
                        	self.url.append(self.surl+'/PBase/FlowBase/')
               	 	elif self.modval==4:
                        	self.url.append(self.surl+'/PBase/Functions/Conditions/')
                	elif self.modval==0:
                        	self.url.append(self.surl+'/PBase/Functions/')
		self.manage_addProperty('Final_Result','','string')
		REQUEST.set('newname',self.getProperty('id'))
		if REQUEST is not None:
        		url=REQUEST['URL1']
			vname='FlowType'
			REQUEST.set('newid',vname)
			RESPONSE.redirect(url+'/confirm?newname=%s&newid=%s'%(self.getProperty('id'),vname))

	def editobject(self,REQUEST,RESPONSE=None):	#Edit the flow type
		"Edit object"
		funobj=string.replace(self.funobj,'|',',')
		typ='flow'
		REQUEST.set('FunctionObject',funobj)
		REQUEST.set('objid',self.__name__)
		REQUEST.set('typ',typ)
		# Redirect to interfun for going to the add new flow type page
		RESPONSE.redirect('interfun?FunctionObject=%s&objid=%s&typ=%s'%(funobj,self.__name__,typ))		

	def callinput(self,RESPONSE=None):
                """Call input page"""
                self.FunObj=string.split(self.funobj,'|',-1)
                self.results=[]
                self.res=''
                self.temp=''
                self.item=[('User-defined','')]
                self.typ="halted"
                for i in self.propertyIds():
                      	if string.find(i,'_id_')==-1 and string.find(i,'_title_')==-1 and string.find(i,'_documentation_')==-1 and string.find(i,'_module_')==-1 and string.find(i,'_rangeofnum_')==-1 and i!='id' and i!='title' and i!='countfunc':
                        	if string.find(i,'_Result')!=-1:
                                	self._updateProperty(i,'0')     #Initialises all the results to 0
				else:
					self._updateProperty(i,'')	#Initialise all the parameters
		self.checkbit=0
		self.counter=0
                self.cnt=0
                self.k=0
                self.rmcnt=0
                self.newval=0
                self.funlist=[]
                self.forbit=0                                   # This bit is set if when a 'for' loop is in execution
                self.execfun=[]
                for i in range(len(self.ids)):
                        self.execfun.append('ne')
                self.whilebit=0                                 # This bit is set if when a 'while' loop is in execution
                self.toexec=0                                   # This bit is set to indicate execute has to be called
                self.funlist.extend(self.FunObj)                # Initialise the funlist to the original list of function objects
                #Redirect to execute function
                RESPONSE.redirect('execute')

	def execute(self,REQUEST,RESPONSE):
		"""execute"""
		setbit=0
		msg="Error!!!"
		#self.funlist=[]
		#self.funlist.extend(self.FunObj)
		FunObj=[]
		FunObj.extend(self.funlist)
                if self.counter<len(self.funlist):   # Check which function is to be executed
			#if self.cnt==2:
				#return '<html><body>hi!!'+str(self.execfun)+str(self.funlist)+'</body></html>'	
          	        if string.find(self.funlist[self.counter-1],'ifdonefalse')!=-1 :
				self.cnt=self.cnt+self.rmcnt
				self.rmcnt=0
     			
			if self.whilebit!=1 and self.forbit!=1 and self.checkbit!=1:
                		self.execfun[self.cnt]='e'
                              	self.cnt=self.cnt+1

          	        if string.find(self.funlist[self.counter-1],'if')!=-1 and string.find(self.funlist[self.counter-1],'endif')==-1:
				self.cnt=self.cnt+self.rmcnt
				self.rmcnt=0
			
			if 'evalres' in REQUEST.keys():
				self.checkbit=0
				self.funlist[self.counter-1]=self.funlist[self.counter-1]+'done'
				#FunObj[self.counter-1]=FunObj[self.counter-1]+'done'
				c=int(REQUEST['evalres'])
                                l=-1
                                g=-1
                                h=-1
                                f=-1
                                f1=-1
				try:
					f=self.funlist.index('ifdone')
                                except: ValueError,msg
                                try:
                                        f1=self.funlist.index('if')
                                except: ValueError,msg
                                try:
                                        g=self.funlist.index('elif')
                                except: ValueError,msg
                                try:
                                        h=self.funlist.index('else')
                                except: ValueError,msg
                                try:   
                                        l=self.funlist.index('endif')
                                except: ValueError,msg
                                if c==1:
                                        tempval=0
                                        if f1!=-1 and f1<l:   # if 'if' contains nested if loop
                                                pass
                                        elif l!=-1:           # if endif present
                                                if g!=-1:     # if elif present delete all fns following it
                                                        for q in range(g,l):
                                                                if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
                                                                        self.rmcnt=self.rmcnt+1 #rmcnt gives a count of all the functions deleted  and it is used to increment the cnt
                                                                if string.find(FunObj[q],'elif')!=-1 and FunObj[q]!='else':
                                                                        tempval=tempval+1
                                                                self.funlist.remove(FunObj[q])
                                                elif h!=-1:   # if else present delete all  fns following it
                                                        for q in range(h,l):
                                                                if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
                                                                        self.rmcnt=self.rmcnt+1
                                                                if string.find(FunObj[q],'elif')!=-1 and FunObj[q]!='else':
                                                                        tempval=tempval+1
                                                                self.funlist.remove(FunObj[q])
                                        self.newval=self.rmcnt    # newval keeps count of all the fns deleted
                                        self.rmcnt=self.rmcnt+tempval
					
                                else:
                                        #return '<html><body>'+str(self.funlist)+str(f1)+str(g)+str(h)+str(l)+'</body></html>'
					if f1==-1 and g==-1 and h==-1:   # if 'if' is not followed by elif/else
                                                if l!=-1:
							#return
                                                        temp=0
                                                        for q in range(self.counter,l+1):
                                                                if string.find(FunObj[q],'if')==-1:
                                                                        self.rmcnt=self.rmcnt+1
                                                                        temp=temp+1
                                                                if string.find(FunObj[q],'endif')!=-1:
                                                                        self.rmcnt=self.rmcnt+1
                                                                try:
									self.funlist.remove(FunObj[q])
								except:
									return str(self.funlist)
                                                        #self.counter=self.counter-1
							if self.counter<len(self.funlist): # if the 'if' function is followed by some other functions
                	                                       	self.k=self.k+temp
						#self.cnt=self.cnt+self.rmcnt
						#return str(self.cnt) 
                                        elif f1!=-1 and f<l and f1<l:            # if 'if' is followed by a nested if-endif
                                                for q in range(self.counter-1,l+1):
                                                        if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else' and FunObj[q]!='endif':
                                                                self.rmcnt=self.rmcnt+1
                                                                #self.k=self.k+1
                                                        self.funlist.remove(FunObj[q])
                                                self.counter=self.counter-1
                                        elif l!=-1:                     # if 'endif' is present
                                                if g!=-1:               # if 'elif' is present
                                                        for q in range(self.counter-1,g):
                                                                if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
                                                                        self.rmcnt=self.rmcnt+1
                                                                        self.k=self.k+1
                                                                self.funlist.remove(FunObj[q])
                                                        #return str(self.funlist)
                                                        #return '<html><body>'+str(self.funlist)+'<br>'+str(FunObj)+'</body></html>'
                                                        #self.counter=self.counter-1
                                                if h!=-1 and f==-1 and self.funlist[self.counter-1]!="elif":  #if else is present and if nested if is not present
                                                        for q in range(self.counter-1,h):
                                                                if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
                                                                        self.rmcnt=self.rmcnt+1
                                                                        self.k=self.k+1
                                                                self.funlist.remove(FunObj[q])
                                                        #return str(self.k)
                                                        #self.counter=self.counter-1
                                                elif g==-1 and h!=-1:  # if elif absent and else present
                                                        for q in range(self.counter-1,h):
							        if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
                                                                        self.rmcnt=self.rmcnt+1
                                                                        self.k=self.k+1
                                                                self.funlist.remove(FunObj[q])
                                                #if self.funlist[self.counter-1]=="elifdone":
                                                self.counter=self.counter-1
				#return '<html><body>'+str(self.cnt)+str(self.rmcnt)+'</body></html>'
				u=self.absolute_url()+'/execute'
				#RESPONSE.redirect('execute')
				#self.counter=self.counter+1

                        elif 'start' and 'stop' and 'step' and 'i' in REQUEST.keys():
				self.checkbit=0
				self.counter=self.counter-1
                                self.ForList=[]
                                self.start=int(REQUEST['start'])
                                self.stop=int(REQUEST['stop'])
                                self.step=int(REQUEST['step'])
                                self.ival=REQUEST['i']
                                self.actualvalue=self.ival
                                #if self.ival=="start":
                                        #self._updateProperty(self.)
                                fend=-1
                                nextendfor=1
                                for i in range(self.counter+1,len(self.funlist)):
                                        if self.funlist[i]=="for":
                                                nextendfor=nextendfor+1
                                        elif self.funlist[i]=="endfor":
                                                nextendfor=nextendfor-1
                                        elif nextendfor==0:
                                                break
                                        #ForList.append(self.funlist[i])
                                        if self.funlist[i]!="endfor":
                                                self.ForList.append(0)
                                self.counter=self.counter+1
                                self.forbit=1
                                u=self.absolute_url()+'/execute'
                                #return '<html><body>'+str(self.ForList)+'</body></html>'

                        elif self.forbit==1:
                                #if self.c!=0:
                                val=0
                                if self.start<=self.stop:
                                        k=0
                                        for i in range(len(self.ForList)):
                                                if self.ForList[i]==0:                  #Check whether the bit for the function is set to 0 if yes then that function ha$
                                                        self.ForList[i]=1
							for ind in range(len(self.ids)):
								if string.find(self.ids[ind],self.funlist[self.counter+i])!=-1:
									break
							u=self.url[ind]+self.funlist[self.counter+i]+'/callPage'
							setbit=1
							self.k=self.k+1
                                                        #self.toexec=2
                                                        #self.callfun(self.k-1)
                                                        break
                                                else:
							k=k+1                           # If set to 1 then increment k
                                        if k==len(self.ForList):                        # if k=length(self.ForList) then all functions have been executed once so reinit$
                                                for i in range(len(self.ForList)):
                                                        self.ForList[i]=0
                                                        self.k=self.k-1
                                                self.start=self.start+self.step
						u=self.absolute_url()+'/execute'

                                else:                                                   # if start>stop then for loop has ended
                                        self.forbit=0
                                        self.counter=self.counter+len(self.ForList)
                                        for i in range(len(self.ForList)):
                                                self.execfun[self.cnt]='e'                           
						self.cnt=self.cnt+1
                                        self.k=self.k+len(self.ForList)
                                        u=self.absolute_url()+'/execute'
                        
			elif 'input1' and 'input2' and 'oper' and 'step' in REQUEST.keys():
                                self.counter=self.counter-1
				self.checkbit=0
				self.WhileList=[]
				self.input1=float(REQUEST['input1'])
				self.input2=float(REQUEST['input2'])
				self.oper=REQUEST['oper']
				self.step=float(REQUEST['step'])
                                wend=-1
                                nextendwhile=1
				#return str(self.counter)
                                for i in range(self.counter+1,len(self.funlist)):
                                        if self.funlist[i]=="while":
                                                nextendwhile=nextendwhile+1
                                        elif self.funlist[i]=="endwhile":
                                                nextendwhile=nextendwhile-1
                                        elif nextendwhile==0:
                                                break
                                        if self.funlist[i]!="endwhile":
                                                self.WhileList.append(0)
                                self.counter=self.counter+1
                                self.whilebit=1
				u=self.absolute_url()+'/execute'
				#return str(self.WhileList)

                        elif self.whilebit==1:
                                val=0
                                con=compile(str(self.input1)+str(self.oper)+str(self.input2),'','eval')
                                c=eval(con)
                                k=0
                                if c==1:
                                        for i in range(len(self.WhileList)): 
                                        	if self.WhileList[i]==0:                   #Check whether the bit for the function is set to 0
                                                        self.WhileList[i]=1
							for ind in range(len(self.ids)):
								if string.find(self.ids[ind],self.funlist[self.counter+i])!=-1:
									break
							u=self.url[ind]+self.funlist[self.counter+i]+'/callPage'
                                                        self.k=self.k+1
							setbit=1
                                                        break
                                                else:
                                                        k=k+1                           # If set to 1 then increment k
                                        if k==len(self.WhileList):                      # if k=length(self.ForList) then all functions have
                                                for i in range(len(self.WhileList)):
                                                        self.WhileList[i]=0
                                                        self.k=self.k-1
                                                self.input1=self.input1+self.step
                                                u=self.absolute_url()+'/execute'
                                else:                                              # if start>stop then for loop has ended
                                        self.whilebit=0
                                        self.counter=self.counter+len(self.WhileList)
                                        for i in range(len(self.WhileList)):
                                                self.execfun[self.cnt]='e'
                                                self.cnt=self.cnt+1
					#return '<html><body>'+str(self.execfun)+str(self.cnt)+'</body></html>'
                                        #return str(self.execfun)
					self.k=self.k+len(self.WhileList)
					u=self.absolute_url()+'/execute'
	                                #self.execute()
                       	
			elif self.funlist[self.counter]!='if' and self.funlist[self.counter]!='elif' and self.funlist[self.counter]!='else' and  self.funlist[self.counter]!='endif' and self.funlist[self.counter]!='for' and self.funlist[self.counter]!='endfor' and self.funlist[self.counter]!='while' and  self.funlist[self.counter]!='endwhile':
				for ind in range(len(self.ids)):
					if string.find(self.ids[ind],self.funlist[self.counter])!=-1:
						break
				u=self.url[ind]+self.funlist[self.counter]+'/callPage'
		 		self.k=self.k+1
				setbit=1
				self.counter=self.counter+1
                        
			elif self.funlist[self.counter]=="endif": # if 'endif' is encountered 
				#return '<html><body>'+str(self.funlist)+'<br>'+str(self.k)+'<br>'+str(self.cnt)+'<br>'+str(self.rmcnt)+'</body></html>'
				#if 'elifdone' in self.funlist: 
				#if self.counter+1<=len(self.funlist)-1: 
					#pass
				#if self.funlist[self.counter+1]=="endif":
					#self.k=self.k+1
				ebit=-1
				if self.counter+1<=len(self.funlist)-1:   # Check whether there are more functions to continue after endifdone
					ebit=0
					if self.funlist[self.counter+1]=="endif":
						#self.k=self.k+1
						ebit=1			  # Indicates there is another endif to follow after this endif	
				
				if self.funlist[self.counter-1]=="endifdone": # Check whether the prev obj was endif too
					pass
				elif 'elsedone' in self.funlist and ebit!=1:  # If elsedone then k need not be incremented on encountering endif
					t=self.funlist.index('elsedone')
					self.funlist[t]=self.funlist[t]+"y"
				elif 'elifdone' in self.funlist: 
					#and ebit!=1:
					
					t=self.funlist.index('elifdone')
					self.funlist[t]=self.funlist[t]+"y"
					self.k=self.k+self.newval
					
				elif 'ifdone' in self.funlist:
					#and ebit!=1:  
					t=self.funlist.index('ifdone')
					self.funlist[t]=self.funlist[t]+"y"
					self.k=self.k+self.newval  # newval is added to k so that k points to the next function to be executed
					self.newval=0              # Reinitialise
					
					#return '<html><body>'+str(len(self.funlist))+'<br>'+str(self.k)+'<br>'+str(self.counter+1)+'<br>'+str(self.rmcnt)'</body></html>'
				else:
					if ebit!=0:
						self.k=self.k+1
				self.funlist[self.counter]=self.funlist[self.counter]+"done"
				self.counter=self.counter+1
				#return '<html><body>'+str(self.item)+str(self.counter)+'</body></html>'
				self.toexec=1
                                u=self.absolute_url()+'/execute'
				
			elif self.funlist[self.counter]=='if' or self.funlist[self.counter]=='elif' or self.funlist[self.counter]=='for' or self.funlist[self.counter]=='while':
				for ind in range(len(self.ids)):
					if string.find(self.ids[ind],self.funlist[self.counter])!=-1:
						break
				u=self.url[ind]+self.funlist[self.counter]+'/condPage'
				setbit=1
				self.checkbit=1
				self.counter=self.counter+1                      

			elif self.funlist[self.counter]=="else": # if else condition is true in an if-endif construct then increment counter so that the next function c
                                self.funlist[self.counter]=self.funlist[self.counter]+"done"
                                self.counter=self.counter+1
                                u=self.absolute_url()+'/execute'
                        elif self.funlist[self.counter]=="endfor" or self.funlist[self.counter]=="endwhile":
                                self.counter=self.counter+1
				u=self.absolute_url()+'/execute'                                
                                #self.execute()
			if self.counter<len(self.funlist):
			 	if string.find(self.funlist[self.counter-1],'endif')!=-1 or string.find(self.funlist[self.counter],'elif')!=-1 or string.find(self.funlist[self.counter-1],'else')!=-1:
					self.cnt=self.cnt+self.rmcnt
					#return '<html><body>'+str(self.cnt)+'</body></html>'
					self.rmcnt=0
	
			if self.counter>1 and setbit==1: 
				setbit=0
                		#self.item=[('User-defined','')]
                       		s=self.propertyIds()
                               	for i in s:
                      			if string.find(i,'_'+str(self.k-2))!=-1 and string.find(i,'_id_')==-1 and string.find(i,'_title_')==-1 and string.find(i,'_documentation_')==-1 and string.find(i,'_module_')==-1 and string.find(i,'_rangeofnum_')==-1 and string.find(i,'if_')==-1:
                                		if self.whilebit!=1 and self.forbit!=1: 
				 			tempval=self.getProperty(i)
							if tempval!='0' and tempval!='':
								tempprop=string.split(i,'_',2)[1]
                                               			tempitem=(tempprop,tempval)
                                               			self.item.append(tempitem)
						if (self.forbit==1 or self.whilebit==1) and string.find(i,self.funlist[self.counter])!=-1:
                                       			tempval=self.getProperty(i)
							if tempval!='0' and tempval!='':
								tempprop=string.split(i,'_',2)[1]
                                               			tempitem=(tempprop,tempval)
                                               			self.item.append(tempitem)
                       	#self.counter=self.counter+1
                	temp=string.replace(str(self.item),"'","")
                       	temp=string.replace(temp,'"','')
                       	temp=string.replace(temp," ","")
                       	temp=string.replace(temp,",",":")
                       	temp=string.replace(temp,'[','')
                       	temp=string.replace(temp,']','')
                       	self.temp=temp
                       	temp=string.replace(temp,'):(','||')
                       	temp=string.replace(temp,'(','')
                	temp=string.replace(temp,')','')
			#return '<html><body>'+str(self.counter-1)+self.FunObj[self.counter]+'</body><html>'
                        REQUEST.set('objid',self.__name__)
                        REQUEST.set('result',self.res)
			REQUEST.set('item',temp)
                        REQUEST.set('counter',str(self.k-1))
                        REQUEST.set('exectyp',self.typ)
                        #Redirect to the input page of the function to be executed
			#self.cnt=self.cnt+self.rmcnt
                        #self.rmcnt=0
			RESPONSE.redirect(u+'?objid=%s&result=%s&item=%s&counter=%s&exectyp=%s'%(self.__name__,self.res,temp,str(self.k-1),self.typ))
			#self.counter=self.counter+1
		
                elif self.counter==len(self.funlist): # If all fns have been excuted then display result.
                        #s=self.funlist[self.k-1]+'_Result_'+str(self.k-1)
                        #s=self.FunObj[self.k]+'_Result_'+str(self.k)
			#return '<html><body>'+str(self.funlist)+str(self.execfun)+str(self.cnt)+'</body></html>'
			for i in range(len(self.ids)-1,-1,-1):
                        	if self.execfun[i]=='e':
                                        if string.find(self.ids[i],'if')==-1 and string.find(self.ids[i],'while')==-1 and string.find(self.ids[i],'for')==-1:
						s=self.ids[i]
                                                #return str(s)
						break
				else:
					s=''
                        s=string.replace(s,'_id_','_Result_')
			self._updateProperty('Final_Result',self.getProperty(s))
			REQUEST.set('result',self.Final_Result)
                        REQUEST.set('flid',self.id)
                        REQUEST.set('fltitle',self.title)
			RESPONSE.redirect('FlowTResult?result=%s&flid=%s&fltitle=%s'%(self.Final_Result,self.id,self.title))
		        #return '<html><body><br><b>Result of '+self.id+'('+self.title+')'+':</b>'+str(self.Final_Result)+'<br>'+'<br>'+'<form action="manage_main" > <br><input type="submit" value="Return to main page"></form></body></html>'

	def decidetype(self,REQUEST,RESPONSE=None):
		""" Decide type of execution """
		funobj=string.replace(self.funobj,'|',',')
		REQUEST.set('funobj',funobj)
		REQUEST.set('objid',self.id)
		if REQUEST['exectyp']=="halted":
			RESPONSE.redirect('callinput')
		elif REQUEST['exectyp']=="complete":
			RESPONSE.redirect('getVariables')
			
	def DelFlowT(self,REQUEST,RESPONSE=None):
                """Delete the flow type"""
                delid=REQUEST.form['id']
                #dest=dispatcher.Destination()
                self.PBase.FlowBase.manage_delObjects(delid)
                nm="FlowType"
                REQUEST.set('newnm',nm)
                REQUEST.set('newid',delid)
                REQUEST.RESPONSE.redirect(REQUEST['URL2']+'/replydelete?newid=%s&newnm=%s' %(delid,nm))
                #return '<html><body>'+str(delid)+ ' has been deleted. </body></html>'
                #RESPONSE.redirect()	
	
	def tocallfun(self,REQUEST,RESPONSE):
                """ assign the values to the variable """
                #return str(REQUEST)
		self.counter=0
		k=0
		if 'seloper' in REQUEST.form.keys():
			seloper=REQUEST['seloper']
                for i in range(len(self.FunObj)):
			if self.FunObj[i]=='if' or self.FunObj[i]=='elif' or self.FunObj[i]=='while':
				a=string.replace(self.ids[i],'_id_','_oper_')
				self._updateProperty(a,seloper[k])
				k=k+1
                        for j in REQUEST.form.keys():
				if string.find(j,'for_i_')!=-1:
					a=string.split(str(REQUEST[j]),',',-1)[0]
					a=string.replace(a,'[','')
					a=string.replace(a,"'","")
                                	self._updateProperty(j,a)
				if string.find(j,self.FunObj[i])!=-1 and string.find(j,'Resultofif')==-1:
                                        self._updateProperty(j,REQUEST[j])
				if string.find(j,'Resultofif')!=-1:
					try:
						self.manage_addProperty(j,'','string')
					except:
						print "Its already present" 
		self.typ="complete"
                #return '<html><body>'+str(self.propertyItems())+'</body></html>'
		REQUEST.set('livar',REQUEST.form['livar'])
		REQUEST.set('objid',self.id)
		#REQUEST.set('funobj',str(self.FunObj))
		RESPONSE.redirect(REQUEST['URL3']+'/manage_addProduct/GNOWSYS05/manage_addFlow?livar=%s&objid=%s'%(REQUEST.form['livar'],self.id))


	flowinfo=DTMLFile('pdtml/flowinfo',globals()) # Info abt the functions in flow object
        getVariables=DTMLFile('pdtml/getVariables',globals())
        editflow=DTMLFile('pdtml/editflow',globals()) # Edit the flow objects
        getVarNames=DTMLFile('pdtml/getVarNames',globals())
        visual=DTMLFile('pdtml/visual',globals())
        #visual1=DTMLFile('pdtml/visual1',globals())
        execType=DTMLFile('pdtml/execType',globals())
        FlowTResult=DTMLFile('pdtml/FlowTResult',globals())
	
def manage_FlowType(dispatcher,id,title,funobj,typ,REQUEST=None,RESPONSE=None):
     "Add a flow object to a folder."
     dest=dispatcher.Destination()
     #phyurl = dest.getPhysicalPath()[1]
     phyurl = dest.InstancePath
     #return '<html><body>'+typ+'</body></html>'
     if id==REQUEST['objid']:
	#return '<html><body>'+id+'</body></html>'
	# Save changes to the object (First delete it and create a new obj with the same name)     
     	dest.PBase.FlowBase.manage_delObjects(REQUEST['objid'])

     dest.PBase.FlowBase._setObject(id,FlowType(id,title,funobj,typ))

     if REQUEST is not None:
        FlowTypeRef = dest.restrictedTraverse( phyurl + 'PBase/FlowBase/'+id)
	FlowTypeRef.callforinit(REQUEST,RESPONSE)

	#RESPONSE.redirect('/'+phyurl+'/PBase/FlowBase/'+id+'/callforinit')
	#return dispatcher.manage_main(dispatcher, REQUEST)

manage_addFlowType=DTMLFile('pdtml/manage_addFlowType',globals())
addnewFlowform=DTMLFile('pdtml/addnewFlowform',globals())

InitializeClass(FlowType)

