// -*- c++ -*-

//  Gnomoradio - roboradio/song-list-history.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_SONG_LIST_HISTORY_H
#define __ROBORADIO_SONG_LIST_HISTORY_H

#include "roboradio/song-list-search.h"

namespace Roboradio
{
	class SongListHistory : public SongListSearch
	{
	public:
		SongListHistory (const Glib::ustring &number);
		virtual ~SongListHistory ();

		virtual bool destroyable ();

		void set_number (const Glib::ustring &number);
		Glib::ustring get_number () const;

	protected:
		Glib::ustring num;
	};
}

#endif
