//  Gnomoradio - rainbow/util.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "rainbow/util.h"
#include <unistd.h>
#include <sys/time.h>

static bool wait_for_socket(int socket, int timeout)
{
	struct timeval t;
	t.tv_sec = timeout;
	t.tv_usec = 0;
	fd_set fds;
	FD_ZERO(&fds);
	FD_SET(socket, &fds);
	if (select(FD_SETSIZE, 0, &fds, 0, &t) < 0)
		return false;
	for (int i = 0; i < FD_SETSIZE; ++i)
		if (FD_ISSET(i, &fds) && i == socket)
			return true;
	return false;
}

bool Rainbow::send_data_on_socket (int socket, const char *data, ssize_t size, int timeout)
{
	if (timeout && !wait_for_socket(socket, timeout))
		return false;

	size_t bytes_written = 0;
	while (bytes_written < size) {
		ssize_t w = write(socket,
				  data + bytes_written,
				  size - bytes_written);
		if (w < 0)
			return false;
		bytes_written += w;
	}
	return true;
}

bool Rainbow::send_data_on_socket (int socket, const std::string &data, int timeout)
{
	return send_data_on_socket(socket, data.data(), data.size(), timeout);
}
