//  Gnomoradio - rainbow/license.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "rainbow/license.h"

using namespace std;
using namespace SigC;
using namespace Rainbow;

map<Glib::ustring,ref_ptr<License> > Rainbow::License::license_map;

void Rainbow::License::get_and_do (const Glib::ustring &url,
				   const Slot1<void,ref_ptr<License> > &slot,
				   xmlpp::Element *secondary_source)
{
	ref_ptr<License> license;
	map<Glib::ustring,ref_ptr<License> >::iterator p = license_map.find(url);
	bool done = false;

	if (p != license_map.end()) {
		license = p->second;
		if (license->verified) {
			done = true;
		} else if (secondary_source) {
			License test;
			test.parse_xml(secondary_source);
			if (test.requires == license->requires
			    && test.prohibits == license->prohibits
			    && test.permits == license->permits) {
				done = true;
			}
		}
	} else {
		license = ref_ptr<License>(new License(url));
		license_map.insert(make_pair(url, license));
		if (secondary_source) {
			license->parse_xml(secondary_source);
			done = true;
		}
	}
	
	if (done) {
		Signal1<void,ref_ptr<License> > sig;
		sig.connect(slot);
		sig(license);
	} else {
		//RdfResource::get_and_do(url, slot());
		// something didn't work...FIXME
	}
}

Rainbow::License::License (const Glib::ustring &url_)
	: downloaded(false),
	  verified(false),
	  url(url_),
	  refcnt(0)
{
}

Rainbow::License::~License ()
{
}

void Rainbow::License::parse_xml (xmlpp::Element *xml)
{
	xmlpp::Node::NodeList children = xml->get_children();
	for (xmlpp::Node::NodeList::iterator i = children.begin(); i != children.end(); ++i) {
		xmlpp::Element *node = dynamic_cast<xmlpp::Element*>(*i);
		if (!node)
			continue;
		xmlpp::Attribute *pred = node->get_attribute("resource");
		if (!pred)
			continue;

		if (node->get_name() == "permits")
			permits.insert(pred->get_value());
		else if (node->get_name() == "requires")
			requires.insert(pred->get_value());
		else if (node->get_name() == "prohibits")
			prohibits.insert(pred->get_value());
		// else
			// not understood
	}
}

bool Rainbow::License::sharable ()
{
	// FIXME: this should probably be cached and only calculated when something changes

	if (permits.find("http://web.resource.org/cc/Reproduction") == permits.end()
	    || permits.find("http://web.resource.org/cc/Distribution") == permits.end())
		return false; // not distributable
	
	for (set<Glib::ustring>::iterator i = requires.begin(); i != requires.end(); ++i) {
		if (*i != "http://web.resource.org/cc/Attribution"
		    && *i != "http://web.resource.org/cc/Notice")
			return false;
	}

	for (set<Glib::ustring>::iterator i = prohibits.begin(); i != prohibits.end(); ++i) {
		if (*i != "http://web.resource.org/cc/CommercialUse")
			return false;
	}

	return true;
}
