// -*- c++ -*-

//  Gnomoradio - gnomoradio/prefs-box.h
//  Copyright (C) 2003  Matt Gerginski, Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __PREFS_BOX_H
#define __PREFS_BOX_H

#include <gtkmm.h>
#include "wraporadio/wraporadio.h"
#include "song-paths.h"

namespace Gnomoradio
{
	class PrefsBoxBase : public Gtk::Window
	{
	public:
		PrefsBoxBase ();
		virtual ~PrefsBoxBase ();

	protected:

		Gtk::Widget *rainbow_setup ();
		
 		Wraporadio::Init wr;

		SongPaths song_paths;
		
		/* Radio List */
		Gtk::Adjustment plan_ahead_adj;
		Gtk::SpinButton plan_ahead_time;

		/* Rainbow */
		Gtk::CheckButton rainbow_checkbutton;
		Gtk::Label rainbow_hub_label;
	        Gtk::Entry rainbow_hub;
		Gtk::CheckButton privacy_checkbutton;

		void on_rainbow_checkbutton_toggled ();
		void save_hub ();
		void on_rainbow_privacy_checkbutton_toggled ();
	};

	class PrefsBox : public PrefsBoxBase
	{
	public:
		PrefsBox ();
		~PrefsBox ();
		
	private:
		void on_close_clicked ();
		void on_hide_event ();

		Gtk::Button close_button;
	};
}

#endif
